/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.isavvix.tools.FileInfo;
import com.zeroio.iteam.base.FileItem;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductCatalogPricingList;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.servicecontracts.base.ServiceContract;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProduct;
import org.aspcfs.modules.servicecontracts.base.ServiceContractProductList;
import org.aspcfs.modules.troubletickets.base.TicketList;
import org.aspcfs.utils.DatabaseUtils;

public class ProductCatalog
extends GenericBean {
    private static final long serialVersionUID = -8112814592797357413L;
    private int id = -1;
    private int parentId = -1;
    private int typeId = -1;
    private int formatId = -1;
    private int shippingId = -1;
    private int estimatedShipTime = -1;
    private int thumbnailImageId = -1;
    private int smallImageId = -1;
    private int largeImageId = -1;
    private int listOrder = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private String name = null;
    private String abbreviation = null;
    private String shortDescription = null;
    private String longDescription = null;
    private String specialNotes = null;
    private String sku = null;
    private boolean enabled = false;
    private boolean inStock = true;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private Timestamp startDate = null;
    private Timestamp expirationDate = null;
    private Timestamp trashedDate = null;
    private boolean active = false;
    private int categoryId = -1;
    private String categoryName = null;
    private String parentName = null;
    private String typeName = null;
    private String formatName = null;
    private String shippingName = null;
    private String shippingTimeName = null;
    private String smallImageName = null;
    private String largeImageName = null;
    private String thumbnailImageName = null;
    private int buildActiveOptions = -1;
    private boolean buildOptions = false;
    private boolean buildCategories = false;
    private ProductOptionList optionList = null;
    private ProductCategoryList categoryList = new ProductCategoryList();
    private ProductCatalogPricingList priceList = new ProductCatalogPricingList();
    private ProductCatalogPricing activePrice = new ProductCatalogPricing();
    private boolean hasCustomerProduct = false;
    private boolean buildPriceList = false;
    private boolean buildActivePrice = false;
    private int statusId = -1;
    private int importId = -1;
    private String comments = null;
    private FileInfo smallImageFile = null;
    private FileInfo largeImageFile = null;
    private FileInfo thumbnailImageFile = null;
    private double msrpAmount = 0.0;
    private double priceAmount = 0.0;
    private double costAmount = 0.0;
    private long milies = -1L;
    private static Logger logger = Logger.getLogger(ProductCatalog.class);

    public FileInfo getThumbnailImageFile() {
        return this.thumbnailImageFile;
    }

    public void setThumbnailImageFile(FileInfo thumbnailImageFile) {
        this.thumbnailImageFile = thumbnailImageFile;
    }

    public String getThumbnailImageName() {
        return this.thumbnailImageName;
    }

    public void setThumbnailImageName(String thumbnailImageName) {
        this.thumbnailImageName = thumbnailImageName;
    }

    public FileInfo getLargeImageFile() {
        return this.largeImageFile;
    }

    public void setLargeImageFile(FileInfo largeImageFile) {
        this.largeImageFile = largeImageFile;
    }

    public FileInfo getSmallImageFile() {
        return this.smallImageFile;
    }

    public void setSmallImageFile(FileInfo smallImageFile) {
        this.smallImageFile = smallImageFile;
    }

    public boolean isApproved() {
        return this.statusId != 6;
    }

    public String getLargeImageName() {
        return this.largeImageName;
    }

    public void setLargeImageName(String largeImageName) {
        this.largeImageName = largeImageName;
    }

    public String getSmallImageName() {
        return this.smallImageName;
    }

    public void setSmallImageName(String smallImageName) {
        this.smallImageName = smallImageName;
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String comments) {
        this.comments = comments;
    }

    public int getImportId() {
        return this.importId;
    }

    public void setImportId(int importId) {
        this.importId = importId;
    }

    public void setImportId(String importId) {
        this.importId = Integer.parseInt(importId);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = Integer.parseInt(statusId);
    }

    public int getBuildActiveOptions() {
        return this.buildActiveOptions;
    }

    public void setBuildActiveOptions(int tmp) {
        this.buildActiveOptions = tmp;
    }

    public void setBuildActiveOptions(String tmp) {
        this.buildActiveOptions = Integer.parseInt(tmp);
    }

    public boolean getBuildActivePrice() {
        return this.buildActivePrice;
    }

    public void setBuildActivePrice(boolean tmp) {
        this.buildActivePrice = tmp;
    }

    public void setBuildActivePrice(String tmp) {
        this.buildActivePrice = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildPriceList() {
        return this.buildPriceList;
    }

    public void setBuildPriceList(boolean tmp) {
        this.buildPriceList = tmp;
    }

    public void setBuildPriceList(String tmp) {
        this.buildPriceList = DatabaseUtils.parseBoolean(tmp);
    }

    public ProductCatalogPricingList getPriceList() {
        return this.priceList;
    }

    public void setPriceList(ProductCatalogPricingList tmp) {
        this.priceList = tmp;
    }

    public void setBuildCategories(boolean tmp) {
        this.buildCategories = tmp;
    }

    public void setBuildCategories(String tmp) {
        this.buildCategories = DatabaseUtils.parseBoolean(tmp);
    }

    public void setActivePrice(ProductCatalogPricing tmp) {
        this.activePrice = tmp;
    }

    public ProductCatalogPricing getActivePrice() {
        return this.activePrice;
    }

    public boolean getBuildCategories() {
        return this.buildCategories;
    }

    public void setCategoryList(ProductCategoryList tmp) {
        this.categoryList = tmp;
    }

    public ProductCategoryList getCategoryList() {
        return this.categoryList;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setFormatId(int tmp) {
        this.formatId = tmp;
    }

    public void setFormatId(String tmp) {
        this.formatId = Integer.parseInt(tmp);
    }

    public void setShippingId(int tmp) {
        this.shippingId = tmp;
    }

    public void setShippingId(String tmp) {
        this.shippingId = Integer.parseInt(tmp);
    }

    public void setEstimatedShipTime(int tmp) {
        this.estimatedShipTime = tmp;
    }

    public void setEstimatedShipTime(String tmp) {
        this.estimatedShipTime = Integer.parseInt(tmp);
    }

    public void setThumbnailImageId(int tmp) {
        this.thumbnailImageId = tmp;
    }

    public void setThumbnailImageId(String tmp) {
        this.thumbnailImageId = Integer.parseInt(tmp);
    }

    public void setSmallImageId(int tmp) {
        this.smallImageId = tmp;
    }

    public void setSmallImageId(String tmp) {
        this.smallImageId = Integer.parseInt(tmp);
    }

    public void setLargeImageId(int tmp) {
        this.largeImageId = tmp;
    }

    public void setLargeImageId(String tmp) {
        this.largeImageId = Integer.parseInt(tmp);
    }

    public void setListOrder(int tmp) {
        this.listOrder = tmp;
    }

    public void setListOrder(String tmp) {
        this.listOrder = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setProductName(String tmp) {
        this.name = tmp;
    }

    public void setAbbreviation(String tmp) {
        this.abbreviation = tmp;
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setLongDescription(String tmp) {
        this.longDescription = tmp;
    }

    public void setSpecialNotes(String tmp) {
        this.specialNotes = tmp;
    }

    public void setSku(String tmp) {
        this.sku = tmp;
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setInStock(boolean tmp) {
        this.inStock = tmp;
    }

    public void setInStock(String tmp) {
        this.inStock = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void setActive(boolean tmp) {
        this.active = tmp;
    }

    public void setActive(String tmp) {
        this.active = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setCategoryName(String tmp) {
        this.categoryName = tmp;
    }

    public void setBuildOptions(boolean tmp) {
        this.buildOptions = tmp;
    }

    public void setBuildOptions(String tmp) {
        this.buildOptions = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOptionList(ProductOptionList tmp) {
        this.optionList = tmp;
    }

    public void setHasCustomerProduct(boolean tmp) {
        this.hasCustomerProduct = tmp;
    }

    public void setHasCustomerProduct(String tmp) {
        this.hasCustomerProduct = DatabaseUtils.parseBoolean(tmp);
    }

    public void setParentName(String tmp) {
        this.parentName = tmp;
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setFormatName(String tmp) {
        this.formatName = tmp;
    }

    public void setShippingName(String tmp) {
        this.shippingName = tmp;
    }

    public void setShippingTimeName(String tmp) {
        this.shippingTimeName = tmp;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getFormatName() {
        return this.formatName;
    }

    public String getShippingName() {
        return this.shippingName;
    }

    public String getShippingTimeName() {
        return this.shippingTimeName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getFormatId() {
        return this.formatId;
    }

    public int getShippingId() {
        return this.shippingId;
    }

    public int getEstimatedShipTime() {
        return this.estimatedShipTime;
    }

    public int getThumbnailImageId() {
        return this.thumbnailImageId;
    }

    public int getSmallImageId() {
        return this.smallImageId;
    }

    public int getLargeImageId() {
        return this.largeImageId;
    }

    public int getLargestImageId() {
        if (this.largeImageId > -1) {
            return this.largeImageId;
        }
        if (this.smallImageId > -1) {
            return this.smallImageId;
        }
        if (this.thumbnailImageId > -1) {
            return this.thumbnailImageId;
        }
        return -1;
    }

    public int getListOrder() {
        return this.listOrder;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public String getName() {
        return this.name;
    }

    public String getProductName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getSpecialNotes() {
        return this.specialNotes;
    }

    public String getSku() {
        return this.sku;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getInStock() {
        return this.inStock;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getActive() {
        return this.active;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public boolean getBuildOptions() {
        return this.buildOptions;
    }

    public ProductOptionList getOptionList() {
        return this.optionList;
    }

    public boolean getHasCustomerProduct() {
        return this.hasCustomerProduct;
    }

    public double getMsrpAmount() {
        return this.msrpAmount;
    }

    public void setMsrpAmount(double tmp) {
        this.msrpAmount = tmp;
    }

    public void setMsrpAmount(String tmp) {
        this.msrpAmount = Double.parseDouble(tmp);
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setPriceAmount(String tmp) {
        this.priceAmount = Double.parseDouble(tmp);
    }

    public double getCostAmount() {
        return this.costAmount;
    }

    public void setCostAmount(double tmp) {
        this.costAmount = tmp;
    }

    public void setCostAmount(String tmp) {
        this.costAmount = Double.parseDouble(tmp);
    }

    public ProductCatalog() {
    }

    public ProductCatalog(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductCatalog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Catalog Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT pctlg.*, pctlg2.product_name AS parent_name, pctlgtype.description AS type_name, pctlgformat.description AS format_name, pctlgshipping.description AS shipping_name, pctlgshiptime.description AS shiptime_name FROM product_catalog pctlg LEFT JOIN product_catalog pctlg2 ON ( pctlg.parent_id = pctlg2.product_id ) LEFT JOIN lookup_product_type pctlgtype ON ( pctlg.type_id = pctlgtype.code ) LEFT JOIN lookup_product_format pctlgformat ON ( pctlg.format_id = pctlgformat.code ) LEFT JOIN lookup_product_shipping pctlgshipping ON ( pctlg.shipping_id = pctlgshipping.code ) LEFT JOIN lookup_product_ship_time pctlgshiptime ON ( pctlg.estimated_ship_time = pctlgshiptime.code ) WHERE pctlg.product_id = ? ");
        pst.setInt(1, id);
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildOptions) {
            this.buildOptions(db);
        }
        if (this.buildCategories) {
            this.buildCategories(db);
        }
        if (this.buildPriceList) {
            this.buildPriceList(db);
        }
        if (this.buildActivePrice) {
            this.buildActivePrice(db);
        }
    }

    public void determineActualCategory(Connection db) throws SQLException {
        if (this.categoryId != -1) {
            String str = this.determineActualCategoryName(db, this.categoryId);
            if (str.indexOf("Publications,") > -1) {
                str = str.substring(str.indexOf(",") + 1);
            }
            this.setCategoryName(str.trim());
        }
    }

    public String determineCategoryByProductId(Connection db, int id) throws SQLException {
        String result = null;
        if (id != -1) {
            PreparedStatement pst = db.prepareStatement("select pc.category_name from product_catalog_category_map pctlgcm, product_category pc where pctlgcm.category_id=pc.category_id and pctlgcm.product_id=?");
            pst.setInt(1, id);
            if (System.getProperty("DEBUG") != null) {
                this.milies = System.currentTimeMillis();
                logger.debug((Object)pst.toString());
            }
            ResultSet rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                this.milies = System.currentTimeMillis() - this.milies;
                logger.debug((Object)(String.valueOf(this.milies) + " ms"));
            }
            if (rs.next()) {
                result = rs.getString(1);
                while (rs.next()) {
                    result = result + ", " + rs.getString(1);
                }
            }
            rs.close();
            pst.close();
        }
        return result;
    }

    public void determineCategory(Connection db) throws SQLException {
        this.categoryName = this.determineCategoryByProductId(db, this.id);
    }

    public boolean removeFileItem(Connection db, int itemId, String imageType, String path) throws SQLException {
        boolean recordDeleted = false;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if ("thumbnail".equals(imageType)) {
                this.setThumbnailImageId(-1);
            } else if ("small".equals(imageType)) {
                this.setSmallImageId(-1);
            } else if ("large".equals(imageType)) {
                this.setLargeImageId(-1);
            }
            this.update(db);
            FileItem thisItem = new FileItem(db, itemId, this.getId(), 200403194);
            recordDeleted = thisItem.delete(db, path);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return recordDeleted;
    }

    public void buildOptions(Connection db) throws SQLException {
        this.optionList = new ProductOptionList();
        this.optionList.setProductId(this.id);
        this.optionList.setEnabled(this.getBuildActiveOptions());
        this.optionList.setBuildConfigDetails(true);
        this.optionList.setBuildResources(true);
        this.optionList.buildList(db);
    }

    public void buildCategories(Connection db) throws SQLException {
        this.categoryList = new ProductCategoryList();
        this.categoryList.setProductId(this.id);
        this.categoryList.buildList(db);
    }

    public void buildPriceList(Connection db) throws SQLException {
        this.priceList = new ProductCatalogPricingList();
        this.priceList.setProductId(this.getId());
        this.priceList.buildList(db);
    }

    public int addCategoryMapping(Connection db, int categoryId) throws SQLException {
        int result = -1;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if (categoryId > -1) {
                int i = 0;
                int seqId = DatabaseUtils.getNextSeq(db, "product_catalog_category_map_id_seq");
                PreparedStatement pst = db.prepareStatement("INSERT INTO product_catalog_category_map (" + (seqId > -1 ? "id, " : "") + "product_id, category_id) " + "VALUES (" + (seqId > -1 ? "?, " : "") + "?, ?)");
                if (seqId > -1) {
                    pst.setInt(++i, seqId);
                }
                pst.setInt(++i, this.getId());
                pst.setInt(++i, categoryId);
                result = pst.executeUpdate();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public void removeCategoryMapping(Connection db, int categoryId) throws SQLException {
        int i = 0;
        PreparedStatement pst = db.prepareStatement(" DELETE FROM product_catalog_category_map  WHERE product_id = ? AND category_id = ? ");
        pst.setInt(++i, this.getId());
        pst.setInt(++i, categoryId);
        pst.execute();
        pst.close();
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("product_id"));
        this.setParentId(DatabaseUtils.getInt(rs, "parent_id"));
        this.setName(rs.getString("product_name"));
        this.setAbbreviation(rs.getString("abbreviation"));
        this.setShortDescription(rs.getString("short_description"));
        this.setLongDescription(rs.getString("long_description"));
        this.setTypeId(DatabaseUtils.getInt(rs, "type_id"));
        this.setSpecialNotes(rs.getString("special_notes"));
        this.setSku(rs.getString("sku"));
        this.setInStock(rs.getBoolean("in_stock"));
        this.setFormatId(DatabaseUtils.getInt(rs, "format_id"));
        this.setShippingId(DatabaseUtils.getInt(rs, "shipping_id"));
        this.setEstimatedShipTime(DatabaseUtils.getInt(rs, "estimated_ship_time"));
        this.setThumbnailImageId(DatabaseUtils.getInt(rs, "thumbnail_image_id"));
        this.setSmallImageId(DatabaseUtils.getInt(rs, "small_image_id"));
        this.setLargeImageId(DatabaseUtils.getInt(rs, "large_image_id"));
        this.setListOrder(DatabaseUtils.getInt(rs, "list_order"));
        this.setEnteredBy(rs.getInt("enteredby"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setModifiedBy(rs.getInt("modifiedby"));
        this.setModified(rs.getTimestamp("modified"));
        this.setStartDate(rs.getTimestamp("start_date"));
        this.setExpirationDate(rs.getTimestamp("expiration_date"));
        this.setEnabled(rs.getBoolean("enabled"));
        this.setTrashedDate(rs.getTimestamp("trashed_date"));
        this.setActive(rs.getBoolean("active"));
        this.setStatusId(DatabaseUtils.getInt(rs, "status_id"));
        this.setImportId(DatabaseUtils.getInt(rs, "import_id"));
        this.setComments(rs.getString("comments"));
        this.setParentName(rs.getString("parent_name"));
        this.setTypeName(rs.getString("type_name"));
        this.setFormatName(rs.getString("format_name"));
        this.setShippingName(rs.getString("shipping_name"));
        this.setShippingTimeName(rs.getString("shiptime_name"));
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Product Catalog ID not specified.");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("DELETE FROM product_catalog_category_map WHERE product_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            ProductOptionList optionList = new ProductOptionList();
            optionList.setProductId(this.getId());
            optionList.buildList(db);
            i = 0;
            pst = db.prepareStatement("DELETE FROM product_option_map WHERE product_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            optionList.delete(db);
            i = 0;
            pst = db.prepareStatement("DELETE FROM product_catalog_pricing WHERE product_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("UPDATE web_product_access_log  SET product_id = ?  WHERE product_id = ? ");
            i = 0;
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("UPDATE web_product_email_log  SET product_id = ?  WHERE product_id = ? ");
            i = 0;
            DatabaseUtils.setInt(pst, ++i, -1);
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            i = 0;
            pst = db.prepareStatement("DELETE FROM product_catalog WHERE product_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("expirationDate");
        return thisList;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "product_catalog_product_id_seq");
            StringBuffer sql = new StringBuffer();
            sql.append(" INSERT INTO product_catalog (parent_id,  product_name, abbreviation, short_description,  long_description, type_id, special_notes, sku, in_stock, format_id,  shipping_id, estimated_ship_time , thumbnail_image_id,  small_image_id, large_image_id, list_order,  enteredby,");
            if (this.id > -1) {
                sql.append("product_id, ");
            }
            if (this.importId > -1) {
                sql.append("import_id, ");
            }
            if (this.statusId > -1) {
                sql.append("status_id, ");
            }
            if (this.comments != null) {
                sql.append("comments, ");
            }
            if (this.entered != null) {
                sql.append(" entered, ");
            }
            sql.append(" modifiedBy, ");
            sql.append(" modified, ");
            sql.append("start_date, expiration_date, enabled, " + DatabaseUtils.addQuotes(db, "active") + ")");
            sql.append("VALUES( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.importId > -1) {
                sql.append("?,");
            }
            if (this.statusId > -1) {
                sql.append("?,");
            }
            if (this.comments != null) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append(" ?, ");
            } else {
                sql.append(" " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("?, ?, ?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getAbbreviation());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getLongDescription());
            DatabaseUtils.setInt(pst, ++i, this.getTypeId());
            pst.setString(++i, this.getSpecialNotes());
            pst.setString(++i, this.getSku());
            pst.setBoolean(++i, this.getInStock());
            DatabaseUtils.setInt(pst, ++i, this.getFormatId());
            DatabaseUtils.setInt(pst, ++i, this.getShippingId());
            DatabaseUtils.setInt(pst, ++i, this.getEstimatedShipTime());
            DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
            DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
            DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
            DatabaseUtils.setInt(pst, ++i, this.getListOrder());
            DatabaseUtils.setInt(pst, ++i, this.getEnteredBy());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.importId > -1) {
                pst.setInt(++i, this.importId);
            }
            if (this.statusId > -1) {
                pst.setInt(++i, this.statusId);
            }
            if (this.comments != null) {
                pst.setString(++i, this.comments);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getEnabled());
            pst.setBoolean(++i, this.getActive());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "product_catalog_product_id_seq", this.id);
            if (this.getCategoryId() > 0) {
                this.addCategoryMapping(db, this.getCategoryId());
            }
            Iterator j = this.categoryList.iterator();
            int thisCategoryId = -1;
            while (j.hasNext()) {
                int count;
                ProductCategory thisCategory = (ProductCategory)((Object)j.next());
                if (thisCategory.getId() == -1 && (count = thisCategory.getCategoryCountByName(db, thisCategory.getName())) <= 0) {
                    thisCategory.process(db, -1, this.enteredBy, this.modifiedBy);
                    thisCategoryId = DatabaseUtils.getCurrVal(db, "product_category_category_id_seq", this.id);
                }
                if (thisCategoryId < 0) {
                    thisCategoryId = thisCategory.getId() < 0 ? ProductCategory.getCategoryById(thisCategory.getName(), this.importId, db) : thisCategory.getId();
                }
                this.addCategoryMapping(db, thisCategoryId);
            }
            for (ProductCatalogPricing thisPrice : this.priceList) {
                thisPrice.setEnabled(true);
                thisPrice.process(db, this.id, this.getEnteredBy(), this.getModifiedBy());
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean insertClone(Connection db, ProductCatalog cloneSource) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.insert(db);
            for (ProductCatalogPricing thisPrice : cloneSource.getPriceList()) {
                thisPrice.setId(-1);
                thisPrice.setProductId(this.getId());
                thisPrice.insert(db);
            }
            for (ProductOption thisOption : cloneSource.getOptionList()) {
                thisOption.setProductId(this.getId());
                thisOption.insertClone(db);
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_catalog SET parent_id = ?, product_name = ?, abbreviation = ?, short_description = ?, long_description = ?, type_id = ?, special_notes = ?, sku = ?, in_stock = ?, format_id = ?, shipping_id = ?, estimated_ship_time = ?, thumbnail_image_id = ?, small_image_id = ?, large_image_id = ?, list_order = ?, start_date = ?, expiration_date = ?, enabled = ?, trashed_date = ?, " + DatabaseUtils.addQuotes(db, "active") + " = ?, " + "modifiedby = ?, " + "modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        sql.append("WHERE product_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getAbbreviation());
        pst.setString(++i, this.getShortDescription());
        pst.setString(++i, this.getLongDescription());
        DatabaseUtils.setInt(pst, ++i, this.getTypeId());
        pst.setString(++i, this.getSpecialNotes());
        pst.setString(++i, this.getSku());
        pst.setBoolean(++i, this.getInStock());
        DatabaseUtils.setInt(pst, ++i, this.getFormatId());
        DatabaseUtils.setInt(pst, ++i, this.getShippingId());
        DatabaseUtils.setInt(pst, ++i, this.getEstimatedShipTime());
        DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
        DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
        DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
        DatabaseUtils.setInt(pst, ++i, this.getListOrder());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
        pst.setBoolean(++i, this.getEnabled());
        DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
        pst.setBoolean(++i, this.getActive());
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateImages(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_catalog SET thumbnail_image_id = ?,small_image_id = ?, large_image_id = ?, modifiedby = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        sql.append("WHERE product_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
        DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
        DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        int resultCount = -1;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_catalog SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE product_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        if (toTrash) {
            DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
        } else {
            DatabaseUtils.setTimestamp(pst, ++i, null);
        }
        DatabaseUtils.setInt(pst, ++i, tmpUserId);
        DatabaseUtils.setInt(pst, ++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        TicketList ticketList = new TicketList();
        ticketList.setProductId(this.getId());
        if (!toTrash) {
            ticketList.setIncludeOnlyTrashed(true);
        }
        ticketList.buildList(db);
        ticketList.updateStatus(db, toTrash, tmpUserId);
        ServiceContractProductList serviceContractProductList = new ServiceContractProductList();
        serviceContractProductList.setProductId(this.getId());
        serviceContractProductList.buildList(db);
        for (ServiceContractProduct serviceContractProduct : serviceContractProductList) {
            int tmpContractId = serviceContractProduct.getContractId();
            ServiceContract tmpServiceContract = new ServiceContract(db, tmpContractId);
            tmpServiceContract.updateStatus(db, toTrash, tmpUserId);
        }
        QuoteProductList quoteProductList = new QuoteProductList();
        quoteProductList.setProductId(this.getId());
        quoteProductList.buildList(db);
        for (QuoteProduct quoteProduct : quoteProductList) {
            int tmpQuoteId = quoteProduct.getQuoteId();
            Quote tmpQuote = new Quote(db, tmpQuoteId);
            tmpQuote.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        int catalogCount;
        if (this.getId() == -1) {
            throw new SQLException("Product Catalog ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        pst = db.prepareStatement("SELECT count(*) AS optioncount FROM product_option_map WHERE product_id = ? ");
        pst.setInt(++i, this.getId());
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next() && (catalogCount = rs.getInt("optioncount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfCatalogOptionMappings");
            thisDependency.setCount(catalogCount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        i = 0;
        pst = db.prepareStatement("SELECT count(*) AS catalogcount FROM service_contract_products WHERE link_product_id = ? ");
        pst.setInt(++i, this.getId());
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next() && (catalogCount = rs.getInt("catalogcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfServiceContractsMappedToTheProduct");
            thisDependency.setCount(catalogCount);
            thisDependency.setCanDelete(false);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        i = 0;
        pst = db.prepareStatement("SELECT count(*) AS catalogcount FROM ticket WHERE product_id = ? ");
        pst.setInt(++i, this.getId());
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next() && (catalogCount = rs.getInt("catalogcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfTicketsMappedToTheProduct");
            thisDependency.setCount(catalogCount);
            thisDependency.setCanDelete(false);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        i = 0;
        pst = db.prepareStatement("SELECT count(*) AS catalogcount FROM quote_product WHERE product_id = ? ");
        pst.setInt(++i, this.getId());
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next() && (catalogCount = rs.getInt("catalogcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfQuoteProductsMappedToTheProduct");
            thisDependency.setCount(catalogCount);
            thisDependency.setCanDelete(false);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        return dependencyList;
    }

    public void getProductCatalogByName(Connection db, String productName, String dimensions, int categoryId) throws SQLException {
        int i = 0;
        StringBuffer sql = new StringBuffer(" SELECT pctlg.product_id AS product_id  FROM product_catalog pctlg  LEFT JOIN product_catalog_category_map pctlgmap  ON ( pctlg.product_id = pctlgmap.product_id )  LEFT JOIN product_category pctgy  ON ( pctlgmap.category_id = pctgy.category_id )  WHERE pctgy.category_id = ? ");
        if (dimensions != null && !"".equals(dimensions)) {
            sql.append(" AND pctlg.short_description = ? ");
        } else {
            sql.append(" AND pctlg.product_name = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, categoryId);
        if (dimensions != null && !"".equals(dimensions)) {
            pst.setString(++i, dimensions);
        } else {
            pst.setString(++i, productName);
        }
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        ResultSet rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (rs.next()) {
            this.setBuildOptions(true);
            this.queryRecord(db, rs.getInt("product_id"));
        }
        rs.close();
        pst.close();
    }

    public ProductCatalogPricing getActivePrice(Connection db) throws SQLException {
        if (this.getId() < 0) {
            throw new SQLException("Product ID not specified");
        }
        ProductCatalogPricingList priceList = new ProductCatalogPricingList();
        priceList.setProductId(this.getId());
        priceList.setEnabled(1);
        priceList.setIsValidNow(1);
        priceList.buildList(db);
        if (priceList.size() == 0) {
            return null;
        }
        return (ProductCatalogPricing)((Object)priceList.get(0));
    }

    public void buildActivePrice(Connection db) throws SQLException {
        this.setActivePrice(this.getActivePrice(db));
    }

    public void resetBaseInfo() {
        this.name = null;
        this.id = -1;
    }

    public static int updateImportStatus(Connection db, int importId, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE product_catalog SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, importId);
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public String determineActualCategoryName(Connection db, int ctgyId) throws SQLException {
        StringBuffer sb = new StringBuffer();
        if (ctgyId != -1) {
            ProductCategory category = new ProductCategory(db, ctgyId);
            sb.append(category.getName());
            int ctgyParentId = category.getParentId();
            while (ctgyParentId != -1) {
                ProductCategory parent = new ProductCategory(db, ctgyParentId);
                sb.insert(0, parent.getName() + ", ");
                ctgyParentId = parent.getParentId();
            }
        }
        return sb.toString();
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("priceAmount");
        thisList.add("msrpAmount");
        thisList.add("costAmount");
        return thisList;
    }

    public boolean hasPricing() {
        return this.getMsrpAmount() > 0.0 || this.getPriceAmount() > 0.0 || this.getCostAmount() > 0.0;
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            logger.setLevel(Level.DEBUG);
        }
    }
}

