/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.isavvix.tools.FileInfo;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.Thumbnail;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.aspcfs.utils.ImageUtils;

public class ProductCatalogImages
extends HashMap {
    public ProductCatalogImages() {
    }

    public ProductCatalogImages(FileItem fileItem, String zipFilePath) throws IOException {
        File zipFile = new File(zipFilePath + fileItem.getFilename());
        ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = null;
        while ((entry = zip.getNextEntry()) != null) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setLocalFile(new File(entry.getName()));
            fileInfo.setSize((int)entry.getSize());
            this.put(entry.getName(), fileInfo);
        }
        zip.close();
    }

    public static ProductCatalogImages processZipFile(FileItem fileItem, String zipFilePath) throws IOException {
        String imagesPath = zipFilePath;
        File zipFile = new File(zipFilePath + fileItem.getFilename());
        ZipInputStream zip = new ZipInputStream(new FileInputStream(zipFile));
        ZipEntry entry = null;
        ProductCatalogImages fileList = new ProductCatalogImages();
        byte[] buffer = new byte[1024];
        String filenameToUse = null;
        int fileCount = 0;
        while ((entry = zip.getNextEntry()) != null) {
            int count;
            if (entry.isDirectory()) continue;
            SimpleDateFormat formatter = new SimpleDateFormat("yyyyMMddHHmmssSSS");
            filenameToUse = formatter.format(new Date());
            if (++fileCount > 1) {
                filenameToUse = filenameToUse + String.valueOf(fileCount);
            }
            String fileName = imagesPath + filenameToUse;
            FileOutputStream file = new FileOutputStream(fileName);
            while ((count = zip.read(buffer)) != -1) {
                file.write(buffer, 0, count);
            }
            file.close();
            FileInfo fileInfo = new FileInfo();
            File newFile = new File(fileName);
            fileInfo.setLocalFile(newFile);
            fileInfo.setName(newFile.getName());
            fileInfo.setSize((int)entry.getSize());
            fileList.put(entry.getName(), fileInfo);
        }
        zip.close();
        return fileList;
    }

    public FileItem saveImage(Connection db, String imageFileName, int productId, int userId) {
        FileInfo largeImageInfo = (FileInfo)this.get(imageFileName);
        FileItem image = new FileItem();
        try {
            File thumbnailFile;
            image.setSubject("Attachmect");
            image.setClientFilename(imageFileName);
            image.setFilename(largeImageInfo.getRealFilename());
            image.setVersion(1.0);
            image.setSize(largeImageInfo.getSize());
            image.setEnabled(false);
            image.setLinkItemId(productId);
            image.setLinkModuleId(200403194);
            image.setEnteredBy(userId);
            image.setModifiedBy(userId);
            boolean largeImageInserted = image.insert(db);
            if (image.isImageFormat() && largeImageInserted) {
                thumbnailFile = new File(largeImageInfo.getLocalFile().getPath() + "TH");
                try {
                    ImageUtils.saveThumbnail(largeImageInfo.getLocalFile(), thumbnailFile, 133.0, 133.0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            } else {
                return null;
            }
            Thumbnail thumbnail = new Thumbnail();
            thumbnail.setId(image.getId());
            thumbnail.setFilename(largeImageInfo.getRealFilename() + "TH");
            thumbnail.setVersion(image.getVersion());
            thumbnail.setSize((int)thumbnailFile.length());
            thumbnail.setEnteredBy(image.getEnteredBy());
            thumbnail.setModifiedBy(image.getModifiedBy());
            thumbnail.insert(db);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
        return image;
    }
}

