/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.database.ConnectionElement;
import com.zeroio.iteam.base.FileItem;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.apps.transfer.reader.mapreader.Property;
import org.aspcfs.apps.transfer.reader.mapreader.PropertyMap;
import org.aspcfs.controller.ImportManager;
import org.aspcfs.controller.ObjectValidator;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.admin.base.UserList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.base.Import;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogImages;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.utils.CFSFileReader;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;

public class ProductCatalogImport
extends Import
implements Runnable {
    private static final long serialVersionUID = 1L;
    public static final String fs = System.getProperty("file.separator");
    private PropertyMap propertyMap = null;
    private String filePath = null;
    private int owner = -1;
    private int userId = -1;
    private int accessTypeId = -1;
    private boolean lookupAccount = false;
    private ImportManager manager = null;
    private Connection db = null;
    private ConnectionElement connectionElement = null;
    private File errorFile = null;
    private BufferedWriter fos = null;
    private FileItem fileItem = null;
    private FileItem zipFileItem = null;
    private Thread importThread = null;
    private boolean lead = false;
    private int leadStatus = -1;
    private int imageId = -1;
    private ProductCatalogImages imageList = new ProductCatalogImages();

    public ProductCatalogImages getImageList() {
        return this.imageList;
    }

    public void setImageList(ProductCatalogImages imageList) {
        this.imageList = imageList;
    }

    public int getImageId() {
        return this.imageId;
    }

    public void setId(String tmp) {
        this.imageId = Integer.parseInt(tmp);
    }

    public void setImageId(int imageId) {
        this.imageId = imageId;
    }

    public ProductCatalogImport() {
    }

    public ProductCatalogImport(Connection db, int importId) throws SQLException {
        super(db, importId);
    }

    public void setProperties(HttpServletRequest request) {
        if (request.getParameter("owner") != null) {
            this.setOwner(request.getParameter("owner"));
        }
        if (request.getParameter("accessType") != null) {
            this.setAccessTypeId(request.getParameter("accessType"));
        }
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setAccessTypeId(int tmp) {
        this.accessTypeId = tmp;
    }

    public void setAccessTypeId(String tmp) {
        this.accessTypeId = Integer.parseInt(tmp);
    }

    public void setUserId(int tmp) {
        this.userId = tmp;
    }

    public void setUserId(String tmp) {
        this.userId = Integer.parseInt(tmp);
    }

    public void setLookupAccount(boolean tmp) {
        this.lookupAccount = tmp;
    }

    public void setLookupAccount(String tmp) {
        this.lookupAccount = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPropertyMap(PropertyMap tmp) {
        this.propertyMap = tmp;
    }

    public void setFilePath(String tmp) {
        this.filePath = tmp;
    }

    public void setDb(Connection tmp) {
        this.db = tmp;
    }

    public void setManager(ImportManager tmp) {
        this.manager = tmp;
    }

    public void setErrorFile(File tmp) {
        this.errorFile = tmp;
    }

    public void setFileItem(FileItem tmp) {
        this.fileItem = tmp;
    }

    public void setImportThread(Thread tmp) {
        this.importThread = tmp;
    }

    public Thread getImportThread() {
        return this.importThread;
    }

    public FileItem getFileItem() {
        return this.fileItem;
    }

    public File getErrorFile() {
        return this.errorFile;
    }

    public ImportManager getManager() {
        return this.manager;
    }

    public Connection getDb() {
        return this.db;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public PropertyMap getPropertyMap() {
        return this.propertyMap;
    }

    public boolean getLookupAccount() {
        return this.lookupAccount;
    }

    public int getUserId() {
        return this.userId;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getAccessTypeId() {
        return this.accessTypeId;
    }

    public void setConnectionElement(ConnectionElement tmp) {
        this.connectionElement = tmp;
    }

    public ConnectionElement getConnectionElement() {
        return this.connectionElement;
    }

    public boolean getLead() {
        return this.lead;
    }

    public void setLead(boolean tmp) {
        this.lead = tmp;
    }

    public void setLead(String tmp) {
        this.lead = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLeadStatus() {
        return this.leadStatus;
    }

    public void setLeadStatus(int tmp) {
        this.leadStatus = tmp;
    }

    public void setLeadStatus(String tmp) {
        this.leadStatus = Integer.parseInt(tmp);
    }

    public void start() {
        this.importThread = new Thread(this);
        this.importThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ArrayList thisRecord = new ArrayList();
        String line = null;
        StringBuffer error = new StringBuffer();
        int recordCount = 1;
        boolean recordInserted = false;
        boolean done = false;
        ArrayList header = null;
        Thread currentThread = Thread.currentThread();
        HashMap images = new HashMap();
        try {
            this.db = this.manager.getConnection(this.connectionElement);
            this.errorFile = new File(this.filePath + "_error");
            this.fos = new BufferedWriter(new FileWriter(this.errorFile));
            if (this.db == null) {
                throw new Exception("FATAL: Could not get database connection!");
            }
            if (this.updateStatus(this.db, 3) < 1) {
                throw new Exception("Error updating status to RUNNING");
            }
            CFSFileReader fileReader = new CFSFileReader(this.filePath, this.getFileType());
            CFSFileReader.Record record = fileReader.nextLine();
            header = record.data;
            this.recordError(null, record.line, 0);
            ProductCategoryList productCategoryList = new ProductCategoryList();
            productCategoryList.setExcludeUnapprovedCategories(false);
            productCategoryList.buildList(this.db);
            UserList userList = new UserList();
            userList.setSiteId(this.getSiteId());
            userList.buildList(this.db);
            while (this.importThread == currentThread && !done) {
                record = fileReader.nextLine();
                if (record != null) {
                    if (error.length() > 0) {
                        error.delete(0, error.length());
                    }
                    recordInserted = false;
                    ++recordCount;
                    try {
                        User user;
                        String productCode;
                        String longDescription;
                        String shortDescription;
                        String thumbnailImageName;
                        String largeImageName;
                        if (record.isEmpty()) continue;
                        thisRecord = record.data;
                        line = fileReader.padLine(record.line, header.size() - thisRecord.size());
                        ProductCatalog thisProductCatalog = new ProductCatalog();
                        thisProductCatalog.setImportId(this.getId());
                        thisProductCatalog.setStatusId(6);
                        thisProductCatalog.setComments(this.getComments());
                        String productName = this.getValue(thisRecord, this.propertyMap.getProperty("productName"));
                        if (!"".equals(StringUtils.toString(productName))) {
                            thisProductCatalog.setProductName(productName);
                        } else if ("".equals(StringUtils.toString(thisProductCatalog.getProductName())) && this.getType() == 33020045) {
                            error.append("; Product name is a required field");
                        }
                        ArrayList priceInstances = this.propertyMap.getDependencyMapList("productCatalogPricing");
                        for (PropertyMap thisMap : priceInstances) {
                            String price = this.getValue(thisRecord, thisMap.getProperty("priceAmount"));
                            price = StringUtils.replace(price, "$", "");
                            price = StringUtils.replace(price, ",", ".");
                            ProductCatalogPricing thisProductCatalogPricing = new ProductCatalogPricing();
                            if ("".equals(StringUtils.toString(price))) continue;
                            thisProductCatalogPricing.setPriceAmount(price);
                            thisProductCatalog.getPriceList().add(thisProductCatalogPricing);
                        }
                        ArrayList categoryInstances = this.propertyMap.getDependencyMapList("productCategory");
                        for (PropertyMap thisMap : categoryInstances) {
                            String categoryName = this.getValue(thisRecord, thisMap.getProperty("name"));
                            if ("".equals(StringUtils.toString(categoryName))) continue;
                            StringTokenizer categoryNamesList = new StringTokenizer(categoryName, ",", false);
                            while (categoryNamesList.hasMoreTokens()) {
                                String tmp = categoryNamesList.nextToken();
                                ProductCategory tmpProductCategory = new ProductCategory();
                                tmpProductCategory.setImportId(this.getId());
                                tmpProductCategory.setStatusId(6);
                                if (productCategoryList.getCategoryByName(tmp) != null) {
                                    tmpProductCategory = productCategoryList.getCategoryByName(tmp);
                                }
                                tmpProductCategory.setName(tmp);
                                thisProductCatalog.getCategoryList().add(tmpProductCategory);
                            }
                        }
                        String smallImageName = this.getValue(thisRecord, this.propertyMap.getProperty("smallImageName"));
                        if (!"".equals(StringUtils.toString(smallImageName))) {
                            if (!images.isEmpty()) {
                                if (this.imageList.containsKey(smallImageName)) {
                                    images.put(smallImageName, null);
                                    thisProductCatalog.setSmallImageName(smallImageName);
                                } else {
                                    error.append("; Small Image Name is absent in archive");
                                }
                            } else if (this.imageList.containsKey(smallImageName)) {
                                images.put(smallImageName, null);
                                thisProductCatalog.setSmallImageName(smallImageName);
                            } else {
                                error.append("; Small Image Name is absent in archive");
                            }
                        }
                        if (!"".equals(StringUtils.toString(largeImageName = this.getValue(thisRecord, this.propertyMap.getProperty("largeImageName"))))) {
                            if (!images.isEmpty()) {
                                if (this.imageList.containsKey(largeImageName)) {
                                    images.put(largeImageName, null);
                                    thisProductCatalog.setLargeImageName(largeImageName);
                                } else {
                                    error.append("; Large Image Name is absent in archive");
                                }
                            } else if (this.imageList.containsKey(largeImageName)) {
                                images.put(largeImageName, null);
                                thisProductCatalog.setLargeImageName(largeImageName);
                            } else {
                                error.append("; Large Image Name is absent in archive");
                            }
                        }
                        if (!"".equals(StringUtils.toString(thumbnailImageName = this.getValue(thisRecord, this.propertyMap.getProperty("thumbnailImageName"))))) {
                            if (!images.isEmpty()) {
                                if (this.imageList.containsKey(thumbnailImageName)) {
                                    images.put(thumbnailImageName, null);
                                    thisProductCatalog.setThumbnailImageName(thumbnailImageName);
                                } else {
                                    error.append("; Thumbnail Image Name is absent in archive");
                                }
                            } else if (this.imageList.containsKey(thumbnailImageName)) {
                                images.put(thumbnailImageName, null);
                                thisProductCatalog.setThumbnailImageName(thumbnailImageName);
                            } else {
                                error.append("; Thumbnail Image Name is absent in archive");
                            }
                        }
                        if (!"".equals(StringUtils.toString(shortDescription = this.getValue(thisRecord, this.propertyMap.getProperty("shortDescription"))))) {
                            thisProductCatalog.setShortDescription(shortDescription);
                        }
                        if (!"".equals(StringUtils.toString(longDescription = this.getValue(thisRecord, this.propertyMap.getProperty("longDescription"))))) {
                            thisProductCatalog.setLongDescription(longDescription);
                        }
                        thisProductCatalog.setAbbreviation(this.getValue(thisRecord, this.propertyMap.getProperty("abbreviation")));
                        if (this.getValue(thisRecord, this.propertyMap.getProperty("estimatedShipTime")) != null) {
                            thisProductCatalog.setEstimatedShipTime(this.getValue(thisRecord, this.propertyMap.getProperty("estimatedShipTime")));
                        }
                        if (this.getValue(thisRecord, this.propertyMap.getProperty("listOrder")) != null) {
                            thisProductCatalog.setListOrder(this.getValue(thisRecord, this.propertyMap.getProperty("listOrder")));
                        }
                        if (!"".equals(StringUtils.toString(productCode = this.getValue(thisRecord, this.propertyMap.getProperty("sku"))))) {
                            thisProductCatalog.setSku(productCode);
                        }
                        thisProductCatalog.setSpecialNotes(this.getValue(thisRecord, this.propertyMap.getProperty("specialNotes")));
                        thisProductCatalog.setInStock(this.getValue(thisRecord, this.propertyMap.getProperty("inStock")));
                        thisProductCatalog.setStartDate(this.getValue(thisRecord, this.propertyMap.getProperty("startDate")));
                        thisProductCatalog.setExpirationDate(this.getValue(thisRecord, this.propertyMap.getProperty("expirationDate")));
                        thisProductCatalog.setTrashedDate(this.getValue(thisRecord, this.propertyMap.getProperty("trashedDate")));
                        String propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("enteredBy"));
                        if (!"".equals(StringUtils.toString(propertyValue))) {
                            try {
                                user = userList.getUserById(Integer.parseInt(propertyValue));
                                thisProductCatalog.setEnteredBy(user != null ? user.getId() : -1);
                            }
                            catch (NumberFormatException nfe) {
                                thisProductCatalog.setEnteredBy(userList.getUserIdByName(propertyValue));
                            }
                            if (thisProductCatalog.getEnteredBy() == -1) {
                                thisProductCatalog.setEnteredBy(this.userId);
                            }
                        } else {
                            thisProductCatalog.setEnteredBy(this.userId);
                        }
                        if (!"".equals(StringUtils.toString(propertyValue = this.getValue(thisRecord, this.propertyMap.getProperty("modifiedBy"))))) {
                            try {
                                user = userList.getUserById(Integer.parseInt(propertyValue));
                                thisProductCatalog.setModifiedBy(user != null ? user.getId() : -1);
                            }
                            catch (NumberFormatException nfe) {
                                thisProductCatalog.setModifiedBy(userList.getUserIdByName(propertyValue));
                            }
                            if (thisProductCatalog.getModifiedBy() == -1) {
                                thisProductCatalog.setModifiedBy(this.userId);
                            }
                        } else {
                            thisProductCatalog.setModifiedBy(this.userId);
                        }
                        thisProductCatalog.setEnabled(true);
                        thisProductCatalog.setInStock(true);
                        if (error.length() == 0) {
                            boolean isValid = ObjectValidator.validate(null, this.db, (Object)thisProductCatalog);
                            if (isValid && (recordInserted = thisProductCatalog.insert(this.db)) && !this.imageList.isEmpty()) {
                                int count;
                                FileItem smallImage = null;
                                FileItem largeImage = null;
                                FileItem thumbnailImage = null;
                                if (!"".equals(StringUtils.toString(thisProductCatalog.getSmallImageName()))) {
                                    smallImage = this.imageList.saveImage(this.db, thisProductCatalog.getSmallImageName(), thisProductCatalog.getId(), this.userId);
                                }
                                if (!"".equals(StringUtils.toString(thisProductCatalog.getLargeImageName()))) {
                                    largeImage = this.imageList.saveImage(this.db, thisProductCatalog.getLargeImageName(), thisProductCatalog.getId(), this.userId);
                                }
                                if (!"".equals(StringUtils.toString(thisProductCatalog.getThumbnailImageName()))) {
                                    thumbnailImage = this.imageList.saveImage(this.db, thisProductCatalog.getThumbnailImageName(), thisProductCatalog.getId(), this.userId);
                                }
                                if (smallImage != null) {
                                    thisProductCatalog.setSmallImageId(smallImage.getId());
                                }
                                if (largeImage != null) {
                                    thisProductCatalog.setLargeImageId(largeImage.getId());
                                }
                                if (thumbnailImage != null) {
                                    thisProductCatalog.setThumbnailImageId(thumbnailImage.getId());
                                }
                                if ((smallImage != null || largeImage != null || thumbnailImage != null) && (count = thisProductCatalog.updateImages(this.db)) <= 0) {
                                    recordInserted = false;
                                }
                            }
                            if (recordInserted) {
                                this.incrementTotalImportedRecords();
                                continue;
                            }
                            this.incrementTotalFailedRecords();
                            continue;
                        }
                        this.recordError(error.toString(), line, recordCount);
                    }
                    catch (Exception unknownException) {
                        unknownException.printStackTrace();
                        if (error.length() == 0) {
                            this.recordError(unknownException.toString(), line, recordCount);
                            continue;
                        }
                        this.recordError(error.toString() + "; " + unknownException.toString(), line, recordCount);
                    }
                    continue;
                }
                done = true;
            }
            if (done) {
                this.setStatusId(6);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.recordError(e.toString(), "", -1);
            try {
                this.setStatusId(4);
            }
            catch (Exception statusException) {
                e.printStackTrace();
            }
        }
        finally {
            if (this.importThread == currentThread) {
                this.stop();
            }
        }
    }

    public void cancel() {
        try {
            this.importThread = null;
            this.setStatusId(5);
            this.destroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        this.importThread = null;
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("Product Catalog Import -> Starting cleanup for ImportId: " + this.getId());
        }
        try {
            this.recordResults(this.db);
            this.fos.flush();
            this.fos.close();
            if (this.getTotalFailedRecords() > 0) {
                this.fileItem.setSubject("Error file");
                this.fileItem.setFilename(this.fileItem.getFilename() + "_error");
                this.fileItem.setClientFilename(this.getId() + "_error.csv");
                this.fileItem.setVersion(1.1);
                this.fileItem.setSize((int)this.errorFile.length());
                this.fileItem.insertVersion(this.db);
            } else {
                this.errorFile.delete();
            }
            this.manager.free(this);
        }
        catch (Exception e) {
            if (System.getProperty("DEBUG") != null) {
                e.printStackTrace();
            }
        }
        finally {
            this.manager.free(this.db);
        }
    }

    private void recordError(String error, String line, int lineNumber) {
        try {
            if (lineNumber == 0) {
                line = line + ",\"_ERROR\"";
            } else if (lineNumber == -1) {
                line = line + error;
            } else if (lineNumber > 0) {
                line = line + ",\"" + error + "\"";
                this.incrementTotalFailedRecords();
            }
            line = line + "\n";
            this.fos.write(line);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private String getValue(ArrayList thisRecord, Property type) {
        String value = null;
        if (type.getMappedColumn() > -1 && thisRecord.size() > type.getMappedColumn()) {
            value = (String)thisRecord.get(type.getMappedColumn());
        } else if (!"".equals(StringUtils.toString(type.getDefaultValue()))) {
            value = type.getDefaultValue();
        }
        return value;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        DependencyList dependencyList = new DependencyList();
        int i = 0;
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as recordcount FROM product_catalog WHERE import_id = ? ");
        pst.setInt(++i, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            recordCount = rs.getInt("recordCount");
        }
        rs.close();
        pst.close();
        Dependency thisDependency = new Dependency();
        thisDependency.setName("products");
        thisDependency.setCount(recordCount);
        thisDependency.setCanDelete(true);
        dependencyList.add(thisDependency);
        return dependencyList;
    }

    public boolean delete(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            if (this.getStatusId() != 1 || this.getStatusId() != 2) {
                ProductCatalogImport.deleteImportedRecords(db, this.getId());
            }
            PreparedStatement pst = db.prepareStatement("DELETE from import WHERE import_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }

    public static boolean deleteImportedRecords(Connection db, int thisImportId) throws SQLException {
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement("DELETE FROM product_catalog WHERE import_id = ?");
            pst.setInt(1, thisImportId);
            pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void buildFileDetails(Connection db) throws SQLException {
        this.setFile(new FileItem(db, "%.csv", this.getId(), this.getType()));
        this.getFile().buildVersionList(db);
    }

    public void buildZipFileDetails(Connection db) throws SQLException {
        this.zipFileItem = new FileItem(db, "%.zip", this.getId(), this.getType());
        this.zipFileItem.buildVersionList(db);
    }

    public FileItem getZipFileItem() {
        return this.zipFileItem;
    }

    public void setZipFileItem(FileItem zipFileItem) {
        this.zipFileItem = zipFileItem;
    }
}

