/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValues;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductCatalogList
extends ArrayList
implements SyncableList {
    public static final String tableName = "product_catalog";
    public static final String uniqueField = "product_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int enteredBy = -1;
    private int id = -1;
    private int parentId = -1;
    private int typeId = -1;
    private int enabled = 1;
    private int topOnly = -1;
    private int hasCategories = -1;
    private int active = -1;
    private int statusId = -1;
    private String name = null;
    private String abbreviation = null;
    private String sku = null;
    private String categoryName = null;
    private String parentName = null;
    private String typeName = null;
    private int categoryId = -1;
    private int serviceContractId = -1;
    private int importId = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private double priceRangeMin = -1.0;
    private double priceRangeMax = -1.0;
    private ProductCategoryList productCategoryList = new ProductCategoryList();
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private String dateAfter = null;
    private String groupKeywords = null;
    private String[] keywords = null;
    private boolean determineCategory = false;
    private boolean excludeUnapprovedProducts = true;
    private long milies = -1L;
    private static Logger logger = Logger.getLogger(ProductCatalogList.class);
    private boolean buildResources = false;
    private boolean buildActivePrice = false;
    private String optionText = null;
    private String optionPrice = null;
    private String optionDefaultText = null;
    private boolean optionMatch = true;
    private boolean optionPriceMatch = true;
    protected HashMap selectedItems = null;
    protected int buildTopLevelOnly = -1;
    protected int buildActiveProductsOnly = -1;

    public boolean isExcludeUnapprovedProducts() {
        return this.excludeUnapprovedProducts;
    }

    public void setExcludeUnapprovedProducts(boolean excludeUnapprovedProducts) {
        this.excludeUnapprovedProducts = excludeUnapprovedProducts;
    }

    public void setExcludeUnapprovedProducts(String excludeUnapprovedProducts) {
        this.excludeUnapprovedProducts = DatabaseUtils.parseBoolean(excludeUnapprovedProducts);
    }

    public double getPriceRangeMax() {
        return this.priceRangeMax;
    }

    public void setPriceRangeMax(double priceRangeMax) {
        this.priceRangeMax = priceRangeMax;
    }

    public void setPriceRangeMax(String priceRangeMax) {
        this.priceRangeMax = Double.parseDouble(priceRangeMax);
    }

    public double getPriceRangeMin() {
        return this.priceRangeMin;
    }

    public void setPriceRangeMin(double priceRangeMin) {
        this.priceRangeMin = priceRangeMin;
    }

    public void setPriceRangeMin(String priceRangeMin) {
        this.priceRangeMin = Double.parseDouble(priceRangeMin);
    }

    public int getImportId() {
        return this.importId;
    }

    public void setImportId(int importId) {
        this.importId = importId;
    }

    public void setImportId(String importId) {
        this.importId = Integer.parseInt(importId);
    }

    public int getServiceContractId() {
        return this.serviceContractId;
    }

    public void setServiceContractId(int tmp) {
        this.serviceContractId = tmp;
    }

    public void setServiceContractId(String tmp) {
        this.serviceContractId = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public boolean getBuildActivePrice() {
        return this.buildActivePrice;
    }

    public void setBuildActivePrice(boolean tmp) {
        this.buildActivePrice = tmp;
    }

    public void setBuildActivePrice(String tmp) {
        this.buildActivePrice = DatabaseUtils.parseBoolean(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAbbreviation(String tmp) {
        this.abbreviation = tmp;
    }

    public void setSku(String tmp) {
        this.sku = tmp;
    }

    public void setBuildTopLevelOnly(int tmp) {
        this.buildTopLevelOnly = tmp;
    }

    public void setBuildTopLevelOnly(String tmp) {
        this.buildTopLevelOnly = Integer.parseInt(tmp);
    }

    public void setBuildActiveProductsOnly(int tmp) {
        this.buildActiveProductsOnly = tmp;
    }

    public void setBuildActiveProductsOnly(String tmp) {
        this.buildActiveProductsOnly = Integer.parseInt(tmp);
    }

    public int getBuildTopLevelOnly() {
        return this.buildTopLevelOnly;
    }

    public int getBuildActiveProductsOnly() {
        return this.buildActiveProductsOnly;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getSku() {
        return this.sku;
    }

    public void setOptionDefaultText(String tmp) {
        this.optionDefaultText = tmp;
    }

    public String getOptionDefaultText() {
        return this.optionDefaultText;
    }

    public void setOptionPrice(String tmp) {
        this.optionPrice = tmp;
    }

    public void setHasCategories(int tmp) {
        this.hasCategories = tmp;
    }

    public void setHasCategories(String tmp) {
        this.hasCategories = Integer.parseInt(tmp);
    }

    public int getHasCategories() {
        return this.hasCategories;
    }

    public void setActive(int tmp) {
        this.active = tmp;
    }

    public void setActive(String tmp) {
        this.active = Integer.parseInt(tmp);
    }

    public int getActive() {
        return this.active;
    }

    public String getOptionPrice() {
        return this.optionPrice;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setOptionText(String tmp) {
        this.optionText = tmp;
    }

    public String getOptionText() {
        return this.optionText;
    }

    public void setOptionMatch(boolean tmp) {
        this.optionMatch = tmp;
    }

    public void setOptionMatch(String tmp) {
        this.optionMatch = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOptionPriceMatch(boolean tmp) {
        this.optionPriceMatch = tmp;
    }

    public void setOptionPriceMatch(String tmp) {
        this.optionPriceMatch = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getOptionMatch() {
        return this.optionMatch;
    }

    public boolean getOptionPriceMatch() {
        return this.optionPriceMatch;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public HashMap getSelectedItems() {
        return this.selectedItems;
    }

    public void setSelectedItems(HashMap tmp) {
        this.selectedItems = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getParentName() {
        return this.parentName;
    }

    public int getTopOnly() {
        return this.topOnly;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setCategoryName(String tmp) {
        this.categoryName = tmp;
    }

    public void setParentName(String tmp) {
        this.parentName = tmp;
    }

    public void setTopOnly(int tmp) {
        this.topOnly = tmp;
    }

    public void setTopOnly(String tmp) {
        this.topOnly = Integer.parseInt(tmp);
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM product_catalog pctlg LEFT JOIN product_catalog pctlg2 ON ( pctlg.parent_id = pctlg2.product_id ) LEFT JOIN lookup_product_type pctlgtype ON ( pctlg.type_id = pctlgtype.code ) LEFT JOIN lookup_product_format pctlgformat ON ( pctlg.format_id = pctlgformat.code ) LEFT JOIN lookup_product_shipping pctlgshipping ON ( pctlg.shipping_id = pctlgshipping.code ) LEFT JOIN lookup_product_ship_time pctlgshiptime ON ( pctlg.estimated_ship_time = pctlgshiptime.code ) WHERE pctlg.product_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            if (System.getProperty("DEBUG") != null) {
                this.milies = System.currentTimeMillis();
                logger.debug((Object)pst.toString());
            }
            rs = pst.executeQuery();
            if (System.getProperty("DEBUG") != null) {
                this.milies = System.currentTimeMillis() - this.milies;
                logger.debug((Object)(String.valueOf(this.milies) + " ms"));
            }
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.product_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                if (System.getProperty("DEBUG") != null) {
                    this.milies = System.currentTimeMillis();
                    logger.debug((Object)pst.toString());
                }
                rs = pst.executeQuery();
                if (System.getProperty("DEBUG") != null) {
                    this.milies = System.currentTimeMillis() - this.milies;
                    logger.debug((Object)(String.valueOf(this.milies) + " ms"));
                }
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("pctlg.product_name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY pctlg.product_name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("pctlg.*, pctlg2.product_name AS parent_name, pctlgtype.description AS type_name, pctlgformat.description AS format_name, pctlgshipping.description AS shipping_name, pctlgshiptime.description AS shiptime_name FROM product_catalog pctlg LEFT JOIN product_catalog pctlg2 ON ( pctlg.parent_id = pctlg2.product_id ) LEFT JOIN lookup_product_type pctlgtype ON ( pctlg.type_id = pctlgtype.code ) LEFT JOIN lookup_product_format pctlgformat ON ( pctlg.format_id = pctlgformat.code ) LEFT JOIN lookup_product_shipping pctlgshipping ON ( pctlg.shipping_id = pctlgshipping.code ) LEFT JOIN lookup_product_ship_time pctlgshiptime ON ( pctlg.estimated_ship_time = pctlgshiptime.code ) WHERE pctlg.product_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis();
            logger.debug((Object)pst.toString());
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (System.getProperty("DEBUG") != null) {
            this.milies = System.currentTimeMillis() - this.milies;
            logger.debug((Object)(String.valueOf(this.milies) + " ms"));
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ProductCatalog productCatalog = new ProductCatalog(rs);
            this.add(productCatalog);
        }
        rs.close();
        pst.close();
        for (ProductCatalog thisProduct : this) {
            if (this.determineCategory) {
                thisProduct.determineCategory(db);
            }
            if (this.buildResources) {
                thisProduct.buildOptions(db);
            }
            if (!this.buildActivePrice) continue;
            thisProduct.buildActivePrice(db);
        }
    }

    public void determineMatch() {
        Iterator productIterator = this.iterator();
        int count = 0;
        int optionId = -1;
        int valueCount = 0;
        String value = "";
        while (productIterator.hasNext()) {
            ProductCatalog thisProduct = (ProductCatalog)((Object)productIterator.next());
            ProductOptionList optionList = thisProduct.getOptionList();
            if (optionList == null) continue;
            Iterator optionIterator = optionList.iterator();
            int countOption = 0;
            while (optionIterator.hasNext()) {
                ++countOption;
                ProductOption thisOption = (ProductOption)((Object)optionIterator.next());
                if (++count == 1) {
                    optionId = thisOption.getId();
                } else if (optionId != thisOption.getId()) {
                    this.optionMatch = false;
                }
                for (ProductOptionValues thisValue : thisOption.getOptionValuesList()) {
                    this.optionPrice = Double.toString(thisValue.getMsrpAmount());
                    if (++valueCount == 1) {
                        value = Double.toString(thisValue.getMsrpAmount());
                    } else if (!value.equals(Double.toString(thisValue.getMsrpAmount()))) {
                        this.optionPriceMatch = false;
                    }
                    if (thisValue.getMsrpAmount() != 0.0) {
                        this.optionText = thisValue.getDescription();
                        continue;
                    }
                    this.optionDefaultText = thisValue.getDescription();
                }
            }
            if (countOption != 0) continue;
            this.optionMatch = false;
            this.optionPriceMatch = false;
        }
        if (!this.optionMatch) {
            this.optionText = null;
            this.optionPrice = null;
        }
    }

    public void delete(Connection db, String basePath) throws SQLException {
        for (ProductCatalog productCatalog : this) {
            productCatalog.delete(db, basePath);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.enteredBy > -1) {
            sqlFilter.append(" AND pctlg.enteredby = ? ");
        }
        if (this.id > -1) {
            sqlFilter.append(" AND pctlg.product_id = ? ");
        }
        if (this.topOnly == 1) {
            sqlFilter.append(" AND pctlg.parent_id IS NULL ");
        } else if (this.topOnly == 0) {
            sqlFilter.append(" AND pctlg.parent_id IS NOT NULL ");
        }
        if (this.parentId > -1) {
            sqlFilter.append(" AND pctlg.parent_id = ? ");
        }
        if (this.typeId > -1) {
            sqlFilter.append(" AND pctlg.type_id = ? ");
        }
        if (this.importId > -1) {
            sqlFilter.append(" AND pctlg.import_id = ? ");
        }
        if (this.excludeUnapprovedProducts) {
            sqlFilter.append("AND (pctlg.status_id IS NULL OR pctlg.status_id = ?) ");
        }
        if (this.name != null) {
            if (this.name.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.product_name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.product_name) = ? ");
            }
        }
        if (this.keywords != null) {
            for (int i = 0; i < this.keywords.length; ++i) {
                sqlFilter.append(" AND ( " + DatabaseUtils.toLowerCase(db) + "(pctlg.product_name) like ? OR " + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.convertToVarChar(db, "pctlg.short_description") + ") like ? OR " + DatabaseUtils.toLowerCase(db) + "(" + DatabaseUtils.convertToVarChar(db, "pctlg.long_description") + ") like ?) ");
            }
        }
        if (this.abbreviation != null) {
            if (this.abbreviation.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.abbreviation) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.abbreviation) = ? ");
            }
        }
        if (this.sku != null) {
            if (this.sku.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.sku) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctlg.sku) = ? ");
            }
        }
        if (this.parentName != null) {
            sqlFilter.append(" AND pctlg2.product_name = ? ");
        }
        if (this.typeName != null) {
            sqlFilter.append(" AND pctlgtype.description = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND pctlg.product_id IN (   SELECT product_id FROM product_catalog_category_map   WHERE category_id = ? )");
        }
        if (this.serviceContractId > -1) {
            sqlFilter.append("AND pctlg.product_id IN ( SELECT link_product_id FROM service_contract_products WHERE link_contract_id = ? )");
        }
        if (!this.productCategoryList.isEmpty()) {
            Iterator i = this.productCategoryList.iterator();
            sqlFilter.append(" AND pctlg.product_id IN (  SELECT product_id FROM product_catalog_category_map WHERE category_id in (");
            String categoryIds = "";
            while (i.hasNext()) {
                ProductCategory productCategory = (ProductCategory)((Object)i.next());
                categoryIds = categoryIds + productCategory.getId() + ",";
            }
            categoryIds = categoryIds.substring(0, categoryIds.length() - 1);
            sqlFilter.append(categoryIds + " )) ");
        }
        if (this.hasCategories == 1) {
            sqlFilter.append(" AND pctlg.product_id IN (  SELECT product_id FROM product_catalog_category_map ) ");
        } else if (this.hasCategories == 0) {
            sqlFilter.append(" AND pctlg.product_id NOT IN (  SELECT product_id FROM product_catalog_category_map )");
        }
        if (this.buildTopLevelOnly == 1) {
            sqlFilter.append("AND pctlg.parent_id IS NULL ");
        } else if (this.buildTopLevelOnly == 0) {
            sqlFilter.append("AND pctlg.parent_id IS NOT NULL ");
        }
        if (this.priceRangeMin > -1.0 || this.priceRangeMax > -1.0) {
            sqlFilter.append(" AND pctlg.product_id IN ( SELECT product_id FROM product_catalog_pricing WHERE ");
            if (this.priceRangeMin > -1.0) {
                sqlFilter.append(" price_amount >= ?");
            }
            if (this.priceRangeMax > -1.0) {
                sqlFilter.append((this.priceRangeMin > -1.0 ? " AND " : "") + " price_amount <= ?");
            }
            sqlFilter.append(") ");
        }
        if (this.startDate != null) {
            sqlFilter.append(" AND pctlg.start_date >= ? ");
        }
        if (this.lastAnchor != null) {
            sqlFilter.append(" AND pctlg.entered >= ? ");
        }
        if (this.endDate != null) {
            sqlFilter.append(" AND pctlg.start_date <= ? ");
        }
        if (this.buildActiveProductsOnly != -1) {
            sqlFilter.append("AND pctlg.product_id IN ( SELECT p.product_id  FROM product_catalog p LEFT JOIN product_catalog_pricing price ON  ( p.product_id = price.product_id )  WHERE p.product_id > 0 ");
            if (this.buildActiveProductsOnly == 1) {
                sqlFilter.append(" AND p." + DatabaseUtils.addQuotes(db, "active") + " = ? " + " AND price.enabled = ? " + " AND (p.start_date < ? OR p.start_date IS NULL) " + " AND (p.expiration_date IS NULL OR p.expiration_date > ?) " + " AND (price.start_date < ? OR price.start_date IS NULL) " + " AND (price.expiration_date IS NULL OR price.expiration_date > ?) " + " ) ");
            } else if (this.buildActiveProductsOnly == 0) {
                sqlFilter.append(" AND (p." + DatabaseUtils.addQuotes(db, "active") + " = ? " + " OR price.enabled = ? " + " OR p.start_date > ? OR p.expiration_date < ? " + " OR price.start_date > ? OR price.expiration_date < ?) " + " ) OR pctlg.product_id NOT IN (SELECT pp.product_id " + " FROM product_catalog_pricing pp WHERE pp.product_id > 0 ))");
            }
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            sqlFilter.append(" AND pctlg.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append(" AND pctlg.modified >= ? ");
            sqlFilter.append(" AND pctlg.entered < ? ");
            sqlFilter.append(" AND pctlg.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND pctlg.entered < ? ");
            }
        }
        if (this.enabled != -1) {
            sqlFilter.append(" AND pctlg.enabled = ? ");
        }
        if (this.active != -1) {
            sqlFilter.append(" AND pctlg." + DatabaseUtils.addQuotes(db, "active") + " = ? ");
        }
        if (this.selectedItems != null) {
            if (this.selectedItems.size() > 0) {
                sqlFilter.append("AND (pctlg." + DatabaseUtils.addQuotes(db, "active") + " = ? OR pctlg.product_id IN (" + this.getItemsAsList() + ")) ");
            } else {
                sqlFilter.append("AND pctlg." + DatabaseUtils.addQuotes(db, "active") + " = ? ");
            }
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND pctlg.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND pctlg.trashed_date = ? ");
        } else {
            sqlFilter.append("AND pctlg.trashed_date IS NULL ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.parentId > -1) {
            pst.setInt(++i, this.parentId);
        }
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.importId > -1) {
            pst.setInt(++i, this.importId);
        }
        if (this.excludeUnapprovedProducts) {
            pst.setInt(++i, 7);
        }
        if (this.name != null) {
            pst.setString(++i, this.name.toLowerCase());
        }
        if (this.keywords != null) {
            for (int i1 = 0; i1 < this.keywords.length; ++i1) {
                pst.setString(++i, "%" + this.keywords[i1].toLowerCase() + "%");
                pst.setString(++i, "%" + this.keywords[i1].toLowerCase() + "%");
                pst.setString(++i, "%" + this.keywords[i1].toLowerCase() + "%");
            }
        }
        if (this.abbreviation != null) {
            pst.setString(++i, this.abbreviation.toLowerCase());
        }
        if (this.sku != null) {
            pst.setString(++i, this.sku.toLowerCase());
        }
        if (this.parentName != null) {
            pst.setString(++i, this.parentName);
        }
        if (this.typeName != null) {
            pst.setString(++i, this.typeName);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.serviceContractId > -1) {
            pst.setInt(++i, this.serviceContractId);
        }
        if (this.priceRangeMin > -1.0 || this.priceRangeMax > -1.0) {
            if (this.priceRangeMin > -1.0) {
                pst.setDouble(++i, this.priceRangeMin);
            }
            if (this.priceRangeMax > -1.0) {
                pst.setDouble(++i, this.priceRangeMax);
            }
        }
        if (this.startDate != null) {
            pst.setTimestamp(++i, this.startDate);
        }
        if (this.lastAnchor != null) {
            pst.setTimestamp(++i, this.lastAnchor);
        }
        if (this.endDate != null) {
            pst.setTimestamp(++i, this.endDate);
        }
        if (this.buildActiveProductsOnly == 1) {
            pst.setBoolean(++i, true);
            pst.setBoolean(++i, true);
            Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
        } else if (this.buildActiveProductsOnly == 0) {
            pst.setBoolean(++i, false);
            pst.setBoolean(++i, false);
            Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
            pst.setTimestamp(++i, currentTimestamp);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.active == 1) {
            pst.setBoolean(++i, true);
        } else if (this.active == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.selectedItems != null) {
            pst.setBoolean(++i, true);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        return i;
    }

    private String getItemsAsList() {
        StringBuffer sb = new StringBuffer();
        if (this.selectedItems != null) {
            Iterator i = this.selectedItems.keySet().iterator();
            while (i.hasNext()) {
                sb.append(String.valueOf((Integer)i.next()));
                if (!i.hasNext()) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public ProductCatalog getProductFromId(int id) {
        ProductCatalog result = null;
        for (ProductCatalog product : this) {
            if (product.getId() != id) continue;
            result = product;
            break;
        }
        return result;
    }

    public void addCategoryMapping(Connection db, int categoryId) throws SQLException {
        if (categoryId == -1) {
            throw new SQLException("Invalid category ID specified");
        }
        for (ProductCatalog thisCatalog : this) {
            thisCatalog.addCategoryMapping(db, categoryId);
        }
    }

    public void removeCategoryMapping(Connection db, int categoryId) throws SQLException {
        if (categoryId == -1) {
            throw new SQLException("Invalid Category ID specified");
        }
        for (ProductCatalog thisProduct : this) {
            thisProduct.removeCategoryMapping(db, categoryId);
        }
    }

    public void addCategoryMapping(Connection db, ProductCatalogList oldList, int categoryId) throws SQLException {
        try {
            db.setAutoCommit(false);
            for (ProductCatalog oldProduct : oldList) {
                boolean exists = false;
                Iterator j = this.iterator();
                while (j.hasNext()) {
                    ProductCatalog thisProduct = (ProductCatalog)((Object)j.next());
                    if (oldProduct.getId() != thisProduct.getId()) continue;
                    exists = true;
                    j.remove();
                    break;
                }
                if (exists) continue;
                oldProduct.removeCategoryMapping(db, categoryId);
            }
            this.addCategoryMapping(db, categoryId);
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public ProductCategoryList getProductCategoryList() {
        return this.productCategoryList;
    }

    public void setProductCategoryList(ProductCategoryList productCategoryList) {
        this.productCategoryList = productCategoryList;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Timestamp endDate) {
        this.endDate = endDate;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Timestamp startDate) {
        this.startDate = startDate;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getDateAfter() {
        return this.dateAfter;
    }

    public void setDateAfter(String dateAfter) throws Exception {
        this.dateAfter = dateAfter;
        if (dateAfter != null && dateAfter != "") {
            String[] temp = dateAfter.split("_");
            Calendar cal = Calendar.getInstance();
            int calendarConst = -1;
            Field[] fields = cal.getClass().getFields();
            for (int i = 0; i < fields.length; ++i) {
                if (!fields[i].getName().equals(temp[1])) continue;
                calendarConst = fields[i].getInt(cal);
                break;
            }
            cal.add(calendarConst, -1 * Integer.parseInt(temp[0]));
            Date date = cal.getTime();
            this.lastAnchor = new Timestamp(date.getTime());
        }
    }

    public void setGroupKeywords(String tmp) {
        this.groupKeywords = tmp;
        this.keywords = this.groupKeywords.split(" ");
    }

    public String getGroupKeywords() {
        return this.groupKeywords;
    }

    public String[] getKeywords() {
        return this.keywords;
    }

    public void setKeywords(String[] keywords) {
        this.keywords = keywords;
    }

    public boolean isDetermineCategory() {
        return this.determineCategory;
    }

    public void setDetermineCategory(boolean determineCategory) {
        this.determineCategory = determineCategory;
    }

    public void setDetermineCategory(String determineCategory) {
        this.determineCategory = DatabaseUtils.parseBoolean(determineCategory);
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            logger.setLevel(Level.DEBUG);
        }
    }
}

