/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.base.ProductCatalogPricingList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;

public class ProductCatalogPricing
extends GenericBean {
    private int id = -1;
    private int productId = -1;
    private int taxId = -1;
    private int msrpCurrency = -1;
    private double msrpAmount = 0.0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;
    private Timestamp startDate = null;
    private Timestamp expirationDate = null;
    private boolean enabled = false;
    private int costCurrency = -1;
    private double costAmount = 0.0;
    private String productName = null;
    private String taxName = null;
    private String msrpCurrencyName = null;
    private String priceCurrencyName = null;
    private String recurringCurrencyName = null;
    private String recurringTypeName = null;
    private String costCurrencyName = null;

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setCostCurrency(int tmp) {
        this.costCurrency = tmp;
    }

    public void setCostCurrency(String tmp) {
        this.costCurrency = Integer.parseInt(tmp);
    }

    public void setCostAmount(double tmp) {
        this.costAmount = tmp;
    }

    public void setCostAmount(String tmp) {
        this.costAmount = Double.parseDouble(tmp);
    }

    public void setCostCurrencyName(String tmp) {
        this.costCurrencyName = tmp;
    }

    public String getCostCurrencyName() {
        return this.costCurrencyName;
    }

    public int getCostCurrency() {
        return this.costCurrency;
    }

    public double getCostAmount() {
        return this.costAmount;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setTaxName(String tmp) {
        this.taxName = tmp;
    }

    public String getTaxName() {
        return this.taxName;
    }

    public void setMsrpCurrencyName(String tmp) {
        this.msrpCurrencyName = tmp;
    }

    public void setPriceCurrencyName(String tmp) {
        this.priceCurrencyName = tmp;
    }

    public void setRecurringCurrencyName(String tmp) {
        this.recurringCurrencyName = tmp;
    }

    public void setRecurringTypeName(String tmp) {
        this.recurringTypeName = tmp;
    }

    public String getMsrpCurrencyName() {
        return this.msrpCurrencyName;
    }

    public String getPriceCurrencyName() {
        return this.priceCurrencyName;
    }

    public String getRecurringCurrencyName() {
        return this.recurringCurrencyName;
    }

    public String getRecurringTypeName() {
        return this.recurringTypeName;
    }

    public int getId() {
        return this.id;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getTaxId() {
        return this.taxId;
    }

    public int getMsrpCurrency() {
        return this.msrpCurrency;
    }

    public double getMsrpAmount() {
        return this.msrpAmount;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setTaxId(int tmp) {
        this.taxId = tmp;
    }

    public void setTaxId(String tmp) {
        this.taxId = Integer.parseInt(tmp);
    }

    public void setMsrpCurrency(int tmp) {
        this.msrpCurrency = tmp;
    }

    public void setMsrpCurrency(String tmp) {
        this.msrpCurrency = Integer.parseInt(tmp);
    }

    public void setMsrpAmount(double tmp) {
        this.msrpAmount = tmp;
    }

    public void setMsrpAmount(String tmp) {
        this.msrpAmount = Double.parseDouble(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setPriceAmount(String tmp) {
        this.priceAmount = Double.parseDouble(tmp);
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setRecurringAmount(String tmp) {
        this.recurringAmount = Double.parseDouble(tmp);
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public ProductCatalogPricing() {
    }

    public ProductCatalogPricing(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductCatalogPricing(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Catalog Pricing ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT pctlgprice.*, pctlg.product_name AS product_name, lpt.description AS tax_name, lcmsrp.description AS msrp_currency_name, lcpc.description AS price_currency_name, lcrc.description AS recurring_currency_name, lrt.description AS recurring_type_name, lccc.description AS cost_currency_name FROM product_catalog_pricing pctlgprice LEFT JOIN product_catalog pctlg ON (pctlgprice.product_id = pctlg.product_id) LEFT JOIN lookup_product_tax lpt ON (pctlgprice.tax_id = lpt.code) LEFT JOIN lookup_currency lcmsrp ON (pctlgprice.msrp_currency = lcmsrp.code) LEFT JOIN lookup_currency lcpc ON (pctlgprice.price_currency = lcpc.code) LEFT JOIN lookup_currency lcrc ON (pctlgprice.recurring_currency = lcrc.code) LEFT JOIN lookup_recurring_type lrt ON (pctlgprice.recurring_type = lrt.code) LEFT JOIN lookup_currency lccc ON (pctlgprice.cost_currency = lccc.code) WHERE pctlgprice.price_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Product Catalog Pricing not found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("price_id"));
        this.setProductId(DatabaseUtils.getInt(rs, "product_id"));
        this.setTaxId(DatabaseUtils.getInt(rs, "tax_id"));
        this.setMsrpCurrency(DatabaseUtils.getInt(rs, "msrp_currency"));
        this.setMsrpAmount(rs.getDouble("msrp_amount"));
        this.setPriceCurrency(DatabaseUtils.getInt(rs, "price_currency"));
        this.setPriceAmount(rs.getDouble("price_amount"));
        this.setRecurringCurrency(DatabaseUtils.getInt(rs, "recurring_currency"));
        this.setRecurringAmount(rs.getDouble("recurring_amount"));
        this.setRecurringType(DatabaseUtils.getInt(rs, "recurring_type"));
        this.setEnteredBy(DatabaseUtils.getInt(rs, "enteredBy"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setModifiedBy(DatabaseUtils.getInt(rs, "modifiedby"));
        this.setModified(rs.getTimestamp("modified"));
        this.setStartDate(rs.getTimestamp("start_date"));
        this.setExpirationDate(rs.getTimestamp("expiration_date"));
        this.setEnabled(rs.getBoolean("enabled"));
        this.setCostCurrency(DatabaseUtils.getInt(rs, "cost_currency"));
        this.setCostAmount(rs.getDouble("cost_amount"));
        this.setProductName(rs.getString("product_name"));
        this.setTaxName(rs.getString("tax_name"));
        this.setMsrpCurrencyName(rs.getString("msrp_currency_name"));
        this.setPriceCurrencyName(rs.getString("price_currency_name"));
        this.setRecurringCurrencyName(rs.getString("recurring_currency_name"));
        this.setRecurringTypeName(rs.getString("recurring_type_name"));
        this.setCostCurrencyName(rs.getString("cost_currency_name"));
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Product Catalog Pricing ID invalid");
        }
        boolean commit = true;
        int i = 0;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement(" DELETE from product_catalog_pricing  WHERE price_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("expirationDate");
        return thisList;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean canCommit = false;
        boolean result = false;
        try {
            canCommit = db.getAutoCommit();
            if (canCommit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "product_catalog_pricing_price_id_seq");
            sql.append(" INSERT INTO product_catalog_pricing ( product_id, tax_id, msrp_currency, msrp_amount,  price_currency , price_amount , recurring_currency ,  recurring_amount, recurring_type, enteredby, ");
            if (this.id > -1) {
                sql.append("price_id, ");
            }
            if (this.entered != null) {
                sql.append(" entered, ");
            }
            sql.append(" modifiedby, ");
            if (this.modified != null) {
                sql.append(" modified, ");
            }
            sql.append(" start_date, expiration_date, enabled, cost_currency, cost_amount) ");
            sql.append(" VALUES ( ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append(" ?, ");
            }
            sql.append(" ?, ");
            if (this.modified != null) {
                sql.append(" ?, ");
            }
            sql.append("?, ?, ?, ?, ? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getProductId());
            DatabaseUtils.setInt(pst, ++i, this.getTaxId());
            DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
            pst.setDouble(++i, this.getMsrpAmount());
            DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
            pst.setDouble(++i, this.getPriceAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
            pst.setDouble(++i, this.getRecurringAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
            DatabaseUtils.setInt(pst, ++i, this.getEnteredBy());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getEnabled());
            DatabaseUtils.setInt(pst, ++i, this.getCostCurrency());
            pst.setDouble(++i, this.getCostAmount());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "product_catalog_pricing_price_id_seq", this.id);
            result = true;
            if (canCommit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (canCommit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (canCommit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_catalog_pricing SET product_id = ?, tax_id = ?, msrp_currency = ?, msrp_amount = ?, price_currency = ?, price_amount = ?, recurring_currency = ?, recurring_amount = ?, recurring_type = ?, modifiedby = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "start_date = ?, expiration_date = ?, enabled = ?, " + "cost_currency = ?, cost_amount = ? " + "WHERE price_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.getProductId());
        DatabaseUtils.setInt(pst, ++i, this.getTaxId());
        DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
        pst.setDouble(++i, this.getMsrpAmount());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
        pst.setBoolean(++i, this.getEnabled());
        DatabaseUtils.setInt(pst, ++i, this.getCostCurrency());
        pst.setDouble(++i, this.getCostAmount());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Product Catalog Pricing ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int priceCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) AS pricecount FROM product_catalog_pricing pcp WHERE pcp.price_id = ? AND pcp.product_id NOT IN ( SELECT product_id FROM product_catalog_pricing WHERE price_id <> ? ) ");
            pst.setInt(++i, this.getId());
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (priceCount = rs.getInt("pricecount")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("numberOfProductsThatHaveOnlyThisPrice");
                thisDependency.setCount(priceCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    private int disableAllPrices(Connection db) throws SQLException {
        if (this.getProductId() == -1) {
            throw new SQLException("Product Catalog Id not specified");
        }
        int resultCount = -1;
        PreparedStatement pst = db.prepareStatement("UPDATE product_catalog_pricing SET enabled = false WHERE product_catalog_pricing.product_id = ? ");
        pst.setInt(1, this.getProductId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean updatePriceStatus(Connection db, boolean status) throws SQLException {
        if (this.getProductId() == -1) {
            throw new SQLException("Product Catalog Id not specified");
        }
        if (status && !this.isValidPriceState(db)) {
            return false;
        }
        int resultCount = -1;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("UPDATE product_catalog_pricing SET enabled = ? WHERE product_id = ? AND price_id = ? ");
            pst.setBoolean(++i, status);
            pst.setInt(++i, this.getProductId());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount > 0;
    }

    public boolean isPriceValid() throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Price ID not specified");
        }
        boolean valid = true;
        if (this.expirationDate != null) {
            if (this.expirationDate.before(DateUtils.getDate(Calendar.getInstance()))) {
                valid = false;
            } else if (this.startDate != null && this.expirationDate.before(this.startDate)) {
                valid = false;
            }
        }
        return valid;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("priceAmount");
        thisList.add("msrpAmount");
        thisList.add("costAmount");
        thisList.add("recurringAmount");
        return thisList;
    }

    public boolean isValidPriceState(Connection db) throws SQLException {
        if (!this.isPriceValid()) {
            return false;
        }
        ProductCatalogPricingList priceList = new ProductCatalogPricingList();
        priceList.setProductId(this.productId);
        priceList.setEnabled(1);
        priceList.buildList(db);
        if (priceList.size() > 0) {
            for (ProductCatalogPricing activePrice : priceList) {
                if (this.getStartDate() != null && this.getExpirationDate() != null) {
                    if (this.compatiblePriceBounds(db, activePrice)) continue;
                    return false;
                }
                if (this.getStartDate() == null && this.getExpirationDate() != null) {
                    if (this.compatiblePriceExpirationBound(db, activePrice)) continue;
                    return false;
                }
                if (this.getStartDate() != null && this.getExpirationDate() == null) {
                    if (this.compatiblePriceStartBound(db, activePrice)) continue;
                    return false;
                }
                return false;
            }
        }
        return true;
    }

    public boolean compatiblePriceBounds(Connection db, ProductCatalogPricing price) throws SQLException {
        if (price.getStartDate() != null && price.getExpirationDate() != null) {
            if (price.getStartDate().before(this.getStartDate()) && price.getExpirationDate().after(this.getStartDate())) {
                return false;
            }
            if (price.getStartDate().before(this.getExpirationDate()) && price.getExpirationDate().after(this.getExpirationDate())) {
                return false;
            }
        } else if (price.getStartDate() == null && price.getExpirationDate() != null) {
            if (price.getExpirationDate().after(this.getStartDate())) {
                return false;
            }
            if (price.getExpirationDate().after(this.getExpirationDate())) {
                return false;
            }
        } else if (price.getStartDate() != null && price.getExpirationDate() == null) {
            if (price.getStartDate().before(this.getStartDate())) {
                return false;
            }
            if (price.getStartDate().before(this.getExpirationDate())) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public boolean compatiblePriceExpirationBound(Connection db, ProductCatalogPricing price) throws SQLException {
        if (price.getStartDate() != null && price.getExpirationDate() != null) {
            if (price.getStartDate().before(this.getExpirationDate())) {
                return false;
            }
        } else {
            if (price.getStartDate() == null && price.getExpirationDate() != null) {
                return false;
            }
            if (price.getStartDate() != null && price.getExpirationDate() == null) {
                if (price.getStartDate().before(this.getExpirationDate())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    public boolean compatiblePriceStartBound(Connection db, ProductCatalogPricing price) throws SQLException {
        if (price.getStartDate() != null && price.getExpirationDate() != null) {
            if (price.getExpirationDate().after(this.getStartDate())) {
                return false;
            }
        } else if (price.getStartDate() == null && price.getExpirationDate() != null) {
            if (price.getExpirationDate().after(this.getStartDate())) {
                return false;
            }
        } else {
            if (price.getStartDate() != null && price.getExpirationDate() == null) {
                return false;
            }
            return false;
        }
        return true;
    }

    public void process(Connection db, int productId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getEnabled()) {
            if (this.getId() == -1) {
                this.setProductId(productId);
                this.setEnteredBy(enteredBy);
                this.setModifiedBy(modifiedBy);
                this.insert(db);
            } else {
                this.setModifiedBy(modifiedBy);
                this.update(db);
            }
        } else {
            this.delete(db, "");
        }
    }
}

