/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductCatalogPricingList
extends ArrayList
implements SyncableList {
    public static final String tableName = "product_catalog_pricing";
    public static final String uniqueField = "price_id";
    private int syncType = -1;
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int productId = -1;
    private int enabled = -1;
    private int isValidNow = -1;
    private String productName = null;
    private Timestamp currentTime = null;

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setCurrentTime(Timestamp tmp) {
        this.currentTime = tmp;
    }

    public void setCurrentTime(String tmp) {
        this.currentTime = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIsValidNow(int tmp) {
        this.isValidNow = tmp;
    }

    public void setIsValidNow(String tmp) {
        this.isValidNow = Integer.parseInt(tmp);
    }

    public int getIsValidNow() {
        return this.isValidNow;
    }

    public Timestamp getCurrentTime() {
        return this.currentTime;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM product_catalog_pricing pctlgprice LEFT JOIN product_catalog pctlg ON ( pctlgprice.product_id = pctlg.product_id ) LEFT JOIN lookup_product_tax lpt ON (pctlgprice.tax_id = lpt.code) LEFT JOIN lookup_currency lcmsrp ON (pctlgprice.msrp_currency = lcmsrp.code) LEFT JOIN lookup_currency lcpc ON (pctlgprice.price_currency = lcpc.code) LEFT JOIN lookup_currency lcrc ON (pctlgprice.recurring_currency = lcrc.code) LEFT JOIN lookup_recurring_type lrt ON (pctlgprice.recurring_type = lrt.code) LEFT JOIN lookup_currency lccc ON (pctlgprice.cost_currency = lccc.code) WHERE pctlgprice.price_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("pctlgprice.*, pctlg.product_name AS product_name, lpt.description AS tax_name, lcmsrp.description AS msrp_currency_name, lcpc.description AS price_currency_name, lcrc.description AS recurring_currency_name, lrt.description AS recurring_type_name, lccc.description AS cost_currency_name FROM product_catalog_pricing pctlgprice LEFT JOIN product_catalog pctlg ON ( pctlgprice.product_id = pctlg.product_id ) LEFT JOIN lookup_product_tax lpt ON (pctlgprice.tax_id = lpt.code) LEFT JOIN lookup_currency lcmsrp ON (pctlgprice.msrp_currency = lcmsrp.code) LEFT JOIN lookup_currency lcpc ON (pctlgprice.price_currency = lcpc.code) LEFT JOIN lookup_currency lcrc ON (pctlgprice.recurring_currency = lcrc.code) LEFT JOIN lookup_recurring_type lrt ON (pctlgprice.recurring_type = lrt.code) LEFT JOIN lookup_currency lccc ON (pctlgprice.cost_currency = lccc.code) WHERE pctlgprice.price_id > 0 ");
        sqlOrder.append("ORDER BY pctlgprice.price_amount ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ProductCatalogPricing catalogPricing = new ProductCatalogPricing(rs);
            this.add(catalogPricing);
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.id > -1) {
            sqlFilter.append("AND pctlgprice.price_id = ? ");
        }
        if (this.productName != null) {
            sqlFilter.append("AND pctlg.product_name = ? ");
        }
        if (this.productId > -1) {
            sqlFilter.append("AND pctlgprice.product_id = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND pctlgprice.enabled = ? ");
        }
        if (this.isValidNow == 1) {
            sqlFilter.append("AND (pctlgprice.expiration_date IS NULL OR pctlgprice.expiration_date > ?) ");
            sqlFilter.append("AND (pctlgprice.start_date < ? OR pctlgprice.start_date IS NULL) ");
        } else if (this.isValidNow == 0) {
            sqlFilter.append("AND (pctlgprice.start_date > ? OR pctlgprice.expiration_date < ?) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.productName != null) {
            pst.setString(++i, this.productName);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.isValidNow != -1) {
            this.currentTime = new Timestamp(Calendar.getInstance().getTimeInMillis());
            pst.setTimestamp(++i, this.currentTime);
            pst.setTimestamp(++i, this.currentTime);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }
}

