/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductCategoryList;
import org.aspcfs.utils.DatabaseUtils;

public class ProductCategory
extends GenericBean {
    private int id = -1;
    private int parentId = -1;
    private String name = null;
    private String abbreviation = null;
    private String shortDescription = null;
    private String longDescription = null;
    private int typeId = -1;
    private int thumbnailImageId = -1;
    private int smallImageId = -1;
    private int largeImageId = -1;
    private int listOrder = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private Timestamp entered = null;
    private Timestamp modified = null;
    private Timestamp startDate = null;
    private Timestamp expirationDate = null;
    private boolean enabled = false;
    private String parentName = null;
    private String typeName = null;
    private boolean buildChildList = false;
    private boolean buildChildCount = false;
    private boolean buildProductList = false;
    private int buildEnabledProducts = -1;
    private int buildActiveProducts = -1;
    private ProductCategoryList childList = new ProductCategoryList();
    private ProductCatalogList productList = new ProductCatalogList();
    private boolean buildCompleteHierarchy = false;
    private boolean buildActivePrice = false;
    private int statusId = -1;
    private int importId = -1;
    private ProductCategoryList fullPath = null;
    private int childCount = -1;
    private int level = -1;
    private long milies = -1L;
    private static Logger logger = Logger.getLogger(ProductCategory.class);

    public boolean getBuildChildCount() {
        return this.buildChildCount;
    }

    public void setBuildChildCount(boolean buildChildCount) {
        this.buildChildCount = buildChildCount;
    }

    public void setBuildChildCount(String buildChildCount) {
        this.buildChildCount = DatabaseUtils.parseBoolean(buildChildCount);
    }

    public int getChildCount() {
        return this.childCount;
    }

    public void setChildCount(int childCount) {
        this.childCount = childCount;
    }

    public void setChildCount(String childCount) {
        this.childCount = Integer.parseInt(childCount);
    }

    public ProductCategoryList getFullPath() {
        return this.fullPath;
    }

    public void setFullPath(ProductCategoryList fullPath) {
        this.fullPath = fullPath;
    }

    public int getImportId() {
        return this.importId;
    }

    public void setImportId(int importId) {
        this.importId = importId;
    }

    public void setImportId(String importId) {
        this.importId = Integer.parseInt(importId);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int statusId) {
        this.statusId = statusId;
    }

    public void setStatusId(String statusId) {
        this.statusId = Integer.parseInt(statusId);
    }

    public boolean getBuildActivePrice() {
        return this.buildActivePrice;
    }

    public void setBuildActivePrice(boolean tmp) {
        this.buildActivePrice = tmp;
    }

    public void setBuildActivePrice(String tmp) {
        this.buildActivePrice = DatabaseUtils.parseBoolean(tmp);
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setBuildChildList(boolean tmp) {
        this.buildChildList = tmp;
    }

    public void setBuildChildList(String tmp) {
        this.buildChildList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildProductList(boolean tmp) {
        this.buildProductList = tmp;
    }

    public void setBuildProductList(String tmp) {
        this.buildProductList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildCompleteHierarchy(boolean tmp) {
        this.buildCompleteHierarchy = tmp;
    }

    public void setBuildCompleteHierarchy(String tmp) {
        this.buildCompleteHierarchy = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCompleteHierarchy() {
        return this.buildCompleteHierarchy;
    }

    public int getBuildEnabledProducts() {
        return this.buildEnabledProducts;
    }

    public void setBuildEnabledProducts(int tmp) {
        this.buildEnabledProducts = tmp;
    }

    public int getBuildActiveProducts() {
        return this.buildActiveProducts;
    }

    public void setBuildActiveProducts(int tmp) {
        this.buildActiveProducts = tmp;
    }

    public void setBuildActiveProducts(String tmp) {
        this.buildActiveProducts = Integer.parseInt(tmp);
    }

    public boolean getBuildChildList() {
        return this.buildChildList;
    }

    public boolean getBuildProductList() {
        return this.buildProductList;
    }

    public void setChildList(ProductCategoryList tmp) {
        this.childList = tmp;
    }

    public void setProductList(ProductCatalogList tmp) {
        this.productList = tmp;
    }

    public ProductCategoryList getChildList() {
        return this.childList;
    }

    public ProductCatalogList getProductList() {
        return this.productList;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getThumbnailImageId() {
        return this.thumbnailImageId;
    }

    public int getSmallImageId() {
        return this.smallImageId;
    }

    public int getLargeImageId() {
        return this.largeImageId;
    }

    public int getListOrder() {
        return this.listOrder;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public String getParentName() {
        return this.parentName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAbbreviation(String tmp) {
        this.abbreviation = tmp;
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setLongDescription(String tmp) {
        this.longDescription = tmp;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setThumbnailImageId(int tmp) {
        this.thumbnailImageId = tmp;
    }

    public void setThumbnailImageId(String tmp) {
        this.thumbnailImageId = Integer.parseInt(tmp);
    }

    public void setSmallImageId(int tmp) {
        this.smallImageId = tmp;
    }

    public void setSmallImageId(String tmp) {
        this.smallImageId = Integer.parseInt(tmp);
    }

    public void setLargeImageId(int tmp) {
        this.largeImageId = tmp;
    }

    public void setLargeImageId(String tmp) {
        this.largeImageId = Integer.parseInt(tmp);
    }

    public void setListOrder(int tmp) {
        this.listOrder = tmp;
    }

    public void setListOrder(String tmp) {
        this.listOrder = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setParentName(String tmp) {
        this.parentName = tmp;
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public ProductCategory() {
    }

    public ProductCategory(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductCategory(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildChildList(Connection db) throws SQLException {
        this.childList.setParentId(this.getId());
        this.childList.setBuildProducts(this.buildProductList);
        this.childList.setBuildActiveProducts(this.buildActiveProducts);
        this.childList.setBuildCompleteHierarchy(this.buildCompleteHierarchy);
        this.childList.setBuildActivePrice(this.getBuildActivePrice());
        this.childList.buildList(db);
    }

    public void buildProductList(Connection db) throws SQLException {
        this.productList.setCategoryId(this.getId());
        this.productList.setActive(this.buildActiveProducts);
        this.productList.setBuildResources(true);
        this.productList.setBuildActivePrice(this.getBuildActivePrice());
        this.productList.buildList(db);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Category Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT  pctgy.*,  pctgy2.category_name AS parent_name,  pctgytype.description AS type_name  FROM product_category pctgy  LEFT JOIN product_category pctgy2  ON ( pctgy.parent_id = pctgy2.category_id )  LEFT JOIN lookup_product_category_type pctgytype  ON ( pctgy.type_id = pctgytype.code )  WHERE pctgy.category_id = ?  ORDER BY pctgy.category_name ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Product Category not found");
        }
        if (this.buildChildList) {
            this.buildChildList(db);
        }
        if (this.buildChildCount) {
            this.buildChildCount(db);
        }
        if (this.buildProductList) {
            this.buildProductList(db);
        }
    }

    public void buildChildCount(Connection db) throws SQLException {
        if (this.id == -1) {
            throw new SQLException("Invalid Product Category Number");
        }
        PreparedStatement pst = db.prepareStatement("select count('X') AS child_count from product_category where parent_id=?");
        pst.setInt(1, this.id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.childCount = DatabaseUtils.getInt(rs, "child_count");
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Product Category not found");
        }
    }

    public int addCategory(Connection db, int cat2id) throws SQLException {
        int seqId = -1;
        int result = -1;
        int i = 0;
        if (cat2id == -1 || this.getId() == -1) {
            throw new SQLException("Invalid category ID ");
        }
        seqId = DatabaseUtils.getNextSeq(db, "product_category_map_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_category_map (" + (seqId > -1 ? "id, " : "") + "category1_id, category2_id) " + "VALUES(" + (seqId > -1 ? "?" : "") + "? , ? );");
        if (seqId > -1) {
            pst.setInt(++i, seqId);
        }
        pst.setInt(++i, this.getId());
        pst.setInt(++i, cat2id);
        result = pst.executeUpdate();
        pst.close();
        i = 0;
        seqId = DatabaseUtils.getNextSeq(db, "product_category_map_id_seq");
        pst = db.prepareStatement("INSERT INTO product_category_map(" + (seqId > -1 ? "id, " : "") + "category1_id, category2_id) " + "VALUES(" + (seqId > -1 ? "?" : "") + "? , ? );");
        if (seqId > -1) {
            pst.setInt(++i, seqId);
        }
        pst.setInt(++i, cat2id);
        pst.setInt(++i, this.getId());
        pst.close();
        return result += pst.executeUpdate();
    }

    public boolean removeCategoryMapping(Connection db, int cat2id) throws SQLException {
        boolean result = false;
        int i = 0;
        if (cat2id == -1 || this.getId() == -1) {
            throw new SQLException("Invalid category ID ");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM product_category_map WHERE category1_id = ? AND   category2_id = ? ");
        pst.setInt(++i, this.getId());
        pst.setInt(++i, cat2id);
        result = pst.execute();
        pst.close();
        i = 0;
        pst = db.prepareStatement("DELETE FROM product_category_map WHERE category1_id = ? AND \t category2_id = ? ");
        pst.setInt(++i, cat2id);
        pst.setInt(++i, this.getId());
        result = pst.execute();
        pst.close();
        return result;
    }

    public int addCatalog(Connection db, int catalogId) throws SQLException {
        int result = -1;
        int i = 0;
        if (catalogId == -1 || this.getId() == -1) {
            throw new SQLException("Invalid catalog id or category id ");
        }
        int seqId = DatabaseUtils.getNextSeq(db, "product_catalog_category_map_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_catalog_category_map (" + (seqId > -1 ? "id, " : "") + "product_id, category_id) " + "VALUES (" + (seqId > -1 ? "?, " : "") + "? , ? );");
        if (seqId > -1) {
            pst.setInt(++i, seqId);
        }
        pst.setInt(++i, catalogId);
        pst.setInt(++i, this.getId());
        result = pst.executeUpdate();
        pst.close();
        return result;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("category_id"));
        this.parentId = DatabaseUtils.getInt(rs, "parent_id");
        this.name = rs.getString("category_name");
        this.abbreviation = rs.getString("abbreviation");
        this.shortDescription = rs.getString("short_description");
        this.longDescription = rs.getString("long_description");
        this.typeId = DatabaseUtils.getInt(rs, "type_id");
        this.thumbnailImageId = DatabaseUtils.getInt(rs, "thumbnail_image_id");
        this.smallImageId = DatabaseUtils.getInt(rs, "small_image_id");
        this.largeImageId = DatabaseUtils.getInt(rs, "large_image_id");
        this.listOrder = DatabaseUtils.getInt(rs, "list_order");
        this.enteredBy = rs.getInt("enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = rs.getInt("modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.startDate = rs.getTimestamp("start_date");
        this.expirationDate = rs.getTimestamp("expiration_date");
        this.enabled = rs.getBoolean("enabled");
        this.setStatusId(DatabaseUtils.getInt(rs, "status_id"));
        this.setImportId(DatabaseUtils.getInt(rs, "import_id"));
        this.parentName = rs.getString("parent_name");
        this.typeName = rs.getString("type_name");
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Product Category ID not specified.");
        }
        boolean commit = true;
        int i = 0;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = db.prepareStatement(" DELETE from product_category_map  WHERE category1_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            i = 0;
            pst = db.prepareStatement(" DELETE from product_category_map  WHERE category2_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            i = 0;
            pst = db.prepareStatement(" DELETE from product_catalog_category_map  WHERE category_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            ProductCategoryList list = new ProductCategoryList();
            list.setParentId(this.getId());
            list.buildList(db);
            list.delete(db, baseFilePath);
            FileItemList fileList = new FileItemList();
            fileList.setLinkModuleId(200403195);
            fileList.setLinkItemId(this.getId());
            fileList.buildList(db);
            fileList.delete(db, baseFilePath);
            fileList = null;
            i = 0;
            pst = db.prepareStatement("DELETE FROM product_category WHERE category_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("expirationDate");
        return thisList;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "product_category_category_id_seq");
            sql.append(" INSERT INTO product_category ( parent_id,  category_name,abbreviation, short_description,  long_description,type_id,thumbnail_image_id,  small_image_id, large_image_id,list_order,  enteredby,");
            if (this.id > -1) {
                sql.append("category_id, ");
            }
            if (this.importId > -1) {
                sql.append("import_id, ");
            }
            if (this.statusId > -1) {
                sql.append("status_id, ");
            }
            if (this.entered != null) {
                sql.append(" entered, ");
            }
            sql.append(" modifiedBy, ");
            if (this.modified != null) {
                sql.append(" modified, ");
            }
            sql.append(" start_date,expiration_date,enabled)");
            sql.append("VALUES ( ?,?,?,?,?,?,?,?,?,?,?,");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.importId > -1) {
                sql.append("?, ");
            }
            if (this.statusId > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append(" ?, ");
            }
            sql.append("?,?,?)");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            pst.setString(++i, this.getName());
            pst.setString(++i, this.getAbbreviation());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getLongDescription());
            DatabaseUtils.setInt(pst, ++i, this.getTypeId());
            DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
            DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
            DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
            DatabaseUtils.setInt(pst, ++i, this.getListOrder());
            DatabaseUtils.setInt(pst, ++i, this.getEnteredBy());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.importId > -1) {
                pst.setInt(++i, this.importId);
            }
            if (this.statusId > -1) {
                pst.setInt(++i, this.statusId);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getEnabled());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "product_category_category_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_category SET parent_id = ?, category_name = ?, abbreviation = ?, short_description = ?, long_description = ?, type_id = ?, thumbnail_image_id = ?, small_image_id = ?, large_image_id = ?, ");
        sql.append("modifiedby = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
        sql.append("start_date = ?, expiration_date = ?, enabled = ? ");
        sql.append("WHERE category_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        pst.setString(++i, this.getName());
        pst.setString(++i, this.getAbbreviation());
        pst.setString(++i, this.getShortDescription());
        pst.setString(++i, this.getLongDescription());
        DatabaseUtils.setInt(pst, ++i, this.getTypeId());
        DatabaseUtils.setInt(pst, ++i, this.getThumbnailImageId());
        DatabaseUtils.setInt(pst, ++i, this.getSmallImageId());
        DatabaseUtils.setInt(pst, ++i, this.getLargeImageId());
        pst.setInt(++i, this.getModifiedBy());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
        pst.setBoolean(++i, this.getEnabled());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateParent(Connection db, int parentId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Product Category ID not specified");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_category SET parent_id = ? WHERE category_id = ? ");
        DatabaseUtils.setInt(pst, 1, parentId);
        pst.setInt(2, this.getId());
        int resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean removeFileItem(Connection db, int itemId, String imageType, String path) throws SQLException {
        boolean recordDeleted = false;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            if ("thumbnail".equals(imageType)) {
                this.setThumbnailImageId(-1);
            } else if ("small".equals(imageType)) {
                this.setSmallImageId(-1);
            } else if ("large".equals(imageType)) {
                this.setLargeImageId(-1);
            }
            this.update(db);
            FileItem thisItem = new FileItem(db, itemId, this.getId(), 200403195);
            recordDeleted = thisItem.delete(db, path);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return recordDeleted;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        Dependency thisDependency;
        int categoryCount;
        if (this.getId() == -1) {
            throw new SQLException("Product Category ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        Dependency docDependency = new Dependency();
        docDependency.setName("images");
        docDependency.setCount(FileItemList.retrieveRecordCount((Connection)db, (int)200403195, (int)this.getId()));
        docDependency.setCanDelete(true);
        dependencyList.add(docDependency);
        i = 0;
        pst = db.prepareStatement("SELECT count(*) as parentcount FROM product_category WHERE parent_id = ?");
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next() && (categoryCount = rs.getInt("parentcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("subcategories");
            thisDependency.setCount(categoryCount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        i = 0;
        pst = db.prepareStatement("SELECT count(*) as productcount FROM product_catalog_category_map WHERE category_id = ?");
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next() && (categoryCount = rs.getInt("productcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("products");
            thisDependency.setCount(categoryCount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        return dependencyList;
    }

    public static boolean lookupId(Connection db, String catName) throws SQLException {
        int buffer;
        boolean result = false;
        int i = 0;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) as counter FROM product_category WHERE category_name = ? ");
        pst.setString(++i, catName);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && (buffer = rs.getInt("counter")) != 0) {
            result = true;
        }
        rs.close();
        pst.close();
        return result;
    }

    public static String lookupDateConfiguratorClass(Connection db, int categoryId) throws SQLException {
        String className = "";
        PreparedStatement pst = db.prepareStatement("SELECT class_name FROM product_date_configurator WHERE category_id = ? ");
        int i = 0;
        pst.setInt(++i, categoryId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            className = rs.getString("class_name");
        }
        rs.close();
        pst.close();
        return className;
    }

    public boolean checkForProducts(Connection db) throws SQLException {
        this.buildChildList(db);
        this.buildProductList(db);
        if (this.getProductList().size() > 0) {
            return true;
        }
        if (!this.getChildList().filterProductCategories(db)) {
            return false;
        }
        return this.getChildList().size() > 0 || this.getProductList().size() > 0;
    }

    public static void buildHierarchy(Connection db, Map hierarchy, int currentId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT parent_id, category_name FROM product_category WHERE category_id = ? ");
        pst.setInt(1, currentId);
        ResultSet rs = pst.executeQuery();
        int parentId = 0;
        String name = null;
        if (rs.next()) {
            parentId = DatabaseUtils.getInt(rs, "parent_id");
            name = rs.getString("category_name");
        }
        rs.close();
        pst.close();
        hierarchy.put(new Integer(currentId), new String[]{name});
        if (parentId > -1) {
            ProductCategory.buildHierarchy(db, hierarchy, parentId);
        }
    }

    public ProductCategory getChild(Connection db, int categoryId) throws SQLException {
        this.buildChildList(db);
        for (ProductCategory thisCategory : this.getChildList()) {
            if (thisCategory.getId() != categoryId) continue;
            return thisCategory;
        }
        for (ProductCategory thisChild : this.getChildList()) {
            thisChild.buildChildList(db);
            ProductCategoryList.buildHierarchy(db, thisChild.getChildList());
            thisChild.getChildList().buildCompleteHierarchy();
            for (ProductCategory node : thisChild.getChildList()) {
                if (node.getId() != categoryId) continue;
                return thisChild;
            }
        }
        return null;
    }

    public boolean hasServiceContractProducts(Connection db, int contractId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Product Category ID not specified");
        }
        ProductCatalogList productList = new ProductCatalogList();
        productList.setCategoryId(this.getId());
        productList.setServiceContractId(contractId);
        productList.buildList(db);
        if (productList.size() > 0) {
            return true;
        }
        ProductCategoryList childList = new ProductCategoryList();
        childList.setParentId(this.getId());
        childList.buildList(db);
        for (ProductCategory thisCategory : childList) {
            if (!thisCategory.hasServiceContractProducts(db, contractId)) continue;
            return true;
        }
        return false;
    }

    public void process(Connection db, int categoryId, int enteredBy, int modifiedBy) throws SQLException {
        if (this.getId() == -1) {
            this.setId(categoryId);
            this.setEnteredBy(enteredBy);
            this.setModifiedBy(modifiedBy);
            this.insert(db);
        } else {
            this.setModifiedBy(modifiedBy);
            this.update(db);
        }
    }

    public int getCategoryCountByName(Connection db, String categoryName) throws SQLException {
        int result = -1;
        if (categoryName == null || "".equals(categoryName.trim())) {
            throw new SQLException("Invalid Product Category Name");
        }
        PreparedStatement pst = db.prepareStatement("SELECT count(*)  FROM product_category pctgy  WHERE pctgy.category_NAME = ? ");
        pst.setString(1, categoryName);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        pst.close();
        return result;
    }

    public static int updateImportStatus(Connection db, int importId, int status) throws SQLException {
        int count = 0;
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String sql = "UPDATE product_category SET status_id = ? WHERE import_id = ? ";
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql);
            pst.setInt(++i, status);
            pst.setInt(++i, importId);
            count = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return count;
    }

    public static ProductCategoryList buildFullName(Connection db, ProductCategoryList fullName, int currentId, boolean includeCurrent) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT parent_id, category_name, category_id FROM product_category WHERE category_id = ? ");
        pst.setInt(1, currentId);
        ResultSet rs = pst.executeQuery();
        int parentId = 0;
        String name = null;
        if (rs.next()) {
            parentId = DatabaseUtils.getInt(rs, "parent_id");
            name = rs.getString("category_name");
        }
        rs.close();
        pst.close();
        ProductCategory pc = new ProductCategory();
        pc.setId(currentId);
        pc.setName(name);
        if (parentId > -1) {
            fullName = ProductCategory.buildFullName(db, fullName, parentId, true);
        }
        if (includeCurrent) {
            fullName.add(pc);
        }
        return fullName;
    }

    public static int getCategoryById(String catalogName, int importId, Connection db) throws SQLException {
        String QUERY = "SELECT category_id FROM product_category WHERE category_name = ?  and (import_id = ? or status_id = ? )";
        PreparedStatement pst = db.prepareStatement(QUERY);
        pst.setString(1, catalogName);
        pst.setInt(2, importId);
        pst.setInt(3, 7);
        ResultSet rs = pst.executeQuery();
        int id = -1;
        if (rs.next()) {
            id = DatabaseUtils.getInt(rs, "category_id");
        }
        rs.close();
        pst.close();
        return id;
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            logger.setLevel(Level.DEBUG);
        }
    }
}

