/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCategory;
import org.aspcfs.modules.products.utils.ProductCategoryCount;
import org.aspcfs.modules.products.utils.ProductCategoryCounter;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductCategoryList
extends ArrayList
implements SyncableList {
    public static final String tableName = "product_category";
    public static final String uniqueField = "category_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int enteredBy = -1;
    private int id = -1;
    private int productId = -1;
    private int parentId = -1;
    private int typeId = -1;
    private int enabled = -1;
    private boolean hasExpireDate = false;
    private int topOnly = -1;
    private int masterCategoryId = -1;
    private int serviceContractId = -1;
    private String name = null;
    private String abbreviation = null;
    private String parentName = null;
    private String typeName = null;
    private boolean excludeMappedCategories = false;
    private int hasProducts = -1;
    private boolean buildProducts = false;
    private boolean buildChildList = false;
    private boolean buildChildCount = false;
    private boolean include = true;
    private boolean buildCompleteHierarchy = false;
    private int buildEnabledProducts = -1;
    private int buildActiveProducts = -1;
    private boolean buildActivePrice = false;
    private boolean excludeUnapprovedCategories = true;
    private long milies = -1L;
    private static Logger logger = Logger.getLogger(ProductCategory.class);
    private String emptyHtmlSelectRecord = null;

    public boolean getBuildChildCount() {
        return this.buildChildCount;
    }

    public void setBuildChildCount(boolean buildChildCount) {
        this.buildChildCount = buildChildCount;
    }

    public void setBuildChildCount(String buildChildCount) {
        this.buildChildCount = DatabaseUtils.parseBoolean(buildChildCount);
    }

    public boolean getExcludeUnapprovedCategories() {
        return this.excludeUnapprovedCategories;
    }

    public void setExcludeUnapprovedCategories(boolean excludeUnapprovedCategories) {
        this.excludeUnapprovedCategories = excludeUnapprovedCategories;
    }

    public void setExcludeUnapprovedCategories(String excludeUnapprovedCategories) {
        this.excludeUnapprovedCategories = DatabaseUtils.parseBoolean(excludeUnapprovedCategories);
    }

    public int getServiceContractId() {
        return this.serviceContractId;
    }

    public void setServiceContractId(int tmp) {
        this.serviceContractId = tmp;
    }

    public void setServiceContractId(String tmp) {
        this.serviceContractId = Integer.parseInt(tmp);
    }

    public boolean getBuildActivePrice() {
        return this.buildActivePrice;
    }

    public void setBuildActivePrice(boolean tmp) {
        this.buildActivePrice = tmp;
    }

    public void setBuildActivePrice(String tmp) {
        this.buildActivePrice = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setAbbreviation(String tmp) {
        this.abbreviation = tmp;
    }

    public String getName() {
        return this.name;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setInclude(boolean tmp) {
        this.include = tmp;
    }

    public void setInclude(String tmp) {
        this.include = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getInclude() {
        return this.include;
    }

    public void setExcludeMappedCategories(boolean tmp) {
        this.excludeMappedCategories = tmp;
    }

    public void setExcludeMappedCategories(String tmp) {
        this.excludeMappedCategories = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getExcludeMappedCategories() {
        return this.excludeMappedCategories;
    }

    public void setBuildChildList(boolean tmp) {
        this.buildChildList = tmp;
    }

    public void setBuildChildList(String tmp) {
        this.buildChildList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildProducts(boolean tmp) {
        this.buildProducts = tmp;
    }

    public void setBuildProducts(String tmp) {
        this.buildProducts = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildCompleteHierarchy(boolean tmp) {
        this.buildCompleteHierarchy = tmp;
    }

    public void setBuildCompleteHierarchy(String tmp) {
        this.buildCompleteHierarchy = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildCompleteHierarchy() {
        return this.buildCompleteHierarchy;
    }

    public int getBuildEnabledProducts() {
        return this.buildEnabledProducts;
    }

    public void setBuildEnabledProducts(int tmp) {
        this.buildEnabledProducts = tmp;
    }

    public void setBuildEnabledProducts(String tmp) {
        this.buildEnabledProducts = Integer.parseInt(tmp);
    }

    public int getBuildActiveProducts() {
        return this.buildActiveProducts;
    }

    public void setBuildActiveProducts(int tmp) {
        this.buildActiveProducts = tmp;
    }

    public void setBuildActiveProducts(String tmp) {
        this.buildActiveProducts = Integer.parseInt(tmp);
    }

    public boolean getBuildChildList() {
        return this.buildChildList;
    }

    public boolean getBuildProducts() {
        return this.buildProducts;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getId() {
        return this.id;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public String getParentName() {
        return this.parentName;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getTopOnly() {
        return this.topOnly;
    }

    public int getMasterCategoryId() {
        return this.masterCategoryId;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public int getHasProducts() {
        return this.hasProducts;
    }

    public String getEmptyHtmlSelectRecord() {
        return this.emptyHtmlSelectRecord;
    }

    public String getHtmlSelect(String selectName) {
        return this.getHtmlSelect(selectName, -1);
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect categoryListSelect = new HtmlSelect();
        if (this.emptyHtmlSelectRecord != null) {
            categoryListSelect.addItem(-1, this.emptyHtmlSelectRecord);
        }
        Iterator i = this.iterator();
        int type = -1;
        while (i.hasNext()) {
            ProductCategory thisCategory = (ProductCategory)((Object)i.next());
            if (type != thisCategory.getTypeId()) {
                type = thisCategory.getTypeId();
                categoryListSelect.addGroup(thisCategory.getTypeName());
            }
            categoryListSelect.addItem(thisCategory.getId(), thisCategory.getName());
        }
        return categoryListSelect.getHtml(selectName, defaultKey);
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setParentName(String tmp) {
        this.parentName = tmp;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setTopOnly(int tmp) {
        this.topOnly = tmp;
    }

    public void setTopOnly(String tmp) {
        this.topOnly = Integer.parseInt(tmp);
    }

    public void setMasterCategoryId(int tmp) {
        this.masterCategoryId = tmp;
    }

    public void setMasterCategoryId(String tmp) {
        this.masterCategoryId = Integer.parseInt(tmp);
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public void setEmptyHtmlSelectRecord(String tmp) {
        this.emptyHtmlSelectRecord = tmp;
    }

    public void setHasProducts(int tmp) {
        this.hasProducts = tmp;
    }

    public void setHasProducts(String tmp) {
        this.hasProducts = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer("");
        StringBuffer sqlCount = new StringBuffer("");
        StringBuffer sqlFilter = new StringBuffer("");
        StringBuffer sqlOrder = new StringBuffer("");
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM product_category pctgy  LEFT JOIN product_category pctgy2  ON ( pctgy.parent_id = pctgy2.category_id )  LEFT JOIN lookup_product_category_type pctgytype  ON ( pctgy.type_id = pctgytype.code )  WHERE pctgy.category_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(pctgy.category_name) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("pctgy.category_name", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY pctgy.type_id, pctgy.category_name ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" pctgy.*,  pctgy2.category_name AS parent_name, pctgytype.description AS type_name  FROM product_category pctgy  LEFT JOIN product_category pctgy2  ON ( pctgy.parent_id = pctgy2.category_id )  LEFT JOIN lookup_product_category_type pctgytype  ON ( pctgy.type_id = pctgytype.code )  WHERE pctgy.category_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ProductCategory productCategory = new ProductCategory(rs);
            if (this.serviceContractId > -1) {
                if (!productCategory.hasServiceContractProducts(db, this.serviceContractId)) continue;
                this.add(productCategory);
                continue;
            }
            this.add(productCategory);
        }
        rs.close();
        pst.close();
        if (this.buildProducts) {
            for (ProductCategory thisCategory : this) {
                thisCategory.setBuildActiveProducts(this.buildActiveProducts);
                thisCategory.buildProductList(db);
            }
        }
        if (this.buildChildCount) {
            for (ProductCategory thisCategory : this) {
                thisCategory.buildChildCount(db);
            }
        }
        if (this.buildChildList || this.buildCompleteHierarchy) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ProductCategory thisCategory = (ProductCategory)((Object)this.get(i));
                thisCategory.setBuildChildList(this.buildChildList);
                thisCategory.setBuildCompleteHierarchy(this.buildCompleteHierarchy);
                thisCategory.setBuildActiveProducts(this.buildActiveProducts);
                thisCategory.setBuildActivePrice(this.buildActivePrice);
                thisCategory.buildChildList(db);
                if (!this.buildCompleteHierarchy || thisCategory.getChildList().size() == 0) continue;
                this.addAll(this.size(), thisCategory.getChildList());
            }
        }
    }

    public void delete(Connection db, String basePath) throws SQLException {
        for (ProductCategory productCategory : this) {
            productCategory.delete(db, basePath);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.enteredBy > -1) {
            sqlFilter.append("AND pctgy.enteredby = ? ");
        }
        if (this.include) {
            if (this.id > -1) {
                sqlFilter.append("AND pctgy.category_id = ? ");
            }
        } else if (this.id > -1) {
            sqlFilter.append("AND pctgy.category_id <> ? ");
        }
        if (this.productId > -1) {
            sqlFilter.append("AND pctgy.category_id IN (SELECT category_id FROM product_catalog_category_map  WHERE product_id = ?) ");
        }
        if (this.topOnly == 1) {
            sqlFilter.append("AND pctgy.parent_id IS NULL ");
        } else if (this.topOnly == 0) {
            sqlFilter.append("AND pctgy.parent_id IS NOT NULL ");
        }
        if (this.parentId > -1) {
            sqlFilter.append("AND pctgy.parent_id = ? ");
        }
        if (this.typeId > -1) {
            sqlFilter.append("AND pctgy.type_id = ? ");
        }
        if (this.name != null) {
            if (this.name.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctgy.category_name) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctgy.category_name) = ? ");
            }
        }
        if (this.abbreviation != null) {
            if (this.abbreviation.indexOf("%") >= 0) {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctgy.abbreviation) LIKE ? ");
            } else {
                sqlFilter.append("AND " + DatabaseUtils.toLowerCase(db) + "(pctgy.abbreviation) = ? ");
            }
        }
        if (this.parentName != null) {
            sqlFilter.append("AND pctgy2.category_name = ? ");
        }
        if (this.typeName != null) {
            sqlFilter.append("AND pctgytype.description = ? ");
        }
        if (this.hasProducts == 1) {
            sqlFilter.append(" AND pctgy.category_id IN (  SELECT category_id  FROM product_catalog_category_map  WHERE id > -1 ) ");
        } else if (this.hasProducts == 0) {
            sqlFilter.append(" AND pctgy.category_id NOT IN (  SELECT category_id  FROM product_catalog_category_map  WHERE id > -1 ) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctgy.entered >= ? ");
            }
            sqlFilter.append("AND pctgy.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append("AND pctgy.modified >= ? ");
            sqlFilter.append("AND pctgy.entered < ? ");
            sqlFilter.append("AND pctgy.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctgy.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND pctgy.entered < ? ");
            }
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND pctgy.enabled = ? ");
        }
        if (this.excludeMappedCategories) {
            if (this.masterCategoryId > -1) {
                sqlFilter.append("AND pctgy.category_id NOT IN (SELECT category2_id FROM product_category_map WHERE category1_id = ?) ");
            }
        } else if (this.masterCategoryId > -1) {
            sqlFilter.append("AND pctgy.category_id IN (SELECT category2_id FROM product_category_map WHERE category1_id = ?) ");
        }
        if (this.excludeUnapprovedCategories) {
            sqlFilter.append("AND (pctgy.status_id IS NULL OR pctgy.status_id = ?) ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
        }
        if (this.parentId > -1) {
            pst.setInt(++i, this.parentId);
        }
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.name != null) {
            pst.setString(++i, this.name.toLowerCase());
        }
        if (this.abbreviation != null) {
            pst.setString(++i, this.abbreviation.toLowerCase());
        }
        if (this.parentName != null) {
            pst.setString(++i, this.parentName);
        }
        if (this.typeName != null) {
            pst.setString(++i, this.typeName);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.masterCategoryId > -1) {
            pst.setInt(++i, this.masterCategoryId);
        }
        if (this.excludeUnapprovedCategories) {
            pst.setInt(++i, 7);
        }
        return i;
    }

    public ProductCategory getCategoryByName(String name) throws SQLException {
        for (ProductCategory productCategory : this) {
            if (!name.equals(productCategory.getName())) continue;
            return productCategory;
        }
        return null;
    }

    public HtmlSelect getHtmlSelect(int typeId) throws SQLException {
        HtmlSelect select = new HtmlSelect();
        select.addItem("-1", "--All--");
        for (ProductCategory thisCategory : this) {
            if (thisCategory.getTypeId() != typeId) continue;
            int value = thisCategory.getId();
            String name = thisCategory.getName();
            select.addItem(value, name);
        }
        return select;
    }

    public void removeNonProductCategories(ProductCategoryCounter genericProductCounter) throws SQLException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ProductCategory category = (ProductCategory)((Object)iterator.next());
            ProductCategoryCount productCategoryCount = genericProductCounter.getProductCategoryCountObject(category.getId());
            if (productCategoryCount != null && productCategoryCount.getCountOfProduct() > 0) continue;
            iterator.remove();
        }
    }

    public boolean filterProductCategories(Connection db) throws SQLException {
        for (ProductCategory category : this) {
            if (!category.checkForProducts(db)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMappingsWithType(int typeId) {
        for (ProductCategory thisCategory : this) {
            if (thisCategory.getTypeId() != typeId) continue;
            return true;
        }
        return false;
    }

    public void addProductMapping(Connection db, int productId) throws SQLException {
        if (productId == -1) {
            throw new SQLException("Invalid category ID specified");
        }
        ProductCatalog product = new ProductCatalog(db, productId);
        for (ProductCategory thisCategory : this) {
            product.addCategoryMapping(db, thisCategory.getId());
        }
    }

    public void addProductMapping(Connection db, ProductCategoryList oldList, int productId) throws SQLException {
        ProductCatalog product = null;
        try {
            db.setAutoCommit(false);
            product = new ProductCatalog(db, productId);
            for (ProductCategory oldCategory : oldList) {
                boolean exists = false;
                Iterator j = this.iterator();
                while (j.hasNext()) {
                    ProductCategory thisProduct = (ProductCategory)((Object)j.next());
                    if (oldCategory.getId() != thisProduct.getId()) continue;
                    exists = true;
                    j.remove();
                    break;
                }
                if (exists) continue;
                product.removeCategoryMapping(db, oldCategory.getId());
            }
            this.addProductMapping(db, productId);
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public static void buildHierarchy(Connection db, ProductCategoryList categoryList) throws SQLException {
        for (ProductCategory thisCategory : categoryList) {
            ProductCategoryList childList = new ProductCategoryList();
            childList.setParentId(thisCategory.getId());
            childList.buildList(db);
            childList.setLevel(thisCategory.getLevel() + 1);
            thisCategory.setChildList(childList);
            ProductCategoryList.buildHierarchy(db, childList);
        }
    }

    public static void buildHierarchyFromSelectedIds(Connection db, ProductCategoryList categoryList, ProductCategoryList selectedList) throws SQLException {
        for (ProductCategory thisCategory : categoryList) {
            if (!selectedList.hasCategory(thisCategory.getId())) continue;
            ProductCategoryList childList = new ProductCategoryList();
            childList.setParentId(thisCategory.getId());
            childList.setBuildChildCount(true);
            childList.buildList(db);
            childList.setLevel(thisCategory.getLevel() + 1);
            ProductCategoryList.buildHierarchyFromSelectedIds(db, childList, selectedList);
            thisCategory.setChildList(childList);
        }
    }

    public void setLevel(int level) {
        for (ProductCategory thisCategory : this) {
            thisCategory.setLevel(level);
        }
    }

    public void buildCompleteHierarchy() {
        for (int j = 0; j < this.size(); ++j) {
            ProductCategory thisCategory = (ProductCategory)((Object)this.get(j));
            if (thisCategory.getChildList().size() <= 0) continue;
            this.addAll(j + 1, thisCategory.getChildList());
        }
    }

    public boolean hasCategory(int categoryId) {
        for (ProductCategory thisCategory : this) {
            if (thisCategory.getId() != categoryId) continue;
            return true;
        }
        return false;
    }

    public ProductCategoryList buildListFromIds(Connection db, String ids) throws SQLException {
        ProductCategoryList result = new ProductCategoryList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sqlSelect = new StringBuffer();
        if (ids != null && !"".equals(ids)) {
            sqlSelect.append("select category_id, category_name from product_category");
            StringTokenizer st = new StringTokenizer(ids, "|");
            if (st.hasMoreTokens()) {
                sqlSelect.append(" where category_id in (").append(st.nextToken());
                while (st.hasMoreTokens()) {
                    sqlSelect.append(",").append(st.nextToken());
                }
                sqlSelect.append(")");
            }
            pst = db.prepareStatement(sqlSelect.toString());
            rs = pst.executeQuery();
            while (rs.next()) {
                ProductCategory category = new ProductCategory();
                category.setId(rs.getInt(uniqueField));
                category.setName(rs.getString("category_name"));
                result.add(category);
            }
            rs.close();
            pst.close();
        }
        return result;
    }

    public void setElements(String categories) {
        StringTokenizer str = new StringTokenizer(categories, "|");
        while (str.hasMoreTokens()) {
            ProductCategory category = new ProductCategory();
            String temp = str.nextToken();
            if (temp == null || "".equals(temp)) continue;
            category.setId(temp);
            this.add(category);
        }
    }

    static {
        if (System.getProperty("DEBUG") != null) {
            logger.setLevel(Level.DEBUG);
        }
    }
}

