/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.util.Locale;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.utils.CurrencyFormat;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Template;

public class ProductEmailFormatter {
    private String introduction = null;
    private boolean showSku = false;
    private boolean showPrice = false;
    private boolean showPriceSavings = false;
    private String productURL = null;
    private String siteURL = null;
    private String fromName = null;
    private String skuText = null;
    private String originalPriceText = null;
    private String priceSavingsText = null;
    private String priceText = null;
    private Locale locale = Locale.US;

    public void setIntroduction(String tmp) {
        this.introduction = tmp;
    }

    public void setProductURL(String tmp) {
        this.productURL = tmp;
    }

    public void setSiteURL(String tmp) {
        this.siteURL = tmp;
    }

    public void setFromName(String tmp) {
        this.fromName = tmp;
    }

    public void setShowSku(boolean tmp) {
        this.showSku = tmp;
    }

    public void setShowSku(String tmp) {
        this.showSku = DatabaseUtils.parseBoolean(tmp);
    }

    public void setShowPrice(boolean tmp) {
        this.showPrice = tmp;
    }

    public void setShowPrice(String tmp) {
        this.showPrice = DatabaseUtils.parseBoolean(tmp);
    }

    public void setShowPriceSavings(boolean tmp) {
        this.showPriceSavings = tmp;
    }

    public void setShowPriceSavings(String tmp) {
        this.showPriceSavings = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSkuText(String tmp) {
        this.skuText = tmp;
    }

    public void setOriginalPriceText(String tmp) {
        this.originalPriceText = tmp;
    }

    public void setPriceSavingsText(String tmp) {
        this.priceSavingsText = tmp;
    }

    public void setPriceText(String tmp) {
        this.priceText = tmp;
    }

    public void setLocale(Locale tmp) {
        this.locale = tmp;
    }

    public String getIntroduction() {
        return this.introduction;
    }

    public String getProductURL() {
        return this.productURL;
    }

    public String getSiteURL() {
        return this.siteURL;
    }

    public String getFromName() {
        return this.fromName;
    }

    public boolean getShowSku() {
        return this.showSku;
    }

    public boolean getShowPrice() {
        return this.showPrice;
    }

    public boolean getShowPriceSavings() {
        return this.showPriceSavings;
    }

    public String getSkuText() {
        return this.skuText;
    }

    public String getOriginalPriceText() {
        return this.originalPriceText;
    }

    public String getPriceSavingsText() {
        return this.priceSavingsText;
    }

    public String getPriceText() {
        return this.priceText;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getProductInformation(ProductCatalog productCatalog, String emailTemplate) throws Exception {
        Template template = new Template();
        template.setText(emailTemplate);
        template.addParseElement("${email.fromName}", this.getFromName());
        template.addParseElement("${product.name}", productCatalog.getName());
        if (productCatalog.getLargeImageId() != -1) {
            template.addParseElement("${product.imageSource}", "<img src=\"cid:productImage\">");
        } else {
            template.addParseElement("${product.imageSource}", "");
        }
        StringBuffer additionalInformation = new StringBuffer();
        if (this.showSku) {
            additionalInformation.append("<br />");
            additionalInformation.append(this.skuText);
            additionalInformation.append(productCatalog.getSku());
        }
        if (this.showPriceSavings) {
            if (productCatalog.getActivePrice() != null) {
                additionalInformation.append("<br />");
                additionalInformation.append(this.originalPriceText);
                additionalInformation.append(CurrencyFormat.getCurrencyString(new Double(productCatalog.getActivePrice().getPriceAmount()), this.locale));
                if (productCatalog.getActivePrice().getMsrpAmount() > productCatalog.getActivePrice().getPriceAmount()) {
                    additionalInformation.append("<br />");
                    additionalInformation.append(this.priceSavingsText);
                    double savings = productCatalog.getActivePrice().getMsrpAmount() - productCatalog.getActivePrice().getPriceAmount();
                    additionalInformation.append(CurrencyFormat.getCurrencyString(new Double(savings), this.locale));
                }
            } else if (System.getProperty("DEBUG") != null) {
                System.out.println("ProductEmailFormatter.getProductInformation() 'showPriceSavings' ==> active price is NULL");
            }
        }
        if (this.showPrice && !this.showPriceSavings) {
            if (productCatalog.getActivePrice() != null) {
                additionalInformation.append("<br />");
                additionalInformation.append(this.priceText);
                additionalInformation.append(CurrencyFormat.getCurrencyString(new Double(productCatalog.getActivePrice().getPriceAmount()), this.locale));
            } else if (System.getProperty("DEBUG") != null) {
                System.out.println("ProductEmailFormatter.getProductInformation() 'showPriceSavings && !showPriceSavings' ==> active price is NULL");
            }
        }
        template.addParseElement("${product.allowedInformation}", additionalInformation.toString());
        template.addParseElement("${email.comments}", productCatalog.getComments());
        template.addParseElement("${product.link}", this.getProductURL());
        template.addParseElement("${site.link}", this.getSiteURL());
        return template.getParsedText();
    }
}

