/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.utils.DatabaseUtils;

public class ProductOption
extends GenericBean {
    private int id = -1;
    private String name = null;
    private int configuratorId = -1;
    private int parentId = -1;
    private String shortDescription = null;
    private String longDescription = null;
    private boolean allowCustomerConfigure = false;
    private boolean allowUserConfigure = false;
    private boolean required = false;
    private boolean enabled = true;
    private Timestamp startDate = null;
    private Timestamp endDate = null;
    private boolean hasMultiplier = false;
    private boolean hasRange = false;
    private String parentName = null;
    private String configuratorName = null;
    private int resultType = -1;
    private String label = null;
    private String html = null;
    private double priceAdjust = 0.0;
    private int productId = -1;
    private boolean buildOptionValues = true;
    private ProductOptionValuesList optionValuesList = null;
    private boolean buildConfigDetails = false;

    public double getPriceAdjust() {
        return this.priceAdjust;
    }

    public void setPriceAdjust(double tmp) {
        this.priceAdjust = tmp;
    }

    public void setPriceAdjust(String tmp) {
        this.priceAdjust = Double.parseDouble(tmp);
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String tmp) {
        this.html = tmp;
    }

    public boolean getBuildConfigDetails() {
        return this.buildConfigDetails;
    }

    public void setBuildConfigDetails(boolean tmp) {
        this.buildConfigDetails = tmp;
    }

    public void setBuildConfigDetails(String tmp) {
        this.buildConfigDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public void setHasMultiplier(boolean tmp) {
        this.hasMultiplier = tmp;
    }

    public void setHasMultiplier(String tmp) {
        this.hasMultiplier = DatabaseUtils.parseBoolean(tmp);
    }

    public void setHasRange(boolean tmp) {
        this.hasRange = tmp;
    }

    public void setHasRange(String tmp) {
        this.hasRange = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getHasMultiplier() {
        return this.hasMultiplier;
    }

    public boolean getHasRange() {
        return this.hasRange;
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public int getProductId() {
        return this.productId;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setConfiguratorId(int tmp) {
        this.configuratorId = tmp;
    }

    public void setConfiguratorId(String tmp) {
        this.configuratorId = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setLongDescription(String tmp) {
        this.longDescription = tmp;
    }

    public void setAllowCustomerConfigure(boolean tmp) {
        this.allowCustomerConfigure = tmp;
    }

    public void setAllowCustomerConfigure(String tmp) {
        this.allowCustomerConfigure = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAllowUserConfigure(boolean tmp) {
        this.allowUserConfigure = tmp;
    }

    public void setAllowUserConfigure(String tmp) {
        this.allowUserConfigure = DatabaseUtils.parseBoolean(tmp);
    }

    public void setRequired(boolean tmp) {
        this.required = tmp;
    }

    public void setRequired(String tmp) {
        this.required = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setStartDate(Timestamp tmp) {
        this.startDate = tmp;
    }

    public void setStartDate(String tmp) {
        this.startDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEndDate(Timestamp tmp) {
        this.endDate = tmp;
    }

    public void setEndDate(String tmp) {
        this.endDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setConfiguratorName(String tmp) {
        this.configuratorName = tmp;
    }

    public void setResultType(int tmp) {
        this.resultType = tmp;
    }

    public void setResultType(String tmp) {
        this.resultType = Integer.parseInt(tmp);
    }

    public void setParentName(String tmp) {
        this.parentName = tmp;
    }

    public void setBuildOptionValues(boolean tmp) {
        this.buildOptionValues = tmp;
    }

    public void setBuildOptionValues(String tmp) {
        this.buildOptionValues = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOptionValuesList(ProductOptionValuesList tmp) {
        this.optionValuesList = tmp;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getConfiguratorId() {
        return this.configuratorId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public boolean getAllowCustomerConfigure() {
        return this.allowCustomerConfigure;
    }

    public boolean getAllowUserConfigure() {
        return this.allowUserConfigure;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public Timestamp getStartDate() {
        return this.startDate;
    }

    public Timestamp getEndDate() {
        return this.endDate;
    }

    public String getConfiguratorName() {
        return this.configuratorName;
    }

    public int getResultType() {
        return this.resultType;
    }

    public String getParentName() {
        return this.parentName;
    }

    public boolean getBuildOptionValues() {
        return this.buildOptionValues;
    }

    public ProductOptionValuesList getOptionValuesList() {
        return this.optionValuesList;
    }

    public ProductOption() {
    }

    public ProductOption(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductOption(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Option ID");
        }
        PreparedStatement pst = db.prepareStatement("SELECT popt.*, poptconf.result_type AS result_type, poptconf.configurator_name AS conf_name, popt2.option_name AS parent_name FROM product_option popt LEFT JOIN product_option_configurator poptconf ON ( popt.configurator_id = poptconf.configurator_id ) LEFT JOIN product_option popt2 ON ( popt.parent_id = popt2.option_id ) WHERE popt.option_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Product Option not found");
        }
        if (this.buildOptionValues) {
            this.buildOptionValues(db);
        }
        if (this.buildConfigDetails) {
            this.buildConfigDetails(db);
        }
    }

    public void buildConfigDetails(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Product Option ID not specified");
        }
        OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, this.getConfiguratorId());
        configurator.queryProperties(db, this.getId(), false);
        this.setConfiguratorName(configurator.getName());
        this.setLabel(configurator.getLabel());
        this.setHtml(configurator.getHtml());
        this.setPriceAdjust(configurator.getPriceAdjust());
    }

    public void buildOptionValues(Connection db) throws SQLException {
        this.optionValuesList = new ProductOptionValuesList();
        this.optionValuesList.setOptionId(this.id);
        this.optionValuesList.buildList(db);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("option_id"));
        this.setConfiguratorId(DatabaseUtils.getInt(rs, "configurator_id"));
        this.setParentId(DatabaseUtils.getInt(rs, "parent_id"));
        this.setShortDescription(rs.getString("short_description"));
        this.setLongDescription(rs.getString("long_description"));
        this.setAllowCustomerConfigure(rs.getBoolean("allow_customer_configure"));
        this.setAllowUserConfigure(rs.getBoolean("allow_user_configure"));
        this.setRequired(rs.getBoolean("required"));
        this.setStartDate(rs.getTimestamp("start_date"));
        this.setEndDate(rs.getTimestamp("end_date"));
        this.setEnabled(rs.getBoolean("enabled"));
        this.setName(rs.getString("option_name"));
        this.setHasMultiplier(rs.getBoolean("has_multiplier"));
        this.setHasRange(rs.getBoolean("has_range"));
        this.setConfiguratorName(rs.getString("conf_name"));
        this.setResultType(rs.getInt("result_type"));
        this.setParentName(rs.getString("parent_name"));
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Product Option ID not specified.");
        }
        boolean commit = true;
        try {
            int i = 0;
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM product_option_map WHERE option_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_values WHERE option_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_text WHERE product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_integer WHERE product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_float WHERE product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_timestamp WHERE product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM product_option_boolean WHERE product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            i = 0;
            pst = db.prepareStatement("DELETE FROM product_option WHERE option_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("startDate");
        thisList.add("endDate");
        return thisList;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "product_option_option_id_seq");
            sql.append("INSERT INTO product_option(" + (this.id > -1 ? "option_id, " : "") + "option_name, configurator_id, " + "parent_id, short_description, long_description, allow_customer_configure, " + "allow_user_configure, required, start_date, end_date, enabled, has_range, has_multiplier ) " + "VALUES(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?, ?, ? ) ");
            PreparedStatement pst = db.prepareStatement(sql.toString());
            int i = 0;
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.getName());
            DatabaseUtils.setInt(pst, ++i, this.getConfiguratorId());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getLongDescription());
            pst.setBoolean(++i, this.getAllowCustomerConfigure());
            pst.setBoolean(++i, this.getAllowUserConfigure());
            pst.setBoolean(++i, this.getRequired());
            DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getEndDate());
            pst.setBoolean(++i, this.getEnabled());
            pst.setBoolean(++i, this.getHasRange());
            pst.setBoolean(++i, this.getHasMultiplier());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "product_option_option_id_seq", this.id);
            if (this.productId != -1) {
                int seqId = DatabaseUtils.getNextSeq(db, "product_option_map_product_option_id_seq");
                pst = db.prepareStatement("INSERT INTO product_option_map (" + (seqId > -1 ? "product_option_id, " : "") + "option_id, product_id) " + "VALUES (" + (seqId > -1 ? "?, " : "") + "?, ? )");
                i = 0;
                if (seqId > -1) {
                    pst.setInt(++i, seqId);
                }
                pst.setInt(++i, this.id);
                pst.setInt(++i, this.productId);
                pst.execute();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean insertClone(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, this.getConfiguratorId());
            configurator.queryProperties(db, this.getId(), false);
            configurator.saveProperties(db, this);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (Exception e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_option SET option_name = ?, configurator_id = ?, parent_id = ?, short_description = ?, long_description = ?, allow_customer_configure = ?, allow_user_configure = ?, required = ?, start_date = ?, end_date = ?, enabled = ?, has_range = ?, has_multiplier = ? WHERE option_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getName());
        DatabaseUtils.setInt(pst, ++i, this.getConfiguratorId());
        DatabaseUtils.setInt(pst, ++i, this.getParentId());
        pst.setString(++i, this.getShortDescription());
        pst.setString(++i, this.getLongDescription());
        pst.setBoolean(++i, this.getAllowCustomerConfigure());
        pst.setBoolean(++i, this.getAllowUserConfigure());
        pst.setBoolean(++i, this.getRequired());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStartDate());
        DatabaseUtils.setTimestamp(pst, ++i, this.getEndDate());
        pst.setBoolean(++i, this.getEnabled());
        pst.setBoolean(++i, this.getHasRange());
        pst.setBoolean(++i, this.getHasMultiplier());
        DatabaseUtils.setInt(pst, ++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean isValid(Connection db) throws SQLException {
        if (this.startDate != null && this.endDate != null && this.startDate.after(this.endDate)) {
            this.errors.put("startDateError", "Start Date cannot be after Expiration Date");
        }
        return !this.hasErrors();
    }

    public int addProductMapping(Connection db, int productId) throws SQLException {
        int result = -1;
        int i = 0;
        if (this.getId() == -1) {
            throw new SQLException("Invalid option id");
        }
        int seqId = DatabaseUtils.getNextSeq(db, "product_option_map_product_option_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_map (" + (seqId > -1 ? "product_option_id, " : "") + "product_id, option_id) " + "VALUES (" + (seqId > -1 ? "?, " : "") + "?, ? ); ");
        if (seqId > -1) {
            pst.setInt(++i, seqId);
        }
        pst.setInt(++i, productId);
        pst.setInt(++i, this.getId());
        result = pst.executeUpdate();
        pst.close();
        return result;
    }

    public boolean removeProductMapping(Connection db, int productId) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Invalid Option ID");
        }
        int i = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM product_option_map WHERE product_id = ? AND option_id = ? ");
        pst.setInt(++i, productId);
        pst.setInt(++i, this.getId());
        result = pst.execute();
        pst.close();
        return result;
    }

    public static boolean lookupId(Connection db, String optName) throws SQLException {
        int buffer;
        boolean result = false;
        PreparedStatement pst = db.prepareStatement("SELECT count(*) AS counter FROM product_option WHERE short_description = ? ");
        pst.setString(1, optName);
        ResultSet rs = pst.executeQuery();
        if (rs.next() && (buffer = rs.getInt("counter")) != 0) {
            result = true;
        }
        rs.close();
        pst.close();
        return result;
    }

    public static int getNextRangeMin(Connection db, int optionId) throws SQLException {
        int nextMin = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option ID specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT MAX(range_max) AS maxrange FROM product_option_values WHERE option_id = ? ");
        pst.setInt(1, optionId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            nextMin = rs.getInt("maxrange");
        }
        rs.close();
        pst.close();
        return nextMin + 1;
    }

    public int getProductOptionId(Connection db, int productId) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Invalid ID");
        }
        int result = -1;
        PreparedStatement pst = db.prepareStatement("SELECT product_option_id FROM product_option_map WHERE product_id = ? AND option_id = ? ");
        pst.setInt(1, productId);
        pst.setInt(2, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            result = rs.getInt("product_option_id");
        }
        rs.close();
        pst.close();
        return result;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        int quoteCount;
        Dependency thisDependency;
        int productCount;
        if (this.getId() == -1) {
            throw new SQLException("Product Option ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        pst = db.prepareStatement("SELECT count(*) AS productcount FROM product_option_map WHERE option_id = ? ");
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next() && (productCount = rs.getInt("productcount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfCatalogOptionMappings");
            thisDependency.setCount(productCount);
            thisDependency.setCanDelete(true);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        i = 0;
        pst = db.prepareStatement("SELECT count(*) AS quoteoptioncount FROM quote_product_options qpo, product_option_map pom WHERE qpo.product_option_id = pom.product_option_id AND option_id = ? ");
        pst.setInt(++i, this.getId());
        rs = pst.executeQuery();
        if (rs.next() && (quoteCount = rs.getInt("quoteoptioncount")) != 0) {
            thisDependency = new Dependency();
            thisDependency.setName("numberOfQuoteOptionMappings");
            thisDependency.setCount(quoteCount);
            thisDependency.setCanDelete(false);
            dependencyList.add(thisDependency);
        }
        rs.close();
        pst.close();
        return dependencyList;
    }
}

