/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.utils.DatabaseUtils;

public class ProductOptionConfigurator
extends GenericBean {
    private int id = -1;
    private String configuratorName = null;
    private String shortDescription = null;
    private String longDescription = null;
    private String className = null;
    private int resultType = -1;

    public void setConfiguratorName(String tmp) {
        this.configuratorName = tmp;
    }

    public String getConfiguratorName() {
        return this.configuratorName;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setLongDescription(String tmp) {
        this.longDescription = tmp;
    }

    public void setClassName(String tmp) {
        this.className = tmp;
    }

    public void setResultType(int tmp) {
        this.resultType = tmp;
    }

    public void setResultType(String tmp) {
        this.resultType = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public String getClassName() {
        return this.className;
    }

    public int getResultType() {
        return this.resultType;
    }

    public ProductOptionConfigurator() {
    }

    public ProductOptionConfigurator(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductOptionConfigurator(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Option Configurator Id");
        }
        PreparedStatement pst = db.prepareStatement("SELECT conf.* FROM product_option_configurator conf WHERE conf.configurator_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Product Option Configurator not found");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("configurator_id"));
        this.setShortDescription(rs.getString("short_description"));
        this.setLongDescription(rs.getString("long_description"));
        this.setClassName(rs.getString("class_name"));
        this.setResultType(DatabaseUtils.getInt(rs, "result_type"));
        this.setConfiguratorName(rs.getString("configurator_name"));
    }

    public boolean delete(Connection db, String baseFilePath) throws SQLException {
        boolean result = false;
        if (this.getId() == -1) {
            throw new SQLException("Product Category ID not specified.");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            int i = 0;
            PreparedStatement pst = db.prepareStatement("DELETE from product_option_configurator WHERE configurator_id = ? ");
            pst.setInt(++i, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "product_option_configurator_configurator_id_seq");
            sql.append("INSERT INTO product_option_configurator(" + (this.id > -1 ? "configurator_id, " : "") + "configurator_name, short_description, long_description, class_name, result_type ) ");
            sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            pst.setString(++i, this.getConfiguratorName());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getLongDescription());
            pst.setString(++i, this.getClassName());
            DatabaseUtils.setInt(pst, ++i, this.getResultType());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "product_option_configurator_configurator_id_seq", this.id);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_option_configurator SET configurator_name = ?, short_description = ?, long_description = ?, class_name = ?, result_type = ? WHERE configurator_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        pst.setString(++i, this.getConfiguratorName());
        pst.setString(++i, this.getShortDescription());
        pst.setString(++i, this.getLongDescription());
        pst.setString(++i, this.getClassName());
        pst.setInt(++i, this.getResultType());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Configurator ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int categoryCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) AS parentcount FROM product_option WHERE configurator_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (categoryCount = rs.getInt("parentcount")) != 0) {
                Dependency thisDependency = new Dependency();
                thisDependency.setName("numberOfChildrenOfThisCategory");
                thisDependency.setCount(categoryCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public static OptionConfigurator getConfigurator(Connection db, int id) throws SQLException {
        OptionConfigurator configurator = null;
        try {
            String className = null;
            configurator = null;
            PreparedStatement pst = db.prepareStatement("SELECT class_name FROM product_option_configurator WHERE configurator_id = ? ");
            pst.setInt(1, id);
            ResultSet rs = pst.executeQuery();
            if (rs.next()) {
                className = rs.getString("class_name");
            }
            rs.close();
            pst.close();
            Class<?> cls = Class.forName(className);
            configurator = (OptionConfigurator)cls.newInstance();
        }
        catch (InstantiationException ie) {
            ie.printStackTrace(System.out);
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace(System.out);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace(System.out);
        }
        return configurator;
    }
}

