/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductOptionConfiguratorList
extends ArrayList {
    public static final String tableName = "product_option_configurator";
    public static final String uniqueField = "configurator_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private String optionName = null;
    private String productName = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM product_option_configurator poptconfig WHERE poptconfig.configurator_id > 0");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("conf.* FROM product_option_configurator conf WHERE conf.configurator_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ProductOptionConfigurator productOptionConfigurator = new ProductOptionConfigurator(rs);
            this.add(productOptionConfigurator);
        }
        rs.close();
        pst.close();
    }

    public void delete(Connection db, String basePath) throws SQLException {
        for (ProductOptionConfigurator productOptionConfigurator : this) {
            productOptionConfigurator.delete(db, basePath);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.id > -1) {
            sqlFilter.append(" AND poptconfig.configurator_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public String getHtmlSelect(String selectName, int defaultKey) {
        HtmlSelect select = new HtmlSelect();
        for (ProductOptionConfigurator config : this) {
            select.addItem(config.getId(), config.getConfiguratorName());
        }
        return select.getHtml(selectName, defaultKey);
    }

    public HtmlSelect getHtmlSelect() {
        HtmlSelect select = new HtmlSelect();
        for (ProductOptionConfigurator config : this) {
            select.addItem(config.getId(), config.getConfiguratorName());
        }
        return select;
    }

    public ProductOptionConfigurator getConfiguratorFromId(int id) throws SQLException {
        ProductOptionConfigurator result = null;
        for (ProductOptionConfigurator configurator : this) {
            if (configurator.getId() != id) continue;
            result = configurator;
            break;
        }
        return result;
    }
}

