/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class ProductOptionList
extends ArrayList {
    public static final String tableName = "product_option";
    public static final String uniqueField = "option_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private String name = null;
    private int configuratorId = -1;
    private int enabled = -1;
    private int productId = -1;
    private String productName = null;
    private boolean buildResources = false;
    private boolean buildConfigDetails = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public boolean getBuildConfigDetails() {
        return this.buildConfigDetails;
    }

    public void setBuildConfigDetails(boolean tmp) {
        this.buildConfigDetails = tmp;
    }

    public void setBuildConfigDetails(String tmp) {
        this.buildConfigDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setConfiguratorId(int tmp) {
        this.configuratorId = tmp;
    }

    public void setConfiguratorId(String tmp) {
        this.configuratorId = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public String getName() {
        return this.name;
    }

    public int getConfiguratorId() {
        return this.configuratorId;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public int getProductId() {
        return this.productId;
    }

    public String getProductName() {
        return this.productName;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM product_option popt LEFT JOIN product_option_configurator poptconf ON ( popt.configurator_id = poptconf.configurator_id ) LEFT JOIN product_option popt2 ON ( popt.parent_id = popt2.option_id ) WHERE popt.option_id > 0 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("popt.option_id", null);
            boolean flag = true;
            if (DatabaseUtils.getType(db) == 2 && this.pagedListInfo.getColumnToSortBy().equals("popt.short_description")) {
                sqlOrder.append("ORDER BY " + DatabaseUtils.convertToVarChar(db, "popt.short_description") + " ");
                flag = false;
            }
            if (flag) {
                this.pagedListInfo.appendSqlTail(db, sqlOrder);
            }
        } else {
            sqlOrder.append("ORDER BY popt.option_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append(" SELECT ");
        }
        sqlSelect.append("popt.*, poptconf.result_type AS result_type, poptconf.configurator_name AS conf_name, popt2.option_name AS parent_name FROM product_option popt LEFT JOIN product_option_configurator poptconf ON ( popt.configurator_id = poptconf.configurator_id ) LEFT JOIN product_option popt2 ON ( popt.parent_id = popt2.option_id ) WHERE popt.option_id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            ProductOption productOption = new ProductOption(rs);
            this.add(productOption);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (ProductOption thisOption : this) {
                thisOption.buildOptionValues(db);
            }
        }
        if (this.buildConfigDetails) {
            for (ProductOption thisOption : this) {
                thisOption.buildConfigDetails(db);
            }
        }
    }

    public void delete(Connection db) throws SQLException {
        for (ProductOption productOption : this) {
            productOption.delete(db);
        }
    }

    private void createFilter(StringBuffer sqlFilter, Connection db) {
        if (this.id > -1) {
            sqlFilter.append("AND popt.option_id = ? ");
        }
        if (this.name != null) {
            sqlFilter.append("AND popt.option_name = ? ");
        }
        if (this.parentId > -1) {
            sqlFilter.append("AND popt.parent_id = ? ");
        }
        if (this.productName != null) {
            sqlFilter.append("AND pctlg.product_name = ? ");
        }
        if (this.enabled != -1) {
            sqlFilter.append("AND popt.enabled = ? ");
        }
        if (this.productId > -1) {
            sqlFilter.append("AND popt.option_id IN (SELECT option_id FROM product_option_map WHERE product_id = ?) ");
        }
        if (this.configuratorId > -1) {
            sqlFilter.append("AND popt.configurator_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.name != null) {
            pst.setString(++i, this.name);
        }
        if (this.parentId > -1) {
            pst.setInt(++i, this.parentId);
        }
        if (this.productName != null) {
            pst.setString(++i, this.productName);
        }
        if (this.enabled == 1) {
            pst.setBoolean(++i, true);
        } else if (this.enabled == 0) {
            pst.setBoolean(++i, false);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
        }
        if (this.configuratorId > -1) {
            pst.setInt(++i, this.configuratorId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void addProductMapping(Connection db, int productId) throws SQLException {
        if (productId == -1) {
            throw new SQLException("Invalid Product ID specified");
        }
        for (ProductOption thisOption : this) {
            thisOption.addProductMapping(db, productId);
        }
    }

    public void removeProductMapping(Connection db, int productId) throws SQLException {
        if (productId == -1) {
            throw new SQLException("Invalid Product ID specified");
        }
        for (ProductOption thisOption : this) {
            thisOption.removeProductMapping(db, productId);
        }
    }

    public void addProductMapping(Connection db, ProductOptionList oldList, int productId) throws SQLException {
        try {
            db.setAutoCommit(false);
            for (ProductOption oldOption : oldList) {
                boolean exists = false;
                Iterator j = this.iterator();
                while (j.hasNext()) {
                    ProductOption thisOption = (ProductOption)((Object)j.next());
                    if (oldOption.getId() != thisOption.getId()) continue;
                    exists = true;
                    j.remove();
                    break;
                }
                if (exists) continue;
                oldOption.removeProductMapping(db, productId);
            }
            this.addProductMapping(db, productId);
            db.commit();
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }

    public ProductOption getOptionFromId(int id) throws SQLException {
        ProductOption result = null;
        if (this.size() > 0) {
            for (ProductOption option : this) {
                if (option.getId() != id) continue;
                result = option;
                break;
            }
        }
        return result;
    }

    public boolean hasValues() {
        int counter = 0;
        for (ProductOption option : this) {
            counter += option.getOptionValuesList().size();
        }
        return counter != 0;
    }
}

