/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.utils.DatabaseUtils;

public class ProductOptionValues
extends GenericBean {
    private int id = -1;
    private int optionId = -1;
    private int resultId = -1;
    private String description = null;
    private int msrpCurrency = -1;
    private double msrpAmount = 0.0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private double value = 0.0;
    private double multiplier = 0.0;
    private int rangeMin = -1;
    private int rangeMax = -1;
    private int costCurrency = -1;
    private double costAmount = 0.0;

    public void setRangeMin(int tmp) {
        this.rangeMin = tmp;
    }

    public void setRangeMin(String tmp) {
        this.rangeMin = Integer.parseInt(tmp);
    }

    public void setRangeMax(int tmp) {
        this.rangeMax = tmp;
    }

    public void setRangeMax(String tmp) {
        this.rangeMax = Integer.parseInt(tmp);
    }

    public void setCostCurrency(int tmp) {
        this.costCurrency = tmp;
    }

    public void setCostCurrency(String tmp) {
        this.costCurrency = Integer.parseInt(tmp);
    }

    public void setCostAmount(double tmp) {
        this.costAmount = tmp;
    }

    public void setCostAmount(String tmp) {
        this.costAmount = Double.parseDouble(tmp);
    }

    public int getCostCurrency() {
        return this.costCurrency;
    }

    public double getCostAmount() {
        return this.costAmount;
    }

    public int getRangeMin() {
        return this.rangeMin;
    }

    public int getRangeMax() {
        return this.rangeMax;
    }

    public void setValue(double tmp) {
        this.value = tmp;
    }

    public void setValue(String tmp) {
        this.value = Double.parseDouble(tmp);
    }

    public void setMultiplier(double tmp) {
        this.multiplier = tmp;
    }

    public void setMultiplier(String tmp) {
        this.multiplier = Double.parseDouble(tmp);
    }

    public double getValue() {
        return this.value;
    }

    public double getMultiplier() {
        return this.multiplier;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setOptionId(int tmp) {
        this.optionId = tmp;
    }

    public void setOptionId(String tmp) {
        this.optionId = Integer.parseInt(tmp);
    }

    public void setResultId(int tmp) {
        this.resultId = tmp;
    }

    public void setResultId(String tmp) {
        this.resultId = Integer.parseInt(tmp);
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setMsrpCurrency(int tmp) {
        this.msrpCurrency = tmp;
    }

    public void setMsrpCurrency(String tmp) {
        this.msrpCurrency = Integer.parseInt(tmp);
    }

    public void setMsrpAmount(double tmp) {
        this.msrpAmount = tmp;
    }

    public void setMsrpAmount(String tmp) {
        this.msrpAmount = Double.parseDouble(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setPriceAmount(String tmp) {
        this.priceAmount = Double.parseDouble(tmp);
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setRecurringAmount(String tmp) {
        this.recurringAmount = Double.parseDouble(tmp);
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getOptionId() {
        return this.optionId;
    }

    public int getResultId() {
        return this.resultId;
    }

    public String getDescription() {
        return this.description;
    }

    public int getMsrpCurrency() {
        return this.msrpCurrency;
    }

    public double getMsrpAmount() {
        return this.msrpAmount;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public ProductOptionValues() {
    }

    public ProductOptionValues(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public ProductOptionValues(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Product Option Value");
        }
        PreparedStatement pst = db.prepareStatement("SELECT poptvalues.* FROM product_option_values poptvalues WHERE poptvalues.value_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Product Option Value not found");
        }
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("value_id"));
        this.setOptionId(DatabaseUtils.getInt(rs, "option_id"));
        this.setResultId(DatabaseUtils.getInt(rs, "result_id"));
        this.setDescription(rs.getString("description"));
        this.setMsrpCurrency(rs.getInt("msrp_currency"));
        this.setMsrpAmount(rs.getDouble("msrp_amount"));
        this.setPriceCurrency(DatabaseUtils.getInt(rs, "price_currency"));
        this.setPriceAmount(rs.getDouble("price_amount"));
        this.setRecurringCurrency(DatabaseUtils.getInt(rs, "price_currency"));
        this.setRecurringAmount(rs.getDouble("recurring_amount"));
        this.setRecurringType(DatabaseUtils.getInt(rs, "recurring_type"));
        this.setValue(rs.getDouble("value"));
        this.setMultiplier(rs.getDouble("multiplier"));
        this.setRangeMin(rs.getInt("range_min"));
        this.setRangeMax(rs.getInt("range_max"));
        this.setCostCurrency(DatabaseUtils.getInt(rs, "cost_currency"));
        this.setCostAmount(rs.getDouble("cost_amount"));
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "product_option_values_value_id_seq");
        sql.append("INSERT INTO product_option_values (" + (this.id > -1 ? "value_id, " : "") + "option_id, " + "result_id, description, msrp_currency, msrp_amount, " + "price_currency, price_amount, " + "recurring_currency, recurring_amount, recurring_type, " + DatabaseUtils.addQuotes(db, "value") + ", multiplier, range_min, range_max, cost_currency, cost_amount ) ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        DatabaseUtils.setInt(pst, ++i, this.getOptionId());
        DatabaseUtils.setInt(pst, ++i, this.getResultId());
        pst.setString(++i, this.getDescription());
        DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
        pst.setDouble(++i, this.getMsrpAmount());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getValue());
        pst.setDouble(++i, this.getMultiplier());
        pst.setInt(++i, this.getRangeMin());
        pst.setInt(++i, this.getRangeMax());
        DatabaseUtils.setInt(pst, ++i, this.getCostCurrency());
        pst.setDouble(++i, this.getCostAmount());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "product_option_values_value_id_seq", this.id);
        result = true;
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE product_option_values SET option_id = ?, result_id = ?, description = ?, msrp_currency = ?, mspr_amount = ? price_currency = ?, price_amount = ?, recurring_currency = ?, recurring_amount = ?, recurring_type = ?, " + DatabaseUtils.addQuotes(db, "value") + " = ?, multiplier = ?, " + "range_min = ?, range_max = ?, cost_currency=?, cost_amount = ? ");
        sql.append("WHERE value_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getOptionId());
        DatabaseUtils.setInt(pst, ++i, this.getResultId());
        pst.setString(++i, this.getDescription());
        DatabaseUtils.setInt(pst, ++i, this.getMsrpCurrency());
        pst.setDouble(++i, this.getMsrpAmount());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getValue());
        pst.setDouble(++i, this.getMultiplier());
        pst.setInt(++i, this.getRangeMin());
        pst.setInt(++i, this.getRangeMax());
        DatabaseUtils.setInt(pst, ++i, this.getCostCurrency());
        pst.setDouble(++i, this.getCostAmount());
        DatabaseUtils.setInt(pst, ++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean isValid(Connection db) throws SQLException {
        return this.getId() != -1;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("price_amount");
        thisList.add("msrp_amount");
        thisList.add("cost_amount");
        return thisList;
    }
}

