/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.configurator.Configurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;

public class CheckboxConfigurator
extends Configurator
implements OptionConfigurator {
    private String label = null;
    private double priceAdjust = 0.0;
    private static final int LABEL_ID = 1;
    private static final int PRICE_ADJUST = 1;

    public double getPriceAdjust() {
        return this.priceAdjust;
    }

    public void setPriceAdjust(double tmp) {
        this.priceAdjust = tmp;
    }

    public void setPriceAdjust(String tmp) {
        this.priceAdjust = Double.parseDouble(tmp);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public CheckboxConfigurator() {
        this.name = "Check Box";
        OptionProperty property = null;
        property = new OptionProperty();
        property.setType(1);
        property.setName("text_label");
        property.setValue("");
        property.setDisplay("Label to display");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(2);
        property.setName("double_priceadjust");
        property.setValue("0");
        property.setDisplay("Adjust base price when selected");
        property.setIsForPrompting(true);
        property.setNote("base price + (amount)");
        this.propertyList.add(property);
    }

    public boolean arePropertiesConfigured() {
        return this.label != null && !this.label.trim().equals("");
    }

    public void setProperties(HttpServletRequest request) {
        this.propertyList.setOptionProperties(request);
        this.label = this.propertyList.getOptionProperty("text_label").getValue();
        this.priceAdjust = Double.parseDouble(this.propertyList.getOptionProperty("double_priceadjust").getValue());
    }

    public boolean saveProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.insert(db);
            this.saveText(db, option.getId(), 1, this.label);
            this.saveDouble(db, option.getId(), 1, this.priceAdjust);
            db.commit();
            this.optionId = option.getId();
            result = true;
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public boolean updateProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.update(db);
            this.updateText(db, option.getId(), 1, this.label);
            this.updateDouble(db, option.getId(), 1, this.priceAdjust);
            db.commit();
            this.optionId = option.getId();
            result = true;
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public void queryProperties(Connection db, int optionId, boolean doClean) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        this.label = this.getText(db, optionId, 1);
        this.propertyList.setOptionProperty("text_label", this.label);
        this.priceAdjust = this.getDouble(db, optionId, 1);
        this.propertyList.setOptionProperty("double_priceadjust", String.valueOf(this.priceAdjust));
        this.built = true;
        this.optionId = optionId;
    }

    public void prepareContext(HttpServletRequest request, Connection db) throws SQLException {
    }

    public String getHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table class=\"empty\" cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" align=\"left\" nowrap>");
        sb.append("\t\t" + this.label + "</td>");
        sb.append("\t\t<td><input type=\"checkbox\" name=\"chk" + this.optionId + "\" value=\"true\" /></td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getQuoteHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellspacing=\"0\" cellpadding=\"4\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>");
        sb.append("\t\t" + this.label + "</td>");
        sb.append("\t\t<td><input type=\"checkbox\" name=\"chk" + this.optionId + "\" value=\"true\" checked disabled></td>");
        sb.append("\t\t<td width=\"25%\"><input type=\"text\" size=\"8\"");
        sb.append("            name=\"price" + this.optionId + "\" value=\"" + this.quotePriceAdjust + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public boolean validateUserInput(HttpServletRequest request) {
        String input;
        boolean isValid = true;
        if (request.getParameter("chk" + this.optionId) != null && (input = request.getParameter("chk" + this.optionId)) != null && !"".equals(input.trim()) && "false".equals(input.trim())) {
            isValid = false;
        }
        try {
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    public boolean hasUserInput(HttpServletRequest request) {
        String input;
        boolean hasInput = false;
        if (request.getParameter("chk" + this.optionId) != null && (input = request.getParameter("chk" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        if (request.getParameter("price" + this.optionId) != null && (input = request.getParameter("price" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        return hasInput;
    }

    public double computePriceAdjust(HttpServletRequest request) {
        if (request.getParameter("price" + this.optionId) != null) {
            double price = Double.parseDouble(request.getParameter("price" + this.optionId));
            return price;
        }
        return this.priceAdjust;
    }

    public void saveQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        this.saveQuoteDouble(db, quoteProductOptionId, 1, this.priceAdjust);
    }

    public void updateQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        if (request.getParameter("price" + this.optionId) != null) {
            String input = request.getParameter("price" + this.optionId);
            this.updateQuoteDouble(db, quoteProductOptionId, 1, Double.parseDouble(input));
        }
    }
}

