/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import org.aspcfs.modules.products.configurator.OptionPropertyList;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.utils.DatabaseUtils;

public abstract class Configurator {
    protected int optionId = -1;
    protected String name = null;
    protected String description = null;
    protected boolean built = false;
    protected boolean hasValues = false;
    protected boolean allowMultiplePrices = false;
    protected OptionPropertyList propertyList = new OptionPropertyList();
    protected HashMap warnings = new HashMap();
    protected boolean onlyWarnings = false;
    public static final String PROPERTY_ERROR = "property error";
    public static final String VALUE_ERROR = "value error";
    protected int quoteProductOptionId = -1;
    protected String quoteUserInput = null;
    protected double quotePriceAdjust = 0.0;
    protected final int QUOTE_USER_INPUT = 1;
    protected final int QUOTE_PRICE_ADJUST = 1;

    public double getQuotePriceAdjust() {
        return this.quotePriceAdjust;
    }

    public void setQuotePriceAdjust(double tmp) {
        this.quotePriceAdjust = tmp;
    }

    public void setQuotePriceAdjust(String tmp) {
        this.quotePriceAdjust = Double.parseDouble(tmp);
    }

    public String getQuoteUserInput() {
        return this.quoteUserInput;
    }

    public boolean getAllowMultiplePrices() {
        return this.allowMultiplePrices;
    }

    public void setAllowMultiplePrices(boolean tmp) {
        this.allowMultiplePrices = tmp;
    }

    public void setAllowMultiplePrices(String tmp) {
        this.allowMultiplePrices = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOptionId(int tmp) {
        this.optionId = tmp;
    }

    public void setOptionId(String tmp) {
        this.optionId = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setBuilt(boolean tmp) {
        this.built = tmp;
    }

    public void setBuilt(String tmp) {
        this.built = DatabaseUtils.parseBoolean(tmp);
    }

    public void setHasValues(boolean tmp) {
        this.hasValues = tmp;
    }

    public void setHasValues(String tmp) {
        this.hasValues = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPropertyList(OptionPropertyList tmp) {
        this.propertyList = tmp;
    }

    public void setWarnings(HashMap warnings) {
        this.warnings = warnings;
    }

    public void setOnlyWarnings(boolean onlyWarnings) {
        this.onlyWarnings = onlyWarnings;
    }

    public int getOptionId() {
        return this.optionId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean getBuilt() {
        return this.built;
    }

    public boolean getHasValues() {
        return this.hasValues;
    }

    public OptionPropertyList getPropertyList() {
        return this.propertyList;
    }

    public HashMap getErrors() {
        return this.propertyList.getErrors();
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public boolean getOnlyWarnings() {
        return this.onlyWarnings;
    }

    abstract boolean arePropertiesConfigured();

    abstract void queryProperties(Connection var1, int var2, boolean var3) throws SQLException;

    abstract String getLabel();

    public void queryQuoteProperties(Connection db, int quoteProductOptionId) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Qupte Product Option Id");
        }
        this.quoteUserInput = this.getQuoteText(db, quoteProductOptionId, 1);
        this.quotePriceAdjust = this.getQuoteDouble(db, quoteProductOptionId, 1);
        this.quoteProductOptionId = quoteProductOptionId;
    }

    public boolean saveQuoteOption(Connection db, QuoteProductOption option) throws SQLException {
        boolean status = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            option.insert(db);
            if (option.getQuoteUserInput() != null) {
                this.saveQuoteText(db, option.getId(), 1, option.getQuoteUserInput());
            }
            this.saveQuoteDouble(db, option.getId(), 1, option.getQuotePriceAdjust());
            if (commit) {
                db.commit();
            }
            status = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return status;
    }

    public String getQuoteText(Connection db, int quoteProductOptionId, int id) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        String text = null;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM quote_product_option_text " + "WHERE quote_product_option_id = ? AND id = ? ");
        pst.setInt(1, quoteProductOptionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            text = rs.getString("value");
        }
        rs.close();
        pst.close();
        return text;
    }

    public double getQuoteDouble(Connection db, int quoteProductOptionId, int id) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        double value = 0.0;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM quote_product_option_float " + "WHERE quote_product_option_id = ? AND id = ? ");
        pst.setInt(1, quoteProductOptionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            value = rs.getDouble("value");
        }
        rs.close();
        pst.close();
        return value;
    }

    public void saveQuoteText(Connection db, int quoteProductOptionId, int id, String value) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO quote_product_option_text(quote_product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, quoteProductOptionId);
        pst.setInt(++i, id);
        pst.setString(++i, value);
        pst.execute();
        pst.close();
    }

    public void saveQuoteDouble(Connection db, int quoteProductOptionId, int id, double value) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO quote_product_option_float(quote_product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, quoteProductOptionId);
        pst.setInt(++i, id);
        pst.setDouble(++i, value);
        pst.execute();
        pst.close();
    }

    public void updateQuoteText(Connection db, int quoteProductOptionId, int id, String value) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE quote_product_option_text SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE quote_product_option_id = ? " + "AND id = ? ");
        int i = 0;
        pst.setString(++i, value);
        pst.setInt(++i, quoteProductOptionId);
        pst.setInt(++i, id);
        pst.execute();
        pst.close();
    }

    public void updateQuoteDouble(Connection db, int quoteProductOptionId, int id, double value) throws SQLException {
        if (quoteProductOptionId == -1) {
            throw new SQLException("Invalid Product Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE quote_product_option_float SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE quote_product_option_id = ? " + "AND id = ? ");
        int i = 0;
        pst.setDouble(++i, value);
        pst.setInt(++i, quoteProductOptionId);
        pst.setInt(++i, id);
        pst.execute();
        pst.close();
    }

    public boolean enableOption(Connection db, int optionId) throws SQLException {
        return true;
    }

    public String getText(Connection db, int optionId, int id) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        String text = null;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM product_option_text " + "WHERE product_option_id = ? AND id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            text = rs.getString("value");
        }
        rs.close();
        pst.close();
        return text;
    }

    public void saveText(Connection db, int optionId, int id, String value) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_text(product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.setString(++i, value);
        pst.execute();
        pst.close();
    }

    public int getInteger(Connection db, int optionId, int id) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        int value = -1;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM product_option_integer " + "WHERE product_option_id = ? AND id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            value = rs.getInt("value");
        }
        rs.close();
        pst.close();
        return value;
    }

    public void saveInteger(Connection db, int optionId, int id, int value) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_integer(product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.setInt(++i, value);
        pst.execute();
        pst.close();
    }

    public boolean getBoolean(Connection db, int optionId, int id) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        boolean value = false;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM product_option_boolean " + "WHERE product_option_id = ? AND id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            value = rs.getBoolean("value");
        }
        rs.close();
        pst.close();
        return value;
    }

    public void saveBoolean(Connection db, int optionId, int id, boolean value) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_boolean(product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.setBoolean(++i, value);
        pst.execute();
        pst.close();
    }

    public double getDouble(Connection db, int optionId, int id) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        double value = 0.0;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM product_option_float " + "WHERE product_option_id = ? AND id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            value = rs.getDouble("value");
        }
        rs.close();
        pst.close();
        return value;
    }

    public void saveDouble(Connection db, int optionId, int id, double value) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_float(product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.setDouble(++i, value);
        pst.execute();
        pst.close();
    }

    public Timestamp getTimestamp(Connection db, int optionId, int id) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        Timestamp value = null;
        PreparedStatement pst = db.prepareStatement("SELECT " + DatabaseUtils.addQuotes(db, "value") + " " + "FROM product_option_timestamp " + "WHERE product_option_id = ? AND id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            value = rs.getTimestamp("value");
        }
        rs.close();
        pst.close();
        return value;
    }

    public void saveTimestamp(Connection db, int optionId, int id, Timestamp value) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("INSERT INTO product_option_timestamp(product_option_id, id, " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (?, ?, ?) ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.setTimestamp(++i, value);
        pst.execute();
        pst.close();
    }

    public int getValueCount(Connection db, int optionId, int resultId) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("SELECT COUNT(*) AS thecount FROM product_option_values WHERE option_id = ? AND result_id = ? ");
        pst.setInt(1, optionId);
        pst.setInt(2, resultId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            return rs.getInt("thecount");
        }
        rs.close();
        pst.close();
        return 0;
    }

    public int updateText(Connection db, int optionId, int id, String value) throws SQLException {
        int resultCount = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_option_text SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setString(++i, value);
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateInteger(Connection db, int optionId, int id, int value) throws SQLException {
        int resultCount = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_option_integer SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setInt(++i, value);
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateBoolean(Connection db, int optionId, int id, boolean value) throws SQLException {
        int resultCount = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_option_boolean SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setBoolean(++i, value);
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateDouble(Connection db, int optionId, int id, double value) throws SQLException {
        int resultCount = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_option_float SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setDouble(++i, value);
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public int updateTimestamp(Connection db, int optionId, int id, Timestamp value) throws SQLException {
        int resultCount = -1;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("UPDATE product_option_timestamp SET " + DatabaseUtils.addQuotes(db, "value") + " = ? " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setTimestamp(++i, value);
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public boolean deleteValue(Connection db, int optionId, int id, String tableName) throws SQLException {
        boolean result = false;
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        PreparedStatement pst = db.prepareStatement("DELETE FROM product_option_" + tableName + " " + "WHERE product_option_id = ? AND id = ? ");
        int i = 0;
        pst.setInt(++i, optionId);
        pst.setInt(++i, id);
        pst.execute();
        pst.close();
        result = true;
        return result;
    }
}

