/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.configurator.Configurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;
import org.aspcfs.utils.web.HtmlSelect;

public class LookupListConfigurator
extends Configurator
implements OptionConfigurator {
    private String label = null;
    private String[] items = new String[30];
    private double[] priceAdjust = new double[30];
    private boolean[] enabled = new boolean[30];
    private int size = -1;
    private int maxListSize = 30;
    private final int LABEL_ID = 1;
    private final int ITEM_ID = 2;
    private final int SIZE_ID = 1;
    private final int PRICE_ADJUST = 1;
    private final int ENABLED = 1;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public double getPriceAdjust() {
        return this.priceAdjust[0];
    }

    public LookupListConfigurator() {
        this.setAllowMultiplePrices(true);
        this.name = "Lookup List";
        OptionProperty property = null;
        property = new OptionProperty();
        property.setType(1);
        property.setName("text_label");
        property.setValue("");
        property.setDisplay("Label");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        for (int i = 0; i < this.maxListSize; ++i) {
            property = new OptionProperty();
            property.setType(3);
            property.setName("text_item" + i);
            property.setValue("");
            property.setDisplay("");
            property.setIsForPrompting(true);
            property.setNote("");
            this.propertyList.add(property);
            property = new OptionProperty();
            property.setType(2);
            property.setName("double_priceadjust" + i);
            property.setValue("0");
            property.setDisplay("");
            property.setIsForPrompting(true);
            property.setNote("");
            this.propertyList.add(property);
            property = new OptionProperty();
            property.setType(3);
            property.setName("boolean_enabled" + i);
            property.setValue("false");
            property.setDisplay("");
            property.setIsForPrompting(true);
            property.setNote("");
            this.propertyList.add(property);
        }
    }

    public boolean arePropertiesConfigured() {
        return true;
    }

    public void setProperties(HttpServletRequest request) {
        this.propertyList.setOptionProperties(request);
        this.label = this.propertyList.getOptionProperty("text_label").getValue();
        int index = 0;
        for (int i = 0; i < this.maxListSize; ++i) {
            OptionProperty itemProperty = this.propertyList.getOptionProperty("text_item" + i);
            OptionProperty priceAdjustProperty = this.propertyList.getOptionProperty("double_priceadjust" + i);
            OptionProperty enabledProperty = this.propertyList.getOptionProperty("boolean_enabled" + i);
            if (itemProperty == null || priceAdjustProperty == null || enabledProperty == null) break;
            if ("".equals(itemProperty.getValue().trim())) continue;
            this.items[index] = itemProperty.getValue();
            this.priceAdjust[index] = Double.parseDouble(priceAdjustProperty.getValue());
            this.enabled[index] = "true".equals(enabledProperty.getValue());
            ++index;
        }
        this.size = index;
    }

    public boolean saveProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.insert(db);
            this.saveText(db, option.getId(), 1, this.label);
            for (int i = 0; i < this.size; ++i) {
                this.saveText(db, option.getId(), 2 + i, this.items[i]);
                this.saveDouble(db, option.getId(), 1 + i, this.priceAdjust[i]);
                this.saveBoolean(db, option.getId(), 1 + i, this.enabled[i]);
            }
            this.saveInteger(db, option.getId(), 1, this.size);
            db.commit();
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        this.cleanProperties();
        return result;
    }

    public boolean updateProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.update(db);
            this.updateText(db, option.getId(), 1, this.label);
            for (int i = 0; i < this.size; ++i) {
                this.updateText(db, option.getId(), 2 + i, this.items[i]);
                this.updateDouble(db, option.getId(), 1 + i, this.priceAdjust[i]);
                this.updateBoolean(db, option.getId(), 1 + i, this.enabled[i]);
            }
            int previousSize = this.getInteger(db, option.getId(), 1);
            if (this.size > previousSize) {
                for (int j = previousSize; j < this.size; ++j) {
                    this.saveText(db, option.getId(), 2 + j, this.items[j]);
                    this.saveDouble(db, option.getId(), 1 + j, this.priceAdjust[j]);
                    this.saveBoolean(db, option.getId(), 1 + j, this.enabled[j]);
                }
            }
            this.updateInteger(db, option.getId(), 1, this.size);
            db.commit();
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        this.cleanProperties();
        return result;
    }

    public void queryProperties(Connection db, int optionId, boolean doClean) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        this.label = this.getText(db, optionId, 1);
        this.propertyList.setOptionProperty("text_label", this.label);
        this.size = this.getInteger(db, optionId, 1);
        for (int i = 0; i < this.size; ++i) {
            this.items[i] = this.getText(db, optionId, 2 + i);
            this.propertyList.setOptionProperty("text_item" + i, this.items[i]);
            this.priceAdjust[i] = this.getDouble(db, optionId, 1 + i);
            this.propertyList.setOptionProperty("double_priceadjust" + i, String.valueOf(this.priceAdjust[i]));
            this.enabled[i] = this.getBoolean(db, optionId, 1 + i);
            this.propertyList.setOptionProperty("boolean_enabled" + i, Boolean.toString(this.enabled[i]));
        }
        if (doClean) {
            this.cleanProperties();
        }
        this.built = true;
        this.optionId = optionId;
    }

    private void cleanProperties() {
        for (int j = 0; j < this.maxListSize; ++j) {
            OptionProperty itemProperty = this.propertyList.getOptionProperty("text_item" + j);
            OptionProperty priceAdjustProperty = this.propertyList.getOptionProperty("double_priceadjust" + j);
            OptionProperty enabledProperty = this.propertyList.getOptionProperty("boolean_enabled" + j);
            if (itemProperty == null || priceAdjustProperty == null || enabledProperty == null || !"".equals(itemProperty.getValue().trim())) continue;
            this.propertyList.remove((Object)this.propertyList.getOptionProperty("text_item" + j));
            this.propertyList.remove((Object)this.propertyList.getOptionProperty("double_priceadjust" + j));
            this.propertyList.remove((Object)this.propertyList.getOptionProperty("boolean_enabled" + j));
        }
    }

    public void prepareContext(HttpServletRequest request, Connection db) throws SQLException {
    }

    private int getItemIndex(String value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!value.equals(this.items[i])) continue;
            return i;
        }
        return -1;
    }

    public String getHtml() {
        HtmlSelect select = new HtmlSelect();
        select.addItem(-1, "----");
        for (int i = 0; i < this.size; ++i) {
            if (!this.enabled[i]) continue;
            select.addItem(i, this.items[i]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<table class=\"empty\" cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>" + this.label + "</td>");
        sb.append("\t\t<td>" + select.getHtml("select" + this.optionId) + "</td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getQuoteHtml() {
        HtmlSelect select = new HtmlSelect();
        for (int i = 0; i < this.size; ++i) {
            if (!this.enabled[i]) continue;
            select.addItem(i, this.items[i]);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellspacing=\"0\" cellpadding=\"4\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>" + this.label + "</td>");
        sb.append("\t\t<td>" + select.getHtml("select" + this.optionId, this.getItemIndex(this.quoteUserInput)) + "</td>");
        sb.append("\t\t<td width=\"25%\"><input type=\"text\" size=\"8\"");
        sb.append("            name=\"price" + this.optionId + "\" value=\"" + this.quotePriceAdjust + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public boolean validateUserInput(HttpServletRequest request) {
        String input;
        boolean isValid = true;
        if (request.getParameter("select" + this.optionId) != null && (input = request.getParameter("select" + this.optionId)) != null && !"".equals(input.trim()) && "-1".equals(input.trim())) {
            isValid = false;
        }
        try {
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    public boolean hasUserInput(HttpServletRequest request) {
        String input;
        boolean hasInput = false;
        if (request.getParameter("select" + this.optionId) != null && (input = request.getParameter("select" + this.optionId)) != null && !"".equals(input.trim()) && !"-1".equals(input.trim())) {
            hasInput = true;
        }
        if (request.getParameter("price" + this.optionId) != null && (input = request.getParameter("price" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        return hasInput;
    }

    public double computePriceAdjust(HttpServletRequest request) {
        if (request.getParameter("select" + this.optionId) != null) {
            String input = request.getParameter("select" + this.optionId);
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
                return price;
            }
            try {
                if (Integer.parseInt(input) >= 0) {
                    return this.priceAdjust[Integer.parseInt(input)];
                }
            }
            catch (NumberFormatException e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public void saveQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("select" + this.optionId) != null && (input = request.getParameter("select" + this.optionId)) != null) {
            this.saveQuoteText(db, quoteProductOptionId, 1, this.items[Integer.parseInt(input)]);
            this.saveQuoteDouble(db, quoteProductOptionId, 1, this.priceAdjust[Integer.parseInt(input)]);
        }
    }

    public void updateQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("select" + this.optionId) != null) {
            input = request.getParameter("select" + this.optionId);
            this.updateQuoteText(db, quoteProductOptionId, 1, this.items[Integer.parseInt(input)]);
        }
        if (request.getParameter("price" + this.optionId) != null) {
            input = request.getParameter("price" + this.optionId);
            this.updateQuoteDouble(db, quoteProductOptionId, 1, Double.parseDouble(input));
        }
    }
}

