/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.configurator.Configurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;
import org.aspcfs.utils.DatabaseUtils;

public class NumericalConfigurator
extends Configurator
implements OptionConfigurator {
    private String label = null;
    private int minNum = -1;
    private int maxNum = -1;
    private int defaultNum = 0;
    private boolean allowFractions = false;
    private double priceAdjust = 0.0;
    private final int LABEL_ID = 1;
    private final int MIN_NUM = 1;
    private final int MAX_NUM = 2;
    private final int DEFAULT_NUM = 3;
    private final int ALLOW_FRACTIONS = 1;
    private final int PRICE_ADJUST = 1;

    public double getPriceAdjust() {
        return this.priceAdjust;
    }

    public void setPriceAdjust(double tmp) {
        this.priceAdjust = tmp;
    }

    public void setPriceAdjust(String tmp) {
        this.priceAdjust = Double.parseDouble(tmp);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public int getMinNum() {
        return this.minNum;
    }

    public void setMinNum(int tmp) {
        this.minNum = tmp;
    }

    public void setMinNum(String tmp) {
        this.minNum = Integer.parseInt(tmp);
    }

    public int getMaxNum() {
        return this.maxNum;
    }

    public void setMaxNum(int tmp) {
        this.maxNum = tmp;
    }

    public void setMaxNum(String tmp) {
        this.maxNum = Integer.parseInt(tmp);
    }

    public int getDefaultNum() {
        return this.defaultNum;
    }

    public void setDefaultNum(int tmp) {
        this.defaultNum = tmp;
    }

    public void setDefaultNum(String tmp) {
        this.defaultNum = Integer.parseInt(tmp);
    }

    public boolean getAllowFractions() {
        return this.allowFractions;
    }

    public void setAllowFractions(boolean tmp) {
        this.allowFractions = tmp;
    }

    public void setAllowFractions(String tmp) {
        this.allowFractions = DatabaseUtils.parseBoolean(tmp);
    }

    public NumericalConfigurator() {
        this.name = "Number";
        OptionProperty property = null;
        property = new OptionProperty();
        property.setType(1);
        property.setName("text_label");
        property.setValue("");
        property.setDisplay("Label to display");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("number_min");
        property.setValue("");
        property.setDisplay("Minimum Number Allowed");
        property.setIsForPrompting(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("number_max");
        property.setValue("");
        property.setDisplay("Maximum Number Allowed");
        property.setIsForPrompting(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("number_default");
        property.setValue("");
        property.setDisplay("Default Value");
        property.setIsForPrompting(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("boolean_allowfractions");
        property.setValue("false");
        property.setDisplay("Allow Fractions?");
        property.setIsForPrompting(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(2);
        property.setName("double_priceadjust");
        property.setValue("0");
        property.setDisplay("Adjust base price based on number specified");
        property.setIsForPrompting(true);
        property.setNote("base price + (number specified X amount)");
        this.propertyList.add(property);
    }

    public boolean arePropertiesConfigured() {
        return true;
    }

    public void setProperties(HttpServletRequest request) {
        this.propertyList.setOptionProperties(request);
        this.label = this.propertyList.getOptionProperty("text_label").getValue();
        String tmp = this.propertyList.getOptionProperty("number_min").getValue();
        if (tmp != null && !"".equals(tmp.trim())) {
            this.minNum = Integer.parseInt(this.propertyList.getOptionProperty("number_min").getValue());
        }
        if ((tmp = this.propertyList.getOptionProperty("number_max").getValue()) != null && !"".equals(tmp.trim())) {
            this.maxNum = Integer.parseInt(this.propertyList.getOptionProperty("number_max").getValue());
        }
        if ((tmp = this.propertyList.getOptionProperty("number_default").getValue()) != null && !"".equals(tmp.trim())) {
            this.defaultNum = Integer.parseInt(this.propertyList.getOptionProperty("number_default").getValue());
        }
        this.allowFractions = "true".equals(tmp = this.propertyList.getOptionProperty("boolean_allowfractions").getValue());
        this.priceAdjust = Double.parseDouble(this.propertyList.getOptionProperty("double_priceadjust").getValue());
    }

    public boolean saveProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.insert(db);
            this.saveText(db, option.getId(), 1, this.label);
            this.saveInteger(db, option.getId(), 1, this.minNum);
            this.saveInteger(db, option.getId(), 2, this.maxNum);
            this.saveInteger(db, option.getId(), 3, this.defaultNum);
            this.saveBoolean(db, option.getId(), 1, this.allowFractions);
            this.saveDouble(db, option.getId(), 1, this.priceAdjust);
            db.commit();
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public boolean updateProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.update(db);
            this.updateText(db, option.getId(), 1, this.label);
            this.updateInteger(db, option.getId(), 1, this.minNum);
            this.updateInteger(db, option.getId(), 2, this.maxNum);
            this.updateInteger(db, option.getId(), 3, this.defaultNum);
            this.updateBoolean(db, option.getId(), 1, this.allowFractions);
            this.updateDouble(db, option.getId(), 1, this.priceAdjust);
            db.commit();
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public void queryProperties(Connection db, int optionId, boolean doClean) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        this.label = this.getText(db, optionId, 1);
        this.propertyList.setOptionProperty("text_label", this.label);
        this.minNum = this.getInteger(db, optionId, 1);
        this.propertyList.setOptionProperty("number_min", String.valueOf(this.minNum));
        this.maxNum = this.getInteger(db, optionId, 2);
        this.propertyList.setOptionProperty("number_max", String.valueOf(this.maxNum));
        this.defaultNum = this.getInteger(db, optionId, 3);
        this.propertyList.setOptionProperty("number_default", String.valueOf(this.defaultNum));
        this.allowFractions = this.getBoolean(db, optionId, 1);
        this.propertyList.setOptionProperty("boolean_allowfractions", Boolean.toString(this.allowFractions));
        this.priceAdjust = this.getDouble(db, optionId, 1);
        this.propertyList.setOptionProperty("double_priceadjust", String.valueOf(this.priceAdjust));
        this.built = true;
        this.optionId = optionId;
    }

    public boolean enableOption(Connection db, int optionId) throws SQLException {
        return true;
    }

    public void prepareContext(HttpServletRequest request, Connection db) throws SQLException {
    }

    public String getHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table class=\"empty\" cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>");
        sb.append("    " + this.label);
        sb.append("   </td>");
        sb.append("\t\t<td><input type=\"text\" size=\"6\"");
        sb.append("            name=\"number" + this.optionId + "\" value=\"" + this.defaultNum + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getQuoteHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellspacing=\"0\" cellpadding=\"4\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>");
        sb.append("    " + this.label);
        sb.append("   </td>");
        sb.append("\t\t<td><input type=\"text\" size=\"6\"");
        sb.append("            name=\"number" + this.optionId + "\" value=\"" + this.quoteUserInput + "\"/>");
        sb.append("   </td>");
        sb.append("\t\t<td width=\"25%\"><input type=\"text\" size=\"8\"");
        sb.append("            name=\"price" + this.optionId + "\" value=\"" + this.quotePriceAdjust + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public boolean validateUserInput(HttpServletRequest request) {
        boolean isValid = true;
        if (request.getParameter("number" + this.optionId) != null) {
            String input = request.getParameter("number" + this.optionId);
            try {
                if (this.allowFractions) {
                    if (this.minNum != -1 && Double.parseDouble(input) < (double)this.minNum) {
                        isValid = false;
                    }
                    if (this.maxNum != -1 && Double.parseDouble(input) > (double)this.maxNum) {
                        isValid = false;
                    }
                    double tmp = Double.parseDouble(input);
                } else {
                    if (this.minNum != -1 && Integer.parseInt(input) < this.minNum) {
                        isValid = false;
                    }
                    if (this.maxNum != -1 && Integer.parseInt(input) > this.maxNum) {
                        isValid = false;
                    }
                    int tmp = Integer.parseInt(input);
                }
            }
            catch (Exception e) {
                isValid = false;
            }
        }
        try {
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    public boolean hasUserInput(HttpServletRequest request) {
        String input;
        boolean hasInput = false;
        if (request.getParameter("number" + this.optionId) != null && (input = request.getParameter("number" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        if (request.getParameter("price" + this.optionId) != null && (input = request.getParameter("price" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        return hasInput;
    }

    public double computePriceAdjust(HttpServletRequest request) {
        if (request.getParameter("number" + this.optionId) != null) {
            String input = request.getParameter("number" + this.optionId);
            try {
                if (this.validateUserInput(request)) {
                    if (request.getParameter("price" + this.optionId) != null) {
                        double price = Double.parseDouble(request.getParameter("price" + this.optionId));
                        if (this.allowFractions) {
                            return Double.parseDouble(input) * price;
                        }
                        return (double)Integer.parseInt(input) * price;
                    }
                    if (this.allowFractions) {
                        return Double.parseDouble(input) * this.priceAdjust;
                    }
                    return (double)Integer.parseInt(input) * this.priceAdjust;
                }
            }
            catch (Exception e) {
                return 0.0;
            }
        }
        return 0.0;
    }

    public void saveQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("number" + this.optionId) != null && (input = request.getParameter("number" + this.optionId)) != null) {
            this.saveQuoteText(db, quoteProductOptionId, 1, input);
            this.saveQuoteDouble(db, quoteProductOptionId, 1, this.priceAdjust);
        }
    }

    public void updateQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("number" + this.optionId) != null) {
            input = request.getParameter("number" + this.optionId);
            this.updateQuoteText(db, quoteProductOptionId, 1, input);
        }
        if (request.getParameter("price" + this.optionId) != null) {
            input = request.getParameter("price" + this.optionId);
            this.updateQuoteDouble(db, quoteProductOptionId, 1, Double.parseDouble(input));
        }
    }
}

