/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.HTTPUtils;

public class OptionProperty
extends GenericBean {
    public static final int LISTSELECT = 1;
    public static final int SIMPLE_PROPERTY = 1;
    public static final int BASEADJUST_PROPERTY = 2;
    public static final int LOOKUP_PROPERTY = 3;
    private String name = null;
    private String value = null;
    private String display = null;
    private boolean isForPrompting = false;
    private boolean isRequired = false;
    private int type = -1;
    private String note = null;
    private String errorMsg = null;

    public boolean getIsRequired() {
        return this.isRequired;
    }

    public void setIsRequired(boolean tmp) {
        this.isRequired = tmp;
    }

    public void setIsRequired(String tmp) {
        this.isRequired = DatabaseUtils.parseBoolean(tmp);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setErrorMsg(String tmp) {
        this.errorMsg = tmp;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setNote(String tmp) {
        this.note = tmp;
    }

    public String getNote() {
        return this.note;
    }

    public void setIsForPrompting(boolean tmp) {
        this.isForPrompting = tmp;
    }

    public void setIsForPrompting(String tmp) {
        this.isForPrompting = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIsForPrompting() {
        return this.isForPrompting;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setValue(String tmp) {
        this.value = tmp;
    }

    public void setDisplay(String tmp) {
        this.display = tmp;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return !"-1".equals(this.value) ? this.value : "";
    }

    public String getDisplay() {
        return this.display;
    }

    public OptionProperty() {
    }

    public OptionProperty(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public OptionProperty(String name, String value, String display, boolean prompt) {
        this.name = name;
        this.value = value;
        this.display = display;
        this.isForPrompting = prompt;
    }

    public void prepareContext(Connection db, HttpServletRequest request) throws SQLException {
    }

    public String getHtml(HttpServletRequest request) {
        if (this.name.startsWith("text_")) {
            int defaultSize = 25;
            return this.table("<input type=\"text\" size=\"" + defaultSize + "\" " + "name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\" />");
        }
        if (this.name.startsWith("number_")) {
            int defaultSize = 10;
            return this.table("<input type=\"text\" size=\"" + defaultSize + "\" " + "name=\"" + this.name + "\" value=\"" + (!"-1".equals(this.value) ? HTTPUtils.toHtmlValue(this.value) : "") + "\" />");
        }
        if (this.name.startsWith("lookup_")) {
            return this.table("<textarea cols=\"28\" rows=\"5\" name=\"" + this.name + "\" wrap=\"SOFT\">" + this.value + "</textarea>");
        }
        if (this.name.startsWith("boolean_")) {
            return this.table("<input type=\"checkbox\" name=\"chk" + this.name + "\" onclick=\"javascript:setField('" + this.name + "', document.paramForm.chk" + this.name + ".checked, 'paramForm');\"" + (this.value != null && Boolean.valueOf(this.value) != false ? "checked" : "") + " >" + "<input type=\"hidden\" name=\"" + this.name + "\" value=\"" + (this.value != null && Boolean.valueOf(this.value) != false ? "true" : "false") + "\">");
        }
        if (this.name.startsWith("double_")) {
            int defaultSize = 7;
            return this.table("<input type=\"text\" size=\"" + defaultSize + "\" " + "name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\" />");
        }
        return "Property Not Supported";
    }

    private String table(String html) {
        return "<table cellspacing=\"1\" cellpadding=\"1\" border=\"0\">\t<tr>\t\t<td nowrap width=\"30%\">" + html + (this.isRequired ? "<font color=\"red\">*</font>" : "") + "</td>" + "\t\t<td nowrap><font color=\"green\">" + this.note + "</font></td>" + "   <td><font color=\"#006699\">" + HTTPUtils.toHtmlValue(this.errorMsg) + "</font></td>" + "  </tr>" + "</table>";
    }

    public boolean isValid(SystemStatus systemStatus) {
        if (this.name.startsWith("text_")) {
            if ((this.value == null || this.value.trim().equals("")) && this.isRequired) {
                this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.required") : "Text value cannot be empty";
            }
        } else if (this.name.startsWith("number_")) {
            try {
                if (this.value != null && !"".equals(this.value.trim())) {
                    int n = Integer.parseInt(this.value);
                    if (n < 0) {
                        this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.valueCanNotBeNegative") : "Value cannot be negative";
                    }
                } else if (this.isRequired) {
                    this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.incorrectNumberFormat") : "Integer value required";
                }
            }
            catch (NumberFormatException nfe) {
                this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.incorrectNumberFormat") : "Integer value required";
            }
        } else if (this.name.startsWith("lookup_")) {
            if ((this.value == null || this.value.trim().equals("")) && this.isRequired) {
                this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.atleastOneItemToBeSpecified") : "At least one item needs to be specified";
            }
        } else if (this.name.startsWith("double_")) {
            try {
                if (this.value != null || !"".equals(this.value.trim())) {
                    double val = Double.parseDouble(this.value);
                    if (val < 0.0) {
                        this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.incorrectNumberFormat") : "float error";
                    }
                } else if (this.isRequired) {
                    this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.incorrectNumberFormat") : "float error";
                }
            }
            catch (NumberFormatException nfe) {
                this.errorMsg = systemStatus != null ? systemStatus.getLabel("object.validation.incorrectNumberFormat") : "float error";
            }
        }
        return this.errorMsg == null;
    }
}

