/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.products.configurator.OptionProperty;

public class OptionPropertyList
extends ArrayList {
    public void setOptionProperties(HttpServletRequest request) {
        for (OptionProperty property : this) {
            if (!property.getIsForPrompting()) continue;
            property.setValue(request.getParameter(property.getName()));
            System.out.println("OptionPropertyList-> property " + property.getName() + "=" + property.getValue());
        }
    }

    public OptionProperty getOptionProperty(String property) {
        for (OptionProperty thisProperty : this) {
            if (!property.equals(thisProperty.getName())) continue;
            return thisProperty;
        }
        return null;
    }

    public void setOptionProperty(String property, String value) {
        for (OptionProperty thisProperty : this) {
            if (!property.equals(thisProperty.getName())) continue;
            thisProperty.setValue(value.trim());
            break;
        }
    }

    public boolean isValid(SystemStatus systemStatus) {
        Iterator i = this.iterator();
        boolean valid = true;
        while (i.hasNext()) {
            OptionProperty property = (OptionProperty)((Object)i.next());
            if (property.isValid(systemStatus)) continue;
            valid = false;
        }
        return valid;
    }

    public HashMap getErrors() {
        HashMap<String, String> errors = new HashMap<String, String>();
        for (OptionProperty property : this) {
            if (property.getErrorMsg() == null) continue;
            errors.put(property.getName(), property.getErrorMsg());
        }
        return errors;
    }
}

