/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.configurator;

import java.sql.Connection;
import java.sql.SQLException;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.products.base.ProductOption;
import org.aspcfs.modules.products.configurator.Configurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionProperty;
import org.aspcfs.utils.HTTPUtils;

public class StringConfigurator
extends Configurator
implements OptionConfigurator {
    private String label = null;
    private int minChars = -1;
    private int maxChars = -1;
    private String defaultText = null;
    private double priceAdjust = 0.0;
    private final int LABEL_ID = 1;
    private final int DEFAULT_TEXT_ID = 2;
    private final int MIN_CHARS = 1;
    private final int MAX_CHARS = 2;
    private final int PRICE_ADJUST = 1;

    public double getPriceAdjust() {
        return this.priceAdjust;
    }

    public void setPriceAdjust(double tmp) {
        this.priceAdjust = tmp;
    }

    public void setPriceAdjust(String tmp) {
        this.priceAdjust = Double.parseDouble(tmp);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String tmp) {
        this.label = tmp;
    }

    public int getMinChars() {
        return this.minChars;
    }

    public void setMinChars(int tmp) {
        this.minChars = tmp;
    }

    public void setMinChars(String tmp) {
        this.minChars = Integer.parseInt(tmp);
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    public void setMaxChars(int tmp) {
        this.maxChars = tmp;
    }

    public void setMaxChars(String tmp) {
        this.maxChars = Integer.parseInt(tmp);
    }

    public String getDefaultText() {
        return this.defaultText;
    }

    public void setDefaultText(String tmp) {
        this.defaultText = tmp;
    }

    public StringConfigurator() {
        this.name = "Text";
        OptionProperty property = null;
        property = new OptionProperty();
        property.setType(1);
        property.setName("text_label");
        property.setValue("");
        property.setDisplay("Label to display");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("number_minchars");
        property.setValue("1");
        property.setDisplay("Minimum Chars Allowed");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("number_maxchars");
        property.setValue("255");
        property.setDisplay("Maximum Chars Allowed");
        property.setIsForPrompting(true);
        property.setIsRequired(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(1);
        property.setName("text_default");
        property.setValue("");
        property.setDisplay("Default Text");
        property.setIsForPrompting(true);
        property.setNote("");
        this.propertyList.add(property);
        property = new OptionProperty();
        property.setType(2);
        property.setName("double_priceadjust");
        property.setValue("0");
        property.setDisplay("Adjust base price based on number of characters");
        property.setIsForPrompting(true);
        property.setNote("base price + (number of characters X amount)");
        this.propertyList.add(property);
    }

    public boolean arePropertiesConfigured() {
        return true;
    }

    public void setProperties(HttpServletRequest request) {
        this.propertyList.setOptionProperties(request);
        this.label = this.propertyList.getOptionProperty("text_label").getValue();
        this.minChars = Integer.parseInt(this.propertyList.getOptionProperty("number_minchars").getValue());
        this.maxChars = Integer.parseInt(this.propertyList.getOptionProperty("number_maxchars").getValue());
        this.defaultText = this.propertyList.getOptionProperty("text_default").getValue();
        this.priceAdjust = Double.parseDouble(this.propertyList.getOptionProperty("double_priceadjust").getValue());
    }

    public boolean saveProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            option.insert(db);
            this.saveText(db, option.getId(), 1, this.label);
            this.saveText(db, option.getId(), 2, this.defaultText);
            this.saveInteger(db, option.getId(), 1, this.minChars);
            this.saveInteger(db, option.getId(), 2, this.maxChars);
            this.saveDouble(db, option.getId(), 1, this.priceAdjust);
            if (commit) {
                db.commit();
            }
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean updateProperties(Connection db, ProductOption option) throws SQLException {
        boolean result = false;
        try {
            db.setAutoCommit(false);
            option.update(db);
            this.updateText(db, option.getId(), 1, this.label);
            this.updateText(db, option.getId(), 2, this.defaultText);
            this.updateInteger(db, option.getId(), 1, this.minChars);
            this.updateInteger(db, option.getId(), 2, this.maxChars);
            this.updateDouble(db, option.getId(), 1, this.priceAdjust);
            db.commit();
            result = true;
            this.optionId = option.getId();
        }
        catch (SQLException e) {
            db.rollback();
            e.printStackTrace(System.out);
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return result;
    }

    public void queryProperties(Connection db, int optionId, boolean doClean) throws SQLException {
        if (optionId == -1) {
            throw new SQLException("Invalid Option Id");
        }
        this.label = this.getText(db, optionId, 1);
        this.propertyList.setOptionProperty("text_label", this.label);
        this.defaultText = this.getText(db, optionId, 2);
        this.propertyList.setOptionProperty("text_default", this.defaultText);
        this.minChars = this.getInteger(db, optionId, 1);
        this.propertyList.setOptionProperty("number_minchars", String.valueOf(this.minChars));
        this.maxChars = this.getInteger(db, optionId, 2);
        this.propertyList.setOptionProperty("number_maxchars", String.valueOf(this.maxChars));
        this.priceAdjust = this.getDouble(db, optionId, 1);
        this.propertyList.setOptionProperty("double_priceadjust", String.valueOf(this.priceAdjust));
        this.built = true;
        this.optionId = optionId;
    }

    public boolean enableOption(Connection db, int optionId) throws SQLException {
        return true;
    }

    public void prepareContext(HttpServletRequest request, Connection db) throws SQLException {
    }

    public String getHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table class=\"empty\" cellspacing=\"4\" cellpadding=\"2\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>");
        sb.append("    " + this.label);
        sb.append("   </td>");
        sb.append("\t\t<td><input type=\"text\" size=\"" + (this.maxChars > 20 ? 20 : this.maxChars) + "\" maxlength=\"" + this.maxChars + "\" ");
        sb.append("            name=\"text" + this.optionId + "\" value=\"" + HTTPUtils.toHtmlValue(this.defaultText) + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public String getQuoteHtml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<table cellspacing=\"0\" cellpadding=\"4\" width=\"100%\">");
        sb.append("\t<tr>");
        sb.append("\t\t<td width=\"100\" nowrap>");
        sb.append("    " + this.label);
        sb.append("   </td>");
        sb.append("\t\t<td><input type=\"text\" size=\"" + (this.maxChars > 20 ? 20 : this.maxChars) + "\" maxlength=\"" + this.maxChars + "\" ");
        sb.append("            name=\"text" + this.optionId + "\" value=\"" + HTTPUtils.toHtmlValue(this.quoteUserInput) + "\"/>");
        sb.append("   </td>");
        sb.append("\t\t<td width=\"25%\"><input type=\"text\" size=\"8\"");
        sb.append("            name=\"price" + this.optionId + "\" value=\"" + this.quotePriceAdjust + "\"/>");
        sb.append("   </td>");
        sb.append(" </tr>");
        sb.append("</table>");
        return sb.toString();
    }

    public boolean validateUserInput(HttpServletRequest request) {
        String input;
        boolean isValid = true;
        if (request.getParameter("text" + this.optionId) != null && ((input = request.getParameter("text" + this.optionId)).length() < this.minChars || input.length() > this.maxChars)) {
            isValid = false;
        }
        try {
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
            }
        }
        catch (Exception e) {
            isValid = false;
        }
        return isValid;
    }

    public boolean hasUserInput(HttpServletRequest request) {
        String input;
        boolean hasInput = false;
        if (request.getParameter("text" + this.optionId) != null && (input = request.getParameter("text" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        if (request.getParameter("price" + this.optionId) != null && (input = request.getParameter("price" + this.optionId)) != null && !"".equals(input.trim())) {
            hasInput = true;
        }
        return hasInput;
    }

    public double computePriceAdjust(HttpServletRequest request) {
        if (request.getParameter("text" + this.optionId) != null) {
            String input = request.getParameter("text" + this.optionId);
            if (request.getParameter("price" + this.optionId) != null) {
                double price = Double.parseDouble(request.getParameter("price" + this.optionId));
                return (double)input.length() * price;
            }
            return (double)input.length() * this.priceAdjust;
        }
        return 0.0;
    }

    public void saveQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("text" + this.optionId) != null && (input = request.getParameter("text" + this.optionId)) != null) {
            this.saveQuoteText(db, quoteProductOptionId, 1, input);
            this.saveQuoteDouble(db, quoteProductOptionId, 1, this.priceAdjust);
        }
    }

    public void updateQuoteOption(Connection db, int quoteProductOptionId, HttpServletRequest request) throws SQLException {
        String input;
        if (request.getParameter("text" + this.optionId) != null) {
            input = request.getParameter("text" + this.optionId);
            this.updateQuoteText(db, quoteProductOptionId, 1, input);
        }
        if (request.getParameter("price" + this.optionId) != null) {
            input = request.getParameter("price" + this.optionId);
            this.updateQuoteDouble(db, quoteProductOptionId, 1, Double.parseDouble(input));
        }
    }
}

