/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.products.utils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.aspcfs.modules.products.utils.ProductCategoryCount;
import org.aspcfs.utils.DatabaseUtils;

public class ProductCategoryCounter {
    private static final String QUERY = "select pc.category_id as category_id,       pccm.count_of_product as count_of_product,       pc.parent_id as parent_id    from product_category pc    left join (select category_id,                       count('x') as count_of_product                    from product_catalog_category_map pccm                          join product_catalog p on p.product_id = pccm.product_id and active = ? and enabled = ?                  group by category_id) pccm  on (pccm.category_id = pc.category_id)order by pc.parent_id desc";
    private HashMap rawData;
    private HashMap result;
    private ProductCategoryCount productCategoryCounter;

    private ProductCategoryCounter() {
    }

    public void refreshStatistics(Connection db) throws SQLException {
        this.rawData = new HashMap();
        this.result = new HashMap();
        int itemId = 0;
        int count = 0;
        PreparedStatement ps = db.prepareStatement(QUERY);
        ps.setBoolean(1, true);
        ps.setBoolean(2, true);
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            this.productCategoryCounter = new ProductCategoryCount();
            this.productCategoryCounter.setProductCategoryId(rs.getInt("category_id"));
            this.productCategoryCounter.setParentProductCategoryId(DatabaseUtils.getInt(rs, "parent_id"));
            this.productCategoryCounter.setCountOfProduct(DatabaseUtils.getInt(rs, "count_of_product", 0));
            this.rawData.put(new Integer(itemId++), this.productCategoryCounter);
        }
        rs.close();
        ps.close();
        for (int i = 0; i <= itemId; ++i) {
            Integer key = new Integer(i);
            if (!this.rawData.containsKey(key)) continue;
            this.productCategoryCounter = (ProductCategoryCount)this.rawData.get(key);
            if (this.productCategoryCounter.getParentProductCategoryId() != -1) continue;
            this.rawData.remove(key);
            count = this.buildHierarchy(itemId, this.productCategoryCounter.getProductCategoryId());
            this.productCategoryCounter.setCountOfProduct(this.productCategoryCounter.getCountOfProduct() + count);
            this.result.put(new Integer(this.productCategoryCounter.getProductCategoryId()), this.productCategoryCounter);
        }
    }

    private int buildHierarchy(int size, int parentItemId) throws SQLException {
        int count = 0;
        int cCount = 0;
        for (int i = 0; i <= size; ++i) {
            ProductCategoryCount pcs;
            Integer key = new Integer(i);
            if (!this.rawData.containsKey(key) || (pcs = (ProductCategoryCount)this.rawData.get(key)).getParentProductCategoryId() != parentItemId) continue;
            this.rawData.remove(key);
            cCount = this.buildHierarchy(size, pcs.getProductCategoryId());
            pcs.setCountOfProduct(pcs.getCountOfProduct() + cCount);
            if (pcs.getCountOfProduct() > 0) {
                this.result.put(new Integer(pcs.getProductCategoryId()), pcs);
            }
            count += pcs.getCountOfProduct();
        }
        return count;
    }

    public ProductCategoryCount getProductCategoryCountObject(int productCategoryId) {
        Integer id = new Integer(productCategoryId);
        if (this.result.containsKey(id)) {
            return (ProductCategoryCount)this.result.get(id);
        }
        return null;
    }

    public int getProductCategoryCount(int productCategoryId) {
        Integer id = new Integer(productCategoryId);
        if (this.result.containsKey(id)) {
            return ((ProductCategoryCount)this.result.get(id)).getCountOfProduct();
        }
        return -1;
    }

    public static ProductCategoryCounter getProductCategoryCounter(Connection db) throws SQLException {
        ProductCategoryCounter genericProductCounter = new ProductCategoryCounter();
        genericProductCounter.refreshStatistics(db);
        return genericProductCounter;
    }
}

