/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.iteam.base.FileItem;
import com.zeroio.iteam.base.FileItemList;
import com.zeroio.webutils.FileDownload;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.HashMap;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperRunManager;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactList;
import org.aspcfs.modules.orders.base.Order;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.products.base.CustomerProduct;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogList;
import org.aspcfs.modules.products.base.ProductOptionList;
import org.aspcfs.modules.products.base.ProductOptionValuesList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.modules.quotes.base.QuoteNoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.JasperReportUtils;
import org.aspcfs.utils.SMTPMessage;
import org.aspcfs.utils.web.HtmlDialog;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.PagedListInfo;

public final class Quotes
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        return this.executeCommandSearchForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandView(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        PagedListInfo quoteListInfo = this.getPagedListInfo(context, "quoteListInfo");
        quoteListInfo.setLink("Quotes.do?command=View");
        Connection db = null;
        QuoteList quoteList = new QuoteList();
        try {
            db = this.getConnection(context);
            quoteList.setPagedListInfo(quoteListInfo);
            quoteList.setIncludeAllSites(false);
            quoteList.setSiteId(this.getUser(context, this.getUserId(context)).getSiteId());
            quoteList.setExclusiveToSite(true);
            quoteList.setBuildResources(true);
            quoteList.buildList(db);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            errorMessage.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("quoteList", (Object)quoteList);
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearchForm(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        if (Quotes.isPortalUser(context)) {
            return this.executeCommandSearch(context);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList statusSelect = systemStatus.getLookupList(db, "lookup_quote_status");
            statusSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("statusSelect", (Object)statusSelect);
            LookupList siteList = new LookupList(db, "lookup_site_id");
            siteList.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            siteList.addItem(-2, systemStatus.getLabel("accounts.allSites"));
            context.getRequest().setAttribute("SiteList", (Object)siteList);
            PagedListInfo quoteListInfo = this.getPagedListInfo(context, "quoteListInfo");
            quoteListInfo.setCurrentLetter("");
            quoteListInfo.setCurrentOffset(0);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "Search Quotes", "Quotes Search");
        return "SearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSearch(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = -1;
        try {
            quoteId = Integer.parseInt(context.getRequest().getParameter("searchId"));
        }
        catch (Exception e) {
            // empty catch block
        }
        String source = context.getRequest().getParameter("source");
        QuoteList quoteList = new QuoteList();
        this.addModuleBean(context, "View Quotes", "Search Results");
        User user = this.getUser(context, this.getUserId(context));
        PagedListInfo searchListInfo = this.getPagedListInfo(context, "quoteListInfo", "group_id", "desc");
        searchListInfo.setLink("Quotes.do?command=Search&version=" + (version != null ? version : ""));
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            list.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            if (Quotes.isPortalUser(context)) {
                source = "searchForm";
            }
            if (version != null && !"".equals(version)) {
                Quote quote = new Quote(db, Integer.parseInt(version));
                quoteList = new QuoteList();
                quoteList.setBuildCompleteVersionList(true);
                quoteList.setId(quote.getRootQuote(db, quote.getParentId()));
                quoteList.setPagedListInfo(searchListInfo);
                searchListInfo.setSearchCriteria(quoteList, context);
                quoteList.buildList(db);
                context.getRequest().setAttribute("quoteList", (Object)quoteList);
                String string = "ListOK";
                return string;
            }
            if (quoteId > -1) {
                quoteList.setId(quoteId);
            }
            quoteList.setPagedListInfo(searchListInfo);
            quoteList.setStatusId(searchListInfo.getFilterKey("listFilter1"));
            searchListInfo.setSearchCriteria(quoteList, context);
            if (Quotes.isPortalUser(context)) {
                quoteList.setOrgId(Quotes.getPortalUserPermittedOrgId(context));
            }
            if (quoteList.getSiteId() == -2) {
                quoteList.setIncludeAllSites(true);
                quoteList.setSiteId(user.getSiteId());
            } else {
                quoteList.setIncludeAllSites(false);
                quoteList.setExclusiveToSite(true);
            }
            quoteList.buildList(db);
            context.getRequest().setAttribute("quoteList", (Object)quoteList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetails(ActionContext context) {
        String version;
        String printQuote;
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        String result = "DetailsOK";
        int quoteId = -1;
        String quoteIdString = (String)context.getRequest().getAttribute("quoteId");
        if (quoteIdString == null || "".equals(quoteIdString)) {
            quoteIdString = context.getRequest().getParameter("quoteId");
        }
        if ((printQuote = context.getRequest().getParameter("canPrint")) != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        if ((version = context.getRequest().getParameter("version")) != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Quote quote = null;
        QuoteProductList quoteProducts = null;
        ProductCatalogList productList = null;
        ProductOptionList optionList = null;
        if (quoteIdString == null || "".equals(quoteIdString)) {
            try {
                int productId = Integer.parseInt(context.getRequest().getParameter("productId"));
                int ticketId = Integer.parseInt(context.getRequest().getParameter("ticketId"));
            }
            catch (Exception e) {
                context.getRequest().setAttribute("actionError", (Object)"Invalid criteria, please review and make necessary changes before submitting");
                return "SearchCriteriaError";
            }
            return this.executeCommandAddQuote(context);
        }
        try {
            quoteId = Integer.parseInt(quoteIdString);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("actionError", (Object)"Invalid criteria, please review and make necessary changes before submitting");
            return "SearchCriteriaError";
        }
        Connection db = null;
        try {
            int headerId;
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String ticketId = "PermissionError";
                return ticketId;
            }
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            productList = new ProductCatalogList();
            optionList = new ProductOptionList();
            optionList.setBuildConfigDetails(true);
            optionList.buildList(db);
            context.getRequest().setAttribute("optionList", (Object)optionList);
            quoteProducts = quote.getProductList();
            for (QuoteProduct quoteProduct : quoteProducts) {
                quoteProduct.setBuildProductOptions(true);
                quoteProduct.queryRecord(db, quoteProduct.getId());
                ProductCatalog product = new ProductCatalog();
                product.setBuildOptions(true);
                product.queryRecord(db, quoteProduct.getProductId());
                productList.add(product);
            }
            int orderId = quote.getOrderId(db);
            if (orderId != -1) {
                Order order = new Order(db, orderId);
                context.getRequest().setAttribute("order", (Object)order);
            }
            if ((headerId = quote.getHeaderId()) != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            context.getRequest().setAttribute("quoteProductList", (Object)quoteProducts);
            context.getRequest().setAttribute("productList", (Object)productList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getLogoFileId() > 0) {
                FileItem thisItem = new FileItem(db, quote.getLogoFileId(), 126200514, 126200511);
                context.getRequest().setAttribute("fileItem", (Object)thisItem);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCustomerDisplay(ActionContext context) {
        if (!this.hasPermission(context, "products-view")) {
            return "PermissionError";
        }
        String result = "CustomerDisplayOK";
        int quoteId = -1;
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        QuoteProductList quoteProducts = null;
        Quote quoteBean = null;
        ProductCatalogList productList = null;
        ProductOptionList optionList = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            if (Quotes.isPortalUser(context)) {
                User user = this.getUser(context, this.getUserId(context));
                int userOrgId = user.getContact().getOrgId();
                if (quote.getOrgId() != userOrgId) {
                    Exception error = new Exception("Unauthorized Access");
                    context.getRequest().setAttribute("Error", (Object)error);
                    String string = "SystemError";
                    return string;
                }
            }
            QuoteNoteList noteList = new QuoteNoteList();
            noteList.setQuoteId(quote.getId());
            noteList.buildList(db);
            context.getRequest().setAttribute("quoteNoteList", (Object)noteList);
            quoteBean = new Quote();
            context.getRequest().setAttribute("quoteBean", (Object)quoteBean);
            productList = new ProductCatalogList();
            optionList = new ProductOptionList();
            optionList.buildList(db);
            context.getRequest().setAttribute("optionList", (Object)optionList);
            quoteProducts = quote.getProductList();
            for (QuoteProduct quoteProduct : quoteProducts) {
                quoteProduct.setBuildProductOptions(true);
                quoteProduct.queryRecord(db, quoteProduct.getId());
                ProductCatalog product = new ProductCatalog();
                product.setBuildOptions(true);
                product.queryRecord(db, quoteProduct.getProductId());
                productList.add(product);
            }
            ProductOptionValuesList values = new ProductOptionValuesList();
            values.buildList(db);
            context.getRequest().setAttribute("productOptionValuesList", (Object)values);
            context.getRequest().setAttribute("quoteProductList", (Object)quoteProducts);
            context.getRequest().setAttribute("productList", (Object)productList);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSubmit(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-edit")) {
            return "PermissionError";
        }
        int quoteId = -1;
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            quote = new Quote();
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SubmitOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSaveNotes(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        int quoteId = -1;
        boolean isValid = false;
        int recordCount = -1;
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        QuoteNote quoteNote = null;
        Quote quote = null;
        Quote previousQuote = null;
        Quote notes = (Quote)((Object)context.getFormBean());
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteId = Integer.parseInt(quoteIdString);
            previousQuote = new Quote(db, quoteId);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            if (notes.getNotes() != null) {
                quoteNote = new QuoteNote();
                quoteNote.setQuoteId(quote.getId());
                quoteNote.setEnteredBy(this.getUserId(context));
                quoteNote.setModifiedBy(this.getUserId(context));
                quoteNote.setNotes(notes.getNotes());
                isValid = this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
                this.processInsertHook(context, (Object)quoteNote);
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote.getStatusId() == list.getIdFromValue("Rejected by customer")) {
                quote.setStatusId(list.getIdFromValue("Pending customer acceptance"));
                Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
                quote.setIssuedDate(currentTimestamp);
                quote.setStatusDate(currentTimestamp);
                boolean bl = isValid = this.validateObject(context, db, (Object)quote) && isValid;
                if (isValid) {
                    recordCount = quote.update(db);
                }
                if (recordCount > 0) {
                    this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
                }
            }
            QuoteNoteList noteList = new QuoteNoteList();
            noteList.setQuoteId(quote.getId());
            noteList.buildList(db);
            context.getRequest().setAttribute("quoteNoteList", (Object)noteList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SaveNotesOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRemoveProduct(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-edit")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String productName = context.getRequest().getParameter("productId");
        int productId = Integer.parseInt(productName.trim());
        QuoteProduct quoteProduct = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quoteProduct = new QuoteProduct(db, productId);
            Quote previousQuote = new Quote();
            previousQuote.queryRecord(db, quoteProduct.getQuoteId());
            previousQuote.buildProducts(db);
            if (!Quotes.isRecordAccessPermitted(context, db, previousQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quoteProduct.delete(db);
            Quote quote = new Quote();
            quote.queryRecord(db, quoteProduct.getQuoteId());
            quote.buildProducts(db);
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "RemoveProductOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDelete(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-delete")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.delete(db);
            this.processDeleteHook(context, (Object)quote);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"Quotes.do?command=Search");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandTrash(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-delete")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.updateStatus(db, true, this.getUserId(context));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("refreshUrl", (Object)"Quotes.do?command=Search");
        return "DeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRestore(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-delete")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.updateStatus(db, false, this.getUserId(context));
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandDetails(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes_edit")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        int quoteId = Integer.parseInt(context.getRequest().getParameter("quoteId"));
        boolean flag = false;
        boolean isValid = false;
        int recordCount = -1;
        Quote quote = null;
        Quote previousQuote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            Quote quoteBean = (Quote)((Object)context.getFormBean());
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            previousQuote = new Quote(db, quoteId);
            if (quoteBean.getNotes() != null && !quote.getNotes().equals(quoteBean.getNotes())) {
                quote.setNotes(quoteBean.getNotes());
                flag = true;
            }
            if (quoteBean.getExpirationDate() != null && quote.getExpirationDate() != quoteBean.getExpirationDate()) {
                quote.setExpirationDate(quoteBean.getExpirationDate());
                flag = true;
            }
            if (flag) {
                isValid = this.validateObject(context, db, (Object)quote);
                if (isValid) {
                    if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                        String string = "PermissionError";
                        return string;
                    }
                    recordCount = quote.update(db);
                }
                if (recordCount > 0) {
                    this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SetSearchOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandConfirmDelete(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-delete")) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Connection db = null;
        Quote quote = null;
        HtmlDialog htmlDialog = new HtmlDialog();
        String quoteId = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        if (context.getRequest().getParameter("quoteId") != null) {
            quoteId = context.getRequest().getParameter("quoteId");
        }
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.setBuildTicket(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            DependencyList dependencies = quote.processDependencies(db);
            dependencies.setSystemStatus(systemStatus);
            htmlDialog.addMessage(systemStatus.getLabel("confirmdelete.caution") + "\n" + dependencies.getHtmlString());
            if (quote.getOrderId(db) != -1) {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.deleteRelatedOrdersFirst"));
                htmlDialog.addButton(systemStatus.getLabel("button.ok"), "javascript:parent.window.close()");
            } else {
                htmlDialog.setTitle(systemStatus.getLabel("confirmdelete.title"));
                htmlDialog.setHeader(systemStatus.getLabel("quotes.dependencies"));
                htmlDialog.addButton(systemStatus.getLabel("global.button.delete"), "javascript:window.location.href='Quotes.do?command=Trash&quoteId=" + quote.getId() + "'");
                htmlDialog.addButton(systemStatus.getLabel("button.cancel"), "javascript:parent.window.close()");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getSession().setAttribute("Dialog", (Object)htmlDialog);
        return "ConfirmDeleteOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModifyForm(ActionContext context) {
        String quoteIdString;
        if (!this.hasPermission(context, "quotes-quotes-edit")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        if ((quoteIdString = (String)context.getRequest().getAttribute("quoteId")) == null || "".equals(quoteIdString)) {
            quoteIdString = context.getRequest().getParameter("quoteId");
        }
        User user = this.getUser(context, this.getUserId(context));
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            quote = new Quote(db, Integer.parseInt(quoteIdString));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            int headerId = quote.getHeaderId();
            if (headerId != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            ContactList contactList = new ContactList();
            if (quote.getOrgId() != -1) {
                contactList.setOrgId(quote.getOrgId());
            } else if (user.getSiteId() == -1) {
                contactList.setIncludeAllSites(true);
            }
            contactList.setSiteId(user.getSiteId());
            contactList.setExclusiveToSite(true);
            contactList.setBuildDetails(false);
            contactList.setBuildTypes(false);
            contactList.setIncludeEnabled(-1);
            contactList.setDefaultContactId(quote.getContactId());
            contactList.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)contactList);
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        boolean isValid = false;
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String returnValue = context.getRequest().getParameter("return");
        String version = context.getRequest().getParameter("versionId");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String orgIdString = context.getRequest().getParameter("orgId");
        int orgId = -1;
        if (orgIdString != null && !"".equals(orgIdString)) {
            orgId = Integer.parseInt(orgIdString);
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        int quoteId = -1;
        if (quoteIdString != null && !"".equals(quoteIdString)) {
            quoteId = Integer.parseInt(quoteIdString);
        }
        int resultCount = -1;
        Quote quote = null;
        Quote quoteBean = (Quote)((Object)context.getFormBean());
        Quote previousQuote = null;
        User user = this.getUser(context, this.getUserId(context));
        String printQuote = (String)context.getRequest().getAttribute("canPrint");
        if (printQuote != null && !"".equals(printQuote)) {
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        } else {
            printQuote = quoteBean.getCanPrint();
            context.getRequest().setAttribute("canPrint", (Object)printQuote);
        }
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote(db, quoteId);
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, quoteId);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quoteBean.getOrgId() != -1) {
                quote.setOrgId(quoteBean.getOrgId());
            }
            if (quoteBean.getContactId() != -1) {
                quote.setContactId(quoteBean.getContactId());
            }
            quote.setShortDescription(quoteBean.getShortDescription());
            quote.setExpirationDate(quoteBean.getExpirationDate());
            quote.setIssuedDate(quoteBean.getIssuedDate());
            quote.setNotes(quoteBean.getNotes());
            quote.setStatusId(quoteBean.getStatusId());
            quote.setHeaderId(quoteBean.getHeaderId());
            quote.setDeliveryId(quoteBean.getDeliveryId());
            quote.setEmailAddress(quoteBean.getEmailAddress());
            quote.setFaxNumber(quoteBean.getFaxNumber());
            quote.setPhoneNumber(quoteBean.getPhoneNumber());
            quote.setAddress(quoteBean.getAddress());
            quote.setCloseIt(quoteBean.getCloseIt());
            quote.setClosed(quoteBean.getClosed());
            quote.setSubmitAction(quoteBean.getSubmitAction());
            quote.setLogoFileId(quoteBean.getLogoFileId());
            quote.setShowTotal(quoteBean.getShowTotal());
            quote.setShowSubtotal(quoteBean.getShowSubtotal());
            quote.setModifiedBy(user.getId());
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid && "submit".equals(context.getRequest().getParameter("return"))) {
                Quote tmpQuote = new Quote();
                tmpQuote.setBuildProducts(true);
                tmpQuote.queryRecord(db, quote.getId());
                isValid = this.validateObject(context, db, tmpQuote.getProductList());
            }
            if (isValid) {
                resultCount = quote.update(db);
            }
            if (resultCount > 0) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount == -1 || !isValid) {
            if (returnValue == null || "".equals(returnValue.trim())) {
                return this.executeCommandModifyForm(context);
            }
            if (returnValue.equals("clone")) {
                return this.executeCommandCloneForm(context);
            }
            if (returnValue.equals("submit")) {
                return this.executeCommandSubmit(context);
            }
            if (returnValue.equals("close")) {
                return this.executeCommandClose(context);
            }
            return "UserError";
        }
        return Quotes.getReturn(context, "Modify");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuote(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-add")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        boolean isValid = false;
        boolean recordInserted = false;
        String ticketIdString = context.getRequest().getParameter("ticketId");
        int ticketId = -1;
        String productIdString = context.getRequest().getParameter("productId");
        int productId = -1;
        if (ticketIdString != null && !"".equals(ticketIdString)) {
            ticketId = Integer.parseInt(ticketIdString);
        }
        if (productIdString != null && !"".equals(productIdString)) {
            productId = Integer.parseInt(productIdString);
        }
        Quote quote = null;
        Ticket ticket = null;
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            Object orgDetails;
            int contactId;
            db = this.getConnection(context);
            quote = (Quote)((Object)context.getFormBean());
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (ticketId != -1) {
                ticket = new Ticket(db, ticketId);
                ProductCatalog product = new ProductCatalog(db, productId);
                quote.setProductId(product.getId());
                quote.setShortDescription(product.getName() + ": ");
                if (!ticket.getProblem().equals("New Ad Design Request") && ticket.getCustomerProductId() != -1) {
                    CustomerProduct customerProduct = new CustomerProduct(db, ticket.getCustomerProductId());
                    quote.setCustomerProductId(customerProduct.getId());
                }
                quote.setOrgId(ticket.getOrgId());
                quote.setContactId(ticket.getContactId());
                quote.setTicketId(ticket.getId());
            }
            if ((contactId = quote.getContactId()) != -1) {
                orgDetails = new Organization(db, quote.getOrgId());
                context.getRequest().setAttribute("OrgDetails", orgDetails);
            } else {
                quote.setStatusId(list.getIdFromValue("Incomplete"));
            }
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            quote.setVersion(quote.getNewVersion());
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                    orgDetails = "PermissionError";
                    return orgDetails;
                }
                quote.createNewGroup(db);
                recordInserted = quote.insert(db);
            }
            if (recordInserted) {
                this.processInsertHook(context, (Object)quote);
            }
            String quoteIdString = null;
            if (isValid) {
                quoteIdString = "" + quote.getId();
                context.getRequest().setAttribute("quoteId", (Object)quoteIdString);
            }
            if (ticketId != -1) {
                QuoteNote quoteNote = new QuoteNote();
                quoteNote.setQuoteId(quote.getId());
                quoteNote.setNotes(ticket.getProblem().trim());
                quoteNote.setModifiedBy(user.getId());
                quoteNote.setEnteredBy(user.getId());
                boolean bl = isValid = isValid && this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (!isValid) {
            return this.executeCommandAddQuoteForm(context);
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddQuoteForm(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-add")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        Quote quote = (Quote)((Object)context.getFormBean());
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            list2.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
            if (quote == null) {
                quote = new Quote();
            }
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            FileItemList itemList = new FileItemList();
            itemList.setLinkModuleId(126200511);
            itemList.setLinkItemId(126200514);
            itemList.buildList(db);
            context.getRequest().setAttribute("fileItemList", (Object)itemList);
            int headerId = quote.getHeaderId();
            if (headerId != -1) {
                OpportunityHeader opportunity = new OpportunityHeader(db, headerId);
                context.getRequest().setAttribute("opportunity", (Object)opportunity);
            }
            if (quote.getOrgId() != -1) {
                Organization orgDetails = new Organization(db, quote.getOrgId());
                quote.setName(orgDetails.getName());
                context.getRequest().setAttribute("OrgDetails", (Object)orgDetails);
                ContactList contactList = new ContactList();
                contactList.setOrgId(quote.getOrgId());
                contactList.setLeadsOnly(0);
                contactList.setEmployeesOnly(0);
                contactList.buildList(db);
                context.getRequest().setAttribute("contactList", (Object)contactList);
            }
            context.getRequest().setAttribute("quoteBean", (Object)quote);
            context.getRequest().setAttribute("systemStatus", (Object)systemStatus);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "AddQuoteFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCustomerQuoteDecision(ActionContext context) {
        if (!this.hasPermission(context, "products-view")) {
            return "PermissionError";
        }
        QuoteNote quoteNote = null;
        Connection db = null;
        boolean isValid = false;
        int recordCount = -1;
        Quote previousQuote = null;
        String quoteIdString = context.getRequest().getParameter("quoteId");
        String value = context.getRequest().getParameter("value");
        User user = this.getUser(context, this.getUserId(context));
        int userOrgId = user.getContact().getOrgId();
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            Quote quoteBean = (Quote)((Object)context.getFormBean());
            Timestamp currentTimestamp = new Timestamp(Calendar.getInstance().getTimeInMillis());
            Quote quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteIdString));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, Integer.parseInt(quoteIdString));
            if (Quotes.isPortalUser(context) && quote.getOrgId() != userOrgId) {
                Exception error = new Exception("Unauthorized Access");
                context.getRequest().setAttribute("Error", (Object)error);
                String string = "SystemError";
                return string;
            }
            if (quoteBean.getNotes() != null && !"".equals(quoteBean.getNotes().trim())) {
                quoteNote = new QuoteNote();
                quoteNote.setQuoteId(Integer.parseInt(quoteIdString));
                quoteNote.setNotes(quoteBean.getNotes());
                quoteNote.setModifiedBy(user.getId());
                quoteNote.setEnteredBy(user.getId());
                isValid = this.validateObject(context, db, (Object)quoteNote);
                if (isValid) {
                    quoteNote.insert(db);
                }
            }
            if (value.equals("REJECT") || value.equals("NOTES")) {
                if (value.equals("REJECT")) {
                    quote.setStatusId(list.getIdFromValue("Rejected by customer"));
                }
                if (quoteNote != null) {
                    this.processInsertHook(context, (Object)quoteNote);
                }
            }
            quote.setStatusDate(currentTimestamp);
            boolean bl = isValid = this.validateObject(context, db, (Object)quote) && isValid;
            if (isValid) {
                recordCount = quote.update(db);
            }
            if (recordCount > 0) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, Integer.parseInt(quoteIdString));
            context.getRequest().setAttribute("quote", (Object)quote);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (value.equals("REJECT") || value.equals("NOTES") || !isValid) {
            return "QuoteRejectedOK";
        }
        return "CustomerQuoteDecisionOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String executeCommandOrganizationJSList(ActionContext context) {
        Connection db = null;
        try {
            String orgId = context.getRequest().getParameter("orgId");
            db = this.getConnection(context);
            ContactList contactList = new ContactList();
            if (orgId != null && !"-1".equals(orgId)) {
                contactList.setBuildDetails(false);
                contactList.setBuildTypes(false);
                contactList.setLeadsOnly(0);
                contactList.setEmployeesOnly(0);
                contactList.setOrgId(Integer.parseInt(orgId));
                contactList.buildList(db);
            }
            context.getRequest().setAttribute("ContactList", (Object)contactList);
        }
        catch (Exception exception) {
            this.freeConnection(context, db);
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
        }
        this.freeConnection(context, db);
        return "OrganizationJSListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCloneForm(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-add") || this.hasPermission(context, "accounts-quotes-add") || this.hasPermission(context, "leads-opportunities-add"))) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteId = context.getRequest().getParameter("quoteId");
        Quote oldQuote = null;
        User user = this.getUser(context, this.getUserId(context));
        ContactList contactList = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            oldQuote = new Quote();
            oldQuote.setBuildProducts(true);
            oldQuote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, oldQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)oldQuote);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            contactList = new ContactList();
            if (oldQuote.getOrgId() != -1) {
                contactList.setOrgId(oldQuote.getOrgId());
            } else if (user.getSiteId() == -1) {
                contactList.setIncludeAllSites(true);
            }
            contactList.setSiteId(user.getSiteId());
            contactList.setExclusiveToSite(true);
            contactList.setBuildDetails(false);
            contactList.setBuildTypes(false);
            contactList.buildList(db);
            context.getRequest().setAttribute("contactList", (Object)contactList);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
        return "CloneFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-add") || this.hasPermission(context, "accounts-quotes-add") || this.hasPermission(context, "leads-opportunities-add"))) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("versionId");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteId = context.getRequest().getParameter("quoteId");
        String returnValue = context.getRequest().getParameter("return");
        Quote quote = (Quote)((Object)context.getFormBean());
        Quote oldQuote = null;
        User user = this.getUser(context, this.getUserId(context));
        Connection db = null;
        try {
            db = this.getConnection(context);
            oldQuote = new Quote();
            oldQuote.setBuildProducts(true);
            oldQuote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, oldQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            quote.setId(-1);
            quote.setCanNotCopyExpirationDate(true);
            quote.setEnteredBy(user.getId());
            quote.setModifiedBy(user.getId());
            quote = oldQuote.clone(db, quote);
            this.processInsertHook(context, (Object)quote);
            if (returnValue != null && !"".equals(returnValue)) {
                if (returnValue.equals("clone")) {
                    context.getRequest().setAttribute("id", (Object)("" + quote.getId() + "&orgId=" + quote.getOrgId()));
                } else if (returnValue.equals("old")) {
                    context.getRequest().setAttribute("id", (Object)("" + oldQuote.getId() + "&version=" + (version != null ? version : "") + "&orgId=" + oldQuote.getOrgId()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CloneOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandAddVersion(ActionContext context) {
        if (!this.hasPermission(context, "quotes-quotes-add")) {
            return "PermissionError";
        }
        String module = context.getRequest().getParameter("module");
        String includePage = context.getRequest().getParameter("include");
        context.getRequest().setAttribute("IncludePage", (Object)includePage);
        this.addModuleBean(context, module, module);
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        String quoteId = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        Quote oldQuote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            if (quoteId != null && !"".equals(quoteId)) {
                oldQuote = new Quote();
                oldQuote.setBuildProducts(true);
                oldQuote.queryRecord(db, Integer.parseInt(quoteId));
            }
            if (!Quotes.isRecordAccessPermitted(context, db, oldQuote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            quote = new Quote();
            quote.setStatusId(list.getIdFromValue("Incomplete"));
            quote = oldQuote.addVersion(db, quote);
            quote = new Quote(db, quote.getId());
            this.processUpdateHook(context, (Object)oldQuote, (Object)quote);
            String quoteIdString = String.valueOf(quote.getId());
            context.getRequest().setAttribute("quoteId", (Object)quoteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return this.executeCommandModifyForm(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDetailsByGroup(ActionContext context) {
        if (!this.hasPermission(context, "quotes-view")) {
            return "PermissionError";
        }
        int quoteId = -1;
        int groupId = -1;
        String groupIdString = context.getRequest().getParameter("quoteId");
        try {
            groupId = Integer.parseInt(groupIdString);
            if (groupId <= 0) {
                throw new Exception("Invalid number selection");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("groupIdError", (Object)"Invalid quote ID");
            context.getRequest().setAttribute("actionError", (Object)"Invalid criteria, please review and make necessary changes before submitting");
            return "SearchCriteriaError";
        }
        Object quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            QuoteList quotes = new QuoteList();
            quotes.setGroupId(groupIdString);
            quotes.setTopOnly(1);
            quotes.buildList(db);
            if (quotes.size() == 0) {
                context.getRequest().setAttribute("actionError", (Object)"No quotes with the given Id could be found.");
                String string = "SearchCriteriaError";
                return string;
            }
            quoteId = ((Quote)((Object)quotes.get(0))).getId();
            String quoteIdString = "" + quoteId;
            context.getRequest().setAttribute("quoteId", (Object)quoteIdString);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("actionError", (Object)"The specified quote could not be found");
            String string = "SearchCriteriaError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "GroupOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewHistory(ActionContext context) {
        SystemStatus systemStatus;
        Quote quote;
        Connection db;
        block7: {
            if (!this.hasPermission(context, "quotes-view")) {
                return "PermissionError";
            }
            String version = context.getRequest().getParameter("version");
            if (version != null && !"".equals(version)) {
                context.getRequest().setAttribute("version", (Object)version);
            }
            db = null;
            quote = null;
            String quoteId = null;
            systemStatus = this.getSystemStatus(context);
            quoteId = context.getRequest().getParameter("quoteId");
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildHistory(true);
            quote.setBuildProducts(true);
            quote.setBuildResources(true);
            quote.setBuildConditions(true);
            quote.setSystemStatus(systemStatus);
            quote.setBuildRemarks(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) break block7;
            String string = "PermissionError";
            this.freeConnection(context, db);
            return string;
        }
        try {
            context.getRequest().setAttribute("quote", (Object)quote);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            LookupList list2 = systemStatus.getLookupList(db, "lookup_quote_delivery");
            context.getRequest().setAttribute("quoteDeliveryList", (Object)list2);
        }
        catch (Exception errorMessage) {
            String string;
            try {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                string = "SystemError";
            }
            catch (Throwable throwable) {
                this.freeConnection(context, db);
                throw throwable;
            }
            this.freeConnection(context, db);
            return string;
        }
        this.freeConnection(context, db);
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        return "ViewHistoryOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClose(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Connection db = null;
        Quote quote = null;
        String quoteId = context.getRequest().getParameter("quoteId");
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        return "CloseFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandEmail(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        String version = context.getRequest().getParameter("version");
        if (version != null && !"".equals(version)) {
            context.getRequest().setAttribute("version", (Object)version);
        }
        Connection db = null;
        Quote quote = null;
        String quoteId = context.getRequest().getParameter("quoteId");
        User user = this.getUser(context, this.getUserId(context));
        Contact userContact = user.getContact();
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            userContact.setBuildDetails(true);
            userContact.queryRecord(db, userContact.getId());
            context.getRequest().setAttribute("userContact", (Object)userContact);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        this.addModuleBean(context, "View Quotes", "View Quote Details");
        return "EmailFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandPrintQuote(ActionContext context) {
        block10: {
            if (!(this.hasPermission(context, "quotes-view") || this.hasPermission(context, "accounts-quotes-view") || this.hasPermission(context, "leads-opportunities-view"))) {
                return "PermissionError";
            }
            Connection db = null;
            try {
                db = this.getConnection(context);
                String id = context.getRequest().getParameter("id");
                Quote quote = new Quote(db, Integer.parseInt(id));
                if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("quote_id", new Integer(id));
                String reportPath = this.getWebInfPath(context, "reports");
                map.put("path", reportPath);
                String displayTotal = context.getRequest().getParameter("display");
                map.put("displaytotal", new Boolean(displayTotal));
                String displaySubTotal = context.getRequest().getParameter("subTotal");
                map.put("displaysubtotal", new Boolean(displaySubTotal));
                if (quote.getLogoFileId() > 0) {
                    FileItem thisItem = new FileItem(db, quote.getLogoFileId(), 126200514, 126200511);
                    String logoFilePath = this.getPath(context, "quotes") + Quotes.getDatePath(thisItem.getModified()) + thisItem.getFilename();
                    map.put("logopath", logoFilePath);
                }
                map.put("language", this.getSystemStatus(context).getLanguage());
                map.put("currency", this.getSystemStatus(context).getApplicationPrefs().get("SYSTEM.CURRENCY"));
                map.put("country", this.getSystemStatus(context).getApplicationPrefs().get("SYSTEM.COUNTRY"));
                map.put("CENTRIC_DICTIONARY", this.getSystemStatus(context).getLocalizationPrefs());
                String filename = "quote.xml";
                Connection scriptdb = this.getConnection(context);
                map.put("SCRIPT_DB_CONNECTION", scriptdb);
                String fontPath = this.getWebInfPath(context, "fonts");
                String reportDir = this.getWebInfPath(context, "reports");
                JasperReport jasperReport = JasperReportUtils.getReport(reportDir + filename);
                String language = Quotes.getPref(context, "SYSTEM.LANGUAGE");
                JasperReportUtils.modifyFontProperties(jasperReport, reportDir, fontPath, language);
                byte[] bytes = JasperRunManager.runReportToPdf((JasperReport)jasperReport, map, (Connection)db);
                if (bytes != null) {
                    FileDownload fileDownload = new FileDownload();
                    fileDownload.setDisplayName("Quote_" + quote.getGroupId() + "v" + quote.getVersionNumber() + ".pdf");
                    fileDownload.sendFile(context, bytes, "application/pdf");
                    break block10;
                }
                String string = "SystemError";
                return string;
            }
            catch (Exception errorMessage) {
                context.getRequest().setAttribute("Error", (Object)errorMessage);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "--none--";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSendEmail(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        Connection db = null;
        HashMap<String, String> errors = new HashMap<String, String>();
        String fromEmailAddress = null;
        String emailToAddress = null;
        String subject = null;
        String emailMeString = null;
        boolean emailMe = false;
        String body = null;
        HashMap<String, String> sentEmailAddresses = new HashMap<String, String>();
        String displayGrandTotal = context.getRequest().getParameter("displayGrandTotal");
        String displaySubTotal = context.getRequest().getParameter("displaySubTotal");
        String quoteId = context.getRequest().getParameter("quoteId");
        Quote quote = null;
        SystemStatus systemStatus = this.getSystemStatus(context);
        emailToAddress = context.getRequest().getParameter("emailToAddress");
        if (emailToAddress == null || "".equals(emailToAddress.trim())) {
            errors.put("emailToAddressError", systemStatus.getLabel("object.validation.required"));
        } else {
            sentEmailAddresses.put("to", emailToAddress);
        }
        fromEmailAddress = context.getRequest().getParameter("fromEmailAddress");
        if ((fromEmailAddress == null || "".equals(fromEmailAddress.trim())) && ((fromEmailAddress = Quotes.getPref(context, "EMAILADDRESS")) == null || "".equals(fromEmailAddress.trim()))) {
            errors.put("fromEmailAddressError", systemStatus.getLabel("object.validation.required"));
        }
        if ((subject = context.getRequest().getParameter("subject")) == null || "".equals(subject.trim())) {
            errors.put("subjectError", systemStatus.getLabel("object.validation.required"));
        }
        if ((body = context.getRequest().getParameter("body")) == null || "".equals(body.trim())) {
            errors.put("bodyError", systemStatus.getLabel("object.validation.required"));
        }
        if ((emailMeString = context.getRequest().getParameter("emailMe")) != null && !"".equals(emailMeString)) {
            emailMe = new Boolean(emailMeString);
            sentEmailAddresses.put("from", fromEmailAddress);
        }
        if (sentEmailAddresses.size() > 0) {
            context.getRequest().setAttribute("sentEmailAddresses", sentEmailAddresses);
        }
        User user = this.getUser(context, this.getUserId(context));
        Contact userContact = user.getContact();
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildResources(true);
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            context.getRequest().setAttribute("quote", (Object)quote);
            LookupList list = systemStatus.getLookupList(db, "lookup_quote_status");
            context.getRequest().setAttribute("quoteStatusList", (Object)list);
            userContact.setBuildDetails(true);
            userContact.queryRecord(db, userContact.getId());
            context.getRequest().setAttribute("userContact", (Object)userContact);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("quote_id", new Integer(quoteId));
            String reportPath = this.getWebInfPath(context, "reports");
            map.put("path", reportPath);
            if (displayGrandTotal != null && !"".equals(displayGrandTotal)) {
                map.put("displaytotal", new Boolean(displayGrandTotal));
            } else {
                map.put("displaytotal", new Boolean("false"));
            }
            if (displaySubTotal != null && !"".equals(displaySubTotal)) {
                map.put("displaysubtotal", new Boolean(displaySubTotal));
            } else {
                map.put("displaysubtotal", new Boolean("false"));
            }
            if (quote.getLogoFileId() > 0) {
                FileItem thisItem = new FileItem(db, quote.getLogoFileId(), 126200514, 126200511);
                String logoFilePath = this.getPath(context, "quotes") + Quotes.getDatePath(thisItem.getModified()) + thisItem.getFilename();
                map.put("logopath", logoFilePath);
            }
            map.put("language", this.getSystemStatus(context).getLanguage());
            map.put("currency", this.getSystemStatus(context).getApplicationPrefs().get("SYSTEM.CURRENCY"));
            map.put("country", this.getSystemStatus(context).getApplicationPrefs().get("SYSTEM.COUNTRY"));
            map.put("CENTRIC_DICTIONARY", this.getSystemStatus(context).getLocalizationPrefs());
            Connection scriptdb = this.getConnection(context);
            map.put("SCRIPT_DB_CONNECTION", scriptdb);
            String filename = "quote.xml";
            String fontPath = this.getWebInfPath(context, "fonts");
            JasperReport jasperReport = JasperReportUtils.getReport(reportPath + filename);
            String language = Quotes.getPref(context, "SYSTEM.LANGUAGE");
            JasperReportUtils.modifyFontProperties(jasperReport, reportPath, fontPath, language);
            byte[] attachment = JasperRunManager.runReportToPdf((JasperReport)jasperReport, map, (Connection)db);
            if (errors.size() == 0) {
                SMTPMessage mail = new SMTPMessage();
                mail.setHost(Quotes.getPref(context, "MAILSERVER"));
                mail.setFrom(fromEmailAddress);
                mail.setTo(emailToAddress);
                if (emailMe) {
                    mail.setBcc(fromEmailAddress);
                }
                mail.setType("text/plain");
                mail.setSubject(subject);
                mail.addByteArrayAttachment("Quote_" + quote.getGroupId() + "v" + quote.getVersionNumber() + ".pdf", attachment, "application/pdf");
                mail.setBody(body + "\r\n");
                if (mail.send() == 2) {
                    if (System.getProperty("DEBUG") != null) {
                        System.out.println("Quotes-> Send error: " + mail.getErrorMsg() + "<br><br>");
                    }
                    System.err.println(mail.getErrorMsg());
                    errors.put("actionError", systemStatus.getLabel("mail.quoteErrorMessage") + mail.getErrorMsg());
                }
            }
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (errors.size() > 0) {
            this.processErrors(context, errors);
            return "EmailFormOK";
        }
        return "EmailSentOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandChangeShowTotal(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        Connection db = null;
        Quote quote = null;
        Quote previousQuote = null;
        int recordCount = -1;
        boolean isValid = false;
        String quoteId = context.getRequest().getParameter("quoteId");
        String showTotal = context.getRequest().getParameter("showTotal");
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, Integer.parseInt(quoteId));
            boolean canShowTotal = new Boolean(showTotal);
            quote.setShowTotal(canShowTotal);
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                recordCount = quote.update(db);
            }
            if (recordCount > 0) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
            context.getRequest().setAttribute("quoteShowTotal", (Object)("" + quote.getShowTotal()));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SetShowTotalOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandChangeShowSubtotal(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        Connection db = null;
        Quote quote = null;
        Quote previousQuote = null;
        int recordCount = -1;
        boolean isValid = false;
        String quoteId = context.getRequest().getParameter("quoteId");
        String showSubtotal = context.getRequest().getParameter("showSubtotal");
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.queryRecord(db, Integer.parseInt(quoteId));
            if (!Quotes.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            previousQuote = new Quote(db, Integer.parseInt(quoteId));
            boolean canShowSubtotal = new Boolean(showSubtotal);
            quote.setShowSubtotal(canShowSubtotal);
            isValid = this.validateObject(context, db, (Object)quote);
            if (isValid) {
                recordCount = quote.update(db);
            }
            if (recordCount > 0) {
                this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            }
            context.getRequest().setAttribute("quoteShowSubtotal", (Object)("" + quote.getShowSubtotal()));
        }
        catch (Exception errorMessage) {
            context.getRequest().setAttribute("Error", (Object)errorMessage);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "SetShowSubtotalOK";
    }
}

