/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.Timestamp;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductBean;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.utils.web.LookupList;

public final class QuotesProducts
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        String action = context.getAction().getActionName();
        this.addModuleBean(context, action, action);
        return action + "OK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandModify(ActionContext context) {
        block9: {
            if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
                return "PermissionError";
            }
            String quoteIdString = context.getRequest().getParameter("quoteId");
            String quoteProductIdString = context.getRequest().getParameter("quoteProductId");
            int quoteId = Integer.parseInt(quoteIdString);
            int quoteProductId = Integer.parseInt(quoteProductIdString);
            Quote quote = null;
            QuoteProduct quoteProduct = null;
            Connection db = null;
            try {
                db = this.getConnection(context);
                quote = new Quote();
                quote.setBuildProducts(true);
                quote.queryRecord(db, quoteId);
                quote.retrieveTicket(db);
                context.getRequest().setAttribute("quote", (Object)quote);
                quoteProduct = new QuoteProduct();
                quoteProduct.setBuildProduct(true);
                quoteProduct.setBuildProductOptions(true);
                quoteProduct.queryRecord(db, quoteProductId);
                context.getRequest().setAttribute("quoteProduct", (Object)quoteProduct);
                if (quoteProduct.getQuoteId() == quote.getId()) {
                    if (!QuotesProducts.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                        String string = "PermissionError";
                        return string;
                    }
                    break block9;
                }
                String string = "PermissionError";
                return string;
            }
            catch (Exception e) {
                e.printStackTrace();
                context.getRequest().setAttribute("Error", (Object)e);
                String string = "SystemError";
                return string;
            }
            finally {
                this.freeConnection(context, db);
            }
        }
        return "ModifyOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandSave(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        String quoteProductIdString = context.getRequest().getParameter("quoteProductId");
        String quantity = context.getRequest().getParameter("quantity");
        String priceAmount = context.getRequest().getParameter("priceAmount");
        String comment = context.getRequest().getParameter("comment");
        String estimatedDelivery = context.getRequest().getParameter("estimatedDelivery");
        QuoteProductBean bean = (QuoteProductBean)((Object)context.getFormBean());
        Timestamp estimatedDeliveryDate = bean.getEstimatedDeliveryDate();
        boolean isValid = false;
        int quoteId = Integer.parseInt(quoteIdString);
        int quoteProductId = Integer.parseInt(quoteProductIdString);
        int resultCount = -1;
        Quote previousQuote = null;
        QuoteProduct quoteProduct = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            previousQuote = new Quote();
            previousQuote.setBuildProducts(true);
            previousQuote.queryRecord(db, quoteId);
            previousQuote.retrieveTicket(db);
            quoteProduct = new QuoteProduct();
            quoteProduct.setBuildProductOptions(true);
            quoteProduct.setBuildProduct(true);
            quoteProduct.queryRecord(db, quoteProductId);
            if (quoteProduct.getQuoteId() == previousQuote.getId()) {
                if (!QuotesProducts.isRecordAccessPermitted(context, db, previousQuote.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
            } else {
                String string = "PermissionError";
                return string;
            }
            quoteProduct.setPriceAmount(bean.getPriceAmount());
            quoteProduct.setComment(comment);
            quoteProduct.setQuantity(Integer.parseInt(quantity));
            quoteProduct.setEstimatedDelivery(estimatedDelivery);
            quoteProduct.setEstimatedDeliveryDate(estimatedDeliveryDate);
            isValid = this.validateObject(context, db, (Object)quoteProduct);
            boolean optionsValid = true;
            for (QuoteProductOption thisOption : quoteProduct.getProductOptionList()) {
                OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, thisOption.getConfiguratorId());
                configurator.queryProperties(db, thisOption.getOptionId(), false);
                if (configurator.validateUserInput(context.getRequest()) || !configurator.hasUserInput(context.getRequest())) continue;
                optionsValid = false;
                break;
            }
            if (isValid && optionsValid) {
                resultCount = quoteProduct.update(db, context.getRequest());
            }
            Quote quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            quote.retrieveTicket(db);
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            context.getRequest().setAttribute("quote", (Object)quote);
            context.getRequest().setAttribute("quoteProduct", (Object)quoteProduct);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (resultCount <= 0 || !isValid) {
            SystemStatus systemStatus = this.getSystemStatus(context);
            context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("quoteProduct.option.validation.actionError"));
            return "ModifyOK";
        }
        return "SaveOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCreateForm(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit") || this.hasPermission(context, "product-catalog-product-add"))) {
            return "PermissionError";
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        int quoteId = Integer.parseInt(quoteIdString);
        Quote quote = null;
        Connection db = null;
        try {
            db = this.getConnection(context);
            SystemStatus systemStatus = this.getSystemStatus(context);
            LookupList currencySelect = systemStatus.getLookupList(db, "lookup_currency");
            currencySelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("CurrencySelect", (Object)currencySelect);
            LookupList recurringTypeSelect = systemStatus.getLookupList(db, "lookup_recurring_type");
            recurringTypeSelect.addItem(-1, systemStatus.getLabel("calendar.none.4dashes"));
            context.getRequest().setAttribute("RecurringTypeSelect", (Object)recurringTypeSelect);
            quote = new Quote();
            quote.queryRecord(db, quoteId);
            if (!QuotesProducts.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                String string = "PermissionError";
                return string;
            }
            quote.buildProducts(db);
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            QuoteProductBean bean = (QuoteProductBean)((Object)context.getFormBean());
            if (bean == null) {
                bean = new QuoteProductBean();
            }
            bean.setQuoteId(quoteId);
            context.getRequest().setAttribute("quoteProductBean", (Object)bean);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CreateFormOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCreate(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit") || this.hasPermission(context, "product-catalog-product-add"))) {
            return "PermissionError";
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        int quoteId = Integer.parseInt(quoteIdString);
        Quote previousQuote = null;
        boolean productInserted = false;
        boolean priceInserted = false;
        boolean itemInserted = false;
        boolean isValid = false;
        int userId = this.getUserId(context);
        ProductCatalog product = new ProductCatalog();
        ProductCatalogPricing pricing = new ProductCatalogPricing();
        QuoteProduct item = new QuoteProduct();
        Connection db = null;
        try {
            db = this.getConnection(context);
            previousQuote = new Quote();
            previousQuote.setBuildProducts(true);
            previousQuote.queryRecord(db, quoteId);
            previousQuote.retrieveTicket(db);
            QuoteProductBean bean = (QuoteProductBean)((Object)context.getFormBean());
            product = bean.getProduct();
            product.setEnteredBy(userId);
            product.setModifiedBy(userId);
            db.setAutoCommit(false);
            isValid = this.validateObject(context, db, (Object)product);
            if (isValid) {
                productInserted = product.insert(db);
            }
            if (productInserted && isValid) {
                pricing = bean.getPricing();
                pricing.setEnteredBy(userId);
                pricing.setModifiedBy(userId);
                isValid = this.validateObject(context, db, (Object)pricing);
                if (isValid) {
                    priceInserted = pricing.insert(db);
                }
            }
            Quote quote = new Quote();
            quote.queryRecord(db, quoteId);
            if (priceInserted && isValid) {
                item = bean.getQuoteProduct();
                if (item.getQuoteId() == quote.getId()) {
                    if (!QuotesProducts.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                        String string = "PermissionError";
                        return string;
                    }
                } else {
                    String string = "PermissionError";
                    return string;
                }
                isValid = this.validateObject(context, db, (Object)item);
                if (isValid) {
                    itemInserted = item.insert(db);
                }
            }
            quote.buildProducts(db);
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            this.processUpdateHook(context, (Object)previousQuote, (Object)quote);
            if (!itemInserted && !isValid) {
                db.rollback();
            } else {
                db.commit();
            }
        }
        catch (Exception e) {
            try {
                db.rollback();
            }
            catch (Exception e1) {
                // empty catch block
            }
            context.getRequest().setAttribute("Error", (Object)e);
            e.printStackTrace();
            String string = "SystemError";
            return string;
        }
        finally {
            try {
                db.setAutoCommit(true);
            }
            catch (Exception e2) {}
            this.freeConnection(context, db);
        }
        if (!itemInserted || !isValid) {
            return this.executeCommandCreateForm(context);
        }
        return "CreateOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandClone(ActionContext context) {
        if (!(this.hasPermission(context, "quotes-quotes-edit") || this.hasPermission(context, "accounts-quotes-edit") || this.hasPermission(context, "leads-opportunities-edit"))) {
            return "PermissionError";
        }
        String quoteIdString = context.getRequest().getParameter("quoteId");
        String quoteProductIdString = context.getRequest().getParameter("quoteProductId");
        int quoteId = Integer.parseInt(quoteIdString);
        int quoteProductId = Integer.parseInt(quoteProductIdString);
        Quote quote = null;
        QuoteProduct quoteProduct = null;
        int clone = -1;
        Connection db = null;
        try {
            db = this.getConnection(context);
            quote = new Quote();
            quote.setBuildProducts(true);
            quote.queryRecord(db, quoteId);
            quote.retrieveTicket(db);
            context.getRequest().setAttribute("quote", (Object)quote);
            quoteProduct = new QuoteProduct();
            quoteProduct.setBuildProduct(true);
            quoteProduct.setBuildProductOptions(true);
            quoteProduct.queryRecord(db, quoteProductId);
            if (quoteProduct.getQuoteId() == quote.getId()) {
                if (!QuotesProducts.isRecordAccessPermitted(context, db, quote.getOrgId())) {
                    String string = "PermissionError";
                    return string;
                }
            } else {
                String string = "PermissionError";
                return string;
            }
            clone = quoteProduct.clone(db);
            context.getRequest().setAttribute("quoteProduct", (Object)quoteProduct);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ModifyOK";
    }
}

