/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.base.Dependency;
import org.aspcfs.modules.base.DependencyList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.quotes.base.QuoteCondition;
import org.aspcfs.modules.quotes.base.QuoteConditionList;
import org.aspcfs.modules.quotes.base.QuoteList;
import org.aspcfs.modules.quotes.base.QuoteLog;
import org.aspcfs.modules.quotes.base.QuoteLogList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.modules.quotes.base.QuoteNoteList;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;
import org.aspcfs.modules.quotes.base.QuoteRemark;
import org.aspcfs.modules.quotes.base.QuoteRemarkList;
import org.aspcfs.modules.troubletickets.base.Ticket;
import org.aspcfs.utils.DatabaseUtils;

public class Quote
extends GenericBean {
    public static final int NONE = 2004110800;
    public static final int PRINT = 2004110801;
    public static final int EMAIL = 2004110802;
    public static final int FAX = 2004110803;
    public static String QUOTE_CONFIG_NAME = "org.aspcfs.modules.quotes.base.Quote";
    public static String MULTIPLE_QUOTE_CONFIG_PARAM = "multipleQuotePerOpportunity";
    public static String MULTIPLE_VERSION_CONFIG_PARAM = "multipleQuoteVersionPerOpportunity";
    private int id = -1;
    private int parentId = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int sourceId = -1;
    private double grandTotal = 0.0;
    private int statusId = -1;
    private Timestamp statusDate = null;
    private Timestamp issuedDate = null;
    private Timestamp expirationDate = null;
    private int quoteTermsId = -1;
    private int quoteTypeId = -1;
    private String shortDescription = null;
    private String notes = null;
    private int ticketId = -1;
    private int productId = -1;
    private int customerProductId = -1;
    private int headerId = -1;
    private String version = "0.0";
    private int groupId = -1;
    private int deliveryId = -1;
    private String emailAddress = null;
    private String phoneNumber = null;
    private String address = null;
    private String faxNumber = null;
    private int submitAction = -1;
    private Timestamp closed = null;
    private boolean showTotal = false;
    private boolean showSubtotal = false;
    private int logoFileId = -1;
    private String statusName = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private Timestamp trashedDate = null;
    private String name = null;
    private String nameLast = null;
    private String nameFirst = null;
    private String nameMiddle = null;
    private boolean lock = false;
    private String siteName = null;
    private boolean buildProducts = false;
    private QuoteProductList productList = new QuoteProductList();
    private boolean buildTicket = false;
    private Ticket ticket = null;
    private boolean buildCompleteVersionList = false;
    private QuoteList versionList = null;
    private boolean buildResources = true;
    private Contact contact = null;
    private Organization organization = null;
    private boolean buildHistory = false;
    private QuoteLogList history = new QuoteLogList();
    private boolean buildConditions = true;
    private QuoteConditionList conditions = new QuoteConditionList();
    private boolean buildRemarks = true;
    private QuoteRemarkList remarks = new QuoteRemarkList();
    private String submitType = null;
    private boolean closeIt = false;
    private String canPrint = "false";
    private boolean canNotCopyExpirationDate = false;
    private SystemStatus systemStatus = null;

    public int getLogoFileId() {
        return this.logoFileId;
    }

    public void setLogoFileId(int tmp) {
        this.logoFileId = tmp;
    }

    public void setLogoFileId(String tmp) {
        this.logoFileId = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
        this.history.setQuoteId(tmp);
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
        this.history.setQuoteId(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setSourceId(int tmp) {
        this.sourceId = tmp;
    }

    public void setSourceId(String tmp) {
        this.sourceId = Integer.parseInt(tmp);
    }

    public void setGrandTotal(double tmp) {
        this.grandTotal = tmp;
    }

    public void setGrandTotal(String tmp) {
        this.grandTotal = Double.parseDouble(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setStatusDate(String tmp) {
        this.statusDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIssuedDate(Timestamp tmp) {
        this.issuedDate = tmp;
    }

    public void setIssuedDate(String tmp) {
        this.issuedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setCustomerProductId(int tmp) {
        this.customerProductId = tmp;
    }

    public void setCustomerProductId(String tmp) {
        this.customerProductId = Integer.parseInt(tmp);
    }

    public void setHeaderId(int tmp) {
        this.headerId = tmp;
    }

    public void setHeaderId(String tmp) {
        this.headerId = Integer.parseInt(tmp);
    }

    public void setVersion(String tmp) {
        this.version = tmp;
    }

    public void setVersionList(QuoteList tmp) {
        this.versionList = tmp;
    }

    public void setBuildCompleteVersionList(boolean tmp) {
        this.buildCompleteVersionList = tmp;
    }

    public void setBuildCompleteVersionList(String tmp) {
        this.buildCompleteVersionList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean getBuildCompleteVersionList() {
        return this.buildCompleteVersionList;
    }

    public QuoteList getVersionList() {
        return this.versionList;
    }

    public String getVersion() {
        return this.version;
    }

    public int getHeaderId() {
        return this.headerId;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getCustomerProductId() {
        return this.customerProductId;
    }

    public Timestamp getIssuedDate() {
        return this.issuedDate;
    }

    public void setExpirationDate(Timestamp tmp) {
        this.expirationDate = tmp;
    }

    public void setExpirationDate(String tmp) {
        this.expirationDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setQuoteTermsId(int tmp) {
        this.quoteTermsId = tmp;
    }

    public void setQuoteTermsId(String tmp) {
        this.quoteTermsId = Integer.parseInt(tmp);
    }

    public void setQuoteTypeId(int tmp) {
        this.quoteTypeId = tmp;
    }

    public void setQuoteTypeId(String tmp) {
        this.quoteTypeId = Integer.parseInt(tmp);
    }

    public void setShortDescription(String tmp) {
        this.shortDescription = tmp;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean isTrashed() {
        return this.trashedDate != null;
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setNameLast(String tmp) {
        this.nameLast = tmp;
    }

    public void setNameFirst(String tmp) {
        this.nameFirst = tmp;
    }

    public void setNameMiddle(String tmp) {
        this.nameMiddle = tmp;
    }

    public void setLock(boolean tmp) {
        this.lock = tmp;
    }

    public void setLock(String tmp) {
        this.lock = DatabaseUtils.parseBoolean(tmp);
    }

    public void setBuildProducts(boolean tmp) {
        this.buildProducts = tmp;
    }

    public void setBuildProducts(String tmp) {
        this.buildProducts = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductList(QuoteProductList tmp) {
        this.productList = tmp;
    }

    public void setTicketId(int tmp) {
        this.ticketId = tmp;
    }

    public void setTicketId(String tmp) {
        this.ticketId = Integer.parseInt(tmp);
    }

    public void setTicket(Ticket tmp) {
        this.ticket = tmp;
    }

    public void setBuildTicket(boolean tmp) {
        this.buildTicket = tmp;
    }

    public void setBuildTicket(String tmp) {
        this.buildTicket = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildTicket() {
        return this.buildTicket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public int getId() {
        return this.id;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public Timestamp getExpirationDate() {
        return this.expirationDate;
    }

    public int getQuoteTermsId() {
        return this.quoteTermsId;
    }

    public int getQuoteTypeId() {
        return this.quoteTypeId;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getNotes() {
        return this.notes;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public String getName() {
        return this.name;
    }

    public String getNameLast() {
        return this.nameLast;
    }

    public String getNameFirst() {
        return this.nameFirst;
    }

    public String getNameMiddle() {
        return this.nameMiddle;
    }

    public boolean getLock() {
        return this.lock;
    }

    public boolean getBuildProducts() {
        return this.buildProducts;
    }

    public QuoteProductList getProductList() {
        return this.productList;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public int getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(int tmp) {
        this.deliveryId = tmp;
    }

    public void setDeliveryId(String tmp) {
        this.deliveryId = Integer.parseInt(tmp);
    }

    public Contact getContact() {
        return this.contact;
    }

    public void setContact(Contact tmp) {
        this.contact = tmp;
    }

    public Organization getOrganization() {
        return this.organization;
    }

    public void setOrganization(Organization tmp) {
        this.organization = tmp;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public QuoteLogList getHistory() {
        return this.history;
    }

    public void setHistory(QuoteLogList tmp) {
        this.history = tmp;
    }

    public boolean getBuildHistory() {
        return this.buildHistory;
    }

    public void setBuildHistory(boolean tmp) {
        this.buildHistory = tmp;
    }

    public void setBuildHistory(String tmp) {
        this.buildHistory = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildConditions() {
        return this.buildConditions;
    }

    public void setBuildConditions(boolean tmp) {
        this.buildConditions = tmp;
    }

    public void setBuildConditions(String tmp) {
        this.buildConditions = DatabaseUtils.parseBoolean(tmp);
    }

    public QuoteConditionList getConditions() {
        return this.conditions;
    }

    public void setConditions(QuoteConditionList tmp) {
        this.conditions = tmp;
    }

    public boolean getBuildRemarks() {
        return this.buildRemarks;
    }

    public void setBuildRemarks(boolean tmp) {
        this.buildRemarks = tmp;
    }

    public void setBuildRemarks(String tmp) {
        this.buildRemarks = DatabaseUtils.parseBoolean(tmp);
    }

    public QuoteRemarkList getRemarks() {
        return this.remarks;
    }

    public void setRemarks(QuoteRemarkList tmp) {
        this.remarks = tmp;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String tmp) {
        this.emailAddress = tmp;
    }

    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String tmp) {
        this.phoneNumber = tmp;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String tmp) {
        this.address = tmp;
    }

    public String getFaxNumber() {
        return this.faxNumber;
    }

    public void setFaxNumber(String tmp) {
        this.faxNumber = tmp;
    }

    public String getSubmitType() {
        return this.submitType;
    }

    public void setSubmitType(String tmp) {
        this.submitType = tmp;
    }

    public int getSubmitAction() {
        return this.submitAction;
    }

    public void setSubmitAction(int tmp) {
        this.submitAction = tmp;
    }

    public void setSubmitAction(String tmp) {
        this.submitAction = Integer.parseInt(tmp);
    }

    public boolean getCloseIt() {
        return this.closeIt;
    }

    public void setCloseIt(boolean tmp) {
        this.closeIt = tmp;
    }

    public void setCloseIt(String tmp) {
        this.closeIt = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getClosed() {
        return this.closed;
    }

    public void setClosed(Timestamp tmp) {
        this.closed = tmp;
    }

    public void setClosed(String tmp) {
        this.closed = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean isClosed() {
        return this.closed != null;
    }

    public String getCanPrint() {
        return this.canPrint;
    }

    public void setCanPrint(String tmp) {
        this.canPrint = tmp;
    }

    public String getPaddedGroupId() {
        String padded = String.valueOf(this.getGroupId());
        while (padded.length() < 6) {
            padded = "0" + padded;
        }
        return padded;
    }

    public boolean getShowTotal() {
        return this.showTotal;
    }

    public void setShowTotal(boolean tmp) {
        this.showTotal = tmp;
    }

    public void setShowTotal(String tmp) {
        this.showTotal = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getShowSubtotal() {
        return this.showSubtotal;
    }

    public void setShowSubtotal(boolean tmp) {
        this.showSubtotal = tmp;
    }

    public void setShowSubtotal(String tmp) {
        this.showSubtotal = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getCanNotCopyExpirationDate() {
        return this.canNotCopyExpirationDate;
    }

    public void setCanNotCopyExpirationDate(boolean tmp) {
        this.canNotCopyExpirationDate = tmp;
    }

    public void setCanNotCopyExpirationDate(String tmp) {
        this.canNotCopyExpirationDate = DatabaseUtils.parseBoolean(tmp);
    }

    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String tmp) {
        this.statusName = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public String getSiteName() {
        return this.siteName;
    }

    public void setSiteName(String tmp) {
        this.siteName = tmp;
    }

    public static boolean allowMultipleQuotesPerOpportunity(String tmp) {
        return tmp == null || !"false".equals(tmp);
    }

    public static boolean allowMultipleVersionsPerQuote(String tmp) {
        return tmp == null || !"false".equals(tmp);
    }

    public Quote() {
    }

    public Quote(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public Quote(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote ID");
        }
        StringBuffer sb = new StringBuffer(" SELECT qe.*,  org.name, ct.namelast, ct.namefirst, ct.namemiddle, lqs.description AS statusName, opp." + DatabaseUtils.addQuotes(db, "lock") + " as opplock, " + " lsi.description AS sitename " + " FROM quote_entry qe " + " LEFT JOIN quote_group qg ON (qe.group_id = qg.group_id) " + " LEFT JOIN organization org ON (qe.org_id = org.org_id) " + " LEFT JOIN lookup_site_id lsi ON (org.site_id = lsi.code) " + " LEFT JOIN lookup_quote_status lqs ON ( qe.status_id = lqs.code ) " + " LEFT JOIN contact ct ON (qe.contact_id = ct.contact_id) " + " LEFT JOIN opportunity_header opp ON (qe.opp_id = opp.opp_id) " + " WHERE qe.quote_id = ? ");
        PreparedStatement pst = db.prepareStatement(sb.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("NOT_FOUND_ERROR");
        }
        if (this.buildProducts) {
            this.buildProducts(db);
        }
        if (this.buildResources) {
            this.buildResources(db);
        }
        if (this.buildConditions) {
            this.buildConditions(db);
        }
        if (this.buildRemarks) {
            this.buildRemarks(db);
        }
        if (this.buildHistory) {
            this.buildHistory(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("quote_id"));
        this.parentId = DatabaseUtils.getInt(rs, "parent_id");
        this.orgId = DatabaseUtils.getInt(rs, "org_id");
        this.contactId = DatabaseUtils.getInt(rs, "contact_id");
        this.sourceId = DatabaseUtils.getInt(rs, "source_id");
        this.grandTotal = DatabaseUtils.getDouble(rs, "grand_total");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.statusDate = rs.getTimestamp("status_date");
        this.expirationDate = rs.getTimestamp("expiration_date");
        this.quoteTermsId = DatabaseUtils.getInt(rs, "quote_terms_id");
        this.quoteTypeId = DatabaseUtils.getInt(rs, "quote_type_id");
        this.issuedDate = rs.getTimestamp("issued");
        this.shortDescription = rs.getString("short_description");
        this.notes = rs.getString("notes");
        this.ticketId = DatabaseUtils.getInt(rs, "ticketid");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.productId = DatabaseUtils.getInt(rs, "product_id");
        this.customerProductId = DatabaseUtils.getInt(rs, "customer_product_id");
        this.headerId = DatabaseUtils.getInt(rs, "opp_id");
        this.version = rs.getString("version");
        this.groupId = DatabaseUtils.getInt(rs, "group_id");
        this.deliveryId = DatabaseUtils.getInt(rs, "delivery_id");
        this.emailAddress = rs.getString("email_address");
        this.phoneNumber = rs.getString("phone_number");
        this.address = rs.getString("address");
        this.faxNumber = rs.getString("fax_number");
        this.submitAction = DatabaseUtils.getInt(rs, "submit_action");
        this.closed = rs.getTimestamp("closed");
        this.showTotal = rs.getBoolean("show_total");
        this.showSubtotal = rs.getBoolean("show_subtotal");
        this.logoFileId = DatabaseUtils.getInt(rs, "logo_file_id");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.name = rs.getString("name");
        this.nameFirst = rs.getString("namefirst");
        this.nameMiddle = rs.getString("namemiddle");
        this.nameLast = rs.getString("namelast");
        this.statusName = rs.getString("statusName");
        this.lock = rs.getBoolean("opplock");
        this.siteName = rs.getString("sitename");
    }

    public void buildProducts(Connection db) throws SQLException {
        this.productList.setQuoteId(this.getId());
        this.productList.setBuildResources(true);
        this.productList.buildList(db);
        Iterator products = this.getProductList().iterator();
        double total = 0.0;
        while (products.hasNext()) {
            QuoteProduct product = (QuoteProduct)((Object)products.next());
            total += product.getTotalPrice();
        }
        this.setGrandTotal(total);
    }

    public void buildResources(Connection db) throws SQLException {
        if (this.getContactId() != -1) {
            this.contact = new Contact();
            this.contact.setBuildDetails(true);
            this.contact.setBuildTypes(true);
            this.contact.queryRecord(db, this.getContactId());
        }
        if (this.getOrgId() != -1) {
            this.organization = new Organization(db, this.getOrgId());
        }
    }

    public void buildRemarks(Connection db) throws SQLException {
        this.remarks.setQuoteId(this.getId());
        this.remarks.buildList(db);
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "quote_entry_quote_id_seq");
            sql.append("INSERT INTO quote_entry (parent_id, org_id, contact_id, source_id, grand_total, status_id, status_date, expiration_date, show_total, show_subtotal, logo_file_id, trashed_date, ");
            if (this.id > -1) {
                sql.append("quote_id, ");
            }
            if (this.getCloseIt() || this.getClosed() != null) {
                sql.append("closed, ");
            }
            sql.append("quote_terms_id, quote_type_id, issued, short_description, notes, ticketid, product_id, customer_product_id, opp_id, " + DatabaseUtils.addQuotes(db, "version") + ", group_id, delivery_id, " + "email_address, phone_number, address, fax_number, submit_action, ");
            if (this.entered != null) {
                sql.append("entered, ");
            }
            sql.append("enteredby, ");
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("modifiedby )");
            sql.append(" VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.getClosed() != null) {
                sql.append("?, ");
            } else if (this.getCloseIt()) {
                sql.append(DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
            if (this.entered != null) {
                sql.append("?, ");
            }
            sql.append("?, ");
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("? )");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            DatabaseUtils.setInt(pst, ++i, this.getOrgId());
            DatabaseUtils.setInt(pst, ++i, this.getContactId());
            DatabaseUtils.setInt(pst, ++i, this.getSourceId());
            DatabaseUtils.setDouble(pst, ++i, this.getGrandTotal());
            DatabaseUtils.setInt(pst, ++i, this.getStatusId());
            DatabaseUtils.setTimestamp(pst, ++i, this.getStatusDate());
            DatabaseUtils.setTimestamp(pst, ++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getShowTotal());
            pst.setBoolean(++i, this.getShowSubtotal());
            DatabaseUtils.setInt(pst, ++i, this.getLogoFileId());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.getClosed() != null) {
                DatabaseUtils.setTimestamp(pst, ++i, this.getClosed());
            }
            DatabaseUtils.setInt(pst, ++i, this.getQuoteTermsId());
            DatabaseUtils.setInt(pst, ++i, this.getQuoteTypeId());
            DatabaseUtils.setTimestamp(pst, ++i, this.getIssuedDate());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getNotes());
            DatabaseUtils.setInt(pst, ++i, this.getTicketId());
            DatabaseUtils.setInt(pst, ++i, this.getProductId());
            DatabaseUtils.setInt(pst, ++i, this.getCustomerProductId());
            DatabaseUtils.setInt(pst, ++i, this.getHeaderId());
            pst.setString(++i, this.getVersion());
            DatabaseUtils.setInt(pst, ++i, this.getGroupId());
            DatabaseUtils.setInt(pst, ++i, this.getDeliveryId());
            pst.setString(++i, this.getEmailAddress());
            pst.setString(++i, this.getPhoneNumber());
            pst.setString(++i, this.getAddress());
            pst.setString(++i, this.getFaxNumber());
            DatabaseUtils.setInt(pst, ++i, this.getSubmitAction());
            if (this.entered != null) {
                pst.setTimestamp(++i, this.getEntered());
            }
            pst.setInt(++i, this.getEnteredBy());
            if (this.modified != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "quote_entry_quote_id_seq", this.id);
            if (this.getEntered() == null) {
                this.updateEntry(db);
            }
            this.productList.insert(db);
            QuoteNote quoteNote = new QuoteNote();
            quoteNote.setQuoteId(this.getId());
            quoteNote.setNotes("New quote created");
            quoteNote.setEnteredBy(this.getEnteredBy());
            quoteNote.setModifiedBy(this.getModifiedBy());
            quoteNote.insert(db);
            if (commit) {
                db.commit();
            }
            result = true;
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.buildProducts(db);
            this.productList.delete(db);
            this.productList = null;
            QuoteNoteList noteList = new QuoteNoteList();
            noteList.setQuoteId(this.getId());
            noteList.buildList(db);
            noteList.delete(db);
            this.history.setQuoteId(this.getId());
            this.history.setDoSystemMessages(false);
            this.buildHistory(db);
            this.getHistory().delete(db);
            QuoteConditionList conditions = new QuoteConditionList();
            conditions.setQuoteId(this.getId());
            conditions.buildList(db);
            conditions.delete(db);
            ContactHistory.deleteObject(db, 5, this.getId());
            QuoteRemarkList remarks = new QuoteRemarkList();
            remarks.setQuoteId(this.getId());
            remarks.buildList(db);
            remarks.delete(db);
            PreparedStatement pst = null;
            ResultSet rs = null;
            Quote childQuote = new Quote();
            int childQuoteId = -1;
            pst = db.prepareStatement("SELECT qe.quote_id AS quote_id FROM quote_entry qe LEFT JOIN quote_entry pqe ON ( qe.parent_id = pqe.quote_id ) WHERE pqe.quote_id = ? ");
            pst.setInt(1, this.getId());
            rs = pst.executeQuery();
            if (rs.next()) {
                childQuoteId = rs.getInt("quote_id");
            }
            rs.close();
            pst.close();
            if (childQuoteId != -1) {
                childQuote.queryRecord(db, childQuoteId);
                childQuote.setParentId(this.getParentId());
                childQuote.update(db);
            }
            pst = db.prepareStatement("DELETE FROM quote_entry WHERE quote_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            QuoteList quoteList = new QuoteList();
            quoteList.setGroupId(this.getGroupId());
            quoteList.buildList(db);
            if (quoteList.size() == 0) {
                pst = db.prepareStatement("DELETE FROM quote_group WHERE group_id = ? ");
                pst.setInt(1, this.getGroupId());
                pst.execute();
                pst.close();
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        boolean commit = false;
        if (this.getId() == -1) {
            return -1;
        }
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.updateEntry(db);
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE quote_entry SET parent_id = ?, org_id = ?, contact_id = ?, source_id = ?, grand_total = ?, status_id = ?, status_date = ?, expiration_date = ?, show_total = ?, show_subtotal = ?, logo_file_id = ?, ");
            if (this.getClosed() != null) {
                sql.append(" closed = ?, ");
            } else if (this.getCloseIt()) {
                sql.append("closed = " + DatabaseUtils.getCurrentTimestamp(db) + ", ");
            }
            sql.append("quote_terms_id = ?, quote_type_id = ?, issued = ?, short_description = ?, notes = ?, ticketid = ?, product_id = ?, customer_product_id = ?, opp_id = ?, " + DatabaseUtils.addQuotes(db, "version") + " = ?, " + "group_id = ?, " + "delivery_id = ?, " + "email_address = ?, " + "phone_number = ?, " + "address = ?, " + "fax_number = ?, " + "submit_action = ?, " + "modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "modifiedby = ?, " + "trashed_date = ? " + "WHERE quote_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getParentId());
            DatabaseUtils.setInt(pst, ++i, this.getOrgId());
            DatabaseUtils.setInt(pst, ++i, this.getContactId());
            DatabaseUtils.setInt(pst, ++i, this.getSourceId());
            DatabaseUtils.setDouble(pst, ++i, this.getGrandTotal());
            DatabaseUtils.setInt(pst, ++i, this.getStatusId());
            pst.setTimestamp(++i, this.getStatusDate());
            pst.setTimestamp(++i, this.getExpirationDate());
            pst.setBoolean(++i, this.getShowTotal());
            pst.setBoolean(++i, this.getShowSubtotal());
            DatabaseUtils.setInt(pst, ++i, this.getLogoFileId());
            if (this.getClosed() != null) {
                pst.setTimestamp(++i, this.getClosed());
            }
            DatabaseUtils.setInt(pst, ++i, this.getQuoteTermsId());
            DatabaseUtils.setInt(pst, ++i, this.getQuoteTypeId());
            pst.setTimestamp(++i, this.getIssuedDate());
            pst.setString(++i, this.getShortDescription());
            pst.setString(++i, this.getNotes());
            DatabaseUtils.setInt(pst, ++i, this.getTicketId());
            DatabaseUtils.setInt(pst, ++i, this.getProductId());
            DatabaseUtils.setInt(pst, ++i, this.getCustomerProductId());
            DatabaseUtils.setInt(pst, ++i, this.getHeaderId());
            pst.setString(++i, this.getVersion());
            DatabaseUtils.setInt(pst, ++i, this.getGroupId());
            DatabaseUtils.setInt(pst, ++i, this.getDeliveryId());
            pst.setString(++i, this.getEmailAddress());
            pst.setString(++i, this.getPhoneNumber());
            pst.setString(++i, this.getAddress());
            pst.setString(++i, this.getFaxNumber());
            DatabaseUtils.setInt(pst, ++i, this.getSubmitAction());
            pst.setInt(++i, this.getModifiedBy());
            pst.setTimestamp(++i, this.getTrashedDate());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            this.setBuildProducts(true);
            this.setBuildResources(true);
            this.setBuildConditions(true);
            this.setBuildRemarks(true);
            this.queryRecord(db, this.getId());
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        boolean commit = true;
        PreparedStatement pst = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE quote_entry SET trashed_date = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + ", " + "modifiedby = ? " + "WHERE quote_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.id);
            pst.executeUpdate();
            pst.close();
            if (toTrash) {
                Quote childQuote = new Quote();
                int childQuoteId = -1;
                pst = db.prepareStatement("SELECT qe.quote_id AS quote_id FROM quote_entry qe LEFT JOIN quote_entry pqe ON ( qe.parent_id = pqe.quote_id ) WHERE pqe.quote_id = ? ");
                pst.setInt(1, this.getId());
                rs = pst.executeQuery();
                if (rs.next()) {
                    childQuoteId = rs.getInt("quote_id");
                }
                rs.close();
                pst.close();
                if (childQuoteId != -1) {
                    childQuote.queryRecord(db, childQuoteId);
                    childQuote.setParentId(this.getParentId());
                    childQuote.update(db);
                }
            } else {
                Quote childQuote = new Quote();
                int childQuoteId = -1;
                pst = db.prepareStatement("SELECT MAX(quote_id) AS quote_id FROM quote_entry WHERE quote_id < ? AND group_id = ? ");
                pst.setInt(1, this.getId());
                pst.setInt(2, this.getGroupId());
                rs = pst.executeQuery();
                if (rs.next()) {
                    childQuoteId = rs.getInt("quote_id");
                }
                rs.close();
                pst.close();
                if (childQuoteId != -1) {
                    childQuote.queryRecord(db, childQuoteId);
                    this.setParentId(childQuote.getParentId());
                    childQuote.setParentId(this.getId());
                    this.update(db);
                    childQuote.update(db);
                }
            }
            ContactHistory.trash(db, 5, this.getId(), !toTrash);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public DependencyList processDependencies(Connection db) throws SQLException {
        int recordCount;
        Dependency thisDependency;
        if (this.getId() == -1) {
            throw new SQLException("Quote ID not specified");
        }
        DependencyList dependencyList = new DependencyList();
        PreparedStatement pst = null;
        ResultSet rs = null;
        int i = 0;
        try {
            int parentCount;
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as parentcount FROM quote_entry WHERE parent_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (parentCount = rs.getInt("parentcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("numberOfParentsOfThisQuote");
                thisDependency.setCount(parentCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as recordcount FROM quote_notes WHERE quote_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("quotenotes");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as recordcount FROM order_entry WHERE quote_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("numberOfOrdersBasedOnThisQuote");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(false);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement("SELECT count(*) as recordcount FROM quotelog WHERE quote_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("HistoryOfThisQuote");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) as recordcount  FROM quote_condition  WHERE quote_id = ?");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (recordCount = rs.getInt("recordcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("NumberOfConditionsForThisQuote");
                thisDependency.setCount(recordCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        try {
            int productCount;
            i = 0;
            pst = db.prepareStatement(" SELECT count(*) AS productcount  FROM quote_product qp  WHERE qp.quote_id = ? ");
            pst.setInt(++i, this.getId());
            rs = pst.executeQuery();
            if (rs.next() && (productCount = rs.getInt("productcount")) != 0) {
                thisDependency = new Dependency();
                thisDependency.setName("numberOfProductsAssociatedWithThisQuote");
                thisDependency.setCount(productCount);
                thisDependency.setCanDelete(true);
                dependencyList.add(thisDependency);
            }
            rs.close();
            pst.close();
        }
        catch (SQLException e) {
            throw new SQLException(e.getMessage());
        }
        return dependencyList;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("statusDate");
        thisList.add("issuedDate");
        thisList.add("closed");
        thisList.add("expirationDate");
        thisList.add("entered");
        thisList.add("modified");
        return thisList;
    }

    public void retrieveTicket(Connection db) throws SQLException {
        if (this.ticketId != -1) {
            this.ticket = new Ticket(db, this.ticketId);
        }
    }

    public int getOrderId(Connection db) throws SQLException {
        int orderId = -1;
        if (this.getId() == -1) {
            throw new SQLException("Error: Incorrect usage");
        }
        PreparedStatement pst = db.prepareStatement("SELECT oe.order_id as order_id FROM order_entry oe LEFT JOIN quote_entry qe ON ( oe.quote_id = qe.quote_id ) WHERE oe.quote_id = ? ");
        pst.setInt(1, this.getId());
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            orderId = rs.getInt("order_id");
        }
        pst.close();
        rs.close();
        return orderId;
    }

    public void buildVersionList(Connection db) throws SQLException {
        this.versionList = new QuoteList();
        this.versionList.setParentId(this.getId());
        this.versionList.setTopOnly(-1);
        this.versionList.setBuildCompleteVersionList(this.getBuildCompleteVersionList());
        this.versionList.buildList(db);
    }

    public Quote copyQuote(Connection db, Quote copyQuote) throws SQLException {
        OpportunityHeader opp;
        copyQuote.setBuildCompleteVersionList(this.getBuildCompleteVersionList());
        copyQuote.setBuildProducts(this.getBuildProducts());
        copyQuote.setBuildTicket(this.getBuildTicket());
        copyQuote.setShowTotal(this.getShowTotal());
        copyQuote.setShowSubtotal(this.getShowSubtotal());
        if (copyQuote.getOrgId() == -1) {
            copyQuote.setOrgId(this.getOrgId());
        }
        if (copyQuote.getContactId() == -1 && copyQuote.getOrgId() == this.getOrgId()) {
            copyQuote.setContactId(this.getContactId());
        }
        if (copyQuote.getCustomerProductId() == -1) {
            copyQuote.setCustomerProductId(this.getCustomerProductId());
        }
        if (copyQuote.getEnteredBy() == -1) {
            copyQuote.setEnteredBy(this.getEnteredBy());
        }
        if (!copyQuote.getCanNotCopyExpirationDate()) {
            copyQuote.setExpirationDate(this.getExpirationDate());
        }
        copyQuote.setGrandTotal(this.getGrandTotal());
        if (!(copyQuote.getHeaderId() != -1 || copyQuote.getOrgId() != this.getOrgId() || this.getHeaderId() == -1 || (opp = new OpportunityHeader(db, this.getHeaderId())).getContactLink() != -1 && opp.getContactLink() != this.getContactId() || opp.getAccountLink() != -1 && opp.getAccountLink() != this.getOrgId())) {
            copyQuote.setHeaderId(this.getHeaderId());
        }
        if (copyQuote.getModifiedBy() == -1) {
            copyQuote.setModifiedBy(this.getModifiedBy());
        }
        copyQuote.setNotes(copyQuote.getNotes() + this.getNotes());
        if (copyQuote.getOrgId() == -1) {
            copyQuote.setOrgId(this.getOrgId());
        }
        if (copyQuote.getProductId() == -1) {
            copyQuote.setProductId(this.getProductId());
        }
        if (copyQuote.getQuoteTermsId() == -1) {
            copyQuote.setQuoteTermsId(this.getQuoteTermsId());
        }
        if (copyQuote.getQuoteTypeId() == -1) {
            copyQuote.setQuoteTypeId(this.getQuoteTypeId());
        }
        if (copyQuote.getShortDescription() == null || "".equals(copyQuote.getShortDescription())) {
            copyQuote.setShortDescription(this.getShortDescription());
        }
        if (copyQuote.getSourceId() == -1) {
            copyQuote.setSourceId(this.getSourceId());
        }
        if (copyQuote.getStatusId() == -1) {
            copyQuote.setStatusId(this.getStatusId());
            copyQuote.setStatusDate(this.getStatusDate());
        }
        if (copyQuote.getTicketId() == -1 && copyQuote.getOrgId() == this.getOrgId()) {
            copyQuote.setTicketId(this.getTicketId());
        }
        if (copyQuote.getVersion() == null || "".equals(copyQuote.getVersion())) {
            copyQuote.setVersion(this.getVersion());
        }
        if (copyQuote.getDeliveryId() == -1) {
            copyQuote.setDeliveryId(this.getDeliveryId());
        }
        if (copyQuote.getAddress() == null || "".equals(copyQuote.getAddress())) {
            copyQuote.setAddress(this.getAddress());
        }
        if (copyQuote.getEmailAddress() == null || "".equals(copyQuote.getEmailAddress())) {
            copyQuote.setEmailAddress(this.getEmailAddress());
        }
        if (copyQuote.getPhoneNumber() == null || "".equals(copyQuote.getPhoneNumber())) {
            copyQuote.setPhoneNumber(this.getPhoneNumber());
        }
        if (copyQuote.getFaxNumber() == null || "".equals(copyQuote.getFaxNumber())) {
            copyQuote.setFaxNumber(this.getFaxNumber());
        }
        if (copyQuote.getLogoFileId() == -1 && copyQuote.getOrgId() == this.getOrgId()) {
            copyQuote.setLogoFileId(this.getLogoFileId());
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            copyQuote.insert(db);
            for (QuoteRemark quoteRemark : this.remarks) {
                quoteRemark.copyQuoteRemark(db, copyQuote.getId());
            }
            for (QuoteCondition quoteCondition : this.conditions) {
                quoteCondition.copyQuoteCondition(db, copyQuote.getId());
            }
            for (QuoteProduct quoteProduct : this.productList) {
                quoteProduct.copyQuoteProduct(db, copyQuote.getId());
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return copyQuote;
    }

    public Quote clone(Connection db) throws SQLException {
        Quote newQuote = null;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            Quote clone = new Quote();
            clone.setVersion(clone.getNewVersion());
            clone.setNotes("Cloned from Quote #" + this.getGroupId() + " version " + this.getVersion() + "\n\n");
            clone.createNewGroup(db);
            newQuote = this.copyQuote(db, clone);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                System.out.println("Quote-> Clone failed..roll back");
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return newQuote;
    }

    public Quote clone(Connection db, Quote clone) throws SQLException {
        Quote newQuote = null;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            String oldNotes = clone.getNotes();
            clone.setNotes("Cloned from Quote #" + this.getGroupId() + " version " + this.getVersion() + "\n\n");
            if (oldNotes != null && !"".equals(oldNotes)) {
                clone.setNotes(clone.getNotes() + oldNotes + "\n");
            }
            clone.setVersion(clone.getNewVersion());
            clone.createNewGroup(db);
            newQuote = this.copyQuote(db, clone);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                System.out.println("Quote-> CLONE FAILED..ROLL BACK");
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return newQuote;
    }

    public Quote addVersion(Connection db) throws SQLException {
        Quote verQuote = new Quote();
        Quote rootQuote = new Quote(db, this.getRootQuote(db, this.getParentId()));
        verQuote.setVersion(rootQuote.getNewVersion());
        verQuote.setNotes("Version derived from Quote #" + this.getGroupId() + " version " + this.getVersion() + "\n\n");
        verQuote.setGroupId(this.getGroupId());
        verQuote = this.copyQuote(db, verQuote);
        rootQuote.setParentId(verQuote.getId());
        rootQuote.update(db);
        return verQuote;
    }

    public Quote addVersion(Connection db, Quote verQuote) throws SQLException {
        Quote rootQuote = new Quote(db, this.getRootQuote(db, this.getParentId()));
        verQuote.setVersion(rootQuote.getNewVersion());
        String oldNotes = verQuote.getNotes();
        verQuote.setNotes("Version derived from Quote #" + this.getGroupId() + " version " + this.getVersion() + "\n\n");
        if (oldNotes != null && !"".equals(oldNotes)) {
            verQuote.setNotes(verQuote.getNotes() + oldNotes + "\n");
        }
        verQuote.setGroupId(this.getGroupId());
        verQuote = this.copyQuote(db, verQuote);
        rootQuote.setParentId(verQuote.getId());
        rootQuote.update(db);
        return verQuote;
    }

    public String getNewVersion() {
        return new String(this.getVersionNumber() + 1 + ".0");
    }

    public int getVersionNumber() {
        return (int)Math.round(Double.parseDouble(this.getVersion()));
    }

    public int getRootQuote(Connection db, int parentId) throws SQLException {
        Quote rootQuote;
        int result = -1;
        result = parentId == -1 ? this.getId() : ((rootQuote = new Quote(db, parentId)).getParentId() != -1 ? rootQuote.getRootQuote(db, rootQuote.getParentId()) : rootQuote.getId());
        return result;
    }

    public void createNewGroup(Connection db) throws SQLException {
        PreparedStatement pst = null;
        this.id = DatabaseUtils.getNextSeq(db, "quote_group_group_id_seq");
        pst = db.prepareStatement("INSERT INTO quote_group (" + (this.id > -1 ? "group_id, " : "") + "unused) VALUES " + "(" + (this.id > -1 ? "?, " : "") + "null) ");
        if (this.id > -1) {
            pst.setInt(1, this.id);
        }
        pst.execute();
        pst.close();
        this.setGroupId(DatabaseUtils.getCurrVal(db, "quote_group_group_id_seq", this.id));
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("grand_total");
        return thisList;
    }

    public void buildHistory(Connection db) throws SQLException {
        this.history.setQuoteId(this.getId());
        if (this.systemStatus != null) {
            this.history.setSystemStatus(this.systemStatus);
        }
        this.history.buildList(db);
    }

    public void buildConditions(Connection db) throws SQLException {
        QuoteConditionList condtns = new QuoteConditionList();
        condtns.setQuoteId(this.getId());
        condtns.buildList(db);
        this.setConditions(condtns);
    }

    public void updateEntry(Connection db) throws SQLException {
        QuoteLog thisEntry = new QuoteLog();
        thisEntry.setQuoteId(this.getId());
        thisEntry.setEnteredBy(this.getModifiedBy());
        thisEntry.setStatusId(this.getStatusId());
        thisEntry.setSourceId(this.getSourceId());
        thisEntry.setTermsId(this.getQuoteTermsId());
        thisEntry.setTypeId(this.getQuoteTypeId());
        thisEntry.setDeliveryId(this.getDeliveryId());
        thisEntry.setIssuedDate(this.getIssuedDate());
        thisEntry.setGrandTotal(this.getGrandTotal());
        if (this.getCloseIt() && this.getClosed() == null) {
            thisEntry.setClosed(new Timestamp(System.currentTimeMillis()));
        } else {
            thisEntry.setClosed(this.getClosed());
        }
        thisEntry.process(db, this.getId(), this.getEnteredBy(), this.getModifiedBy());
    }

    public String getSubmitActionString() {
        if (this.getSubmitAction() == 2004110802) {
            return "Email";
        }
        if (this.getSubmitAction() == 2004110803) {
            return "Fax";
        }
        if (this.getSubmitAction() == 2004110801) {
            return "Print";
        }
        return "Error";
    }

    public boolean hasExpired() {
        return this.getExpirationDate() != null && this.getExpirationDate().before(Calendar.getInstance().getTime());
    }
}

