/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteCondition
extends GenericBean {
    private int id = -1;
    private int quoteId = -1;
    private int conditionId = -1;
    private String conditionName = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public int getConditionId() {
        return this.conditionId;
    }

    public void setConditionId(int tmp) {
        this.conditionId = tmp;
    }

    public void setConditionId(String tmp) {
        this.conditionId = Integer.parseInt(tmp);
    }

    public String getConditionName() {
        return this.conditionName;
    }

    public void setConditionName(String tmp) {
        this.conditionName = tmp;
    }

    public QuoteCondition() {
    }

    public QuoteCondition(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public QuoteCondition(Connection db, int mapId) throws SQLException {
        this.queryRecord(db, mapId);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote Condition ID");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT qc.*, lqc.description AS condition_name FROM quote_condition qc LEFT JOIN quote_entry qe ON (qc.quote_id = qe.quote_id) LEFT JOIN lookup_quote_condition lqc ON (qc.condition_id = lqc.code) WHERE qc.map_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Quote Condition Entry not found");
        }
    }

    public void queryRecord(Connection db, int qId, int cId) throws SQLException {
        if (qId == -1 || cId == -1) {
            throw new SQLException("Invalid Quote Id and Condition ID");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT qc.*, lqc.description AS condition_name FROM quote_condition qc LEFT JOIN quote_entry qe ON (qc.quote_id = qe.quote_id) LEFT JOIN lookup_quote_condition lqc ON (qc.condition_id = lqc.code) WHERE qc.condition_id = ? AND qc.quote_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, cId);
        pst.setInt(2, qId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Quote Condition Entry not found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("map_id"));
        this.setQuoteId(rs.getInt("quote_id"));
        this.setConditionId(rs.getInt("condition_id"));
        this.setConditionName(rs.getString("condition_name"));
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.quoteId == -1 || this.conditionId == -1) {
            return false;
        }
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "quote_condition_map_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO quote_condition (" + (this.id > -1 ? "map_id, " : "") + "quote_id, condition_id ) " + "VALUES (" + (this.id > -1 ? "?," : "") + "?,?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getQuoteId());
        pst.setInt(++i, this.getConditionId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "quote_condition_map_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote Condition ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM quote_condition WHERE map_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int insertLookup(Connection db, String description) throws SQLException {
        int tempId = DatabaseUtils.getNextSeq(db, "lookup_quote_condition_code_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_quote_condition (" + (tempId > -1 ? "code, " : "") + "description) " + "VALUES (" + (tempId > -1 ? "?," : "") + "?)");
        if (tempId > -1) {
            pst.setInt(++i, tempId);
        }
        pst.setString(++i, description);
        pst.execute();
        pst.close();
        return DatabaseUtils.getCurrVal(db, "lookup_quote_condition_code_seq", tempId);
    }

    public void copyQuoteCondition(Connection db, int quoteId) throws SQLException {
        QuoteCondition copy = new QuoteCondition();
        copy.setConditionId(this.getConditionId());
        copy.setConditionName(this.getConditionName());
        copy.setQuoteId(quoteId);
        copy.insert(db);
    }
}

