/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteList
extends ArrayList
implements SyncableList {
    public static final String tableName = "quote_entry";
    public static final String uniqueField = "quote_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int parentId = -1;
    private int orgId = -1;
    private int contactId = -1;
    private int sourceId = -1;
    private int statusId = -1;
    private int typeId = -1;
    private int ticketId = -1;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int categoryId = -1;
    private int groupId = -1;
    private String productName = null;
    private boolean buildResources = false;
    private int closedOnly = -1;
    private int headerId = -1;
    private String version = null;
    private int topOnly = 1;
    private boolean buildCompleteVersionList = false;
    protected Timestamp alertRangeStart = null;
    protected Timestamp alertRangeEnd = null;
    protected int deliveryId = -1;
    protected int submitAction = -1;
    protected Timestamp closed = null;
    protected String sku = null;
    private int logoFileId = -1;
    private boolean deleteAllQuotes = false;
    private int siteId = -1;
    private Timestamp trashedDate = null;
    private boolean includeOnlyTrashed = false;
    private boolean exclusiveToSite = false;
    private boolean includeAllSites = true;

    public int getLogoFileId() {
        return this.logoFileId;
    }

    public void setLogoFileId(int tmp) {
        this.logoFileId = tmp;
    }

    public void setLogoFileId(String tmp) {
        this.logoFileId = Integer.parseInt(tmp);
    }

    public void setCategoryId(int tmp) {
        this.categoryId = tmp;
    }

    public void setCategoryId(String tmp) {
        this.categoryId = Integer.parseInt(tmp);
    }

    public void setClosedOnly(int tmp) {
        this.closedOnly = tmp;
    }

    public void setClosedOnly(String tmp) {
        this.closedOnly = Integer.parseInt(tmp);
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public void setHeaderId(int tmp) {
        this.headerId = tmp;
    }

    public void setHeaderId(String tmp) {
        this.headerId = Integer.parseInt(tmp);
    }

    public void setVersion(String tmp) {
        this.version = tmp;
    }

    public void setTopOnly(int tmp) {
        this.topOnly = tmp;
    }

    public void setTopOnly(String tmp) {
        this.topOnly = Integer.parseInt(tmp);
    }

    public void setParentId(int tmp) {
        this.parentId = tmp;
    }

    public void setParentId(String tmp) {
        this.parentId = Integer.parseInt(tmp);
    }

    public void setBuildCompleteVersionList(boolean tmp) {
        this.buildCompleteVersionList = tmp;
    }

    public void setBuildCompleteVersionList(String tmp) {
        this.buildCompleteVersionList = DatabaseUtils.parseBoolean(tmp);
    }

    public void setGroupId(int tmp) {
        this.groupId = tmp;
    }

    public void setGroupId(String tmp) {
        this.groupId = Integer.parseInt(tmp);
    }

    public void setSiteId(int tmp) {
        this.siteId = tmp;
    }

    public void setSiteId(String tmp) {
        this.siteId = Integer.parseInt(tmp);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public boolean getBuildCompleteVersionList() {
        return this.buildCompleteVersionList;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getTopOnly() {
        return this.topOnly;
    }

    public String getVersion() {
        return this.version;
    }

    public int getHeaderId() {
        return this.headerId;
    }

    public String getProductName() {
        return this.productName;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public int getClosedOnly() {
        return this.closedOnly;
    }

    public int getCategoryId() {
        return this.categoryId;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setTicketId(int tmp) {
        this.ticketId = tmp;
    }

    public void setTicketId(String tmp) {
        this.ticketId = Integer.parseInt(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getId() {
        return this.id;
    }

    public void setOrgId(int tmp) {
        this.orgId = tmp;
    }

    public void setOrgId(String tmp) {
        this.orgId = Integer.parseInt(tmp);
    }

    public void setContactId(int tmp) {
        this.contactId = tmp;
    }

    public void setContactId(String tmp) {
        this.contactId = Integer.parseInt(tmp);
    }

    public void setSourceId(int tmp) {
        this.sourceId = tmp;
    }

    public void setSourceId(String tmp) {
        this.sourceId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public void setAlertRangeStart(Timestamp tmp) {
        this.alertRangeStart = tmp;
    }

    public void setAlertRangeStart(String tmp) {
        this.alertRangeStart = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setAlertRangeEnd(Timestamp tmp) {
        this.alertRangeEnd = tmp;
    }

    public void setAlertRangeEnd(String tmp) {
        this.alertRangeEnd = DatabaseUtils.parseTimestamp(tmp);
    }

    public Timestamp getAlertRangeStart() {
        return this.alertRangeStart;
    }

    public Timestamp getAlertRangeEnd() {
        return this.alertRangeEnd;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getOrgId() {
        return this.orgId;
    }

    public int getContactId() {
        return this.contactId;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public int getTicketId() {
        return this.ticketId;
    }

    public int getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(int tmp) {
        this.deliveryId = tmp;
    }

    public void setDeliveryId(String tmp) {
        this.deliveryId = Integer.parseInt(tmp);
    }

    public int getSubmitAction() {
        return this.submitAction;
    }

    public void setSubmitAction(int tmp) {
        this.submitAction = tmp;
    }

    public void setSubmitAction(String tmp) {
        this.submitAction = Integer.parseInt(tmp);
    }

    public Timestamp getClosed() {
        return this.closed;
    }

    public void setClosed(Timestamp tmp) {
        this.closed = tmp;
    }

    public void setClosed(String tmp) {
        this.closed = DatabaseUtils.parseTimestamp(tmp);
    }

    public String getSku() {
        return this.sku;
    }

    public void setSku(String tmp) {
        this.sku = tmp;
    }

    public boolean getDeleteAllQuotes() {
        return this.deleteAllQuotes;
    }

    public void setDeleteAllQuotes(boolean tmp) {
        this.deleteAllQuotes = tmp;
    }

    public void setDeleteAllQuotes(String tmp) {
        this.deleteAllQuotes = DatabaseUtils.parseBoolean(tmp);
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public int getSiteId() {
        return this.siteId;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public boolean getExclusiveToSite() {
        return this.exclusiveToSite;
    }

    public void setExclusiveToSite(boolean tmp) {
        this.exclusiveToSite = tmp;
    }

    public void setExclusiveToSite(String tmp) {
        this.exclusiveToSite = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getIncludeAllSites() {
        return this.includeAllSites;
    }

    public void setIncludeAllSites(boolean tmp) {
        this.includeAllSites = tmp;
    }

    public void setIncludeAllSites(String tmp) {
        this.includeAllSites = DatabaseUtils.parseBoolean(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM quote_entry qe  LEFT JOIN quote_group qg ON (qe.group_id = qg.group_id)  LEFT JOIN organization org ON (qe.org_id = org.org_id)  LEFT JOIN lookup_site_id lsi ON (org.site_id = lsi.code)  LEFT JOIN contact ct ON (qe.contact_id = ct.contact_id)  LEFT JOIN lookup_quote_status lqs ON ( qe.status_id = lqs.code )  LEFT JOIN opportunity_header opp ON (qe.opp_id = opp.opp_id)  WHERE qe.quote_id > -1 ");
        this.createFilter(sqlFilter, db);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("qe.entered", null);
            boolean flag = true;
            if (DatabaseUtils.getType(db) == 2 && this.pagedListInfo.getColumnToSortBy().equals("qe.short_description")) {
                sqlOrder.append("ORDER BY " + DatabaseUtils.convertToVarChar(db, "qe.short_description") + (this.pagedListInfo.getSortOrder() != null ? " DESC " : " "));
                flag = false;
            }
            if (flag) {
                this.pagedListInfo.appendSqlTail(db, sqlOrder);
            }
        } else {
            sqlOrder.append("ORDER BY qe.quote_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" qe.*,  org.name, ct.namelast, ct.namefirst, ct.namemiddle, lqs.description AS statusName, opp." + DatabaseUtils.addQuotes(db, "lock") + " AS opplock, " + " lsi.description AS sitename " + " FROM quote_entry qe " + " LEFT JOIN quote_group qg ON (qe.group_id = qg.group_id) " + " LEFT JOIN organization org ON (qe.org_id = org.org_id) " + " LEFT JOIN lookup_site_id lsi ON (org.site_id = lsi.code) " + " LEFT JOIN contact ct ON (qe.contact_id = ct.contact_id) " + " LEFT JOIN lookup_quote_status lqs ON ( qe.status_id = lqs.code ) " + " LEFT JOIN opportunity_header opp ON (qe.opp_id = opp.opp_id) " + " WHERE qe.quote_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Quote thisQuote = new Quote(rs);
            this.add(thisQuote);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (Quote thisQuote : this) {
                thisQuote.buildProducts(db);
                thisQuote.retrieveTicket(db);
            }
        }
        if (this.getBuildCompleteVersionList()) {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                Quote quote = (Quote)((Object)this.get(i));
                quote.setBuildCompleteVersionList(true);
                quote.buildVersionList(db);
                if (quote.getVersionList().size() <= 0) continue;
                this.addAll(this.size(), quote.getVersionList());
            }
        }
    }

    protected int filterOnProductName(Connection db) throws SQLException {
        int counter = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Quote quote = (Quote)((Object)iterator.next());
            quote.setBuildProducts(true);
            quote.getProductList().setProductName(this.getProductName());
            quote.queryRecord(db, quote.getId());
            if (quote.getProductList().size() == 0) {
                iterator.remove();
                continue;
            }
            ++counter;
        }
        return counter;
    }

    protected void createFilter(StringBuffer sqlFilter, Connection db) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND qe.quote_id = ? ");
        }
        if (this.parentId > -1) {
            sqlFilter.append(" AND qe.parent_id = ? ");
        }
        if (this.orgId > -1) {
            sqlFilter.append("AND qe.org_id = ? ");
        }
        if (this.contactId > -1) {
            sqlFilter.append("AND qe.contact_id = ? ");
        }
        if (this.sourceId > -1) {
            sqlFilter.append("AND qe.source_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND qe.status_id = ? ");
        }
        if (this.typeId > -1) {
            sqlFilter.append("AND qe.quote_type_id = ? ");
        }
        if (this.enteredBy > -1) {
            sqlFilter.append(" AND qe.enteredby = ? ");
        }
        if (this.modifiedBy > -1) {
            sqlFilter.append(" AND qe.modifiedby = ? ");
        }
        if (this.ticketId > -1) {
            sqlFilter.append(" AND qe.ticketid = ? ");
        }
        if (this.categoryId > -1) {
            sqlFilter.append("AND qe.product_id IN ( SELECT product_id  FROM product_catalog_category_map pccm  WHERE pccm.category_id = ? ) ");
        }
        if (this.closedOnly == 1) {
            sqlFilter.append(" AND qe.closed < " + DatabaseUtils.getCurrentTimestamp(db) + " ");
        } else if (this.closedOnly == 0) {
            sqlFilter.append(" AND (qe.closed > " + DatabaseUtils.getCurrentTimestamp(db) + " OR qe.closed IS NULL ) ");
        }
        if (this.headerId > -1) {
            sqlFilter.append(" AND opp.opp_id = ? ");
        }
        if (this.version != null) {
            sqlFilter.append(" AND qe." + DatabaseUtils.addQuotes(db, "version") + " = ? ");
        }
        if (this.groupId != -1) {
            sqlFilter.append(" AND qe.group_id = ? ");
        }
        if (!this.deleteAllQuotes) {
            if (this.topOnly == 1) {
                sqlFilter.append(" AND qe.parent_id IS NULL ");
            } else if (this.topOnly == 0) {
                sqlFilter.append(" AND qe.parent_id IS NOT NULL ");
            }
        }
        if (this.deliveryId != -1) {
            sqlFilter.append(" AND qe.delivery_id = ? ");
        }
        if (this.submitAction == 0) {
            sqlFilter.append(" AND qe.submit_action IS NULL ");
        } else if (this.submitAction == 1) {
            sqlFilter.append(" AND qe.submit_action IS NOT NULL ");
        }
        if (this.productName != null && !"".equals(this.productName) && !"%%".equals(this.productName)) {
            sqlFilter.append("AND qe.quote_id IN ( SELECT pq.quote_id FROM quote_product pq LEFT JOIN product_catalog pctlg ON (pq.product_id = pctlg.product_id) WHERE pctlg.product_name LIKE ? ) ");
        }
        if (this.sku != null && !"".equals(this.sku) && !"%%".equals(this.sku)) {
            sqlFilter.append("AND qe.quote_id IN ( SELECT pq.quote_id FROM quote_product pq LEFT JOIN product_catalog pctlg ON (pq.product_id = pctlg.product_id) WHERE pctlg.sku LIKE ? ) ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            sqlFilter.append(" AND pctlg.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append(" AND pctlg.modified >= ? ");
            sqlFilter.append(" AND pctlg.entered < ? ");
            sqlFilter.append(" AND pctlg.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND pctlg.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND pctlg.entered < ? ");
            }
        }
        if (this.logoFileId != -1) {
            sqlFilter.append("AND qe.logo_file_id = ? ");
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1 && this.enteredBy == -1 && this.ticketId == -1 && this.parentId == -1 && this.headerId == -1) {
            if (this.siteId != -1) {
                sqlFilter.append("AND (org.site_id = ? ");
                if (!this.exclusiveToSite) {
                    sqlFilter.append("OR org.site_id IS NULL ");
                }
                sqlFilter.append(") ");
            } else {
                sqlFilter.append("AND org.site_id IS NULL ");
            }
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND qe.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND qe.trashed_date = ? ");
        } else {
            sqlFilter.append("AND qe.trashed_date IS NULL ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.parentId > -1) {
            pst.setInt(++i, this.parentId);
        }
        if (this.orgId > -1) {
            pst.setInt(++i, this.orgId);
        }
        if (this.contactId > -1) {
            pst.setInt(++i, this.contactId);
        }
        if (this.sourceId > -1) {
            pst.setInt(++i, this.sourceId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.enteredBy);
        }
        if (this.modifiedBy > -1) {
            pst.setInt(++i, this.modifiedBy);
        }
        if (this.ticketId > -1) {
            pst.setInt(++i, this.ticketId);
        }
        if (this.categoryId > -1) {
            pst.setInt(++i, this.categoryId);
        }
        if (this.headerId > -1) {
            pst.setInt(++i, this.headerId);
        }
        if (this.version != null) {
            pst.setString(++i, this.version);
        }
        if (this.groupId != -1) {
            pst.setInt(++i, this.groupId);
        }
        if (this.deliveryId != -1) {
            pst.setInt(++i, this.deliveryId);
        }
        if (this.productName != null && !"".equals(this.productName) && !"%%".equals(this.productName)) {
            pst.setString(++i, this.productName);
        }
        if (this.sku != null && !"".equals(this.sku) && !"%%".equals(this.sku)) {
            pst.setString(++i, this.sku);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        if (this.logoFileId != -1) {
            pst.setInt(++i, this.logoFileId);
        }
        if (!this.includeAllSites && this.orgId == -1 && this.contactId == -1 && this.enteredBy == -1 && this.ticketId == -1 && this.parentId == -1 && this.headerId == -1 && this.siteId != -1) {
            pst.setInt(++i, this.siteId);
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        return i;
    }

    public void delete(Connection db) throws SQLException {
        Iterator quotes = this.iterator();
        while (quotes.hasNext()) {
            Quote quote = (Quote)((Object)quotes.next());
            quote.delete(db);
            quotes.remove();
        }
    }

    public QuoteList filterMyQuotes(Connection db) throws SQLException {
        for (Quote quote : this) {
            if (quote.getEnteredBy() == quote.getTicket().getAssignedTo()) continue;
            this.remove((Object)quote);
        }
        return this;
    }

    public void removeLogoLink(Connection db) throws SQLException {
        for (Quote quote : this) {
            quote.setLogoFileId(-1);
            quote.update(db);
        }
    }

    public static int retrieveRecordCount(Connection db, int moduleId, int itemId) throws SQLException {
        int count = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT COUNT(DISTINCT(group_id)) AS itemcount FROM quote_entry qe WHERE qe.quote_id > 0 AND qe.trashed_date IS NULL ");
        if (moduleId == 1) {
            sql.append("AND qe.org_id = ? ");
        } else if (moduleId == 2) {
            sql.append("AND qe.contact_id = ? ");
        }
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (moduleId == 1) {
            pst.setInt(1, itemId);
        } else if (moduleId == 2) {
            pst.setInt(1, itemId);
        }
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            count = rs.getInt("itemcount");
        }
        rs.close();
        pst.close();
        return count;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        for (Quote tmpQuote : this) {
            tmpQuote.updateStatus(db, toTrash, tmpUserId);
        }
        return true;
    }
}

