/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteLog
extends GenericBean {
    private int id = -1;
    private int quoteId = -1;
    private int sourceId = -1;
    private double grandTotal = 0.0;
    private int statusId = -1;
    private int termsId = -1;
    private int typeId = -1;
    private String notes = null;
    private int deliveryId = -1;
    private Timestamp issuedDate = null;
    private int submitAction = -1;
    private Timestamp closed = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private String sourceName = null;
    private String statusName = null;
    private String termsName = null;
    private String typeName = null;
    private String deliveryName = null;
    private String lastName = null;
    private String firstName = null;
    private boolean systemMessage = false;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public void setSourceId(int tmp) {
        this.sourceId = tmp;
    }

    public void setSourceId(String tmp) {
        this.sourceId = Integer.parseInt(tmp);
    }

    public double getGrandTotal() {
        return this.grandTotal;
    }

    public void setGrandTotal(double tmp) {
        this.grandTotal = tmp;
    }

    public void setGrandTotal(String tmp) {
        this.grandTotal = Double.parseDouble(tmp);
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getTermsId() {
        return this.termsId;
    }

    public void setTermsId(int tmp) {
        this.termsId = tmp;
    }

    public void setTermsId(String tmp) {
        this.termsId = Integer.parseInt(tmp);
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public int getDeliveryId() {
        return this.deliveryId;
    }

    public void setDeliveryId(int tmp) {
        this.deliveryId = tmp;
    }

    public void setDeliveryId(String tmp) {
        this.deliveryId = Integer.parseInt(tmp);
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public void setSourceName(String tmp) {
        this.sourceName = tmp;
    }

    public String getStatusName() {
        return this.statusName;
    }

    public void setStatusName(String tmp) {
        this.statusName = tmp;
    }

    public String getTermsName() {
        return this.termsName;
    }

    public void setTermsName(String tmp) {
        this.termsName = tmp;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String tmp) {
        this.typeName = tmp;
    }

    public String getDeliveryName() {
        return this.deliveryName;
    }

    public void setDeliveryName(String tmp) {
        this.deliveryName = tmp;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String tmp) {
        this.lastName = tmp;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String tmp) {
        this.firstName = tmp;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public boolean getSystemMessage() {
        return this.systemMessage;
    }

    public void setSystemMessage(boolean tmp) {
        this.systemMessage = tmp;
    }

    public void setSystemMessage(String tmp) {
        this.systemMessage = DatabaseUtils.parseBoolean(tmp);
    }

    public Timestamp getIssuedDate() {
        return this.issuedDate;
    }

    public void setIssuedDate(Timestamp tmp) {
        this.issuedDate = tmp;
    }

    public void setIssuedDate(String tmp) {
        this.issuedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getSubmitAction() {
        return this.submitAction;
    }

    public void setSubmitAction(int tmp) {
        this.submitAction = tmp;
    }

    public void setSubmitAction(String tmp) {
        this.submitAction = Integer.parseInt(tmp);
    }

    public Timestamp getClosed() {
        return this.closed;
    }

    public void setClosed(Timestamp tmp) {
        this.closed = tmp;
    }

    public void setClosed(String tmp) {
        this.closed = DatabaseUtils.parseTimestamp(tmp);
    }

    public QuoteLog() {
    }

    public QuoteLog(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public QuoteLog(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote Log Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT q.*, lqso.description AS source_name, lqst.description AS status_name, lqtm.description AS terms_name, lqty.description AS type_name, lqd.description AS delivery_name,ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst FROM quotelog q LEFT JOIN contact ct_eb ON (q.enteredby = ct_eb.user_id) LEFT JOIN lookup_quote_status lqst ON (q.status_id = lqst.code) LEFT JOIN lookup_quote_source lqso ON (q.source_id = lqso.code) LEFT JOIN lookup_quote_terms lqtm ON (q.terms_id = lqtm.code) LEFT JOIN lookup_quote_type lqty ON (q.type_id = lqty.code) LEFT JOIN lookup_quote_delivery lqd ON (q.delivery_id = lqd.code) WHERE q.id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("QuoteLog not found");
        }
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.quoteId == -1) {
            throw new SQLException("Log entry must be associated with a Quote");
        }
        StringBuffer sql = new StringBuffer();
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            this.id = DatabaseUtils.getNextSeq(db, "quotelog_id_seq");
            sql.append("INSERT INTO quotelog (quote_id, source_id, status_id,");
            sql.append("terms_id, type_id, delivery_id, notes, grand_total, issued_date, submit_action, closed, ");
            if (this.id > -1) {
                sql.append("id, ");
            }
            if (this.entered != null) {
                sql.append(" entered, ");
            }
            if (this.modified != null) {
                sql.append(" modified, ");
            }
            sql.append(" enteredby, modifiedby) ");
            sql.append("VALUES (?,?,?,?,?,?,?,?,?,?,?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?,");
            }
            if (this.modified != null) {
                sql.append("?,");
            }
            sql.append("?,?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.quoteId);
            DatabaseUtils.setInt(pst, ++i, this.sourceId);
            DatabaseUtils.setInt(pst, ++i, this.statusId);
            DatabaseUtils.setInt(pst, ++i, this.termsId);
            DatabaseUtils.setInt(pst, ++i, this.typeId);
            DatabaseUtils.setInt(pst, ++i, this.deliveryId);
            pst.setString(++i, this.getNotes());
            pst.setDouble(++i, this.getGrandTotal());
            DatabaseUtils.setTimestamp(pst, ++i, this.issuedDate);
            DatabaseUtils.setInt(pst, ++i, this.submitAction);
            DatabaseUtils.setTimestamp(pst, ++i, this.closed);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "quotelog_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public void process(Connection db, int quoteId, int enteredBy, int modifiedBy) throws SQLException {
        if (quoteId != -1) {
            this.setEnteredBy(modifiedBy);
            this.setModifiedBy(modifiedBy);
            this.insert(db);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote Log ID not specified.");
        }
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            Statement st = db.createStatement();
            st.executeUpdate("DELETE FROM quotelog WHERE id = " + this.getId());
            st.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    protected boolean isValid() {
        this.errors.clear();
        return this.quoteId != -1 && this.notes != null && !this.notes.trim().equals("") && this.enteredBy != -1 && this.modifiedBy != -1;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = DatabaseUtils.getInt(rs, "id");
        this.quoteId = DatabaseUtils.getInt(rs, "quote_id");
        this.sourceId = DatabaseUtils.getInt(rs, "source_id");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.termsId = DatabaseUtils.getInt(rs, "terms_id");
        this.typeId = DatabaseUtils.getInt(rs, "type_id");
        this.deliveryId = DatabaseUtils.getInt(rs, "delivery_id");
        this.notes = rs.getString("notes");
        this.grandTotal = rs.getDouble("grand_total");
        this.enteredBy = DatabaseUtils.getInt(rs, "enteredby");
        this.entered = rs.getTimestamp("entered");
        this.modifiedBy = DatabaseUtils.getInt(rs, "modifiedby");
        this.modified = rs.getTimestamp("modified");
        this.issuedDate = rs.getTimestamp("issued_date");
        this.submitAction = DatabaseUtils.getInt(rs, "submit_action");
        this.closed = rs.getTimestamp("closed");
        this.sourceName = rs.getString("source_name");
        this.statusName = rs.getString("status_name");
        this.termsName = rs.getString("terms_name");
        this.typeName = rs.getString("type_name");
        this.deliveryName = rs.getString("delivery_name");
        this.setFirstName(rs.getString("eb_namefirst"));
        this.setLastName(rs.getString("eb_namelast"));
    }

    protected void buildRecord(HttpServletRequest request) {
        this.setNotes(request.getParameter("notes"));
        this.setQuoteId(Integer.parseInt(request.getParameter("quoteId")));
    }

    public void createSysMsg(QuoteLog source) {
        this.setEnteredBy(source.getModifiedBy());
        this.setEntered(source.getEntered());
        this.setModifiedBy(source.getModifiedBy());
        this.setModified(source.getEntered());
        this.setQuoteId(source.getQuoteId());
        this.setSourceId(source.getSourceId());
        this.setStatusId(source.getStatusId());
        this.setTermsId(source.getTermsId());
        this.setTypeId(source.getTypeId());
        this.setDeliveryId(source.getDeliveryId());
        this.setIssuedDate(source.getIssuedDate());
        this.setSubmitAction(source.getSubmitAction());
        this.setClosed(source.getClosed());
        this.setSystemMessage(true);
        this.setSourceName(source.getSourceName());
        this.setStatusName(source.getStatusName());
        this.setTermsName(source.getTermsName());
        this.setTypeName(source.getTypeName());
        this.setDeliveryName(source.getDeliveryName());
        this.setLastName(source.getLastName());
        this.setFirstName(source.getFirstName());
    }
}

