/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.quotes.base.QuoteLog;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteLogList
extends ArrayList {
    public static final String tableName = "quotelog";
    public static final String uniqueField = "id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int quoteId = -1;
    private boolean doSystemMessages = true;
    private SystemStatus systemStatus = null;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public boolean getDoSystemMessages() {
        return this.doSystemMessages;
    }

    public void setDoSystemMessages(boolean tmp) {
        this.doSystemMessages = tmp;
    }

    public void setDoSystemMessages(String tmp) {
        this.doSystemMessages = DatabaseUtils.parseBoolean(tmp);
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public QuoteLogList() {
    }

    public QuoteLogList(HttpServletRequest request, int userId) {
        if (request.getParameter("newquotelogentry") != null) {
            QuoteLog thisEntry = new QuoteLog();
            thisEntry.setEnteredBy(userId);
            thisEntry.buildRecord(request);
            if (thisEntry.isValid()) {
                this.add(thisEntry);
            }
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM quotelog q WHERE q.id > 0 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND q.notes < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("q.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY q.entered ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("q.*, lqso.description AS source_name, lqst.description AS status_name, lqtm.description AS terms_name, lqty.description AS type_name, lqd.description AS delivery_name,ct_eb.namelast AS eb_namelast, ct_eb.namefirst AS eb_namefirst FROM quotelog q LEFT JOIN contact ct_eb ON (q.enteredby = ct_eb.user_id) LEFT JOIN lookup_quote_status lqst ON (q.status_id = lqst.code) LEFT JOIN lookup_quote_source lqso ON (q.source_id = lqso.code) LEFT JOIN lookup_quote_terms lqtm ON (q.terms_id = lqtm.code) LEFT JOIN lookup_quote_type lqty ON (q.type_id = lqty.code) LEFT JOIN lookup_quote_delivery lqd ON (q.delivery_id = lqd.code) WHERE q.id > 0 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        QuoteLog prevQuoteLog = null;
        while (rs.next()) {
            QuoteLog thisQuoteLog = new QuoteLog(rs);
            if (this.doSystemMessages) {
                this.setSystemMessages(thisQuoteLog, prevQuoteLog);
                if (thisQuoteLog.getNotes() != null && !"".equals(thisQuoteLog.getNotes().trim())) {
                    this.add(thisQuoteLog);
                }
            } else {
                this.add(thisQuoteLog);
            }
            prevQuoteLog = thisQuoteLog;
        }
        rs.close();
        pst.close();
    }

    private void createFilter(StringBuffer sqlFilter) {
        if (this.quoteId > -1) {
            sqlFilter.append("AND q.quote_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    private int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.quoteId > -1) {
            pst.setInt(++i, this.quoteId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public String getLabel(SystemStatus systemStatus, HashMap map, String input) {
        Template template = new Template(input);
        template.setParseElements(map);
        return template.getParsedText();
    }

    public boolean setSystemMessages(QuoteLog current, QuoteLog prev) {
        HashMap<String, String> map;
        String logEntry;
        QuoteLog tempLog = null;
        if (prev == null) {
            HashMap<String, String> map2;
            String logEntry2;
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteCreated") + " ]");
            } else {
                tempLog.setNotes("[ Quote Created ]");
            }
            this.add(tempLog);
            if (current.getDeliveryId() > 0) {
                tempLog = new QuoteLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("quotes.quotelog.deliverySetTo.text");
                    if (logEntry2 != null) {
                        map2 = new HashMap<String, String>();
                        map2.put("${name}", current.getDeliveryName());
                        tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    }
                } else {
                    tempLog.setNotes("[ Delivery set to " + current.getDeliveryName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getSourceId() > 0) {
                tempLog = new QuoteLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("quotes.quotelog.sourceIs.text");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${name}", current.getSourceName());
                        tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    }
                } else {
                    tempLog.setNotes("[ The Source is " + current.getSourceName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getStatusId() > 0) {
                tempLog = new QuoteLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    logEntry2 = this.systemStatus.getLabel("quotes.quotelog.statusIs.text");
                    if (logEntry2 != null) {
                        map2 = new HashMap();
                        map2.put("${name}", current.getStatusName());
                        tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map2, logEntry2) + " ]");
                    }
                } else {
                    tempLog.setNotes("[ Status is " + current.getStatusName() + " ]");
                }
                this.add(tempLog);
            }
            if (current.getIssuedDate() != null) {
                tempLog = new QuoteLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteIssuedToCustomer") + " ]");
                } else {
                    tempLog.setNotes("[ Quote issued to the Customer ]");
                }
                this.add(tempLog);
            }
            if (current.getClosed() != null) {
                tempLog = new QuoteLog();
                tempLog.createSysMsg(current);
                if (this.systemStatus != null) {
                    tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteClosed") + " ]");
                } else {
                    tempLog.setNotes("[ Quote closed ]");
                }
                this.add(tempLog);
            }
            return true;
        }
        if (current.getSourceId() != prev.getSourceId()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("quotes.quotelog.quoteSourceChangedFrom.text");
                if (logEntry != null) {
                    map = new HashMap<String, String>();
                    map.put("${previousName}", this.isSet(prev.getSourceName()));
                    map.put("${currentName}", this.isSet(current.getSourceName()));
                    tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                }
            } else {
                tempLog.setNotes("[ Source changed from " + this.isSet(prev.getSourceName()) + " to " + this.isSet(current.getSourceName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getStatusId() != prev.getStatusId()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("quotes.quotelog.quoteStatusChangedFrom.text");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${previousName}", this.isSet(prev.getStatusName()));
                    map.put("${currentName}", this.isSet(current.getStatusName()));
                    tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                }
            } else {
                tempLog.setNotes("[ Status changed from " + this.isSet(prev.getStatusName()) + " to " + this.isSet(current.getStatusName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getIssuedDate() != prev.getIssuedDate()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (prev.getIssuedDate() != null) {
                if (this.systemStatus != null) {
                    tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteModifiedAndReIssued") + " ]");
                } else {
                    tempLog.setNotes("[ Quote modified and re-issued ]");
                }
            } else if (this.systemStatus != null) {
                tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteIssuedToCustomer") + " ]");
            } else {
                tempLog.setNotes("[ Quote issued to the Customer ]");
            }
            this.add(tempLog);
        }
        if (current.getTermsId() != prev.getTermsId()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("quotes.quotelog.termsChangedFrom.text");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${previousName}", this.isSet(prev.getTermsName()));
                    map.put("${currentName}", this.isSet(current.getTermsName()));
                    tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                }
            } else {
                tempLog.setNotes("[ Terms changed from " + this.isSet(prev.getTermsName()) + " to " + this.isSet(current.getTermsName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getTypeId() != prev.getTypeId()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("quotes.quotelog.typeChangedFrom.text");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${previousName}", this.isSet(prev.getTypeName()));
                    map.put("${currentName}", this.isSet(current.getTypeName()));
                    tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                }
            } else {
                tempLog.setNotes("[ Type changed from " + this.isSet(prev.getTypeName()) + " to " + this.isSet(current.getTypeName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getDeliveryId() != prev.getDeliveryId()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (this.systemStatus != null) {
                logEntry = this.systemStatus.getLabel("quotes.quotelog.deliveryChangedFrom.text");
                if (logEntry != null) {
                    map = new HashMap();
                    map.put("${previousName}", this.isSet(prev.getDeliveryName()));
                    map.put("${currentName}", this.isSet(current.getDeliveryName()));
                    tempLog.setNotes("[ " + this.getLabel(this.systemStatus, map, logEntry) + " ]");
                }
            } else {
                tempLog.setNotes("[ Delivery changed from " + this.isSet(prev.getDeliveryName()) + " to " + this.isSet(current.getDeliveryName()) + " ]");
            }
            this.add(tempLog);
        }
        if (current.getClosed() != prev.getClosed()) {
            tempLog = new QuoteLog();
            tempLog.createSysMsg(current);
            if (prev.getClosed() != null) {
                if (this.systemStatus != null) {
                    tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteClosedWithDifferentStatus") + " ]");
                } else {
                    tempLog.setNotes("[ Quote closed with a different status ]");
                }
            } else if (this.systemStatus != null) {
                tempLog.setNotes("[ " + this.systemStatus.getLabel("quotes.quotelog.quoteClosed") + " ]");
            } else {
                tempLog.setNotes("[ Quote closed ]");
            }
            this.add(tempLog);
        }
        return true;
    }

    private String isSet(String value) {
        if (value == null) {
            return "not set";
        }
        return value;
    }

    public void delete(Connection db) throws SQLException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            QuoteLog log = (QuoteLog)((Object)iterator.next());
            log.delete(db);
            iterator.remove();
        }
    }
}

