/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteNote
extends GenericBean {
    private int id = -1;
    private int quoteId = -1;
    private String notes = null;
    private int enteredBy = -1;
    private Timestamp entered = null;
    private int modifiedBy = -1;
    private Timestamp modified = null;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public QuoteNote() {
    }

    public QuoteNote(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public QuoteNote(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote id");
        }
        StringBuffer buffer = new StringBuffer(" SELECT n.*  FROM quote_notes n  WHERE n.quote_id = ? ");
        PreparedStatement pst = db.prepareStatement(buffer.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Quote Notes entry not found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("notes_id"));
        this.setQuoteId(DatabaseUtils.getInt(rs, "quote_id"));
        this.setNotes(rs.getString("notes"));
        this.setEnteredBy(rs.getInt("enteredby"));
        this.setEntered(rs.getTimestamp("entered"));
        this.setModifiedBy(rs.getInt("modifiedby"));
        this.setModified(rs.getTimestamp("modified"));
    }

    public boolean insert(Connection db) throws SQLException {
        boolean result = false;
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "quote_notes_notes_id_seq");
        sql.append("INSERT INTO quote_notes( quote_id, notes, ");
        if (this.id > -1) {
            sql.append("notes_id, ");
        }
        if (this.entered != null) {
            sql.append("entered, ");
        }
        sql.append("enteredby, ");
        if (this.modified != null) {
            sql.append("modified, ");
        }
        sql.append("modifiedby ) ");
        sql.append("VALUES (?, ?, ");
        if (this.id > -1) {
            sql.append("?,");
        }
        if (this.entered != null) {
            sql.append(" ?, ");
        }
        sql.append(" ?, ");
        if (this.modified != null) {
            sql.append(" ?, ");
        }
        sql.append(" ? ) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getQuoteId());
        pst.setString(++i, this.getNotes());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.entered != null) {
            pst.setTimestamp(++i, this.getEntered());
        }
        pst.setInt(++i, this.getEnteredBy());
        if (this.modified != null) {
            pst.setTimestamp(++i, this.getModified());
        }
        pst.setInt(++i, this.getModifiedBy());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "quote_notes_notes_id_seq", this.id);
        result = true;
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE quote_notes  SET quote_id = ?,  notes = ?,  modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + " modifiedby = ? " + " WHERE notes_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getQuoteId());
        pst.setString(++i, this.getNotes());
        DatabaseUtils.setInt(pst, ++i, this.getModifiedBy());
        DatabaseUtils.setInt(pst, ++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM quote_notes WHERE quote_id = ? AND notes_id = ? ");
        pst.setInt(1, this.getQuoteId());
        pst.setInt(2, this.getId());
        pst.execute();
        pst.close();
    }

    public static void delete(Connection db, int quoteId, int notesId) throws SQLException {
        PreparedStatement pst = null;
        pst = db.prepareStatement("DELETE FROM quote_notes WHERE quote_id = ? AND notes_id = ? ");
        pst.setInt(1, quoteId);
        pst.setInt(2, notesId);
        pst.execute();
        pst.close();
    }
}

