/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.base.SyncableList;
import org.aspcfs.modules.quotes.base.QuoteNote;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteNoteList
extends ArrayList
implements SyncableList {
    public static final String tableName = "quote_notes";
    public static final String uniqueField = "notes_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int quoteId = -1;
    private String notes = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private boolean buildResources = false;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public void setNotes(String tmp) {
        this.notes = tmp;
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setSyncType(String tmp) {
        this.syncType = Integer.parseInt(tmp);
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getId() {
        return this.id;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public String getNotes() {
        return this.notes;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public Timestamp getLastAnchor() {
        return this.lastAnchor;
    }

    public Timestamp getNextAnchor() {
        return this.nextAnchor;
    }

    public int getSyncType() {
        return this.syncType;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append(" SELECT COUNT(*) AS recordcount  FROM quote_notes n  WHERE n.notes_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("n.entered", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY notes_id");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append(" n.*  FROM quote_notes n  WHERE n.notes_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            QuoteNote thisQuoteNote = new QuoteNote(rs);
            this.add(thisQuoteNote);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND n.notes_id = ? ");
        }
        if (this.quoteId > -1) {
            sqlFilter.append("AND n.quote_id = ? ");
        }
        if (this.notes != null) {
            sqlFilter.append("AND n.notes = ? ");
        }
        if (this.enteredBy > -1) {
            sqlFilter.append("AND n.enteredby = ? ");
        }
        if (this.modifiedBy > -1) {
            sqlFilter.append("AND n.modifiedby = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND n.entered >= ? ");
            }
            sqlFilter.append(" AND n.entered < ? ");
        } else if (this.syncType == 3) {
            sqlFilter.append(" AND n.modified >= ? ");
            sqlFilter.append(" AND n.entered < ? ");
            sqlFilter.append(" AND n.modified < ? ");
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND n.entered >= ? ");
            }
            if (this.nextAnchor != null) {
                sqlFilter.append("AND n.entered < ? ");
            }
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.quoteId > -1) {
            pst.setInt(++i, this.getQuoteId());
        }
        if (this.notes != null) {
            pst.setString(++i, this.getNotes());
        }
        if (this.enteredBy > -1) {
            pst.setInt(++i, this.getEnteredBy());
        }
        if (this.modifiedBy > -1) {
            pst.setInt(++i, this.getModifiedBy());
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        } else if (this.syncType == 5) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            if (this.nextAnchor != null) {
                pst.setTimestamp(++i, this.nextAnchor);
            }
        }
        return i;
    }

    public String getAllNotes() throws SQLException {
        StringBuffer result = new StringBuffer("");
        for (QuoteNote note : this) {
            result.append("\n" + note.getNotes());
        }
        return result.toString();
    }

    public void delete(Connection db) throws SQLException {
        for (QuoteNote note : this) {
            note.delete(db);
        }
    }
}

