/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.products.base.ProductCatalogPricing;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.modules.quotes.base.QuoteProductOptionList;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteProduct
extends GenericBean {
    private int id = -1;
    private int quoteId = -1;
    private int productId = -1;
    private int quantity = 0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private double extendedPrice = 0.0;
    private double totalPrice = 0.0;
    private Timestamp estimatedDeliveryDate = null;
    private int statusId = -1;
    private Timestamp statusDate = null;
    private String estimatedDelivery = null;
    private String comment = null;
    private boolean buildProductOptions = false;
    private QuoteProductOptionList productOptionList = new QuoteProductOptionList();
    private boolean buildProduct = false;
    private ProductCatalog productCatalog = null;

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setQuantity(int tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Integer.parseInt(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public void setExtendedPrice(double tmp) {
        this.extendedPrice = tmp;
    }

    public void setTotalPrice(double tmp) {
        this.totalPrice = tmp;
    }

    public void setEstimatedDeliveryDate(Timestamp tmp) {
        this.estimatedDeliveryDate = tmp;
    }

    public void setEstimatedDeliveryDate(String tmp) {
        this.estimatedDeliveryDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setStatusDate(Timestamp tmp) {
        this.statusDate = tmp;
    }

    public void setStatusDate(String tmp) {
        this.statusDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setBuildProductOptions(boolean tmp) {
        this.buildProductOptions = tmp;
    }

    public void setBuildProductOptions(String tmp) {
        this.buildProductOptions = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductOptionList(QuoteProductOptionList tmp) {
        this.productOptionList = tmp;
    }

    public void setProductCatalog(ProductCatalog tmp) {
        this.productCatalog = tmp;
    }

    public void setBuildProduct(boolean tmp) {
        this.buildProduct = tmp;
    }

    public void setBuildProduct(String tmp) {
        this.buildProduct = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getBuildProduct() {
        return this.buildProduct;
    }

    public ProductCatalog getProductCatalog() {
        return this.productCatalog;
    }

    public int getId() {
        return this.id;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public int getProductId() {
        return this.productId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public double getExtendedPrice() {
        return this.extendedPrice;
    }

    public double getTotalPrice() {
        this.totalPrice = (double)this.getQuantity() * (this.getPriceAmount() - this.getExtendedPrice());
        for (QuoteProductOption option : this.getProductOptionList()) {
            this.totalPrice += (double)this.getQuantity() * option.getTotalPrice();
        }
        return this.totalPrice;
    }

    public Timestamp getEstimatedDeliveryDate() {
        return this.estimatedDeliveryDate;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public Timestamp getStatusDate() {
        return this.statusDate;
    }

    public boolean getBuildProductOptions() {
        return this.buildProductOptions;
    }

    public QuoteProductOptionList getProductOptionList() {
        return this.productOptionList;
    }

    public String getEstimatedDelivery() {
        return this.estimatedDelivery;
    }

    public void setEstimatedDelivery(String tmp) {
        this.estimatedDelivery = tmp;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String tmp) {
        this.comment = tmp;
    }

    public QuoteProduct() {
    }

    public QuoteProduct(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public QuoteProduct(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote Product Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT qp.* FROM quote_product qp LEFT JOIN product_catalog pctlg ON (qp.product_id = pctlg.product_id) WHERE qp.item_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Quote Product not found");
        }
        if (this.buildProduct) {
            this.buildProduct(db);
        }
        if (this.buildProductOptions) {
            this.buildProductOptions(db);
        }
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("item_id"));
        this.quoteId = rs.getInt("quote_id");
        this.productId = rs.getInt("product_id");
        this.quantity = rs.getInt("quantity");
        this.priceCurrency = DatabaseUtils.getInt(rs, "price_currency");
        this.priceAmount = DatabaseUtils.getDouble(rs, "price_amount");
        this.recurringCurrency = DatabaseUtils.getInt(rs, "recurring_currency");
        this.recurringAmount = DatabaseUtils.getDouble(rs, "recurring_amount");
        this.recurringType = DatabaseUtils.getInt(rs, "recurring_type");
        this.extendedPrice = DatabaseUtils.getDouble(rs, "extended_price");
        this.totalPrice = DatabaseUtils.getDouble(rs, "total_price");
        this.estimatedDeliveryDate = rs.getTimestamp("estimated_delivery_date");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.statusDate = rs.getTimestamp("status_date");
        this.estimatedDelivery = rs.getString("estimated_delivery");
        this.comment = rs.getString("comment");
    }

    public void buildProduct(Connection db) throws SQLException {
        this.productCatalog = new ProductCatalog(db, this.getProductId());
        this.productCatalog.buildActivePrice(db);
    }

    public void buildProductOptions(Connection db) throws SQLException {
        this.productOptionList = new QuoteProductOptionList();
        this.productOptionList.setItemId(this.getId());
        this.productOptionList.setBuildConfigDetails(true);
        this.productOptionList.buildList(db);
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "quote_product_item_id_seq");
        sql.append(" INSERT INTO quote_product(" + (this.id > -1 ? "item_id, " : "") + "quote_id, product_id, " + " quantity, price_currency, price_amount, recurring_currency, " + " recurring_amount, recurring_type, extended_price, " + " total_price, estimated_delivery_date, status_id, status_date, estimated_delivery, " + DatabaseUtils.addQuotes(db, "comment") + ")");
        sql.append("VALUES(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getQuoteId());
        pst.setInt(++i, this.getProductId());
        pst.setInt(++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getExtendedPrice());
        pst.setDouble(++i, this.getTotalPrice());
        DatabaseUtils.setTimestamp(pst, ++i, this.getEstimatedDeliveryDate());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        DatabaseUtils.setTimestamp(pst, ++i, this.getStatusDate());
        pst.setString(++i, this.getEstimatedDelivery());
        pst.setString(++i, this.getComment());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "quote_product_item_id_seq", this.id);
        return true;
    }

    public boolean insert(Connection db, QuoteProductOptionList optionList, HttpServletRequest request) throws SQLException {
        boolean status = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            status = this.insert(db);
            for (QuoteProductOption option : optionList) {
                option.setItemId(this.getId());
                status = option.insert(db);
                OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
                configurator.queryProperties(db, option.getOptionId(), false);
                configurator.saveQuoteOption(db, option.getId(), request);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return status;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Item ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            this.setBuildProductOptions(true);
            this.buildProductOptions(db);
            if (this.getProductOptionList().size() > 0) {
                this.productOptionList.delete(db);
            }
            this.productOptionList = null;
            PreparedStatement pst = db.prepareStatement(" DELETE FROM quote_product WHERE item_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            StringBuffer sql = new StringBuffer();
            sql.append(" UPDATE quote_product  SET quantity = ? ,      price_currency = ?,      price_amount = ?,      recurring_currency = ?,      recurring_amount = ?,      recurring_type = ?,      extended_price = ?,      total_price = ?,      estimated_delivery_date = ?,      status_id = ?,      status_date = ?,      estimated_delivery = ?,      " + DatabaseUtils.addQuotes(db, "comment") + " = ? " + " WHERE item_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            DatabaseUtils.setInt(pst, ++i, this.getQuantity());
            DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
            pst.setDouble(++i, this.getPriceAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
            pst.setDouble(++i, this.getRecurringAmount());
            DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
            pst.setDouble(++i, this.getExtendedPrice());
            pst.setDouble(++i, this.getTotalPrice());
            pst.setTimestamp(++i, this.getEstimatedDeliveryDate());
            DatabaseUtils.setInt(pst, ++i, this.getStatusId());
            pst.setTimestamp(++i, this.getStatusDate());
            pst.setString(++i, this.getEstimatedDelivery());
            pst.setString(++i, this.getComment());
            pst.setInt(++i, this.getId());
            resultCount = pst.executeUpdate();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public int update(Connection db, HttpServletRequest request) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            throw new SQLException("Quote Product Option ID not specified");
        }
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            resultCount = this.update(db);
            for (QuoteProductOption thisOption : this.getProductOptionList()) {
                OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, thisOption.getConfiguratorId());
                configurator.queryProperties(db, thisOption.getOptionId(), false);
                configurator.queryQuoteProperties(db, thisOption.getId());
                double priceAdjust = configurator.computePriceAdjust(request);
                thisOption.setPriceAmount(priceAdjust);
                thisOption.setTotalPrice(priceAdjust);
                thisOption.update(db);
                configurator.updateQuoteOption(db, thisOption.getId(), request);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return resultCount;
    }

    public static ArrayList getTimeZoneParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("estimatedDeliveryDate");
        thisList.add("statusDate");
        return thisList;
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("price_amount");
        thisList.add("recurring_amount");
        thisList.add("extended_price");
        thisList.add("total_price");
        return thisList;
    }

    public void copyQuoteProduct(Connection db, int quoteId) throws SQLException {
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            QuoteProduct copyProduct = new QuoteProduct();
            copyProduct.setBuildProduct(this.getBuildProduct());
            copyProduct.setBuildProductOptions(this.getBuildProductOptions());
            copyProduct.setEstimatedDeliveryDate(this.getEstimatedDeliveryDate());
            copyProduct.setExtendedPrice(this.getExtendedPrice());
            copyProduct.setPriceAmount(this.getPriceAmount());
            copyProduct.setPriceCurrency(this.getPriceCurrency());
            copyProduct.setProductId(this.getProductId());
            copyProduct.setQuantity(this.getQuantity());
            copyProduct.setQuoteId(quoteId);
            copyProduct.setRecurringAmount(this.getRecurringAmount());
            copyProduct.setRecurringCurrency(this.getRecurringCurrency());
            copyProduct.setRecurringType(this.getRecurringType());
            copyProduct.setComment(this.getComment());
            copyProduct.setEstimatedDelivery(this.getEstimatedDelivery());
            copyProduct.insert(db);
            for (QuoteProductOption option : this.getProductOptionList()) {
                option.copyQuoteProductOption(db, copyProduct.getId());
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
    }

    public void buildPricing(Connection db) throws SQLException {
        if (this.getProductCatalog() == null && this.getProductId() != -1) {
            ProductCatalog product = new ProductCatalog(db, this.getProductId());
            product.buildActivePrice(db);
            this.setProductCatalog(product);
        } else if (this.getProductCatalog() == null && this.getProductId() == -1) {
            throw new SQLException("Product ID not provided");
        }
        if (this.getProductCatalog().getActivePrice() == null) {
            throw new SQLException("The selected product does not have an enabled price");
        }
        ProductCatalogPricing price = this.getProductCatalog().getActivePrice();
        this.setPriceAmount(price.getPriceAmount());
        this.setPriceCurrency(price.getPriceCurrency());
        this.setRecurringAmount(price.getRecurringAmount());
        this.setRecurringCurrency(price.getRecurringCurrency());
        this.setRecurringType(price.getRecurringType());
    }

    public int clone(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote Product not populated to be cloned");
        }
        boolean status = false;
        boolean commit = false;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            status = this.insert(db);
            if (this.getProductOptionList() != null && this.getProductOptionList().size() > 0) {
                for (QuoteProductOption option : this.getProductOptionList()) {
                    OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, option.getConfiguratorId());
                    option.setItemId(this.getId());
                    configurator.queryProperties(db, option.getOptionId(), false);
                    configurator.queryQuoteProperties(db, option.getId());
                    status = configurator.saveQuoteOption(db, option);
                }
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        if (status) {
            this.buildProductOptions(db);
            return this.getId();
        }
        return -1;
    }
}

