/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.actions.ActionContext;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.StringUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteProductList
extends ArrayList {
    public static final String tableName = "quote_product";
    public static final String uniqueField = "item_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int quoteId = -1;
    private int statusId = -1;
    private int productId = -1;
    private String productName = null;
    private boolean buildResources = false;
    private HashMap errors = new HashMap();
    private HashMap warnings = new HashMap();
    private boolean onlyWarnings = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setBuildResources(boolean tmp) {
        this.buildResources = tmp;
    }

    public void setBuildResources(String tmp) {
        this.buildResources = DatabaseUtils.parseBoolean(tmp);
    }

    public void setProductName(String tmp) {
        this.productName = tmp;
    }

    public String getProductName() {
        return this.productName;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public void setWarnings(HashMap tmp) {
        this.warnings = tmp;
    }

    public HashMap getWarnings() {
        return this.warnings;
    }

    public void setOnlyWarnings(boolean tmp) {
        this.onlyWarnings = tmp;
    }

    public void setOnlyWarnings(String tmp) {
        this.onlyWarnings = "on".equalsIgnoreCase(tmp);
    }

    public boolean isOnlyWarnings() {
        return this.onlyWarnings;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getProductId() {
        return this.productId;
    }

    public boolean getBuildResources() {
        return this.buildResources;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM quote_product qp LEFT JOIN product_catalog pctlg ON (qp.product_id = pctlg.product_id) WHERE qp.item_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
                items = this.prepareFilter(pst);
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("qp.item_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY qp.item_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("qp.* FROM quote_product qp LEFT JOIN product_catalog pctlg ON (qp.product_id = pctlg.product_id) WHERE qp.item_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            QuoteProduct thisQuoteProduct = new QuoteProduct(rs);
            this.add(thisQuoteProduct);
        }
        rs.close();
        pst.close();
        if (this.buildResources) {
            for (QuoteProduct thisQuoteProduct : this) {
                thisQuoteProduct.buildProductOptions(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.quoteId > -1) {
            sqlFilter.append("AND qp.quote_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND qp.status_id = ? ");
        }
        if (this.productId > -1) {
            sqlFilter.append("AND qp.product_id = ? ");
        }
        if (this.productName != null) {
            sqlFilter.append("AND pctlg.product_name LIKE ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.quoteId > -1) {
            pst.setInt(++i, this.quoteId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.productId > -1) {
            pst.setInt(++i, this.productId);
        }
        if (this.productName != null) {
            pst.setString(++i, this.productName);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (QuoteProduct thisProduct : this) {
            thisProduct.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (QuoteProduct thisProduct : this) {
            thisProduct.delete(db);
        }
    }

    public QuoteProduct getQuoteProductFromProductId(int id) throws SQLException {
        QuoteProduct result = null;
        for (QuoteProduct quoteProduct : this) {
            if (quoteProduct.getProductId() != id) continue;
            result = quoteProduct;
            break;
        }
        return result;
    }

    public void populate(Connection db, ActionContext context, User user) throws Exception {
        NumberFormat nf = null;
        nf = NumberFormat.getInstance(user.getLocale());
        int i = 1;
        while (true) {
            String productIdString = context.getRequest().getParameter("product_" + i);
            String quantityString = context.getRequest().getParameter("qty_" + i);
            String priceString = context.getRequest().getParameter("price_" + i);
            String commentString = context.getRequest().getParameter("comment_" + i);
            if (productIdString == null || "".equals(productIdString)) break;
            if (quantityString != null && !"".equals(quantityString)) {
                ProductCatalog product = new ProductCatalog(db, Integer.parseInt(productIdString));
                product.setBuildActiveOptions(1);
                product.buildOptions(db);
                product.buildActivePrice(db);
                QuoteProduct quoteProduct = new QuoteProduct();
                quoteProduct.setProductCatalog(product);
                quoteProduct.setProductId(product.getId());
                quoteProduct.setComment(commentString);
                quoteProduct.setQuantity(Integer.parseInt(quantityString));
                quoteProduct.buildPricing(db);
                if (priceString != null && !"".equals(priceString)) {
                    quoteProduct.setPriceAmount(nf.parse(StringUtils.replace(priceString, " ", "")).doubleValue());
                } else {
                    quoteProduct.setPriceAmount(0.0);
                }
                this.add(quoteProduct);
            }
            ++i;
        }
    }
}

