/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.products.base.ProductOptionConfigurator;
import org.aspcfs.modules.products.configurator.OptionConfigurator;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteProductOption
extends GenericBean {
    private int id = -1;
    private int itemId = -1;
    private int productOptionId = -1;
    private int quantity = 0;
    private int priceCurrency = -1;
    private double priceAmount = 0.0;
    private int recurringCurrency = -1;
    private double recurringAmount = 0.0;
    private int recurringType = -1;
    private double extendedPrice = 0.0;
    private double totalPrice = 0.0;
    private int statusId = -1;
    private boolean booleanValue = false;
    private double floatValue = 0.0;
    private Timestamp timestampValue = null;
    private int integerValue = -1;
    private String textValue = null;
    private int productId = -1;
    private int optionId = -1;
    private int configuratorId = -1;
    private String quoteUserInput = null;
    private double quotePriceAdjust = 0.0;
    private String quoteHtml = null;
    private boolean buildConfigDetails = false;

    public double getQuotePriceAdjust() {
        return this.quotePriceAdjust;
    }

    public void setQuotePriceAdjust(double tmp) {
        this.quotePriceAdjust = tmp;
    }

    public void setQuotePriceAdjust(String tmp) {
        this.quotePriceAdjust = Double.parseDouble(tmp);
    }

    public String getQuoteHtml() {
        return this.quoteHtml;
    }

    public void setQuoteHtml(String tmp) {
        this.quoteHtml = tmp;
    }

    public String getQuoteUserInput() {
        return this.quoteUserInput;
    }

    public void setQuoteUserInput(String tmp) {
        this.quoteUserInput = tmp;
    }

    public boolean getBuildConfigDetails() {
        return this.buildConfigDetails;
    }

    public void setBuildConfigDetails(boolean tmp) {
        this.buildConfigDetails = tmp;
    }

    public void setBuildConfigDetails(String tmp) {
        this.buildConfigDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public int getConfiguratorId() {
        return this.configuratorId;
    }

    public void setConfiguratorId(int tmp) {
        this.configuratorId = tmp;
    }

    public void setConfiguratorId(String tmp) {
        this.configuratorId = Integer.parseInt(tmp);
    }

    public int getOptionId() {
        return this.optionId;
    }

    public void setOptionId(int tmp) {
        this.optionId = tmp;
    }

    public void setOptionId(String tmp) {
        this.optionId = Integer.parseInt(tmp);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setProductOptionId(int tmp) {
        this.productOptionId = tmp;
    }

    public void setProductOptionId(String tmp) {
        this.productOptionId = Integer.parseInt(tmp);
    }

    public void setQuantity(int tmp) {
        this.quantity = tmp;
    }

    public void setQuantity(String tmp) {
        this.quantity = Integer.parseInt(tmp);
    }

    public void setPriceCurrency(int tmp) {
        this.priceCurrency = tmp;
    }

    public void setPriceCurrency(String tmp) {
        this.priceCurrency = Integer.parseInt(tmp);
    }

    public void setPriceAmount(double tmp) {
        this.priceAmount = tmp;
    }

    public void setRecurringCurrency(int tmp) {
        this.recurringCurrency = tmp;
    }

    public void setRecurringCurrency(String tmp) {
        this.recurringCurrency = Integer.parseInt(tmp);
    }

    public void setRecurringAmount(double tmp) {
        this.recurringAmount = tmp;
    }

    public void setRecurringType(int tmp) {
        this.recurringType = tmp;
    }

    public void setRecurringType(String tmp) {
        this.recurringType = Integer.parseInt(tmp);
    }

    public void setExtendedPrice(double tmp) {
        this.extendedPrice = tmp;
    }

    public void setTotalPrice(double tmp) {
        this.totalPrice = tmp;
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public void setProductId(int tmp) {
        this.productId = tmp;
    }

    public void setProductId(String tmp) {
        this.productId = Integer.parseInt(tmp);
    }

    public void setBooleanValue(boolean tmp) {
        this.booleanValue = tmp;
    }

    public void setBooleanValue(String tmp) {
        this.booleanValue = DatabaseUtils.parseBoolean(tmp);
    }

    public void setFloatValue(double tmp) {
        this.floatValue = tmp;
    }

    public void setTimestampValue(Timestamp tmp) {
        this.timestampValue = tmp;
    }

    public void setTimestampValue(String tmp) {
        this.timestampValue = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setIntegerValue(int tmp) {
        this.integerValue = tmp;
    }

    public void setIntegerValue(String tmp) {
        this.integerValue = Integer.parseInt(tmp);
    }

    public void setTextValue(String tmp) {
        this.textValue = tmp;
    }

    public boolean getBooleanValue() {
        return this.booleanValue;
    }

    public double getFloatValue() {
        return this.floatValue;
    }

    public Timestamp getTimestampValue() {
        return this.timestampValue;
    }

    public int getIntegerValue() {
        return this.integerValue;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public int getId() {
        return this.id;
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getProductOptionId() {
        return this.productOptionId;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public int getPriceCurrency() {
        return this.priceCurrency;
    }

    public double getPriceAmount() {
        return this.priceAmount;
    }

    public int getRecurringCurrency() {
        return this.recurringCurrency;
    }

    public double getRecurringAmount() {
        return this.recurringAmount;
    }

    public int getRecurringType() {
        return this.recurringType;
    }

    public double getExtendedPrice() {
        return this.extendedPrice;
    }

    public double getTotalPrice() {
        return this.totalPrice;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public int getProductId() {
        return this.productId;
    }

    public QuoteProductOption() {
    }

    public QuoteProductOption(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public QuoteProductOption(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote Product Option ID Number");
        }
        PreparedStatement pst = db.prepareStatement("SELECT opt.*, bool." + DatabaseUtils.addQuotes(db, "value") + " AS boolean_value, " + "float." + DatabaseUtils.addQuotes(db, "value") + " AS float_value, intr." + DatabaseUtils.addQuotes(db, "value") + " AS integer_value, " + "tst." + DatabaseUtils.addQuotes(db, "value") + " AS timestamp_value, txt." + DatabaseUtils.addQuotes(db, "value") + " AS text_value, " + "pom.option_id, po.configurator_id, " + "prod.product_id " + "FROM quote_product_options opt " + "LEFT JOIN quote_product_option_boolean bool ON ( opt.quote_product_option_id = bool.quote_product_option_id ) " + "LEFT JOIN quote_product_option_float float ON ( opt.quote_product_option_id = float.quote_product_option_id ) " + "LEFT JOIN quote_product_option_timestamp tst ON ( opt.quote_product_option_id = tst.quote_product_option_id ) " + "LEFT JOIN quote_product_option_integer intr ON ( opt.quote_product_option_id = intr.quote_product_option_id ) " + "LEFT JOIN quote_product_option_text txt ON ( opt.quote_product_option_id = txt.quote_product_option_id ) " + "LEFT JOIN product_option_map pom ON (opt.product_option_id = pom.product_option_id) " + "LEFT JOIN product_option po ON (pom.option_id = po.option_id), " + "quote_product prod " + "WHERE opt.item_id = prod.item_id " + "AND opt.quote_product_option_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Quote Product Option not found");
        }
        if (this.buildConfigDetails) {
            this.buildConfigDetails(db);
        }
    }

    public void buildConfigDetails(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote Product Option ID not specified");
        }
        OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, this.getConfiguratorId());
        configurator.queryProperties(db, this.getOptionId(), false);
        configurator.queryQuoteProperties(db, this.getId());
        this.setQuoteHtml(configurator.getQuoteHtml());
        this.setQuoteUserInput(configurator.getQuoteUserInput());
        this.setQuotePriceAdjust(configurator.getQuotePriceAdjust());
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("quote_product_option_id"));
        this.itemId = rs.getInt("item_id");
        this.productOptionId = rs.getInt("product_option_id");
        this.quantity = DatabaseUtils.getInt(rs, "quantity");
        this.priceCurrency = DatabaseUtils.getInt(rs, "price_currency");
        this.priceAmount = DatabaseUtils.getDouble(rs, "price_amount");
        this.recurringCurrency = DatabaseUtils.getInt(rs, "recurring_currency");
        this.recurringAmount = DatabaseUtils.getDouble(rs, "recurring_amount");
        this.recurringType = DatabaseUtils.getInt(rs, "recurring_type");
        this.extendedPrice = DatabaseUtils.getDouble(rs, "extended_price");
        this.totalPrice = DatabaseUtils.getDouble(rs, "total_price");
        this.statusId = DatabaseUtils.getInt(rs, "status_id");
        this.optionId = DatabaseUtils.getInt(rs, "option_id");
        this.configuratorId = DatabaseUtils.getInt(rs, "configurator_id");
        this.productId = DatabaseUtils.getInt(rs, "product_id");
        this.booleanValue = rs.getBoolean("boolean_value");
        this.floatValue = DatabaseUtils.getDouble(rs, "float_value");
        this.integerValue = DatabaseUtils.getInt(rs, "integer_value");
        this.textValue = rs.getString("text_value");
        this.timestampValue = rs.getTimestamp("timestamp_value");
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.id = DatabaseUtils.getNextSeq(db, "quote_product_options_quote_product_option_id_seq");
        sql.append(" INSERT INTO quote_product_options (" + (this.id > -1 ? "quote_product_option_id, " : "") + "item_id, product_option_id, " + "   quantity, price_currency, price_amount, recurring_currency, " + "   recurring_amount, recurring_type, extended_price, total_price, status_id) ");
        sql.append(" VALUES(" + (this.id > -1 ? "?, " : "") + "?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ? )");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getItemId());
        pst.setInt(++i, this.getProductOptionId());
        DatabaseUtils.setInt(pst, ++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getExtendedPrice());
        pst.setDouble(++i, this.getTotalPrice());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.execute();
        pst.close();
        this.setId(DatabaseUtils.getCurrVal(db, "quote_product_options_quote_product_option_id_seq", this.id));
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        PreparedStatement pst = null;
        if (this.getId() == -1) {
            throw new SQLException("Quote Product Option ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            pst = db.prepareStatement(" DELETE FROM quote_product_option_boolean WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM quote_product_option_float WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            result = pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM quote_product_option_timestamp WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM quote_product_option_integer WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM quote_product_option_text WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            pst = db.prepareStatement(" DELETE FROM quote_product_options WHERE quote_product_option_id = ? ");
            pst.setInt(1, this.getId());
            result = pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            e.printStackTrace(System.out);
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return result;
    }

    public int update(Connection db) throws SQLException {
        int resultCount = 0;
        if (this.getId() == -1) {
            return -1;
        }
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE quote_product_options  SET quantity = ?,      price_currency = ?,      price_amount = ?,      recurring_currency = ?,      recurring_amount = ?,      recurring_type = ?,      extended_price = ?,      total_price = ?,      status_id = ? ");
        sql.append(" WHERE quote_product_option_id = ? ");
        int i = 0;
        pst = db.prepareStatement(sql.toString());
        DatabaseUtils.setInt(pst, ++i, this.getQuantity());
        DatabaseUtils.setInt(pst, ++i, this.getPriceCurrency());
        pst.setDouble(++i, this.getPriceAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringCurrency());
        pst.setDouble(++i, this.getRecurringAmount());
        DatabaseUtils.setInt(pst, ++i, this.getRecurringType());
        pst.setDouble(++i, this.getExtendedPrice());
        pst.setDouble(++i, this.getTotalPrice());
        DatabaseUtils.setInt(pst, ++i, this.getStatusId());
        pst.setInt(++i, this.getId());
        resultCount = pst.executeUpdate();
        pst.close();
        return resultCount;
    }

    public void copyQuoteProductOption(Connection db, int productId) throws SQLException {
        QuoteProductOption copyOption = new QuoteProductOption();
        copyOption.setExtendedPrice(this.getExtendedPrice());
        copyOption.setItemId(productId);
        copyOption.setPriceAmount(this.getPriceAmount());
        copyOption.setPriceCurrency(this.getPriceCurrency());
        copyOption.setProductId(this.getProductId());
        copyOption.setProductOptionId(this.getProductOptionId());
        copyOption.setQuantity(this.getQuantity());
        copyOption.setRecurringAmount(this.getRecurringAmount());
        copyOption.setRecurringCurrency(this.getRecurringCurrency());
        copyOption.setRecurringType(this.getRecurringType());
        copyOption.setStatusId(this.getStatusId());
        copyOption.setTotalPrice(this.getTotalPrice());
        copyOption.setOptionId(this.getOptionId());
        copyOption.setConfiguratorId(this.getConfiguratorId());
        copyOption.setQuoteUserInput(this.getQuoteUserInput());
        copyOption.setQuotePriceAdjust(this.getQuotePriceAdjust());
        OptionConfigurator configurator = ProductOptionConfigurator.getConfigurator(db, copyOption.getConfiguratorId());
        configurator.queryProperties(db, copyOption.getOptionId(), false);
        configurator.saveQuoteOption(db, copyOption);
    }

    public static ArrayList getNumberParams() {
        ArrayList<String> thisList = new ArrayList<String>();
        thisList.add("price_amount");
        thisList.add("recurring_amount");
        thisList.add("extended_price");
        thisList.add("total_price");
        return thisList;
    }
}

