/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.quotes.base.QuoteProductOption;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteProductOptionList
extends ArrayList {
    public static final String tableName = "quote_product_options";
    public static final String uniqueField = "quote_product_option_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int itemId = -1;
    private int statusId = -1;
    private boolean buildConfigDetails = false;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public boolean getBuildConfigDetails() {
        return this.buildConfigDetails;
    }

    public void setBuildConfigDetails(boolean tmp) {
        this.buildConfigDetails = tmp;
    }

    public void setBuildConfigDetails(String tmp) {
        this.buildConfigDetails = DatabaseUtils.parseBoolean(tmp);
    }

    public void setItemId(int tmp) {
        this.itemId = tmp;
    }

    public void setItemId(String tmp) {
        this.itemId = Integer.parseInt(tmp);
    }

    public void setStatusId(int tmp) {
        this.statusId = tmp;
    }

    public void setStatusId(String tmp) {
        this.statusId = Integer.parseInt(tmp);
    }

    public int getItemId() {
        return this.itemId;
    }

    public int getStatusId() {
        return this.statusId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM quote_product_options opt LEFT JOIN quote_product_option_boolean bool ON ( opt.quote_product_option_id = bool.quote_product_option_id ) LEFT JOIN quote_product_option_float " + DatabaseUtils.addQuotes(db, "float") + " ON ( opt.quote_product_option_id = " + DatabaseUtils.addQuotes(db, "float") + ".quote_product_option_id ) " + "LEFT JOIN quote_product_option_timestamp tst ON ( opt.quote_product_option_id = tst.quote_product_option_id ) " + "LEFT JOIN quote_product_option_integer intr ON ( opt.quote_product_option_id = intr.quote_product_option_id ) " + "LEFT JOIN quote_product_option_text txt ON ( opt.quote_product_option_id = txt.quote_product_option_id ) " + "LEFT JOIN product_option_map pom ON (opt.product_option_id = pom.product_option_id) " + "LEFT JOIN product_option po ON (pom.option_id = po.option_id), " + "quote_product prod " + "WHERE opt.item_id = prod.item_id " + "AND opt.quote_product_option_id > -1 ");
        this.createFilter(sqlFilter);
        sqlOrder.append("ORDER BY opt.status_id");
        sqlSelect.append("SELECT ");
        sqlSelect.append("opt.*, bool." + DatabaseUtils.addQuotes(db, "value") + " AS boolean_value, " + "" + DatabaseUtils.addQuotes(db, "float") + "." + DatabaseUtils.addQuotes(db, "value") + " AS float_value, intr." + DatabaseUtils.addQuotes(db, "value") + " AS integer_value, " + "tst." + DatabaseUtils.addQuotes(db, "value") + " AS timestamp_value, txt." + DatabaseUtils.addQuotes(db, "value") + " AS text_value, " + "pom.option_id, po.configurator_id, " + "prod.product_id " + "FROM quote_product_options opt " + "LEFT JOIN quote_product_option_boolean bool ON ( opt.quote_product_option_id = bool.quote_product_option_id ) " + "LEFT JOIN quote_product_option_float " + DatabaseUtils.addQuotes(db, "float") + " ON ( opt.quote_product_option_id = " + DatabaseUtils.addQuotes(db, "float") + ".quote_product_option_id ) " + "LEFT JOIN quote_product_option_timestamp tst ON ( opt.quote_product_option_id = tst.quote_product_option_id ) " + "LEFT JOIN quote_product_option_integer intr ON ( opt.quote_product_option_id = intr.quote_product_option_id ) " + "LEFT JOIN quote_product_option_text txt ON ( opt.quote_product_option_id = txt.quote_product_option_id ) " + "LEFT JOIN product_option_map pom ON (opt.product_option_id = pom.product_option_id) " + "LEFT JOIN product_option po ON (pom.option_id = po.option_id), " + "quote_product prod " + "WHERE opt.item_id = prod.item_id " + "AND opt.quote_product_option_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        rs = pst.executeQuery();
        while (rs.next()) {
            QuoteProductOption thisQuoteProductOption = new QuoteProductOption(rs);
            this.add(thisQuoteProductOption);
        }
        rs.close();
        pst.close();
        if (this.buildConfigDetails) {
            for (QuoteProductOption thisOption : this) {
                thisOption.buildConfigDetails(db);
            }
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.itemId > -1) {
            sqlFilter.append("AND opt.item_id = ? ");
        }
        if (this.statusId > -1) {
            sqlFilter.append("AND opt.status_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.itemId > -1) {
            pst.setInt(++i, this.itemId);
        }
        if (this.statusId > -1) {
            pst.setInt(++i, this.statusId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (QuoteProductOption thisOption : this) {
            thisOption.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        for (QuoteProductOption thisOption : this) {
            thisOption.delete(db);
        }
    }
}

