/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class QuoteRemark
extends GenericBean {
    private int id = -1;
    private int quoteId = -1;
    private int remarkId = -1;
    private String remarkName = null;

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public int getRemarkId() {
        return this.remarkId;
    }

    public void setRemarkId(int tmp) {
        this.remarkId = tmp;
    }

    public void setRemarkId(String tmp) {
        this.remarkId = Integer.parseInt(tmp);
    }

    public String getRemarkName() {
        return this.remarkName;
    }

    public void setRemarkName(String tmp) {
        this.remarkName = tmp;
    }

    public QuoteRemark() {
    }

    public QuoteRemark(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public QuoteRemark(Connection db, int id) throws SQLException {
        if (id == -1) {
            throw new SQLException("Invalid Quote Remark ID");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT qr.*, lqr.description AS remark_name FROM quote_remark qr LEFT JOIN quote_entry qe ON (qr.quote_id = qe.quote_id) LEFT JOIN lookup_quote_remarks lqr ON (qr.remark_id = lqr.code) WHERE qr.map_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Quote Remark Entry not found");
        }
    }

    public QuoteRemark(Connection db, int qId, int cId) throws SQLException {
        if (qId == -1 || cId == -1) {
            throw new SQLException("Invalid Quote ID or Remark ID");
        }
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT qr.*, lqr.description AS remark_name FROM quote_remark qr LEFT JOIN quote_entry qe ON (qr.quote_id = qe.quote_id) LEFT JOIN lookup_quote_remarks lqr ON (qr.remark_id = lqr.code) WHERE qr.remark_id = ? AND qr.quote_id = ? ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(1, cId);
        pst.setInt(2, qId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Quote Remark Entry not found");
        }
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.setId(rs.getInt("map_id"));
        this.setQuoteId(rs.getInt("quote_id"));
        this.setRemarkId(rs.getInt("remark_id"));
        this.setRemarkName(rs.getString("remark_name"));
    }

    public boolean insert(Connection db) throws SQLException {
        if (this.quoteId == -1 || this.remarkId == -1) {
            return false;
        }
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "quote_remark_map_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO quote_remark (" + (this.id > -1 ? "map_id, " : "") + "quote_id, remark_id ) " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?) ");
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.getQuoteId());
        pst.setInt(++i, this.getRemarkId());
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "quote_remark_map_id_seq", this.id);
        return true;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("Quote Remark ID not specified");
        }
        boolean commit = true;
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            PreparedStatement pst = null;
            pst = db.prepareStatement("DELETE FROM quote_remark WHERE map_id = ?");
            pst.setInt(1, this.getId());
            pst.execute();
            pst.close();
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int insertLookup(Connection db, String description) throws SQLException {
        int tempId = DatabaseUtils.getNextSeq(db, "lookup_quote_remarks_code_seq");
        int i = 0;
        PreparedStatement pst = db.prepareStatement("INSERT INTO lookup_quote_remarks (" + (tempId > -1 ? "code, " : "") + "description) " + "VALUES (" + (tempId > -1 ? "?," : "") + "?)");
        if (tempId > -1) {
            pst.setInt(++i, tempId);
        }
        pst.setString(++i, description);
        pst.execute();
        pst.close();
        return DatabaseUtils.getCurrVal(db, "lookup_quote_remarks_code_seq", tempId);
    }

    public void copyQuoteRemark(Connection db, int quoteId) throws SQLException {
        QuoteRemark copy = new QuoteRemark();
        copy.setQuoteId(quoteId);
        copy.setRemarkId(this.getRemarkId());
        copy.setRemarkName(this.getRemarkName());
        copy.insert(db);
    }
}

