/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aspcfs.modules.quotes.base.QuoteRemark;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QuoteRemarkList
extends ArrayList {
    public static final String tableName = "quote_remark";
    public static final String uniqueField = "map_id";
    private Timestamp lastAnchor = null;
    private Timestamp nextAnchor = null;
    private int syncType = -1;
    private PagedListInfo pagedListInfo = null;
    private int id = -1;
    private int quoteId = -1;
    private int remarkId = -1;

    public void setLastAnchor(Timestamp tmp) {
        this.lastAnchor = tmp;
    }

    public void setLastAnchor(String tmp) {
        this.lastAnchor = Timestamp.valueOf(tmp);
    }

    public void setNextAnchor(Timestamp tmp) {
        this.nextAnchor = tmp;
    }

    public void setNextAnchor(String tmp) {
        this.nextAnchor = Timestamp.valueOf(tmp);
    }

    public void setSyncType(int tmp) {
        this.syncType = tmp;
    }

    public String getTableName() {
        return tableName;
    }

    public String getUniqueField() {
        return uniqueField;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public int getQuoteId() {
        return this.quoteId;
    }

    public void setQuoteId(int tmp) {
        this.quoteId = tmp;
    }

    public void setQuoteId(String tmp) {
        this.quoteId = Integer.parseInt(tmp);
    }

    public int getRemarkId() {
        return this.remarkId;
    }

    public void setRemarkId(int tmp) {
        this.remarkId = tmp;
    }

    public void setRemarkId(String tmp) {
        this.remarkId = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM quote_remark qr LEFT JOIN quote_entry qe ON (qr.quote_id = qe.quote_id) LEFT JOIN lookup_quote_remarks lqr ON (qr.remark_id = lqr.code) WHERE qr.map_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND " + DatabaseUtils.toLowerCase(db) + "(lqr.description) < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("qr.map_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY qr.map_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("qr.*, lqr.description AS remark_name FROM quote_remark qr LEFT JOIN quote_entry qe ON (qr.quote_id = qe.quote_id) LEFT JOIN lookup_quote_remarks lqr ON (qr.remark_id = lqr.code) WHERE qr.map_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            QuoteRemark thisQuoteRemark = new QuoteRemark(rs);
            this.add(thisQuoteRemark);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.id > -1) {
            sqlFilter.append("AND qr.map_id = ? ");
        }
        if (this.quoteId > -1) {
            sqlFilter.append("AND qr.quote_id = ? ");
        }
        if (this.remarkId > -1) {
            sqlFilter.append("AND qr.remark_id = ? ");
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                sqlFilter.append("AND o.entered > ? ");
            }
            sqlFilter.append("AND o.entered < ? ");
        }
        if (this.syncType == 3) {
            sqlFilter.append("AND o.modified > ? ");
            sqlFilter.append("AND o.entered < ? ");
            sqlFilter.append("AND o.modified < ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        if (this.quoteId > -1) {
            pst.setInt(++i, this.quoteId);
        }
        if (this.remarkId > -1) {
            pst.setInt(++i, this.remarkId);
        }
        if (this.syncType == 2) {
            if (this.lastAnchor != null) {
                pst.setTimestamp(++i, this.lastAnchor);
            }
            pst.setTimestamp(++i, this.nextAnchor);
        }
        if (this.syncType == 3) {
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.lastAnchor);
            pst.setTimestamp(++i, this.nextAnchor);
        }
        return i;
    }

    public void delete(Connection db) throws SQLException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            QuoteRemark quoteRemark = (QuoteRemark)((Object)iterator.next());
            quoteRemark.delete(db);
            iterator.remove();
        }
    }

    public boolean hasRemark(int id) {
        for (QuoteRemark remark : this) {
            if (remark.getRemarkId() != id) continue;
            return true;
        }
        return false;
    }

    public HashMap retrieveMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (QuoteRemark remark : this) {
            map.put("" + remark.getRemarkId(), "" + remark.getId());
        }
        return map;
    }

    public boolean fixDeletedRemarks(Connection db, HashMap map) throws SQLException {
        if (map.isEmpty()) {
            return true;
        }
        for (String key : map.keySet()) {
            QuoteRemark remark;
            String mapId = (String)map.get(key);
            if (mapId == null && "".equals(mapId) || (remark = new QuoteRemark(db, Integer.parseInt(mapId))).delete(db)) continue;
            return false;
        }
        return true;
    }
}

