/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.quotes.components;

import com.darkhorseventures.database.ConnectionElement;
import java.sql.Connection;
import java.util.Iterator;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponent;
import org.aspcfs.modules.pipeline.base.OpportunityComponentList;
import org.aspcfs.modules.pipeline.base.OpportunityHeader;
import org.aspcfs.modules.products.base.ProductCatalog;
import org.aspcfs.modules.quotes.base.Quote;
import org.aspcfs.modules.quotes.base.QuoteProduct;
import org.aspcfs.modules.quotes.base.QuoteProductList;

public class OpportunityUpdate
extends ObjectHookComponent
implements ComponentInterface {
    public String getDescription() {
        return "Update Opportunity Information related to a quote";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        Quote thisQuote = (Quote)((Object)context.getThisObject());
        Quote previousQuote = (Quote)((Object)context.getPreviousObject());
        Connection db = null;
        try {
            db = OpportunityUpdate.getConnection(context);
            if (thisQuote != null && thisQuote.getId() > -1 && thisQuote.getHeaderId() != -1) {
                OpportunityHeader opportunityHeader;
                OpportunityComponentList opportunityComponentList = new OpportunityComponentList();
                opportunityComponentList.setHeaderId(thisQuote.getHeaderId());
                opportunityComponentList.buildList(db);
                if (opportunityComponentList.size() > 0) {
                    OpportunityComponent opportunityComponent = (OpportunityComponent)((Object)opportunityComponentList.get(0));
                    opportunityComponent.setGuess(thisQuote.getGrandTotal());
                    opportunityComponent.update(db);
                    this.invalidateUserData(context, opportunityComponent.getOwner());
                }
                boolean foundTicketProduct = false;
                QuoteProductList quoteProductList = thisQuote.getProductList();
                Iterator quoteProductIterator = quoteProductList.iterator();
                int groupSize = 0;
                while (quoteProductIterator.hasNext()) {
                    QuoteProduct tmpQuoteProduct = (QuoteProduct)((Object)quoteProductIterator.next());
                    ProductCatalog product = new ProductCatalog(db, tmpQuoteProduct.getProductId());
                    if (!"00010".equals(product.getSku())) continue;
                    foundTicketProduct = true;
                    groupSize += tmpQuoteProduct.getQuantity();
                }
                if (!foundTicketProduct) {
                    opportunityHeader = new OpportunityHeader(db, thisQuote.getHeaderId());
                    opportunityHeader.setCustom1Integer(-1);
                    opportunityHeader.update(db);
                } else {
                    opportunityHeader = new OpportunityHeader(db, thisQuote.getHeaderId());
                    opportunityHeader.setCustom1Integer(groupSize);
                    opportunityHeader.update(db);
                }
            }
            if (previousQuote != null && previousQuote.getHeaderId() != thisQuote.getHeaderId()) {
                OpportunityComponentList newOpportunityComponentList = new OpportunityComponentList();
                newOpportunityComponentList.setHeaderId(previousQuote.getHeaderId());
                newOpportunityComponentList.buildList(db);
                if (newOpportunityComponentList.size() > 0) {
                    OpportunityComponent opportunityComponent = (OpportunityComponent)((Object)newOpportunityComponentList.get(0));
                    opportunityComponent.setGuess(0.0);
                    opportunityComponent.update(db);
                    this.invalidateUserData(context, opportunityComponent.getOwner());
                }
                OpportunityHeader opportunityHeader = new OpportunityHeader(db, previousQuote.getHeaderId());
                opportunityHeader.setCustom1Integer(-1);
                opportunityHeader.update(db);
            }
            result = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            OpportunityUpdate.freeConnection(context, db);
        }
        return result;
    }

    private void invalidateUserData(ComponentContext context, int userId) {
        ConnectionElement ce = (ConnectionElement)context.getAttribute("ConnectionElement");
        SystemStatus systemStatus = (SystemStatus)context.getAttribute("SystemStatus");
        systemStatus.getHierarchyList().getUser(userId).setIsValid(false, true);
    }
}

