/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.relationships.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.actionplans.base.ActionItemWork;
import org.aspcfs.modules.actionplans.base.ActionPlan;
import org.aspcfs.modules.contacts.base.ContactHistory;
import org.aspcfs.utils.DatabaseUtils;

public class Relationship
extends GenericBean {
    private int id = -1;
    private int typeId = -1;
    private int objectIdMapsFrom = -1;
    private int categoryIdMapsFrom = -1;
    private int objectIdMapsTo = -1;
    private int categoryIdMapsTo = -1;
    private Timestamp modified = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private int modifiedBy = -1;
    private int enabled = -1;
    private String reciprocalName1 = null;
    private String reciprocalName2 = null;
    private Object mappedObject = null;
    private Timestamp trashedDate = null;

    public Relationship() {
    }

    public Relationship(Connection db, int thisId) throws SQLException {
        if (thisId == -1) {
            throw new SQLException("Relatioship Id not specified");
        }
        PreparedStatement pst = db.prepareStatement("SELECT r.relationship_id, r.type_id, r.object_id_maps_from, r.category_id_maps_from, r.object_id_maps_to, r.category_id_maps_to, r.entered, r.enteredby, r.modified, r.modifiedby, r.trashed_date, rt.reciprocal_name_1, rt.reciprocal_name_2 FROM relationship r LEFT JOIN lookup_relationship_types rt ON (rt.type_id = r.type_id) WHERE relationship_id = ? ");
        int i = 0;
        pst.setInt(++i, thisId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (thisId == -1) {
            throw new SQLException("Relationship ID not found");
        }
    }

    public Relationship(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setCategoryIdMapsFrom(int tmp) {
        this.categoryIdMapsFrom = tmp;
    }

    public void setCategoryIdMapsFrom(String tmp) {
        this.categoryIdMapsFrom = Integer.parseInt(tmp);
    }

    public void setObjectIdMapsTo(int tmp) {
        this.objectIdMapsTo = tmp;
    }

    public void setObjectIdMapsTo(String tmp) {
        this.objectIdMapsTo = Integer.parseInt(tmp);
    }

    public void setCategoryIdMapsTo(int tmp) {
        this.categoryIdMapsTo = tmp;
    }

    public void setCategoryIdMapsTo(String tmp) {
        this.categoryIdMapsTo = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(int tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = Integer.parseInt(tmp);
    }

    public void setMappedObject(Object tmp) {
        this.mappedObject = tmp;
    }

    public Object getMappedObject() {
        return this.mappedObject;
    }

    public int getObjectIdMapsFrom() {
        return this.objectIdMapsFrom;
    }

    public int getCategoryIdMapsFrom() {
        return this.categoryIdMapsFrom;
    }

    public int getObjectIdMapsTo() {
        return this.objectIdMapsTo;
    }

    public int getCategoryIdMapsTo() {
        return this.categoryIdMapsTo;
    }

    public int getId() {
        return this.id;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setObjectIdMapsFrom(int tmp) {
        this.objectIdMapsFrom = tmp;
    }

    public void setObjectIdMapsFrom(String tmp) {
        this.objectIdMapsFrom = Integer.parseInt(tmp);
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public int getEnabled() {
        return this.enabled;
    }

    public void setReciprocalName1(String tmp) {
        this.reciprocalName1 = tmp;
    }

    public void setReciprocalName2(String tmp) {
        this.reciprocalName2 = tmp;
    }

    public String getReciprocalName1() {
        return this.reciprocalName1;
    }

    public String getReciprocalName2() {
        return this.reciprocalName2;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "relationship_relationship_id_seq");
            sql.append("INSERT INTO relationship (type_id, object_id_maps_from, category_id_maps_from, object_id_maps_to, category_id_maps_to, trashed_date, ");
            if (this.id > -1) {
                sql.append("relationship_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enteredBy, modifiedBy ) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?,");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?, ?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.getTypeId());
            pst.setInt(++i, this.getObjectIdMapsFrom());
            pst.setInt(++i, this.getCategoryIdMapsFrom());
            pst.setInt(++i, this.getObjectIdMapsTo());
            pst.setInt(++i, this.getCategoryIdMapsTo());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setInt(++i, this.getEnteredBy());
            pst.setInt(++i, this.getModifiedBy());
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "relationship_relationship_id_seq", this.id);
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public int update(Connection db) throws SQLException {
        String sql = null;
        PreparedStatement pst = null;
        int count = 0;
        if (this.id == -1) {
            throw new SQLException("Relationship ID not specified");
        }
        if (this.getId() == -1) {
            return -1;
        }
        try {
            db.setAutoCommit(false);
            sql = "UPDATE relationship SET modifiedby = ?, object_id_maps_from = ?, category_id_maps_from = ?, object_id_maps_to = ?, category_id_maps_to = ?, trashed_date = ?, modified = CURRENT_TIMESTAMP WHERE relationship_id = ? AND modified " + (this.getModified() == null ? "IS NULL " : "= ? ");
            int i = 0;
            pst = db.prepareStatement(sql);
            pst.setInt(++i, this.getModifiedBy());
            pst.setInt(++i, this.getObjectIdMapsFrom());
            pst.setInt(++i, this.getCategoryIdMapsFrom());
            pst.setInt(++i, this.getObjectIdMapsTo());
            pst.setInt(++i, this.getCategoryIdMapsTo());
            DatabaseUtils.setTimestamp(pst, ++i, this.getTrashedDate());
            pst.setInt(++i, this.id);
            if (this.getModified() != null) {
                pst.setTimestamp(++i, this.getModified());
            }
            count = pst.executeUpdate();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return count;
    }

    public boolean delete(Connection db) throws SQLException {
        if (this.getId() == -1) {
            throw new SQLException("ID was not specified");
        }
        ContactHistory.deleteObject(db, 11, this.getId());
        try {
            int linkModuleId = ActionPlan.getMapIdGivenConstantId(db, 110061020);
            ActionItemWork itemWork = new ActionItemWork(db, linkModuleId, this.getId());
            itemWork.resetAttachment(db);
        }
        catch (SQLException e) {
            // empty catch block
        }
        int recordCount = 0;
        PreparedStatement pst = db.prepareStatement("DELETE FROM relationship WHERE relationship_id = ? ");
        pst.setInt(1, this.id);
        recordCount = pst.executeUpdate();
        pst.close();
        return recordCount != 0;
    }

    public void buildMappedObject(Connection db, String direction) throws SQLException {
        int categoryId = this.categoryIdMapsTo;
        if ("from".equals(direction)) {
            categoryId = this.categoryIdMapsFrom;
        }
        switch (categoryId) {
            case 42420034: {
                this.mappedObject = new Organization(db, "from".equals(direction) ? this.objectIdMapsFrom : this.objectIdMapsTo);
                break;
            }
        }
    }

    public String getMappedObjectLabel() {
        if (this.mappedObject != null && this.mappedObject instanceof Organization) {
            Organization thisOrg = (Organization)((Object)this.mappedObject);
            return thisOrg.getName();
        }
        return null;
    }

    private void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("relationship_id");
        this.typeId = rs.getInt("type_id");
        this.objectIdMapsFrom = rs.getInt("object_id_maps_from");
        this.categoryIdMapsFrom = rs.getInt("category_id_maps_from");
        this.objectIdMapsTo = rs.getInt("object_id_maps_to");
        this.categoryIdMapsTo = rs.getInt("category_id_maps_to");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.trashedDate = rs.getTimestamp("trashed_date");
        this.reciprocalName1 = rs.getString("reciprocal_name_1");
        this.reciprocalName2 = rs.getString("reciprocal_name_2");
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        boolean commit = true;
        PreparedStatement pst = null;
        StringBuffer sql = new StringBuffer();
        try {
            commit = db.getAutoCommit();
            if (commit) {
                db.setAutoCommit(false);
            }
            sql.append("UPDATE relationship SET trashed_date = ? , modified = " + DatabaseUtils.getCurrentTimestamp(db) + " , " + "modifiedby = ? " + "WHERE relationship_id = ? ");
            int i = 0;
            pst = db.prepareStatement(sql.toString());
            if (toTrash) {
                DatabaseUtils.setTimestamp(pst, ++i, new Timestamp(System.currentTimeMillis()));
            } else {
                DatabaseUtils.setTimestamp(pst, ++i, null);
            }
            DatabaseUtils.setInt(pst, ++i, tmpUserId);
            pst.setInt(++i, this.getId());
            pst.executeUpdate();
            pst.close();
            if (this.getCategoryIdMapsFrom() == 42420034 && this.getCategoryIdMapsTo() == 42420034) {
                i = 0;
                int relationshipLinkModuleId = ActionPlan.getMapIdGivenConstantId(db, 110061020);
                pst = db.prepareStatement("UPDATE action_item_work SET link_item_id = ? WHERE link_module_id = ? AND link_item_id = ? ");
                DatabaseUtils.setInt(pst, ++i, -1);
                pst.setInt(++i, relationshipLinkModuleId);
                pst.setInt(++i, this.getId());
                pst.executeUpdate();
                pst.close();
            }
            ContactHistory.deleteObject(db, 11, this.getId());
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean isPresent(ArrayList finalSelection, String type) {
        if (finalSelection != null) {
            for (String val : finalSelection) {
                if (!(type.endsWith("_reciprocal") ? this.getObjectIdMapsFrom() == Integer.parseInt(val) : this.getObjectIdMapsTo() == Integer.parseInt(val))) continue;
                return true;
            }
        }
        return false;
    }
}

