/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.relationships.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class RelationshipList
extends LinkedHashMap {
    protected int typeId = -1;
    protected int categoryIdMapsFrom = -1;
    protected int objectIdMapsFrom = -1;
    protected int categoryIdMapsTo = -1;
    protected int objectIdMapsTo = -1;
    protected boolean buildDualMappings = false;
    protected PagedListInfo pagedListInfo = null;
    protected Timestamp trashedDate = null;
    protected boolean includeOnlyTrashed = false;

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setCategoryIdMapsFrom(int tmp) {
        this.categoryIdMapsFrom = tmp;
    }

    public void setCategoryIdMapsFrom(String tmp) {
        this.categoryIdMapsFrom = Integer.parseInt(tmp);
    }

    public void setObjectIdMapsFrom(int tmp) {
        this.objectIdMapsFrom = tmp;
    }

    public void setObjectIdMapsFrom(String tmp) {
        this.objectIdMapsFrom = Integer.parseInt(tmp);
    }

    public void setBuildDualMappings(boolean tmp) {
        this.buildDualMappings = tmp;
    }

    public void setBuildDualMappings(String tmp) {
        this.buildDualMappings = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getCategoryIdMapsFrom() {
        return this.categoryIdMapsFrom;
    }

    public int getObjectIdMapsFrom() {
        return this.objectIdMapsFrom;
    }

    public boolean getBuildDualMappings() {
        return this.buildDualMappings;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public Timestamp getTrashedDate() {
        return this.trashedDate;
    }

    public void setTrashedDate(Timestamp tmp) {
        this.trashedDate = tmp;
    }

    public void setTrashedDate(String tmp) {
        this.trashedDate = DatabaseUtils.parseTimestamp(tmp);
    }

    public boolean getIncludeOnlyTrashed() {
        return this.includeOnlyTrashed;
    }

    public void setIncludeOnlyTrashed(boolean tmp) {
        this.includeOnlyTrashed = tmp;
    }

    public void setIncludeOnlyTrashed(String tmp) {
        this.includeOnlyTrashed = DatabaseUtils.parseBoolean(tmp);
    }

    public int getCategoryIdMapsTo() {
        return this.categoryIdMapsTo;
    }

    public void setCategoryIdMapsTo(int tmp) {
        this.categoryIdMapsTo = tmp;
    }

    public void setCategoryIdMapsTo(String tmp) {
        this.categoryIdMapsTo = Integer.parseInt(tmp);
    }

    public int getObjectIdMapsTo() {
        return this.objectIdMapsTo;
    }

    public void setObjectIdMapsTo(int tmp) {
        this.objectIdMapsTo = tmp;
    }

    public void setObjectIdMapsTo(String tmp) {
        this.objectIdMapsTo = Integer.parseInt(tmp);
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM relationship t WHERE r.relationship_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND rt.reciprocal_name_1 > ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("r.type_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY r.type_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("r.relationship_id, r.type_id, r.object_id_maps_from, r.category_id_maps_from, r.object_id_maps_to, r.category_id_maps_to, r.entered, r.enteredby, r.modified, r.modifiedby, r.trashed_date, rt.reciprocal_name_1, rt.reciprocal_name_2 FROM relationship r LEFT JOIN lookup_relationship_types rt ON (rt.type_id = r.type_id) WHERE relationship_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Relationship thisRelationship = new Relationship(rs);
            this.add(thisRelationship);
        }
        rs.close();
        pst.close();
        for (String relType : this.keySet()) {
            ArrayList tmpList = (ArrayList)this.get(relType);
            for (Relationship thisRelationship : tmpList) {
                if (thisRelationship.getObjectIdMapsFrom() == this.objectIdMapsFrom) {
                    thisRelationship.buildMappedObject(db, "to");
                    continue;
                }
                thisRelationship.buildMappedObject(db, "from");
            }
        }
        for (String relType : this.keySet()) {
            ArrayList tmpList = (ArrayList)this.get(relType);
            relationshipComparator comparator = new relationshipComparator();
            Collections.sort(tmpList, comparator);
        }
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.typeId != -1) {
            sqlFilter.append(" AND r.type_id = ? ");
        }
        if (this.buildDualMappings) {
            sqlFilter.append("AND ((r.category_id_maps_from = ? AND r.object_id_maps_from = ?) OR (r.category_id_maps_to = ? AND r.object_id_maps_to = ?)) ");
        } else {
            if (this.categoryIdMapsFrom != -1) {
                sqlFilter.append("AND r.category_id_maps_from = ? ");
            }
            if (this.objectIdMapsFrom != -1) {
                sqlFilter.append("AND r.object_id_maps_from = ? ");
            }
            if (this.categoryIdMapsTo != -1) {
                sqlFilter.append("AND r.category_id_maps_to = ? ");
            }
            if (this.objectIdMapsTo != -1) {
                sqlFilter.append("AND r.object_id_maps_to = ? ");
            }
        }
        if (this.includeOnlyTrashed) {
            sqlFilter.append("AND r.trashed_date IS NOT NULL ");
        } else if (this.trashedDate != null) {
            sqlFilter.append("AND r.trashed_date = ? ");
        } else {
            sqlFilter.append("AND r.trashed_date IS NULL ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.typeId != -1) {
            pst.setInt(++i, this.typeId);
        }
        if (this.buildDualMappings) {
            pst.setInt(++i, this.categoryIdMapsFrom);
            pst.setInt(++i, this.objectIdMapsFrom);
            pst.setInt(++i, this.categoryIdMapsFrom);
            pst.setInt(++i, this.objectIdMapsFrom);
        } else {
            if (this.categoryIdMapsFrom != -1) {
                pst.setInt(++i, this.categoryIdMapsFrom);
            }
            if (this.objectIdMapsFrom != -1) {
                pst.setInt(++i, this.objectIdMapsFrom);
            }
            if (this.categoryIdMapsTo != -1) {
                pst.setInt(++i, this.categoryIdMapsTo);
            }
            if (this.objectIdMapsTo != -1) {
                pst.setInt(++i, this.objectIdMapsTo);
            }
        }
        if (!this.includeOnlyTrashed && this.trashedDate != null) {
            pst.setTimestamp(++i, this.trashedDate);
        }
        return i;
    }

    public void add(Relationship r) {
        ArrayList tmpList = null;
        if (r.getObjectIdMapsFrom() == this.objectIdMapsFrom) {
            tmpList = this.containsKey(r.getReciprocalName1()) ? (ArrayList)this.get(r.getReciprocalName1()) : new ArrayList();
            tmpList.add(r);
            this.put(r.getReciprocalName1(), tmpList);
        } else {
            tmpList = this.containsKey(r.getReciprocalName2()) ? (ArrayList)this.get(r.getReciprocalName2()) : new ArrayList();
            tmpList.add(r);
            this.put(r.getReciprocalName2(), tmpList);
        }
    }

    public boolean delete(Connection db) throws SQLException {
        boolean result = false;
        int size = this.size();
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            String relType = (String)iterator.next();
            ArrayList tmpList = (ArrayList)this.get(relType);
            Iterator j = tmpList.iterator();
            while (j.hasNext()) {
                Relationship relationship = (Relationship)((Object)j.next());
                result = relationship.delete(db);
                j.remove();
            }
            iterator.remove();
            result = true;
        }
        return result;
    }

    public int getNumberOfRelationships() {
        int relationshipCounter = 0;
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)iterator.next());
            for (Relationship rel : tempList) {
                ++relationshipCounter;
            }
        }
        return relationshipCounter;
    }

    public int checkDuplicateRelationship(Connection db, int id, int categoryTypeId, int category) {
        int result = 0;
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)iterator.next());
            for (Relationship rel : tempList) {
                if (rel.getObjectIdMapsTo() != id || rel.getTypeId() != categoryTypeId || rel.getCategoryIdMapsTo() != category) continue;
                ++result;
            }
        }
        return result;
    }

    public Relationship getDuplicateRelation(Connection db, int id, int categoryTypeId, int category) throws SQLException {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)iterator.next());
            for (Relationship rel : tempList) {
                if (rel.getObjectIdMapsTo() != id || rel.getTypeId() != categoryTypeId || rel.getCategoryIdMapsTo() != category) continue;
                return rel;
            }
        }
        return null;
    }

    public boolean updateStatus(Connection db, boolean toTrash, int tmpUserId) throws SQLException {
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)iterator.next());
            for (Relationship rel : tempList) {
                rel.updateStatus(db, toTrash, tmpUserId);
            }
        }
        return true;
    }

    public String getDisplayHtml() {
        StringBuffer sb = new StringBuffer();
        Iterator j = this.keySet().iterator();
        while (j.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)j.next());
            Iterator tempIter = tempList.iterator();
            while (tempIter.hasNext()) {
                Relationship rel = (Relationship)((Object)tempIter.next());
                String label = rel.getMappedObjectLabel();
                if (tempIter.hasNext()) {
                    sb.append((label != null ? label : "") + "\r\n");
                    continue;
                }
                sb.append(label != null ? label : "");
            }
        }
        return sb.toString().trim();
    }

    public void getMappedObjectIds(ArrayList list, String type) {
        if (list == null) {
            list = new ArrayList<String>();
        }
        Iterator j = this.keySet().iterator();
        while (j.hasNext()) {
            ArrayList tempList = (ArrayList)this.get((String)j.next());
            for (Relationship rel : tempList) {
                if (type.endsWith("_reciprocal")) {
                    list.add(String.valueOf(rel.getObjectIdMapsFrom()));
                    continue;
                }
                list.add(String.valueOf(rel.getObjectIdMapsTo()));
            }
        }
    }

    public void filterAccounts(ArrayList accountTypes) {
        if (this.getCategoryIdMapsFrom() == 42420034) {
            for (String relType : this.keySet()) {
                ArrayList tmpList = (ArrayList)this.get(relType);
                Iterator j = tmpList.iterator();
                while (j.hasNext()) {
                    String type;
                    Relationship thisRelationship = (Relationship)((Object)j.next());
                    Organization thisAccount = (Organization)((Object)thisRelationship.getMappedObject());
                    boolean hasType = false;
                    Iterator types = accountTypes.iterator();
                    while (types.hasNext() && !(hasType = thisAccount.hasType(Integer.parseInt(type = (String)types.next())))) {
                    }
                    if (hasType) continue;
                    j.remove();
                }
            }
        }
    }

    public class relationshipComparator
    implements Comparator {
        public int compare(Object left, Object right) {
            String a = new String(((Relationship)((Object)left)).getMappedObjectLabel());
            String b = new String(((Relationship)((Object)right)).getMappedObjectLabel());
            int compareResult = b.compareTo(a);
            return compareResult;
        }
    }
}

