/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.relationships.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class RelationshipType {
    private int typeId = 0;
    private int categoryIdMapsFrom = -1;
    private int categoryIdMapsTo = -1;
    private String reciprocalName1 = null;
    private String reciprocalName2 = null;
    private int level = -1;
    private boolean defaultItem = false;
    private boolean enabled = false;

    public int getId() {
        return this.typeId;
    }

    public void setId(int tmp) {
        this.typeId = tmp;
    }

    public void setId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public void setCategoryIdMapsFrom(int tmp) {
        this.categoryIdMapsFrom = tmp;
    }

    public void setCategoryIdMapsFrom(String tmp) {
        this.categoryIdMapsFrom = Integer.parseInt(tmp);
    }

    public void setCategoryIdMapsTo(int tmp) {
        this.categoryIdMapsTo = tmp;
    }

    public void setCategoryIdMapsTo(String tmp) {
        this.categoryIdMapsTo = Integer.parseInt(tmp);
    }

    public void setReciprocalName1(String tmp) {
        this.reciprocalName1 = tmp;
    }

    public void setReciprocalName2(String tmp) {
        this.reciprocalName2 = tmp;
    }

    public void setLevel(int tmp) {
        this.level = tmp;
    }

    public void setLevel(String tmp) {
        this.level = Integer.parseInt(tmp);
    }

    public void setDefaultItem(boolean tmp) {
        this.defaultItem = tmp;
    }

    public void setDefaultItem(String tmp) {
        this.defaultItem = DatabaseUtils.parseBoolean(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public int getCategoryIdMapsFrom() {
        return this.categoryIdMapsFrom;
    }

    public int getCategoryIdMapsTo() {
        return this.categoryIdMapsTo;
    }

    public String getReciprocalName1() {
        return this.reciprocalName1;
    }

    public String getReciprocalName2() {
        return this.reciprocalName2;
    }

    public int getLevel() {
        return this.level;
    }

    public boolean getDefaultItem() {
        return this.defaultItem;
    }

    public RelationshipType() {
    }

    public RelationshipType(Connection db, int typeId) throws SQLException {
        this.queryRecord(db, typeId);
    }

    public void queryRecord(Connection db, int typeId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT lrt.* FROM lookup_relationship_types lrt WHERE lrt.type_id = ? ");
        pst.setInt(1, typeId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Record Not Found");
        }
    }

    public RelationshipType(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void buildRecord(ResultSet rs) throws SQLException {
        this.typeId = rs.getInt("type_id");
        this.categoryIdMapsFrom = rs.getInt("category_id_maps_from");
        this.categoryIdMapsTo = rs.getInt("category_id_maps_to");
        this.reciprocalName1 = rs.getString("reciprocal_name_1");
        this.reciprocalName2 = rs.getString("reciprocal_name_2");
        this.level = rs.getInt("level");
        this.defaultItem = rs.getBoolean("default_item");
        this.enabled = rs.getBoolean("enabled");
    }

    public boolean insert(Connection db) throws SQLException {
        StringBuffer sql = new StringBuffer();
        this.typeId = DatabaseUtils.getNextSeq(db, "lookup_relationship_types_type_id_seq");
        sql.append("INSERT INTO lookup_relationship_types (category_id_maps_from, category_id_maps_to, reciprocal_name_1, reciprocal_name_2, " + DatabaseUtils.addQuotes(db, "level") + ", default_item, ");
        if (this.typeId > -1) {
            sql.append("type_id, ");
        }
        sql.append("enabled) ");
        sql.append("VALUES (?, ?, ?, ?, ?, ?, ");
        if (this.typeId > -1) {
            sql.append("?, ");
        }
        sql.append("?) ");
        int i = 0;
        PreparedStatement pst = db.prepareStatement(sql.toString());
        pst.setInt(++i, this.categoryIdMapsFrom);
        pst.setInt(++i, this.categoryIdMapsTo);
        pst.setString(++i, this.reciprocalName1);
        pst.setString(++i, this.reciprocalName2);
        pst.setInt(++i, this.level);
        pst.setBoolean(++i, this.defaultItem);
        if (this.typeId > -1) {
            pst.setInt(++i, this.typeId);
        }
        pst.setBoolean(++i, this.enabled);
        pst.execute();
        pst.close();
        this.typeId = DatabaseUtils.getCurrVal(db, "lookup_relationship_types_type_id_seq", this.typeId);
        return true;
    }
}

