/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.relationships.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.relationships.base.RelationshipType;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.PagedListInfo;

public class RelationshipTypeList
extends ArrayList {
    private int categoryIdMapsFrom = -1;
    private String jsEvent = "";
    private int defaultKey = -1;
    private int size = 1;
    private boolean showDisabled = true;
    protected PagedListInfo pagedListInfo = null;
    private int typeId = -1;

    public RelationshipTypeList() {
    }

    public RelationshipTypeList(Connection db) throws SQLException {
        this.buildList(db);
    }

    public void setCategoryIdMapsFrom(int tmp) {
        this.categoryIdMapsFrom = tmp;
    }

    public void setCategoryIdMapsFrom(String tmp) {
        this.categoryIdMapsFrom = Integer.parseInt(tmp);
    }

    public void setJsEvent(String tmp) {
        this.jsEvent = tmp;
    }

    public void setDefaultKey(int tmp) {
        this.defaultKey = tmp;
    }

    public void setDefaultKey(String tmp) {
        this.defaultKey = Integer.parseInt(tmp);
    }

    public void setSize(int tmp) {
        this.size = tmp;
    }

    public void setSize(String tmp) {
        this.size = Integer.parseInt(tmp);
    }

    public void setShowDisabled(boolean tmp) {
        this.showDisabled = tmp;
    }

    public void setShowDisabled(String tmp) {
        this.showDisabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public int getCategoryIdMapsFrom() {
        return this.categoryIdMapsFrom;
    }

    public String getJsEvent() {
        return this.jsEvent;
    }

    public int getDefaultKey() {
        return this.defaultKey;
    }

    public int getSize() {
        return this.size;
    }

    public boolean getShowDisabled() {
        return this.showDisabled;
    }

    public int getTypeId() {
        return this.typeId;
    }

    public void setTypeId(int tmp) {
        this.typeId = tmp;
    }

    public void setTypeId(String tmp) {
        this.typeId = Integer.parseInt(tmp);
    }

    public HtmlSelect getHtmlSelect() {
        HtmlSelect relationshipTypeSelect = new HtmlSelect();
        relationshipTypeSelect.setJsEvent(this.jsEvent);
        relationshipTypeSelect.setSelectSize(this.getSize());
        for (RelationshipType thisRelationshipType : this) {
            relationshipTypeSelect.addItem(thisRelationshipType.getTypeId(), thisRelationshipType.getReciprocalName1());
            if (thisRelationshipType.getReciprocalName1().equals(thisRelationshipType.getReciprocalName2())) continue;
            relationshipTypeSelect.addItem(thisRelationshipType.getTypeId() + "_reciprocal", thisRelationshipType.getReciprocalName2());
        }
        return relationshipTypeSelect;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) AS recordcount FROM lookup_relationship_types lrt WHERE code > -1 ");
        this.createFilter(db, sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            if (!this.pagedListInfo.getCurrentLetter().equals("")) {
                pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString() + "AND lrt.reciprocal_name_1 < ? ");
                items = this.prepareFilter(pst);
                pst.setString(++items, this.pagedListInfo.getCurrentLetter().toLowerCase());
                rs = pst.executeQuery();
                if (rs.next()) {
                    int offsetCount = rs.getInt("recordcount");
                    this.pagedListInfo.setCurrentOffset(offsetCount);
                }
                rs.close();
                pst.close();
            }
            this.pagedListInfo.setDefaultSort("lrt.type_id,category_id_maps_from", null);
        } else {
            sqlOrder.append("ORDER BY lrt.type_id,lrt.category_id_maps_from ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("lrt.* FROM lookup_relationship_types lrt WHERE lrt.type_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            RelationshipType thisRelationshipType = new RelationshipType(rs);
            this.add(thisRelationshipType);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(Connection db, StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.categoryIdMapsFrom != -1) {
            sqlFilter.append("AND lrt.category_id_maps_from = ? ");
        }
        if (this.typeId != -1) {
            sqlFilter.append("AND lrt.type_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.categoryIdMapsFrom != -1) {
            pst.setInt(++i, this.categoryIdMapsFrom);
        }
        if (this.typeId != -1) {
            pst.setInt(++i, this.typeId);
        }
        return i;
    }
}

