/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.relationships.components;

import java.sql.Connection;
import org.aspcfs.apps.workFlowManager.ComponentContext;
import org.aspcfs.apps.workFlowManager.ComponentInterface;
import org.aspcfs.controller.objectHookManager.ObjectHookComponent;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.accounts.base.OrganizationHistory;
import org.aspcfs.modules.relationships.base.Relationship;
import org.aspcfs.modules.relationships.base.RelationshipType;
import org.aspcfs.modules.relationships.base.RelationshipTypeList;

public class SetAccountHistory
extends ObjectHookComponent
implements ComponentInterface {
    public static final String LEVEL = "history.level";
    public static final String ORG_ID = "history.orgId";
    public static final String LINK_OBJECT_ID = "history.linkObjectId";
    public static final String LINK_ITEM_ID = "history.linkItemId";
    public static final String DESCRIPTION = "history.description";
    public static final String ENABLED = "history.enabled";
    public static final String STATUS = "history.status";
    public static final String TYPE = "history.type";
    public static final String ENTERED_BY = "history.enteredby";
    public static final String MODIFIED_BY = "history.modifiedby";

    public String getDescription() {
        return "Set the account's history";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ComponentContext context) {
        boolean result = false;
        OrganizationHistory history = new OrganizationHistory();
        RelationshipTypeList typeList = null;
        RelationshipType type = null;
        Organization firstOrg = null;
        Organization secondOrg = null;
        Relationship thisRelationship = (Relationship)((Object)context.getThisObject());
        Connection db = null;
        try {
            db = SetAccountHistory.getConnection(context);
            history.setLevel(context.getParameterAsInt(LEVEL));
            history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
            history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
            history.setType(context.getParameter(TYPE));
            history.setEnabled(context.getParameter(ENABLED));
            history.setEnteredBy(context.getParameter(ENTERED_BY));
            history.setModifiedBy(context.getParameter(MODIFIED_BY));
            history.setStatus(context.getParameter(STATUS));
            firstOrg = new Organization(db, thisRelationship.getObjectIdMapsFrom());
            secondOrg = new Organization(db, thisRelationship.getObjectIdMapsTo());
            typeList = new RelationshipTypeList();
            typeList.setTypeId(thisRelationship.getTypeId());
            typeList.buildList(db);
            if (typeList.size() == 1) {
                type = (RelationshipType)typeList.get(0);
                history.setOrgId(context.getParameterAsInt(ORG_ID));
                history.setDescription(type.getReciprocalName1() + " " + secondOrg.getName());
                result = history.insert(db);
                history = new OrganizationHistory();
                history.setLevel(context.getParameterAsInt(LEVEL));
                history.setLinkObjectId(context.getParameterAsInt(LINK_OBJECT_ID));
                history.setLinkItemId(context.getParameterAsInt(LINK_ITEM_ID));
                history.setType(context.getParameter(TYPE));
                history.setEnabled(context.getParameter(ENABLED));
                history.setEnteredBy(context.getParameter(ENTERED_BY));
                history.setModifiedBy(context.getParameter(MODIFIED_BY));
                history.setStatus(context.getParameter(STATUS));
                history.setOrgId(thisRelationship.getObjectIdMapsTo());
                history.setDescription(type.getReciprocalName2() + " " + firstOrg.getName());
                result = history.insert(db);
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        finally {
            SetAccountHistory.freeConnection(context, db);
        }
        return result;
    }
}

