/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.actions;

import com.darkhorseventures.framework.actions.ActionContext;
import com.zeroio.webutils.FileDownload;
import java.sql.Connection;
import java.util.HashMap;
import net.sf.jasperreports.engine.JasperReport;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.actions.CFSModule;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.admin.base.PermissionCategoryList;
import org.aspcfs.modules.contacts.base.Contact;
import org.aspcfs.modules.reports.base.Criteria;
import org.aspcfs.modules.reports.base.CriteriaList;
import org.aspcfs.modules.reports.base.Parameter;
import org.aspcfs.modules.reports.base.ParameterList;
import org.aspcfs.modules.reports.base.Report;
import org.aspcfs.modules.reports.base.ReportList;
import org.aspcfs.modules.reports.base.ReportQueue;
import org.aspcfs.modules.reports.base.ReportQueueList;
import org.aspcfs.modules.reports.base.ReportTypeList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.JasperReportUtils;

public final class Reports
extends CFSModule {
    public String executeCommandDefault(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        return this.executeCommandViewQueue(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandViewQueue(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.queue", "View Queue");
        Connection db = null;
        try {
            db = this.getConnection(context);
            ReportQueueList completed = new ReportQueueList();
            completed.setEnteredBy(this.getUserId(context));
            completed.setProcessedOnly(true);
            completed.setBuildResources(true);
            completed.buildList(db);
            context.getRequest().setAttribute("completedQueue", (Object)completed);
            ReportQueueList pending = new ReportQueueList();
            pending.setEnteredBy(this.getUserId(context));
            pending.setInQueueOnly(true);
            pending.setSortAscending(true);
            pending.setBuildResources(true);
            pending.buildList(db);
            context.getRequest().setAttribute("pendingQueue", (Object)pending);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ReportQueueOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandRunReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.run", "Run Report");
        Connection db = null;
        try {
            db = this.getConnection(context);
            PermissionCategoryList categories = new PermissionCategoryList();
            categories.setModulesWithReportsOnly(true);
            categories.setEnabledState(1);
            categories.buildList(db);
            context.getRequest().setAttribute("categories", (Object)categories);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "RunReportOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandListReports(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.run", "Run Report");
        Connection db = null;
        String categoryId = context.getRequest().getParameter("categoryId");
        try {
            db = this.getConnection(context);
            PermissionCategory thisCategory = new PermissionCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("category", (Object)thisCategory);
            ReportList reports = new ReportList();
            reports.setCategoryId(Integer.parseInt(categoryId));
            reports.setEnabled(1);
            reports.buildList(db);
            context.getRequest().setAttribute("reports", (Object)reports);
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ListReportsOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCriteriaList(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.run", "Run Report");
        Connection db = null;
        String categoryId = context.getRequest().getParameter("categoryId");
        String reportId = context.getRequest().getParameter("reportId");
        try {
            db = this.getConnection(context);
            PermissionCategory thisCategory = new PermissionCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("category", (Object)thisCategory);
            Report report = new Report(db, Integer.parseInt(reportId));
            context.getRequest().setAttribute("report", (Object)report);
            CriteriaList criteriaList = new CriteriaList();
            criteriaList.setReportId(report.getId());
            criteriaList.setOwner(this.getUserId(context));
            criteriaList.buildList(db);
            ReportTypeList reportTypeList = new ReportTypeList();
            reportTypeList.buildList(db);
            context.getRequest().setAttribute("reportTypeList", (Object)reportTypeList);
            context.getRequest().setAttribute("criteriaList", (Object)criteriaList);
            if (criteriaList.size() == 0) {
                String string = "CriteriaListSKIP";
                return string;
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CriteriaListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteCriteria(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String criteriaId = context.getRequest().getParameter("criteriaId");
        try {
            db = this.getConnection(context);
            CriteriaList.delete(db, Integer.parseInt(criteriaId));
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteCriteriaOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandParameterList(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.run", "Run Report");
        Connection db = null;
        String categoryId = context.getRequest().getParameter("categoryId");
        String reportId = context.getRequest().getParameter("reportId");
        String criteriaId = context.getRequest().getParameter("criteriaId");
        try {
            db = this.getConnection(context);
            PermissionCategory thisCategory = new PermissionCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("category", (Object)thisCategory);
            Report report = new Report(db, Integer.parseInt(reportId));
            context.getRequest().setAttribute("report", (Object)report);
            String reportPath = this.getWebInfPath(context, "reports");
            JasperReport jasperReport = JasperReportUtils.getReport(reportPath + report.getFilename());
            ParameterList params = new ParameterList();
            params = (ParameterList)context.getRequest().getAttribute("parameterList");
            if (params == null) {
                params = new ParameterList();
                params.setParameters(jasperReport);
            }
            context.getRequest().setAttribute("criteriaId", (Object)"-1");
            if (criteriaId != null && !criteriaId.equals("-1") && !"".equals(criteriaId)) {
                CriteriaList criteriaList = new CriteriaList();
                criteriaList.setReportId(report.getId());
                criteriaList.setOwner(this.getUserId(context));
                criteriaList.setCriteriaId(criteriaId);
                criteriaList.buildList(db);
                if (criteriaList.size() != 0) {
                    Criteria criteria = new Criteria(db, Integer.parseInt(criteriaId));
                    criteria.buildResources(db);
                    params.setParameters(criteria);
                    context.getRequest().setAttribute("criteria", (Object)criteria);
                    context.getRequest().setAttribute("criteriaId", (Object)criteriaId);
                } else {
                    context.getRequest().setAttribute("criteriaId", (Object)"-1");
                }
            }
            for (Parameter param : params) {
                if (!param.getIsForPrompting()) continue;
                param.prepareContext(context.getRequest(), db);
            }
            context.getRequest().setAttribute("parameterList", (Object)params);
            context.getRequest().setAttribute("systemStatus", (Object)this.getSystemStatus(context));
            context.getRequest().setAttribute("hasEmail", (Object)"false");
            int contactId = this.getUser(context, this.getUserId(context)).getContactId();
            Contact contact = new Contact();
            contact.setBuildDetails(true);
            contact.queryRecord(db, contactId);
            if (contact.getEmailAddressList().size() > 0) {
                context.getRequest().setAttribute("hasEmail", (Object)"true");
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "ParameterListOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandGenerateReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        this.addModuleBean(context, "reports.run", "Run Report");
        Connection db = null;
        boolean isValid = false;
        boolean result = false;
        boolean toInsert = false;
        SystemStatus systemStatus = this.getSystemStatus(context);
        ParameterList params = new ParameterList();
        Criteria thisCriteria = new Criteria();
        String categoryId = context.getRequest().getParameter("categoryId");
        String reportId = context.getRequest().getParameter("reportId");
        try {
            db = this.getConnection(context);
            PermissionCategory thisCategory = new PermissionCategory(db, Integer.parseInt(categoryId));
            context.getRequest().setAttribute("category", (Object)thisCategory);
            Report report = new Report(db, Integer.parseInt(reportId));
            context.getRequest().setAttribute("report", (Object)report);
            String reportPath = this.getWebInfPath(context, "reports");
            JasperReport jasperReport = JasperReportUtils.getReport(reportPath + report.getFilename());
            params = new ParameterList();
            params.setSystemStatus(systemStatus);
            params.setParameters(jasperReport);
            toInsert = params.setParameters(context.getRequest());
            if (toInsert) {
                Parameter thisParam;
                params.addParam("user_name", this.getUser(context, this.getUserId(context)).getContact().getNameFirstLast());
                params.addParam("path_icons", context.getServletContext().getRealPath("/") + "images" + fs + "icons" + fs);
                params.addParam("path_report_images", this.getPath(context, "report_images"));
                if (params.getParameter("year_part") != null) {
                    thisParam = params.getParameter("year_part");
                    params.addParam("year_part", DatabaseUtils.getYearPart(db, thisParam.getDescription()));
                }
                if (params.getParameter("month_part") != null) {
                    thisParam = params.getParameter("month_part");
                    params.addParam("month_part", DatabaseUtils.getMonthPart(db, thisParam.getDescription()));
                }
                if (params.getParameter("day_part") != null) {
                    thisParam = params.getParameter("day_part");
                    params.addParam("day_part", DatabaseUtils.getDayPart(db, thisParam.getDescription()));
                }
                if (params.getParameter("hour_part") != null) {
                    thisParam = params.getParameter("hour_part");
                    params.addParam("hour_part", DatabaseUtils.getHourPart(db, thisParam.getDescription()));
                }
                if (params.getParameter("min_part") != null) {
                    thisParam = params.getParameter("min_part");
                    params.addParam("min_part", DatabaseUtils.getMinutePart(db, thisParam.getDescription()));
                }
                if (params.getParameter("temp_table_name") != null) {
                    thisParam = params.getParameter("temp_table_name");
                    params.addParam("temp_table_name", DatabaseUtils.getTempTableName(db, thisParam.getDescription()));
                }
                thisCriteria = new Criteria();
                thisCriteria.setReportId(report.getId());
                thisCriteria.setOwner(this.getUserId(context));
                thisCriteria.setEnteredBy(this.getUserId(context));
                thisCriteria.setModifiedBy(this.getUserId(context));
                thisCriteria.setSubject(context.getRequest().getParameter("criteria_subject"));
                thisCriteria.setParameters(params);
                thisCriteria.setSave(context.getRequest().getParameter("save"));
                String saveType = context.getRequest().getParameter("saveType");
                if ("overwrite".equals(saveType)) {
                    thisCriteria.setId(Integer.parseInt(context.getRequest().getParameter("criteriaId")));
                    thisCriteria.setOverwrite(true);
                } else if ("save".equals(saveType)) {
                    thisCriteria.setSave(true);
                }
                if (thisCriteria.getSave() || thisCriteria.getOverwrite()) {
                    isValid = this.validateObject(context, db, (Object)thisCriteria);
                }
                if (isValid) {
                    result = thisCriteria.save(db);
                }
                if (result) {
                    for (Parameter param : params) {
                        param.setCriteriaId(thisCriteria.getId());
                        isValid = this.validateObject(context, db, (Object)param) && isValid;
                        if (!isValid) continue;
                        param.insert(db);
                    }
                }
                String reportTypeStr = context.getRequest().getParameter("reportType");
                int reportType = 1;
                if (reportTypeStr != null) {
                    reportType = Integer.parseInt(reportTypeStr);
                }
                boolean sendEmail = false;
                if ("true".equals(context.getRequest().getParameter("email"))) {
                    sendEmail = true;
                }
                if (isValid || !thisCriteria.getSave() || !thisCriteria.getOverwrite()) {
                    int position = ReportQueue.insert(db, thisCriteria, reportType, sendEmail);
                    context.getRequest().setAttribute("queuePosition", (Object)String.valueOf(position));
                    this.executeJob(context, "reportRunner");
                }
            } else {
                HashMap<String, String> errors = new HashMap<String, String>(params.getErrors());
                errors.put("actionError", systemStatus.getLabel("object.validation.pleaseEnterValidInput"));
                this.processErrors(context, errors);
                context.getRequest().setAttribute("parameterList", (Object)params);
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        if (toInsert && (isValid || !thisCriteria.getSave() || !thisCriteria.getOverwrite())) {
            return "GenerateReportOK";
        }
        return this.executeCommandParameterList(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandStreamReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        ReportQueue queue = null;
        try {
            db = this.getConnection(context);
            queue = new ReportQueue(db, Integer.parseInt(id));
            queue.buildReport(db);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        if (queue != null) {
            try {
                FileDownload download = new FileDownload();
                download.setFullPath(this.getPath(context, "reports-queue") + Reports.getDatePath(queue.getEntered()) + queue.getFilename());
                switch (queue.getOutputTypeConstant()) {
                    case 1: {
                        download.setDisplayName(queue.getReport().getFilename() + ".pdf");
                        break;
                    }
                    case 3: {
                        download.setDisplayName(queue.getReport().getFilename() + ".html");
                        break;
                    }
                    case 2: {
                        download.setDisplayName(queue.getReport().getFilename() + ".csv");
                        break;
                    }
                    case 4: {
                        download.setDisplayName(queue.getReport().getFilename() + ".xls");
                    }
                }
                download.streamContent(context);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDownloadReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        ReportQueue queue = null;
        try {
            db = this.getConnection(context);
            queue = new ReportQueue(db, Integer.parseInt(id));
            queue.buildReport(db);
        }
        catch (Exception e) {
        }
        finally {
            this.freeConnection(context, db);
        }
        if (queue != null) {
            try {
                FileDownload download = new FileDownload();
                download.setFullPath(this.getPath(context, "reports-queue") + Reports.getDatePath(queue.getEntered()) + queue.getFilename());
                switch (queue.getOutputTypeConstant()) {
                    case 1: {
                        download.setDisplayName(queue.getReport().getFilename().substring(0, queue.getReport().getFilename().lastIndexOf(".xml")) + ".pdf");
                        break;
                    }
                    case 3: {
                        download.setDisplayName(queue.getReport().getFilename().substring(0, queue.getReport().getFilename().lastIndexOf(".xml")) + ".html");
                        break;
                    }
                    case 2: {
                        download.setDisplayName(queue.getReport().getFilename().substring(0, queue.getReport().getFilename().lastIndexOf(".xml")) + ".csv");
                        break;
                    }
                    case 4: {
                        download.setDisplayName(queue.getReport().getFilename().substring(0, queue.getReport().getFilename().lastIndexOf(".xml")) + ".xls");
                    }
                }
                download.sendFile(context);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }
        return "-none-";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandDeleteReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            ReportQueue queue = new ReportQueue(db, Integer.parseInt(id), false);
            if (queue.getId() != -1) {
                if (queue.getProcessed() != null) {
                    queue.delete(db, this.getPath(context, "reports-queue") + Reports.getDatePath(queue.getEntered()) + queue.getFilename());
                } else {
                    context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.reportDeletion"));
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "DeleteReportOK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeCommandCancelReport(ActionContext context) {
        if (!this.hasPermission(context, "reports-view")) {
            return "PermissionError";
        }
        SystemStatus systemStatus = this.getSystemStatus(context);
        Connection db = null;
        String id = context.getRequest().getParameter("id");
        try {
            db = this.getConnection(context);
            ReportQueue queue = new ReportQueue(db, Integer.parseInt(id), false);
            if (queue.getId() != -1) {
                if (queue.getProcessed() == null) {
                    queue.delete(db, this.getPath(context, "reports-queue") + Reports.getDatePath(queue.getEntered()) + queue.getFilename());
                } else {
                    context.getRequest().setAttribute("actionError", (Object)systemStatus.getLabel("object.validation.actionError.reportCancellation"));
                }
            }
        }
        catch (Exception e) {
            context.getRequest().setAttribute("Error", (Object)e);
            String string = "SystemError";
            return string;
        }
        finally {
            this.freeConnection(context, db);
        }
        return "CancelReportOK";
    }
}

