/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.aspcfs.modules.reports.base.ParameterList;
import org.aspcfs.utils.DatabaseUtils;

public class Criteria
extends GenericBean {
    private int id = -1;
    private int reportId = -1;
    private int owner = -1;
    private String subject = null;
    private ParameterList parameters = null;
    private Timestamp entered = null;
    private int enteredBy = -1;
    private Timestamp modified = null;
    private int modifiedBy = -1;
    private boolean enabled = true;
    private boolean save = false;
    private boolean overwrite = false;

    public Criteria() {
    }

    public Criteria(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public Criteria(Connection db, int criteriaId) throws SQLException {
        this.queryRecord(db, criteriaId);
    }

    public void queryRecord(Connection db, int criteriaId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT c.* FROM report_criteria c WHERE criteria_id = ? ");
        pst.setInt(1, criteriaId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (this.id == -1) {
            throw new SQLException("Criteria record not found.");
        }
    }

    public void buildResources(Connection db) throws SQLException {
        this.parameters = new ParameterList();
        this.parameters.setCriteriaId(this.id);
        this.parameters.buildList(db);
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("criteria_id");
        this.reportId = rs.getInt("report_id");
        this.owner = rs.getInt("owner");
        this.subject = rs.getString("subject");
        this.entered = rs.getTimestamp("entered");
        this.enteredBy = rs.getInt("enteredby");
        this.modified = rs.getTimestamp("modified");
        this.modifiedBy = rs.getInt("modifiedby");
        this.enabled = rs.getBoolean("enabled");
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setReportId(int tmp) {
        this.reportId = tmp;
    }

    public void setReportId(String tmp) {
        this.reportId = Integer.parseInt(tmp);
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setSubject(String tmp) {
        this.subject = tmp;
    }

    public void setParameters(ParameterList tmp) {
        this.parameters = tmp;
    }

    public void setEntered(Timestamp tmp) {
        this.entered = tmp;
    }

    public void setEntered(String tmp) {
        this.entered = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setEnteredBy(int tmp) {
        this.enteredBy = tmp;
    }

    public void setEnteredBy(String tmp) {
        this.enteredBy = Integer.parseInt(tmp);
    }

    public void setModified(Timestamp tmp) {
        this.modified = tmp;
    }

    public void setModified(String tmp) {
        this.modified = DatabaseUtils.parseTimestamp(tmp);
    }

    public void setModifiedBy(int tmp) {
        this.modifiedBy = tmp;
    }

    public void setModifiedBy(String tmp) {
        this.modifiedBy = Integer.parseInt(tmp);
    }

    public void setEnabled(boolean tmp) {
        this.enabled = tmp;
    }

    public void setEnabled(String tmp) {
        this.enabled = DatabaseUtils.parseBoolean(tmp);
    }

    public void setSave(boolean tmp) {
        this.save = tmp;
    }

    public void setSave(String tmp) {
        this.save = DatabaseUtils.parseBoolean(tmp);
    }

    public void setOverwrite(boolean tmp) {
        this.overwrite = tmp;
    }

    public void setOverwrite(String tmp) {
        this.overwrite = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getReportId() {
        return this.reportId;
    }

    public int getOwner() {
        return this.owner;
    }

    public String getSubject() {
        return this.subject;
    }

    public ParameterList getParameters() {
        if (this.parameters == null) {
            this.parameters = new ParameterList();
        }
        return this.parameters;
    }

    public Timestamp getEntered() {
        return this.entered;
    }

    public int getEnteredBy() {
        return this.enteredBy;
    }

    public Timestamp getModified() {
        return this.modified;
    }

    public int getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public boolean getSave() {
        return this.save;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public boolean save(Connection db) throws SQLException {
        if (this.overwrite) {
            this.update(db);
        } else if (this.save) {
            this.insert(db);
        }
        return true;
    }

    public boolean insert(Connection db) throws SQLException {
        boolean commit = db.getAutoCommit();
        try {
            if (commit) {
                db.setAutoCommit(false);
            }
            StringBuffer sql = new StringBuffer();
            this.id = DatabaseUtils.getNextSeq(db, "report_criteria_criteria_id_seq");
            sql.append("INSERT INTO report_criteria (report_id, owner, subject, enteredby, modifiedby, ");
            if (this.id > -1) {
                sql.append("criteria_id, ");
            }
            if (this.entered != null) {
                sql.append("entered, ");
            }
            if (this.modified != null) {
                sql.append("modified, ");
            }
            sql.append("enabled) ");
            sql.append("VALUES (?, ?, ?, ?, ?, ");
            if (this.id > -1) {
                sql.append("?, ");
            }
            if (this.entered != null) {
                sql.append("?, ");
            }
            if (this.modified != null) {
                sql.append("?, ");
            }
            sql.append("?) ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setInt(++i, this.reportId);
            pst.setInt(++i, this.owner);
            pst.setString(++i, this.subject);
            pst.setInt(++i, this.enteredBy);
            pst.setInt(++i, this.modifiedBy);
            if (this.id > -1) {
                pst.setInt(++i, this.id);
            }
            if (this.entered != null) {
                pst.setTimestamp(++i, this.entered);
            }
            if (this.modified != null) {
                pst.setTimestamp(++i, this.modified);
            }
            pst.setBoolean(++i, this.enabled);
            pst.execute();
            pst.close();
            this.id = DatabaseUtils.getCurrVal(db, "report_criteria_criteria_id_seq", this.id);
            if (this.parameters != null) {
                this.parameters.setCriteriaId(this.id);
                this.parameters.insert(db);
            }
            if (commit) {
                db.commit();
            }
        }
        catch (SQLException e) {
            if (commit) {
                db.rollback();
            }
            throw new SQLException(e.getMessage());
        }
        finally {
            if (commit) {
                db.setAutoCommit(true);
            }
        }
        return true;
    }

    public boolean update(Connection db) throws SQLException {
        try {
            db.setAutoCommit(false);
            StringBuffer sql = new StringBuffer();
            sql.append("UPDATE report_criteria SET subject = ?, modified = " + DatabaseUtils.getCurrentTimestamp(db) + " " + "WHERE criteria_id = ? ");
            int i = 0;
            PreparedStatement pst = db.prepareStatement(sql.toString());
            pst.setString(++i, this.subject);
            pst.setInt(++i, this.id);
            pst.executeUpdate();
            pst.close();
            if (this.parameters != null) {
                this.parameters.setCriteriaId(this.id);
                this.parameters.update(db);
            }
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
        return true;
    }
}

