/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import org.aspcfs.modules.reports.base.Criteria;
import org.aspcfs.utils.web.PagedListInfo;

public class CriteriaList
extends ArrayList {
    protected PagedListInfo pagedListInfo = null;
    protected int reportId = -1;
    protected int owner = -1;
    protected int criteriaId = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setReportId(int tmp) {
        this.reportId = tmp;
    }

    public void setReportId(String tmp) {
        this.reportId = Integer.parseInt(tmp);
    }

    public void setOwner(int tmp) {
        this.owner = tmp;
    }

    public void setOwner(String tmp) {
        this.owner = Integer.parseInt(tmp);
    }

    public void setCriteriaId(int tmp) {
        this.criteriaId = tmp;
    }

    public void setCriteriaId(String tmp) {
        this.criteriaId = Integer.parseInt(tmp);
    }

    public int getReportId() {
        return this.reportId;
    }

    public int getOwner() {
        return this.owner;
    }

    public int getCriteriaId() {
        return this.criteriaId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM report_criteria c WHERE criteria_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("c.modified", "DESC");
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY c.modified DESC ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("c.* FROM report_criteria c WHERE criteria_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Criteria thisCriteria = new Criteria(rs);
            this.add(thisCriteria);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.reportId != -1) {
            sqlFilter.append("AND c.report_id = ? ");
        }
        if (this.owner != -1) {
            sqlFilter.append("AND c.owner = ? ");
        }
        if (this.criteriaId != -1) {
            sqlFilter.append("AND c.criteria_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.reportId != -1) {
            pst.setInt(++i, this.reportId);
        }
        if (this.owner != -1) {
            pst.setInt(++i, this.owner);
        }
        if (this.criteriaId != -1) {
            pst.setInt(++i, this.criteriaId);
        }
        return i;
    }

    public static void delete(Connection db, int criteriaId) throws SQLException {
        try {
            db.setAutoCommit(false);
            PreparedStatement pst = db.prepareStatement("DELETE FROM report_criteria_parameter WHERE criteria_id = ? ");
            pst.setInt(1, criteriaId);
            pst.execute();
            pst.close();
            pst = db.prepareStatement("DELETE FROM report_criteria WHERE criteria_id = ? ");
            pst.setInt(1, criteriaId);
            pst.execute();
            pst.close();
            db.commit();
        }
        catch (SQLException e) {
            db.rollback();
            throw new SQLException(e.getMessage());
        }
        finally {
            db.setAutoCommit(true);
        }
    }
}

