/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRParameter;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.accounts.base.Organization;
import org.aspcfs.modules.admin.base.RoleList;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.login.beans.UserBean;
import org.aspcfs.modules.reports.base.ParameterList;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.HTTPUtils;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.HtmlSelect;
import org.aspcfs.utils.web.HtmlSelectProbabilityRange;
import org.aspcfs.utils.web.HtmlSelectRecordSource;
import org.aspcfs.utils.web.LookupList;
import org.aspcfs.utils.web.StateSelect;

public class Parameter
extends GenericBean {
    private int id = -1;
    private int criteriaId = -1;
    private int type = -1;
    private String name = null;
    private String value = null;
    private String displayValue = null;
    private Class valueClass = null;
    private String description = null;
    private boolean required = false;
    private boolean isForPrompting = false;
    private boolean isSystemDefined = false;

    public Parameter() {
    }

    public Parameter(Connection db, int parameterId) throws SQLException {
        this.queryRecord(db, parameterId);
    }

    public void queryRecord(Connection db, int parameterId) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT p.* FROM report_criteria_parameter p WHERE p.parameter_id = ? ");
        pst.setInt(1, parameterId);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.build(rs);
        }
        rs.close();
        pst.close();
        if (this.getId() == -1) {
            throw new SQLException("Record Not Found");
        }
    }

    public Parameter(ResultSet rs) throws SQLException {
        this.build(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setCriteriaId(int tmp) {
        this.criteriaId = tmp;
    }

    public void setCriteriaId(String tmp) {
        this.criteriaId = Integer.parseInt(tmp);
    }

    public void setType(int tmp) {
        this.type = tmp;
    }

    public void setType(String tmp) {
        this.type = Integer.parseInt(tmp);
    }

    public void setName(String tmp) {
        this.name = tmp;
    }

    public void setValue(String tmp) {
        this.value = tmp;
    }

    public void setDisplayValue(String tmp) {
        this.displayValue = tmp;
    }

    public void setValueClass(Class tmp) {
        this.valueClass = tmp;
    }

    public void setDescription(String tmp) {
        this.description = tmp;
    }

    public void setRequired(boolean tmp) {
        this.required = tmp;
    }

    public void setRequired(String tmp) {
        this.required = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIsForPrompting(boolean tmp) {
        this.isForPrompting = tmp;
    }

    public void setIsForPrompting(String tmp) {
        this.isForPrompting = DatabaseUtils.parseBoolean(tmp);
    }

    public void setIsSystemDefined(boolean tmp) {
        this.isSystemDefined = tmp;
    }

    public void setIsSystemDefined(String tmp) {
        this.isSystemDefined = DatabaseUtils.parseBoolean(tmp);
    }

    public int getId() {
        return this.id;
    }

    public int getCriteriaId() {
        return this.criteriaId;
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        return this.displayValue;
    }

    public Class getValueClass() {
        return this.valueClass;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        if (this.description != null && !"".equals(this.description)) {
            return this.description;
        }
        return this.name;
    }

    public String getDisplayName(SystemStatus thisSystem) {
        if (this.description != null && !"".equals(this.description)) {
            return thisSystem.getLabel(this.description);
        }
        return this.name;
    }

    public boolean getRequired() {
        return this.required;
    }

    public boolean getIsForPrompting() {
        return this.isForPrompting;
    }

    public boolean getIsSystemDefined() {
        return this.isSystemDefined;
    }

    public void setParam(JRParameter param) {
        this.name = param.getName();
        this.value = null;
        this.description = param.getDescription();
        this.required = param.isForPrompting();
        this.valueClass = param.getValueClass();
        this.isForPrompting = param.isForPrompting();
        this.isSystemDefined = param.isSystemDefined();
    }

    public void build(ResultSet rs) throws SQLException {
        this.id = rs.getInt("parameter_id");
        this.criteriaId = rs.getInt("criteria_id");
        this.name = rs.getString("parameter");
        this.value = rs.getString("value");
    }

    public boolean isValid() {
        if (this.criteriaId == -1) {
            this.errors.put("criteriaIdError", "Criteria Id is required");
        }
        return !this.hasErrors();
    }

    public boolean insert(Connection db) throws SQLException {
        if (!this.isValid()) {
            return false;
        }
        int i = 0;
        this.id = DatabaseUtils.getNextSeq(db, "report_criteria_parameter_parameter_id_seq");
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO report_criteria_parameter (" + (this.id > -1 ? "parameter_id, " : "") + "criteria_id, " + DatabaseUtils.addQuotes(db, "parameter") + ", " + DatabaseUtils.addQuotes(db, "value") + ") ");
        sql.append("VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
        PreparedStatement pst = db.prepareStatement(sql.toString());
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.criteriaId);
        pst.setString(++i, this.name);
        pst.setString(++i, this.value);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "report_criteria_parameter_parameter_id_seq", this.id);
        return true;
    }

    public void prepareContext(HttpServletRequest request, Connection db) throws SQLException {
        if (!this.name.startsWith("lookup_state")) {
            if (this.name.startsWith("lookup_ticket_severity") && !this.name.endsWith("_where")) {
                LookupList select = new LookupList(db, "ticket_severity");
                select.addItem(-1, "Any");
                request.setAttribute(this.name, (Object)select);
            } else if (this.name.startsWith("lookup_ticket_priority") && !this.name.endsWith("_where")) {
                LookupList select = new LookupList(db, "ticket_priority");
                select.addItem(-1, "Any");
                request.setAttribute(this.name, (Object)select);
            } else if (!this.name.startsWith("lookup_call_result") || this.name.endsWith("_where")) {
                if (this.name.startsWith("lookup_role") && !this.name.endsWith("_where")) {
                    RoleList roles = new RoleList();
                    roles.buildList(db);
                    LookupList select = roles.getLookupList();
                    select.addItem(-1, "Any");
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("lookup_stage") && !this.name.endsWith("_where")) {
                    LookupList select = new LookupList(db, "lookup_stage");
                    select.addItem(-1, "Any");
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("lookup_") && !this.name.endsWith("_where")) {
                    LookupList select = new LookupList(db, this.name);
                    select.addItem(-1, "Any");
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("textlookup_") && !this.name.endsWith("_where")) {
                    LookupList select = new LookupList(db, this.name.substring(4));
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("boolean_") && !this.name.endsWith("_where")) {
                    HtmlSelect select = new HtmlSelect();
                    select.addItem("-1", "Any");
                    select.addItem("1", "Yes");
                    select.addItem("0", "No");
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("orgid")) {
                    try {
                        int id = Integer.parseInt(this.value);
                        Organization org = new Organization(db, id);
                        this.displayValue = org.getName();
                    }
                    catch (Exception e) {
                        this.displayValue = "All";
                        this.value = "-1";
                    }
                } else if (this.name.startsWith("siteid")) {
                    if (UserUtils.getUserSiteId(request) <= -1) {
                        try {
                            int id = Integer.parseInt(this.value);
                            LookupList sites = new LookupList(db, "lookup_site_id");
                            this.displayValue = sites.getValueFromId(id);
                            if ("".equals(this.displayValue.trim())) {
                                this.displayValue = "All";
                            }
                        }
                        catch (Exception e) {
                            this.displayValue = "All";
                            this.value = "-1";
                        }
                    } else {
                        this.value = String.valueOf(UserUtils.getUserSiteId(request));
                        this.isForPrompting = false;
                    }
                } else if (this.name.startsWith("date_")) {
                    try {
                        Timestamp tmpTimestamp = DateUtils.getUserToServerDateTime(null, 3, 1, this.value, Locale.getDefault());
                        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, UserUtils.getUserLocale(request));
                        formatter.applyPattern(DateUtils.get4DigitYearDateFormat(formatter.toPattern()));
                        this.value = formatter.format(tmpTimestamp);
                    }
                    catch (Exception e) {}
                } else if (this.name.startsWith("range_date")) {
                    HtmlSelect select = new HtmlSelect();
                    select.addItem("-1", "All");
                    select.addItem("7", "Last 7 days");
                    select.addItem("14", "Last 14 days");
                    select.addItem("30", "Last 30 days");
                    request.setAttribute(this.name, (Object)select);
                } else if (this.name.startsWith("hidden_")) {
                    // empty if block
                }
            }
        }
    }

    public String getHtml(SystemStatus thisSystem, HttpServletRequest request, ParameterList params) {
        if (this.name.equals("userid_range_source")) {
            return HtmlSelectRecordSource.getSelect(this.name, this.value).getHtml();
        }
        if (this.name.startsWith("date_")) {
            User user = ((UserBean)((Object)request.getSession().getAttribute("User"))).getUserRecord();
            String language = user.getLocale().getLanguage();
            String country = user.getLocale().getCountry();
            return "<input type='text' size='10' name='" + this.name + "' " + "value='" + HTTPUtils.toHtmlValue(this.value) + "'/>\r\n" + "<a href=\"javascript:popCalendar('paramForm', '" + this.name + "','" + language + "','" + country + "');\">" + "<img src=\"images/icons/stock_form-date-field-16.gif\" " + "border=\"0\" align=\"absmiddle\" height=\"16\" width=\"16\"/></a>";
        }
        if (this.name.startsWith("lookup_state")) {
            User user = ((UserBean)((Object)request.getSession().getAttribute("User"))).getUserRecord();
            String country = user.getLocale().getCountry();
            return new StateSelect(thisSystem, country).getHtmlSelect(this.name, country);
        }
        if (this.name.startsWith("lookup_") && !this.name.endsWith("_where")) {
            LookupList select = (LookupList)request.getAttribute(this.name);
            if (this.value != null) {
                return select.getHtmlSelect(this.name, Integer.parseInt(this.value));
            }
            return select.getHtmlSelect(this.name, -1);
        }
        if (this.name.startsWith("textlookup_") && !this.name.endsWith("_where")) {
            int defaultSize = 30;
            int maxLength = -1;
            if (this.name.indexOf(":") > -1) {
                maxLength = Integer.parseInt(this.name.substring(this.name.indexOf(":") + 1));
                defaultSize = maxLength > 40 ? 40 : maxLength;
            }
            String textBox = "<input type=\"text\" size=\"" + defaultSize + "\" " + (maxLength == -1 ? "" : "maxlength=\"" + maxLength + "\" ") + "name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\"/>";
            LookupList select = (LookupList)request.getAttribute(this.name);
            if (select == null) {
                return textBox;
            }
            select.setJsEvent("onClick=\"javascript:document.forms['paramForm'].elements['" + this.name + "'].value=this.options[this.selectedIndex].text\"");
            if (this.value != null) {
                return textBox + " " + select.getHtmlSelect(this.name + System.currentTimeMillis(), Integer.parseInt(this.value));
            }
            return textBox + " " + select.getHtmlSelect(this.name + System.currentTimeMillis(), -1);
        }
        if (this.name.startsWith("boolean_") && !this.name.endsWith("_where")) {
            HtmlSelect select = (HtmlSelect)request.getAttribute(this.name);
            if (this.value != null) {
                return select.getHtml(this.name, Integer.parseInt(this.value));
            }
            return select.getHtml(this.name, -1);
        }
        if (this.name.startsWith("percent_") && !this.name.endsWith("_max") && !this.name.endsWith("_min")) {
            return HtmlSelectProbabilityRange.getSelect(this.name, this.value).getHtml();
        }
        if (this.name.startsWith("text_")) {
            int defaultSize = 30;
            int maxLength = -1;
            if (this.name.indexOf(":") > -1) {
                maxLength = Integer.parseInt(this.name.substring(this.name.indexOf(":") + 1));
                defaultSize = maxLength > 40 ? 40 : maxLength;
            }
            return "<input type=\"text\" size=\"" + defaultSize + "\" " + (maxLength == -1 ? "" : "maxlength=\"" + maxLength + "\" ") + "name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\"/>";
        }
        if (this.name.startsWith("number_")) {
            int defaultSize = 30;
            int maxLength = -1;
            if (this.name.indexOf(":") > -1) {
                maxLength = Integer.parseInt(this.name.substring(this.name.indexOf(":") + 1));
                defaultSize = maxLength > 40 ? 40 : maxLength;
            }
            return "<input type=\"text\" size=\"" + defaultSize + "\" " + (maxLength == -1 ? "" : "maxlength=\"" + maxLength + "\" ") + "name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\"/>";
        }
        if (this.name.startsWith("orgid")) {
            return "<div id=\"change" + this.name + "\" style=\"display:inline\">" + this.displayValue + "</div>" + "<input type=\"hidden\" name=\"" + this.name + "\" id=\"" + this.name + "\" value=\"" + this.value + "\">" + "&nbsp; [<a href=\"javascript:popSiteAccountsListSingle('" + this.name + "','change" + this.name + "','siteid" + "', 'showMyCompany=true&filters=all|my|disabled');\">Select</a>]" + "&nbsp; [<a href=\"javascript:changeDivContent('change" + this.name + "','All');javascript:resetNumericFieldValue('" + this.name + "');\">Clear</a>]";
        }
        if (this.name.startsWith("siteid")) {
            String resetOrg = "";
            Parameter orgParam = params.getParameter("orgid");
            if (orgParam != null) {
                resetOrg = resetOrg + "javascript:changeDivContent('change" + orgParam.getName() + "', 'All');";
                resetOrg = resetOrg + "javascript:resetNumericFieldValue('" + orgParam.getName() + "');";
            }
            return "<div id=\"change" + this.name + "\" style=\"display:inline\">" + this.displayValue + "</div>" + "<input type=\"hidden\" name=\"" + this.name + "\" id=\"" + this.name + "\" value=\"" + this.value + "\">" + "&nbsp; [<a href=\"javascript:popLookupSelector('" + this.name + "','change" + this.name + "', 'lookup_site_id', '&listType=single');" + (orgParam != null ? resetOrg : "") + "\">Select</a>]" + "&nbsp; [<a href=\"javascript:changeDivContent('change" + this.name + "','All');javascript:resetNumericFieldValue('" + this.name + "');" + (orgParam != null ? resetOrg : "") + "\">Clear</a>]";
        }
        if (this.name.startsWith("range_date")) {
            HtmlSelect select = (HtmlSelect)request.getAttribute(this.name);
            if (this.value != null) {
                return select.getHtml(this.name, Integer.parseInt(this.value));
            }
            return select.getHtml(this.name, -1);
        }
        if (this.name.startsWith("hidden_")) {
            return "<input type=\"hidden\" name=\"" + this.name + "\" " + "value=\"" + HTTPUtils.toHtmlValue(this.value) + "\"/>";
        }
        return "Parameter type not supported";
    }
}

