/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JasperReport;
import org.aspcfs.controller.SystemStatus;
import org.aspcfs.modules.admin.base.PermissionCategory;
import org.aspcfs.modules.admin.base.User;
import org.aspcfs.modules.reports.base.Criteria;
import org.aspcfs.modules.reports.base.Parameter;
import org.aspcfs.utils.DateUtils;
import org.aspcfs.utils.Template;
import org.aspcfs.utils.UserUtils;
import org.aspcfs.utils.web.HtmlSelectProbabilityRange;
import org.aspcfs.utils.web.PagedListInfo;

public class ParameterList
extends ArrayList {
    private int criteriaId = -1;
    protected PagedListInfo pagedListInfo = null;
    public HashMap errors = new HashMap();
    public SystemStatus systemStatus = null;

    public void setCriteriaId(int tmp) {
        this.criteriaId = tmp;
    }

    public void setCriteriaId(String tmp) {
        this.criteriaId = Integer.parseInt(tmp);
    }

    public void setSystemStatus(SystemStatus tmp) {
        this.systemStatus = tmp;
    }

    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    public int getCriteriaId() {
        return this.criteriaId;
    }

    public void setErrors(HashMap tmp) {
        this.errors = tmp;
    }

    public HashMap getErrors() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public void setParameters(JasperReport report) {
        JRParameter[] params = report.getParameters();
        for (int i = 0; i < params.length; ++i) {
            JRParameter param = params[i];
            Parameter thisParam = new Parameter();
            thisParam.setParam(param);
            if (thisParam.getIsSystemDefined()) continue;
            this.add(thisParam);
        }
    }

    public boolean setParameters(HttpServletRequest request) {
        StringTokenizer st;
        Timestamp startDate = null;
        Timestamp endDate = null;
        Calendar today = Calendar.getInstance();
        for (Parameter param : this) {
            if (param.getIsForPrompting() || param.getRequired()) {
                Template where;
                Parameter whereParam;
                param.setValue(request.getParameter(param.getName()));
                if (param.getName().equals("userid_range_source")) {
                    if (param.getValue().equals("all")) {
                        this.addParam("userid_range", "");
                    } else if (param.getValue().equals("hierarchy")) {
                        this.addParam("userid_range", UserUtils.getUserIdRange(request));
                    } else {
                        this.addParam("userid_range", String.valueOf(UserUtils.getUserId(request)));
                    }
                }
                if (param.getName().startsWith("lookup_")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if (!"-1".equals(param.getValue())) {
                            where = new Template(whereParam.getDescription());
                            where.addParseElement("$P{" + param.getName() + "}", param.getValue());
                            this.addParam(whereParam.getName(), where.getParsedText());
                        } else {
                            this.addParam(whereParam.getName(), " ");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().startsWith("boolean_")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if ("1".equals(param.getValue())) {
                            this.addParam(whereParam.getName(), whereParam.getDescription());
                        } else if (!"0".equals(param.getValue())) {
                            this.addParam(whereParam.getName(), "");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().equals("range_date")) {
                    Parameter startParam = this.getParameter("date_start");
                    Parameter endParam = this.getParameter("date_end");
                    if (startParam != null && endParam != null) {
                        startParam.setValue(request.getParameter(startParam.getName()));
                        endParam.setValue(request.getParameter(endParam.getName()));
                        if (startParam.getValue() != null && endParam.getValue() != null) {
                            String end;
                            String start;
                            if (!"".equals(startParam.getValue().trim()) && "".equals(endParam.getValue().trim())) {
                                startDate = this.getTimestamp(request, startParam.getValue());
                                start = this.getDateAsString(startDate);
                                startParam.setValue(start);
                                this.setDateRange(start, "");
                                Parameter rangeEndParam = this.getParameter("range_date_end");
                                this.addParam(rangeEndParam.getName(), "");
                            } else if (!"".equals(endParam.getValue().trim()) && "".equals(startParam.getValue().trim())) {
                                endDate = this.getTimestamp(request, endParam.getValue());
                                end = this.getDateAsString(endDate);
                                endParam.setValue(end);
                                this.setDateRange("", end);
                                Parameter rangeStartParam = this.getParameter("range_date_start");
                                this.addParam(rangeStartParam.getName(), "");
                            } else if (!"".equals(endParam.getValue().trim()) && !"".equals(startParam.getValue().trim())) {
                                startDate = this.getTimestamp(request, startParam.getValue());
                                start = this.getDateAsString(startDate);
                                startParam.setValue(start);
                                endDate = this.getTimestamp(request, endParam.getValue());
                                String end2 = this.getDateAsString(endDate);
                                endParam.setValue(end2);
                                this.setDateRange(start, end2);
                            } else {
                                end = DateUtils.roundUpToNextFive(System.currentTimeMillis()).toString();
                                String start2 = "";
                                if ("7".equals(param.getValue())) {
                                    today.add(5, -7);
                                    start2 = this.getDateAsString(request, today);
                                } else if ("14".equals(param.getValue())) {
                                    today.add(5, -14);
                                    start2 = this.getDateAsString(request, today);
                                } else if ("30".equals(param.getValue())) {
                                    today.add(5, -30);
                                    start2 = this.getDateAsString(request, today);
                                }
                                if (!"-1".equals(param.getValue())) {
                                    this.setDateRange(start2, end);
                                    this.addParam(startParam.getName(), start2);
                                    this.addParam(endParam.getName(), end);
                                } else {
                                    Parameter rangeStartParam = this.getParameter("range_date_start");
                                    Parameter rangeEndParam = this.getParameter("range_date_end");
                                    this.addParam(rangeStartParam.getName(), "");
                                    this.addParam(rangeEndParam.getName(), "");
                                }
                            }
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().startsWith("textlookup_")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if (!"".equals(param.getValue())) {
                            where = new Template(whereParam.getDescription());
                            where.addParseElement("$P{" + param.getName() + "}", param.getValue());
                            this.addParam(whereParam.getName(), where.getParsedText());
                        } else {
                            this.addParam(whereParam.getName(), " ");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().startsWith("text_")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if (!"".equals(param.getValue())) {
                            where = new Template(whereParam.getDescription());
                            where.addParseElement("$P{" + param.getName() + "}", param.getValue());
                            this.addParam(whereParam.getName(), where.getParsedText());
                        } else {
                            this.addParam(whereParam.getName(), " ");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().startsWith("percent_")) {
                    st = new StringTokenizer(param.getValue(), "|");
                    this.addParam(param.getName() + "_min", st.nextToken());
                    this.addParam(param.getName() + "_max", st.nextToken());
                    param.setValue(HtmlSelectProbabilityRange.getValueFromId(param.getValue()));
                }
                if (param.getName().startsWith("orgid")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if (!"-1".equals(param.getValue())) {
                            where = new Template(whereParam.getDescription());
                            where.addParseElement("$P{" + param.getName() + "}", param.getValue());
                            this.addParam(whereParam.getName(), where.getParsedText());
                        } else {
                            this.addParam(whereParam.getName(), " ");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                if (param.getName().startsWith("siteid")) {
                    whereParam = this.getParameter(param.getName() + "_where");
                    if (whereParam != null) {
                        if (!"-1".equals(param.getValue())) {
                            where = new Template(whereParam.getDescription());
                            where.addParseElement("$P{" + param.getName() + "}", param.getValue());
                            this.addParam(whereParam.getName(), where.getParsedText());
                        } else {
                            this.addParam(whereParam.getName(), " ");
                        }
                    }
                    this.addParam(param.getName(), param.getValue());
                }
                try {
                    if (this.getParameter("range_date") == null && param.getName().startsWith("date_")) {
                        Timestamp tmpTimestamp = DateUtils.getUserToServerDateTime(TimeZone.getTimeZone(UserUtils.getUserTimeZone(request)), 3, 1, param.getValue(), UserUtils.getUserLocale(request));
                        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, Locale.getDefault());
                        String date = formatter.format(tmpTimestamp);
                        param.setValue(date);
                        if (param.getName().equals("date_start")) {
                            startDate = tmpTimestamp;
                        }
                        if (param.getName().equals("date_end")) {
                            endDate = tmpTimestamp;
                        }
                    }
                }
                catch (Exception e) {
                    if (this.systemStatus != null) {
                        this.errors.put(param.getName() + "Error", this.systemStatus.getLabel("object.validation.invalidInput"));
                    }
                    this.errors.put(param.getName() + "Error", "no input or invalid date");
                }
            }
            if (param.getName().startsWith("hidden_")) {
                // empty if block
            }
            if (System.getProperty("DEBUG") == null) continue;
            System.out.println("ParameterList-> " + param.getName() + "=" + param.getValue());
        }
        if (startDate != null && endDate != null && startDate.after(endDate)) {
            if (this.systemStatus != null) {
                this.errors.put("date_startError", this.systemStatus.getLabel("object.validation.firstDateNotAfterSecondDate"));
            } else {
                this.errors.put("date_startError", "The first date can not be after second date.");
            }
        }
        this.addParam("currency", UserUtils.getUserCurrency(request));
        this.addParam("country", UserUtils.getUserLocale(request).getCountry());
        this.addParam("language", UserUtils.getUserLocale(request).getLanguage());
        this.addParam("userid", String.valueOf(UserUtils.getUserId(request)));
        this.addParam("user_hierarchy", UserUtils.getUserIdRange(request));
        this.addParam("user_contact_name", UserUtils.getUserContactName(request));
        PermissionCategory thisCategory = (PermissionCategory)((Object)request.getAttribute("category"));
        if (thisCategory != null) {
            switch (thisCategory.getConstant()) {
                case 1: 
                case 228051100: {
                    this.addParam("actionplan_module_constant", String.valueOf(42420034));
                    this.addParam("actionplan_module_opp_constant", String.valueOf(1011200517));
                    break;
                }
                case 8: {
                    this.addParam("actionplan_module_constant", String.valueOf(912051329));
                }
            }
        }
        this.addParam("COMPLETE_FOLLOWUP_PENDING", String.valueOf(3));
        try {
            if (this.getParameter("user_id_ranges") != null && this.systemStatus != null) {
                st = new StringTokenizer(UserUtils.getUserIdRange(request), ",");
                while (st.hasMoreTokens()) {
                    String userId = st.nextToken().trim();
                    User userRecord = this.systemStatus.getUser(Integer.parseInt(userId));
                    if (userRecord == null) continue;
                    this.addParameter("user_id_range_" + userId, userRecord.getIdRange(), Class.forName("java.lang.String"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
        return !this.hasErrors();
    }

    public void setParameters(Criteria criteria) {
        for (Parameter param : criteria.getParameters()) {
            this.addParam(param.getName(), param.getValue());
        }
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM report_criteria_parameter p WHERE parameter_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("parameter_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY parameter_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("p.* FROM report_criteria_parameter p WHERE parameter_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            Parameter thisParameter = new Parameter(rs);
            this.add(thisParameter);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.criteriaId != -1) {
            sqlFilter.append("AND p.criteria_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.criteriaId != -1) {
            pst.setInt(++i, this.criteriaId);
        }
        return i;
    }

    public void insert(Connection db) throws SQLException {
        for (Parameter thisParameter : this) {
            thisParameter.setCriteriaId(this.criteriaId);
            thisParameter.insert(db);
        }
    }

    public void update(Connection db) throws SQLException {
        this.delete(db);
        for (Parameter thisParameter : this) {
            thisParameter.setCriteriaId(this.criteriaId);
            thisParameter.insert(db);
        }
    }

    public void delete(Connection db) throws SQLException {
        PreparedStatement pst = db.prepareStatement("DELETE FROM report_criteria_parameter WHERE criteria_id = ? ");
        pst.setInt(1, this.criteriaId);
        pst.execute();
        pst.close();
    }

    private void addParameter(String param, String value, Class className) {
        boolean added = this.addParam(param, value);
        if (!added) {
            Parameter parameter = new Parameter();
            parameter.setName(param);
            parameter.setValue(value);
            parameter.setValueClass(className);
            this.add(parameter);
        }
    }

    public boolean addParam(String param, String value) {
        for (Parameter thisParameter : this) {
            if (!param.equals(thisParameter.getName())) continue;
            thisParameter.setValue(value);
            return true;
        }
        return false;
    }

    public String getDisplayValues() {
        StringBuffer sb = new StringBuffer();
        for (Parameter thisParameter : this) {
            if (!thisParameter.getIsForPrompting()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(thisParameter.getDescription() + "=" + thisParameter.getValue());
        }
        return sb.toString();
    }

    public Class getValueClass(String param) {
        for (Parameter thisParam : this) {
            if (!param.equals(thisParam.getName())) continue;
            return thisParam.getValueClass();
        }
        return null;
    }

    public Parameter getParameter(String param) {
        for (Parameter thisParam : this) {
            if (!param.equals(thisParam.getName())) continue;
            return thisParam;
        }
        return null;
    }

    private Timestamp getTimestamp(HttpServletRequest request, String value) {
        Timestamp tmpTimestamp = DateUtils.getUserToServerDateTime(TimeZone.getTimeZone(UserUtils.getUserTimeZone(request)), 3, 1, value, UserUtils.getUserLocale(request));
        return tmpTimestamp;
    }

    private String getDateAsString(Timestamp ts) {
        SimpleDateFormat formatter = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, Locale.getDefault());
        return formatter.format(ts);
    }

    private String getDateAsString(HttpServletRequest request, Calendar cal) {
        String date = DateUtils.getServerToUserDateString(TimeZone.getTimeZone(UserUtils.getUserTimeZone(request)), 3, DateUtils.getUserToServerDateTime(cal, TimeZone.getTimeZone(UserUtils.getUserTimeZone(request))));
        return date;
    }

    private void setDateRange(String start, String end) {
        Parameter rangeStartParam = this.getParameter("range_date_start");
        Template t1 = new Template(rangeStartParam.getDescription());
        t1.addParseElement("$P{date_start}", "'" + start + "'");
        this.addParam(rangeStartParam.getName(), t1.getParsedText());
        Parameter rangeEndParam = this.getParameter("range_date_end");
        Template t2 = new Template(rangeEndParam.getDescription());
        t2.addParseElement("$P{date_end}", "'" + end + "'");
        this.addParam(rangeEndParam.getName(), t2.getParsedText());
    }
}

