/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import com.darkhorseventures.framework.beans.GenericBean;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.aspcfs.utils.DatabaseUtils;

public class QueueCriteria
extends GenericBean {
    private int id = -1;
    private int queueId = -1;
    private String parameter = null;
    private String value = null;

    public QueueCriteria() {
    }

    public QueueCriteria(Connection db, int id) throws SQLException {
        this.queryRecord(db, id);
    }

    public void queryRecord(Connection db, int id) throws SQLException {
        PreparedStatement pst = db.prepareStatement("SELECT q.* FROM report_queue_criteria q WHERE criteria_id = ? ");
        pst.setInt(1, id);
        ResultSet rs = pst.executeQuery();
        if (rs.next()) {
            this.buildRecord(rs);
        }
        rs.close();
        pst.close();
        if (id == -1) {
            throw new SQLException("Queue Criteria record not found.");
        }
    }

    public QueueCriteria(ResultSet rs) throws SQLException {
        this.buildRecord(rs);
    }

    public void setId(int tmp) {
        this.id = tmp;
    }

    public void setId(String tmp) {
        this.id = Integer.parseInt(tmp);
    }

    public void setQueueId(int tmp) {
        this.queueId = tmp;
    }

    public void setQueueId(String tmp) {
        this.queueId = Integer.parseInt(tmp);
    }

    public void setParameter(String tmp) {
        this.parameter = tmp;
    }

    public void setValue(String tmp) {
        this.value = tmp;
    }

    public int getId() {
        return this.id;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public String getParameter() {
        return this.parameter;
    }

    public String getValue() {
        return this.value;
    }

    protected void buildRecord(ResultSet rs) throws SQLException {
        this.id = rs.getInt("criteria_id");
        this.queueId = rs.getInt("queue_id");
        this.parameter = rs.getString("parameter");
        this.value = rs.getString("value");
    }

    public void insert(Connection db) throws SQLException {
        this.id = DatabaseUtils.getNextSeq(db, "report_queue_criteria_criteria_id_seq");
        PreparedStatement pst = db.prepareStatement("INSERT INTO report_queue_criteria (" + (this.id > -1 ? "criteria_id, " : "") + "queue_id, " + DatabaseUtils.addQuotes(db, "parameter") + ", " + DatabaseUtils.addQuotes(db, "value") + ") " + "VALUES (" + (this.id > -1 ? "?, " : "") + "?, ?, ?) ");
        int i = 0;
        if (this.id > -1) {
            pst.setInt(++i, this.id);
        }
        pst.setInt(++i, this.queueId);
        pst.setString(++i, this.parameter);
        pst.setString(++i, this.value);
        pst.execute();
        pst.close();
        this.id = DatabaseUtils.getCurrVal(db, "report_queue_criteria_criteria_id_seq", this.id);
    }
}

