/*
 * Decompiled with CFR 0.152.
 */
package org.aspcfs.modules.reports.base;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReport;
import org.aspcfs.modules.reports.base.ParameterList;
import org.aspcfs.modules.reports.base.QueueCriteria;
import org.aspcfs.utils.DatabaseUtils;
import org.aspcfs.utils.web.PagedListInfo;

public class QueueCriteriaList
extends ArrayList {
    protected PagedListInfo pagedListInfo = null;
    protected int queueId = -1;

    public void setPagedListInfo(PagedListInfo tmp) {
        this.pagedListInfo = tmp;
    }

    public PagedListInfo getPagedListInfo() {
        return this.pagedListInfo;
    }

    public void setQueueId(int tmp) {
        this.queueId = tmp;
    }

    public void setQueueId(String tmp) {
        this.queueId = Integer.parseInt(tmp);
    }

    public int getQueueId() {
        return this.queueId;
    }

    public void buildList(Connection db) throws SQLException {
        PreparedStatement pst = null;
        ResultSet rs = null;
        int items = -1;
        StringBuffer sqlSelect = new StringBuffer();
        StringBuffer sqlCount = new StringBuffer();
        StringBuffer sqlFilter = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        sqlCount.append("SELECT COUNT(*) as recordcount FROM report_queue_criteria qc WHERE criteria_id > -1 ");
        this.createFilter(sqlFilter);
        if (this.pagedListInfo != null) {
            pst = db.prepareStatement(sqlCount.toString() + sqlFilter.toString());
            items = this.prepareFilter(pst);
            rs = pst.executeQuery();
            if (rs.next()) {
                int maxRecords = rs.getInt("recordcount");
                this.pagedListInfo.setMaxRecords(maxRecords);
            }
            rs.close();
            pst.close();
            this.pagedListInfo.setDefaultSort("qc.criteria_id", null);
            this.pagedListInfo.appendSqlTail(db, sqlOrder);
        } else {
            sqlOrder.append("ORDER BY qc.criteria_id ");
        }
        if (this.pagedListInfo != null) {
            this.pagedListInfo.appendSqlSelectHead(db, sqlSelect);
        } else {
            sqlSelect.append("SELECT ");
        }
        sqlSelect.append("qc.* FROM report_queue_criteria qc WHERE criteria_id > -1 ");
        pst = db.prepareStatement(sqlSelect.toString() + sqlFilter.toString() + sqlOrder.toString());
        items = this.prepareFilter(pst);
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, pst);
        }
        rs = pst.executeQuery();
        if (this.pagedListInfo != null) {
            this.pagedListInfo.doManualOffset(db, rs);
        }
        while (rs.next()) {
            QueueCriteria thisCriteria = new QueueCriteria(rs);
            this.add(thisCriteria);
        }
        rs.close();
        pst.close();
    }

    protected void createFilter(StringBuffer sqlFilter) {
        if (sqlFilter == null) {
            sqlFilter = new StringBuffer();
        }
        if (this.queueId != -1) {
            sqlFilter.append("AND qc.queue_id = ? ");
        }
    }

    protected int prepareFilter(PreparedStatement pst) throws SQLException {
        int i = 0;
        if (this.queueId != -1) {
            pst.setInt(++i, this.queueId);
        }
        return i;
    }

    public Map getParameters(JasperReport jasperReport) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return this.getParameters(jasperReport, null);
    }

    public Map getParameters(JasperReport jasperReport, String path) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        ParameterList params = new ParameterList();
        params.setParameters(jasperReport);
        HashMap<Integer, String> userIdRanges = new HashMap<Integer, String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (QueueCriteria thisCriteria : this) {
            Class classValue = params.getValueClass(thisCriteria.getParameter());
            if (thisCriteria.getParameter().startsWith("user_id_range_")) {
                String param = thisCriteria.getParameter();
                Integer userId = new Integer(param.substring(param.lastIndexOf("_") + 1));
                userIdRanges.put(userId, thisCriteria.getValue());
                continue;
            }
            if (classValue.getName().equals("java.sql.Timestamp") && thisCriteria.getParameter().startsWith("date_")) {
                parameters.put(thisCriteria.getParameter(), DatabaseUtils.parseDateToTimestamp(thisCriteria.getValue()));
                continue;
            }
            if (classValue.getName().equals("java.sql.Timestamp")) {
                parameters.put(thisCriteria.getParameter(), DatabaseUtils.parseTimestamp(thisCriteria.getValue()));
                continue;
            }
            if (classValue.getName().equals("java.lang.Boolean") || classValue.getName().equals("java.util.Map") || classValue.getName().equals("java.sql.Connection")) continue;
            if (!classValue.getName().equals("java.lang.String")) {
                Class[] argTypes = new Class[]{String.class};
                Method method = classValue.getMethod("valueOf", argTypes);
                Object result = method.invoke(null, thisCriteria.getValue());
                parameters.put(thisCriteria.getParameter(), result);
                continue;
            }
            parameters.put(thisCriteria.getParameter(), thisCriteria.getValue());
        }
        if (path != null) {
            parameters.put("path", path);
        }
        if (userIdRanges.size() > 0) {
            parameters.put("user_id_ranges", userIdRanges);
        }
        return parameters;
    }
}

